/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import bsh.TargetError;
import eu.irreality.age.Descriptible;
import eu.irreality.age.Description;
import eu.irreality.age.EVASemanticException;
import eu.irreality.age.Entity;
import eu.irreality.age.EntityList;
import eu.irreality.age.InputOutputClient;
import eu.irreality.age.Inventory;
import eu.irreality.age.Item;
import eu.irreality.age.MobileList;
import eu.irreality.age.Nameable;
import eu.irreality.age.NaturalLanguage;
import eu.irreality.age.NullInputOutputClient;
import eu.irreality.age.ObjectCode;
import eu.irreality.age.Path;
import eu.irreality.age.Player;
import eu.irreality.age.PropertyEntry;
import eu.irreality.age.ReturnValue;
import eu.irreality.age.Room;
import eu.irreality.age.Spell;
import eu.irreality.age.SpellList;
import eu.irreality.age.StringMethods;
import eu.irreality.age.SupportingCode;
import eu.irreality.age.Traits;
import eu.irreality.age.Utility;
import eu.irreality.age.VolumeLimitExceededException;
import eu.irreality.age.Weapon;
import eu.irreality.age.Wearable;
import eu.irreality.age.WeightLimitExceededException;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Mobile
extends Entity
implements Descriptible,
SupportingCode,
Nameable {
    public static final int IDLE = 1;
    public static final int MOVING = 2;
    public static final int ATTACKING = 3;
    public static final int BLOCKING = 4;
    public static final int READY_TO_BLOCK = 5;
    public static final int DODGING = 6;
    public static final int READY_TO_DODGE = 7;
    public static final int ATTACK_RECOVER = 8;
    public static final int BLOCK_RECOVER = 9;
    public static final int DAMAGE_RECOVER = 10;
    public static final int DODGE_RECOVER = 11;
    public static final int DYING = 12;
    public static final int DEAD = 13;
    public static final int SURPRISE_RECOVER = 14;
    public static final int DISABLED = 15;
    public static final int CASTING = 16;
    boolean numeric_damage = false;
    private String mobileType;
    private int idnumber;
    private int inheritsFrom;
    protected Room habitacionActual;
    protected Room habitacionAnterior;
    protected String title;
    private int isInstanceOf;
    protected Description[] descriptionList;
    protected Description[] singNames;
    protected Description[] plurNames;
    protected boolean gender;
    protected String respondToSing;
    protected String respondToPlur;
    protected Inventory inventory;
    protected Inventory virtualInventory;
    protected Inventory partsInventory;
    protected SpellList spellRefs;
    protected MobileList combatRefs;
    protected Inventory wieldedWeapons;
    protected Inventory wornItems;
    protected Vector knownSpellRefs;
    protected String extraDescriptions;
    protected List extraDescriptionArrays;
    protected List extraDescriptionNameArrays;
    protected boolean properName = false;
    protected Inventory wieldingLimbs;
    protected Traits caracteristicas;
    protected int hp;
    protected int mp;
    protected int maxhp;
    protected int maxmp;
    protected Vector relationships = new Vector();
    protected Vector relationship_properties = new Vector();
    protected ObjectCode itsCode;
    protected Vector PSIanswers;
    protected Vector PSIkeywords;
    protected InputOutputClient io;
    String exitname;
    Weapon usingWeapon;
    Spell usingSpell;
    private Random aleat;
    protected NaturalLanguage lenguaje;
    protected World mundo;
    protected Path movingState_Path;

    public Mobile() {
    }

    public Mobile(World mundo, String mobfile) throws IOException, FileNotFoundException {
        this.mundo = mundo;
        this.io = new NullInputOutputClient();
        this.lenguaje = mundo.getLang();
        this.constructMob(mundo, mobfile, true, "none");
    }

    public Mobile(World mundo, Node n) throws XMLtoWorldException {
        this.mundo = mundo;
        this.io = new NullInputOutputClient();
        this.lenguaje = mundo.getLang();
        this.constructMob(mundo, n, true, "none");
    }

    public static Mobile getInstance(World mundo, Node n) throws XMLtoWorldException {
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Mobile node not Element");
        }
        Element e = (Element)n;
        Object ourNewMobile = !e.hasAttribute("type") ? new Mobile(mundo, n) : (e.getAttribute("type").equalsIgnoreCase("daedra") ? null : new Mobile(mundo, n));
        return ourNewMobile;
    }

    public static Mobile getInstance(World mundo, String mobfile) throws FileNotFoundException, IOException {
        FileInputStream fp = new FileInputStream(mobfile);
        BufferedReader filein = new BufferedReader(Utility.getBestInputStreamReader(fp));
        String mobtype = "none";
        for (int line = 1; line < 100; ++line) {
            String linea = filein.readLine();
            String id_linea = StringMethods.getTok(linea, 1, ' ');
            linea = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
            try {
                if (id_linea == null || Integer.valueOf(id_linea) != 0) continue;
                mobtype = linea;
                continue;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        Mobile ourNewMob = mobtype.equalsIgnoreCase("daedra") ? new Mobile(mundo, mobfile) : new Mobile(mundo, mobfile);
        return ourNewMob;
    }

    public void constructMob(World mundo, String mobfile, boolean allowInheritance, String mobtype) throws IOException, FileNotFoundException {
        FileInputStream fp = new FileInputStream(mobfile);
        BufferedReader filein = new BufferedReader(Utility.getBestInputStreamReader(fp));
        for (int line = 1; line < 100; ++line) {
            String linea = filein.readLine();
            String id_linea = StringMethods.getTok(linea, 1, ' ');
            linea = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
            if (id_linea != null) {
                switch (Integer.valueOf(id_linea)) {
                    case 1: {
                        this.idnumber = Integer.valueOf(linea);
                        break;
                    }
                    case 2: {
                        this.inheritsFrom = Integer.valueOf(linea);
                        if (this.inheritsFrom >= this.idnumber || !allowInheritance) break;
                        this.constructMob(mundo, Utility.mobFile(mundo, this.inheritsFrom), true, mobtype);
                        this.constructMob(mundo, mobfile, false, mobtype);
                        return;
                    }
                    case 3: {
                        this.setNewState(Integer.valueOf(linea));
                        break;
                    }
                    case 4: {
                        this.title = linea;
                        break;
                    }
                    case 5: {
                        this.isInstanceOf = Integer.valueOf(linea);
                        if (this.isInstanceOf >= this.idnumber || !allowInheritance) break;
                        this.constructMob(mundo, Utility.mobFile(mundo, this.isInstanceOf), true, mobtype);
                        this.constructMob(mundo, mobfile, false, mobtype);
                        return;
                    }
                    case 10: {
                        this.descriptionList = Utility.loadDescriptionListFromString(linea);
                        break;
                    }
                    case 11: {
                        this.singNames = Utility.loadDescriptionListFromString(linea);
                        break;
                    }
                    case 12: {
                        this.plurNames = Utility.loadDescriptionListFromString(linea);
                        break;
                    }
                    case 13: {
                        int temp = Integer.valueOf(linea);
                        if (temp == 0) {
                            this.gender = false;
                            break;
                        }
                        this.gender = true;
                        break;
                    }
                    case 14: {
                        this.respondToSing = linea;
                        break;
                    }
                    case 15: {
                        this.respondToPlur = linea;
                        break;
                    }
                    case 20: {
                        int i;
                        int nObjects = StringMethods.numToks(linea, '$');
                        this.inventory = new Inventory(10000, 10000, nObjects);
                        for (i = 0; i < nObjects; ++i) {
                            try {
                                this.inventory.addItem(mundo.getItem(StringMethods.getTok(linea, i + 1, '$')));
                                continue;
                            }
                            catch (WeightLimitExceededException exc) {
                                continue;
                            }
                            catch (VolumeLimitExceededException exc2) {
                                // empty catch block
                            }
                        }
                        break;
                    }
                    case 21: {
                        int i;
                        int nObjects = StringMethods.numToks(linea, '$');
                        this.virtualInventory = new Inventory(10000, 10000, nObjects);
                        for (i = 0; i < nObjects; ++i) {
                            try {
                                this.virtualInventory.addItem(mundo.getItem(StringMethods.getTok(linea, i + 1, '$')));
                                continue;
                            }
                            catch (WeightLimitExceededException exc) {
                                continue;
                            }
                            catch (VolumeLimitExceededException exc2) {
                                // empty catch block
                            }
                        }
                        break;
                    }
                    case 25: {
                        int i;
                        int nObjects = StringMethods.numToks(linea, '$');
                        this.combatRefs = new MobileList(nObjects);
                        for (i = 0; i < nObjects; ++i) {
                            this.combatRefs.addMobile(mundo.getMob(StringMethods.getTok(linea, i + 1, '$')));
                        }
                        break;
                    }
                    case 26: {
                        int i;
                        int nObjects = StringMethods.numToks(linea, '$');
                        this.wieldedWeapons = new Inventory(10000, 10000, nObjects);
                        for (i = 0; i < nObjects; ++i) {
                            try {
                                this.wieldedWeapons.addItem(mundo.getItem(StringMethods.getTok(linea, i + 1, '$')));
                                continue;
                            }
                            catch (WeightLimitExceededException exc) {
                                continue;
                            }
                            catch (VolumeLimitExceededException exc2) {
                                // empty catch block
                            }
                        }
                        break;
                    }
                    case 40: {
                        try {
                            if (!linea.equalsIgnoreCase("true") && Integer.parseInt(linea) != 1) break;
                            this.properName = true;
                        }
                        catch (NumberFormatException nfe) {}
                        break;
                    }
                    case 50: {
                        int i;
                        int nObjects = StringMethods.numToks(linea, '$');
                        this.wieldingLimbs = new Inventory(10000, 10000, nObjects);
                        for (i = 0; i < nObjects; ++i) {
                            try {
                                this.wieldingLimbs.addItem(mundo.getItem(StringMethods.getTok(linea, i + 1, '$')));
                                continue;
                            }
                            catch (WeightLimitExceededException exc) {
                                continue;
                            }
                            catch (VolumeLimitExceededException exc2) {
                                // empty catch block
                            }
                        }
                        break;
                    }
                    case 70: {
                        this.relationships = new Vector();
                        this.relationship_properties = new Vector();
                        StringTokenizer st = new StringTokenizer(linea, "@");
                        while (st.hasMoreTokens()) {
                            PropertyEntry pe;
                            ArrayList<PropertyEntry> l;
                            this.relationships.add(mundo.getObject(st.nextToken()));
                            if (st.hasMoreTokens()) {
                                l = new ArrayList<PropertyEntry>();
                                pe = new PropertyEntry("state", st.nextToken(), 0L);
                                l.add(pe);
                                this.relationship_properties.add(l);
                                continue;
                            }
                            l = new ArrayList();
                            pe = new PropertyEntry("state", "0", 0L);
                            l.add(pe);
                            this.relationship_properties.add(l);
                        }
                        break;
                    }
                    case 80: {
                        String EVACodeString = linea;
                        boolean terminamos = false;
                        while (!terminamos) {
                            int intval;
                            linea = filein.readLine();
                            id_linea = StringMethods.getTok(linea, 1, ' ');
                            try {
                                intval = Integer.valueOf(id_linea);
                            }
                            catch (NumberFormatException e) {
                                intval = 0;
                            }
                            if (intval == 81) {
                                terminamos = true;
                                continue;
                            }
                            EVACodeString = EVACodeString + "\n";
                            EVACodeString = EVACodeString + linea;
                        }
                        this.itsCode = new ObjectCode(EVACodeString, "EVA", mundo);
                        break;
                    }
                    case 82: {
                        String PSISpecString = linea;
                        boolean terminamos = false;
                        while (!terminamos) {
                            int intval;
                            linea = filein.readLine();
                            id_linea = StringMethods.getTok(linea, 1, ' ');
                            try {
                                intval = Integer.valueOf(id_linea);
                            }
                            catch (NumberFormatException e) {
                                intval = 0;
                            }
                            if (intval == 83) {
                                terminamos = true;
                                continue;
                            }
                            PSISpecString = PSISpecString + "\n";
                            PSISpecString = PSISpecString + linea;
                        }
                        this.loadPSISpecs(PSISpecString);
                        break;
                    }
                    case 84: {
                        String bshCodeString = linea;
                        boolean terminamos = false;
                        while (!terminamos) {
                            int intval;
                            linea = filein.readLine();
                            id_linea = StringMethods.getTok(linea, 1, ' ');
                            try {
                                intval = Integer.valueOf(id_linea);
                            }
                            catch (NumberFormatException e) {
                                intval = 0;
                            }
                            if (intval == 85) {
                                terminamos = true;
                                continue;
                            }
                            bshCodeString = bshCodeString + "\n";
                            bshCodeString = bshCodeString + linea;
                        }
                        this.itsCode = new ObjectCode(bshCodeString, "BeanShell", mundo);
                        break;
                    }
                }
            }
            if (this.getID() < 10000000) {
                this.idnumber += 20000000;
            }
            if (this.wieldingLimbs == null || this.wieldedWeapons != null) continue;
            this.wieldedWeapons = new Inventory(10000, 10000, this.wieldingLimbs.size());
            this.wieldedWeapons.incrementSize(this.wieldingLimbs.size());
        }
        if (mobtype.equalsIgnoreCase("daedra")) {
            // empty if block
        }
    }

    public void constructMob(World mundo, Node n, boolean allowInheritance, String mobtype) throws XMLtoWorldException {
        Element e2;
        NodeList invNodes;
        Element e22;
        NodeList invNodes2;
        Element e23;
        NodeList invNodes3;
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Mobile node not Element");
        }
        Element e = (Element)n;
        this.mp = 0;
        this.maxmp = 0;
        this.properName = false;
        if (e.hasAttribute("extends") && !e.getAttribute("extends").equals("0") && allowInheritance) {
            this.constructMob(mundo, mundo.getMobileNode(e.getAttribute("extends")), true, mobtype);
            this.constructMob(mundo, n, false, mobtype);
        }
        if (e.hasAttribute("clones") && !e.getAttribute("clones").equals("0") && allowInheritance) {
            this.constructMob(mundo, mundo.getMobileNode(e.getAttribute("clones")), true, mobtype);
            this.constructMob(mundo, n, false, mobtype);
        }
        if (!e.hasAttribute("name")) {
            throw new XMLtoWorldException("Mobile node lacks attribute name");
        }
        if (!e.hasAttribute("hp")) {
            throw new XMLtoWorldException("Mobile node lacks attribute hp");
        }
        if (!e.hasAttribute("maxhp")) {
            throw new XMLtoWorldException("Item node lacks attribute maxhp");
        }
        if (!e.hasAttribute("gender")) {
            throw new XMLtoWorldException("Item node lacks attribute gender");
        }
        try {
            if (e.hasAttribute("id")) {
                this.idnumber = Integer.valueOf(e.getAttribute("id"));
            }
        }
        catch (NumberFormatException nfe) {
            throw new XMLtoWorldException("Bad number format at attribute id in mobile node");
        }
        this.title = e.getAttribute("name");
        this.gender = Boolean.valueOf(e.getAttribute("gender"));
        try {
            this.hp = Integer.valueOf(e.getAttribute("hp"));
        }
        catch (NumberFormatException nfe) {
            throw new XMLtoWorldException("Bad number format at attribute hp in item node");
        }
        try {
            this.maxhp = Integer.valueOf(e.getAttribute("maxhp"));
        }
        catch (NumberFormatException nfe) {
            throw new XMLtoWorldException("Bad number format at attribute maxhp in item node");
        }
        if (e.hasAttribute("mp")) {
            try {
                this.mp = Integer.valueOf(e.getAttribute("mp"));
            }
            catch (NumberFormatException nfe) {
                throw new XMLtoWorldException("Bad number format at attribute mp in item node");
            }
        }
        if (e.hasAttribute("maxmp")) {
            try {
                this.maxmp = Integer.valueOf(e.getAttribute("maxmp"));
            }
            catch (NumberFormatException nfe) {
                throw new XMLtoWorldException("Bad number format at attribute maxmp in item node");
            }
        }
        if (e.hasAttribute("properName")) {
            this.properName = Boolean.valueOf(e.getAttribute("properName"));
        }
        this.readPropListFromXML(mundo, n);
        boolean roomsdone = true;
        try {
            mundo.getRoom(0);
        }
        catch (NullPointerException npe) {
            roomsdone = false;
        }
        if (roomsdone) {
            NodeList currentRoomNodes = e.getElementsByTagName("CurrentRoom");
            if (currentRoomNodes.getLength() < 1) {
                this.habitacionActual = null;
            } else {
                Element currentRoomNode = (Element)currentRoomNodes.item(0);
                if (!currentRoomNode.hasAttribute("id")) {
                    throw new XMLtoWorldException("CurrentRoom element lacking id at Mobile");
                }
                Room r = mundo.getRoom(currentRoomNode.getAttribute("id"));
                if (r == null) {
                    throw new XMLtoWorldException("CurrentRoom element pointing to unknown Room object");
                }
                this.habitacionActual = r;
            }
        }
        this.descriptionList = Utility.loadDescriptionListFromXML(mundo, e, "DescriptionList", true);
        this.singNames = Utility.loadDescriptionListFromXML(mundo, e, "SingularNames", true);
        this.plurNames = Utility.loadDescriptionListFromXML(mundo, e, "PluralNames", true);
        this.respondToSing = Utility.loadNameListFromXML(mundo, e, "SingularReferenceNames", true);
        this.respondToPlur = Utility.loadNameListFromXML(mundo, e, "PluralReferenceNames", true);
        NodeList inventoryNodes = e.getElementsByTagName("Inventory");
        ArrayList<Node> realInventoryNodes = new ArrayList<Node>();
        for (int i = 0; i < inventoryNodes.getLength(); ++i) {
            if (inventoryNodes.item(i).getParentNode() != e) continue;
            realInventoryNodes.add(inventoryNodes.item(i));
        }
        this.inventory = realInventoryNodes.size() < 1 ? null : new Inventory(mundo, (Node)realInventoryNodes.get(0));
        NodeList virtualInvNodes = e.getElementsByTagName("VirtualInventory");
        this.virtualInventory = virtualInvNodes.getLength() < 1 ? null : ((invNodes3 = (e23 = (Element)virtualInvNodes.item(0)).getElementsByTagName("Inventory")).getLength() < 1 ? null : new Inventory(mundo, invNodes3.item(0)));
        NodeList wieldedInvNodes = e.getElementsByTagName("WieldedWeaponsInventory");
        this.wieldedWeapons = wieldedInvNodes.getLength() < 1 ? null : ((invNodes2 = (e22 = (Element)wieldedInvNodes.item(0)).getElementsByTagName("Inventory")).getLength() < 1 ? null : new Inventory(mundo, invNodes2.item(0)));
        NodeList wornItemNodes = e.getElementsByTagName("WornItemsInventory");
        this.wornItems = wornItemNodes.getLength() < 1 ? null : ((invNodes = (e2 = (Element)wornItemNodes.item(0)).getElementsByTagName("Inventory")).getLength() < 1 ? null : new Inventory(mundo, invNodes.item(0)));
        this.wieldingLimbs = null;
        NodeList spellNodes = e.getElementsByTagName("SpellList");
        this.spellRefs = spellNodes.getLength() < 1 ? null : new SpellList(mundo, spellNodes.item(0));
        NodeList partsInvNodes = e.getElementsByTagName("Parts");
        if (partsInvNodes.getLength() < 1) {
            this.partsInventory = null;
        } else {
            Element e24 = (Element)partsInvNodes.item(0);
            NodeList invNodes4 = e24.getElementsByTagName("Inventory");
            if (invNodes4.getLength() < 1) {
                this.partsInventory = null;
            } else {
                this.partsInventory = new Inventory(mundo, invNodes4.item(0));
                System.out.println(this + "Parts Inventory: " + this.wieldingLimbs);
            }
        }
        NodeList traitNodes = e.getElementsByTagName("Traits");
        if (traitNodes.getLength() > 0) {
            try {
                this.caracteristicas = new Traits(mundo, traitNodes.item(0));
            }
            catch (XMLtoWorldException ex) {
                throw new XMLtoWorldException("Exception at Traits node: " + ex.getMessage());
            }
        }
        long strength = Math.max(this.caracteristicas.getSkill("FUE"), this.caracteristicas.getSkill("STR"));
        try {
            this.inventory.setVolumeLimit((int)(2000L + 10L * strength));
            this.inventory.setWeightLimit((int)(2000L + 10L * strength));
        }
        catch (Exception exc) {
            System.err.println("[Warning] Mobile " + this.getTitle() + " carrying items too heavy or big for its strength of " + strength);
        }
        List temp = Utility.loadExtraDescriptionsFromXML(mundo, e, "ExtraDescriptionList", true);
        if (temp == null || temp.size() < 2) {
            this.extraDescriptionArrays = new ArrayList();
            this.extraDescriptionNameArrays = new ArrayList();
        } else {
            this.extraDescriptionArrays = (List)temp.get(1);
            this.extraDescriptionNameArrays = (List)temp.get(0);
        }
        NodeList codeNodes = e.getElementsByTagName("Code");
        if (codeNodes.getLength() > 0) {
            try {
                this.itsCode = new ObjectCode(mundo, codeNodes.item(0));
            }
            catch (XMLtoWorldException ex) {
                throw new XMLtoWorldException("Exception at Code node: " + ex.getMessage());
            }
        }
        this.loadPSISpecs(mundo, e);
        if (mobtype.equalsIgnoreCase("daedra")) {
            // empty if block
        }
        if (this.getID() < 10000000) {
            this.idnumber += 20000000;
        }
        if (this.wieldingLimbs != null && this.wieldedWeapons == null) {
            this.wieldedWeapons = new Inventory(10000, 10000, this.wieldingLimbs.size());
            this.wieldedWeapons.incrementSize(this.wieldingLimbs.size());
        }
        if (this.wornItems == null) {
            this.wornItems = new Inventory(10000, 10000);
        }
    }

    public int getID() {
        return this.idnumber;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription(long comparand) {
        String desString = "";
        for (int i = 0; i < this.descriptionList.length; ++i) {
            if (!this.descriptionList[i].matches(comparand)) continue;
            desString = desString + this.descriptionList[i].getText();
        }
        return desString;
    }

    public String getDescription(Entity viewer) {
        String desString = "";
        for (int i = 0; i < this.descriptionList.length; ++i) {
            if (!this.descriptionList[i].matchesConditions(this, viewer)) continue;
            desString = desString + this.descriptionList[i].getText();
        }
        return desString;
    }

    public boolean isInvisible(Entity viewer) {
        if (!this.properName) {
            return StringMethods.numToks(this.constructName(1, viewer), ' ') < 2;
        }
        return StringMethods.numToks(this.constructName(1, viewer), ' ') < 1;
    }

    public String getName(boolean s_p, int comparand) {
        Description[] theList = s_p ? this.singNames : this.plurNames;
        String desString = "";
        for (int i = 0; i < theList.length; ++i) {
            if (!theList[i].matches(comparand)) continue;
            desString = desString + theList[i].getText();
        }
        return desString;
    }

    public String getName(boolean s_p) {
        Description[] theList = s_p ? this.singNames : this.plurNames;
        String desString = "";
        for (int i = 0; i < theList.length; ++i) {
            if (!theList[i].matchesConditions(this)) continue;
            desString = desString + theList[i].getText();
        }
        return desString;
    }

    public String getSingName(int comparand) {
        return this.getName(true, comparand);
    }

    public String getPlurName(int comparand) {
        return this.getName(false, comparand);
    }

    public String getSingName() {
        return this.getName(true);
    }

    public String getPlurName() {
        return this.getName(false);
    }

    public String constructName(int nItems) {
        return this.constructName(nItems, this.getState());
    }

    public String constructName(int nItems, int comparand) {
        if (nItems == 1) {
            if (this.properName) {
                return this.getSingName(comparand);
            }
            if (this.gender) {
                return "un " + this.getSingName(comparand);
            }
            return "una " + this.getSingName(comparand);
        }
        if (nItems < 10) {
            String str;
            switch (nItems) {
                case 2: {
                    str = "dos";
                    break;
                }
                case 3: {
                    str = "tres";
                    break;
                }
                case 4: {
                    str = "cuatro";
                    break;
                }
                case 5: {
                    str = "cinco";
                    break;
                }
                case 6: {
                    str = "seis";
                    break;
                }
                case 7: {
                    str = "siete";
                    break;
                }
                case 8: {
                    str = "ocho";
                    break;
                }
                default: {
                    str = "nueve";
                }
            }
            return str + " " + this.getPlurName(comparand);
        }
        return nItems + " " + this.getPlurName(comparand);
    }

    public String constructName2(int nItems) {
        return this.constructName2(nItems, this.getState());
    }

    public String constructName2(int nItems, int comparand) {
        if (nItems == 1) {
            if (this.properName) {
                return this.getSingName(comparand);
            }
            if (this.gender) {
                return "el " + this.getSingName(comparand);
            }
            return "la " + this.getSingName(comparand);
        }
        return nItems + " " + this.getPlurName(comparand);
    }

    public String getExtraDescription(String thingieName, Entity viewer) {
        for (int i = 0; i < this.extraDescriptionNameArrays.size(); ++i) {
            String[] curNameArray = (String[])this.extraDescriptionNameArrays.get(i);
            Description[] curDesArray = (Description[])this.extraDescriptionArrays.get(i);
            for (int j = 0; j < curNameArray.length; ++j) {
                if (!StringMethods.getTok(thingieName, StringMethods.numToks(thingieName, ' '), ' ').equalsIgnoreCase(curNameArray[j])) continue;
                String desString = "";
                for (int k = 0; k < curDesArray.length; ++k) {
                    if (!curDesArray[k].matchesConditions(this, viewer)) continue;
                    desString = desString + "\n";
                    desString = desString + curDesArray[k].getText();
                }
                if (desString.length() > 0) {
                    return desString.substring(1);
                }
                return null;
            }
        }
        return null;
    }

    public String getBestReferenceName(boolean pluralOrSingular) {
        String theList = pluralOrSingular ? this.respondToPlur : this.respondToSing;
        String tmp = StringMethods.getTok(theList, 1, '$');
        return Character.toLowerCase(tmp.charAt(0)) + tmp.substring(1);
    }

    public int matchesCommand(String commandArgs, boolean pluralOrSingular) {
        String listaDeInteres = pluralOrSingular ? this.respondToPlur : this.respondToSing;
        int nToksArg = StringMethods.numToks(commandArgs, ' ');
        int nToksList = StringMethods.numToks(listaDeInteres, '$');
        for (int i = 1; i <= nToksArg; ++i) {
            String currentToAnalyze = StringMethods.getToks(commandArgs, i, nToksArg, ' ');
            for (int j = 1; j <= nToksList; ++j) {
                if (!StringMethods.getTok(listaDeInteres, j, '$').equalsIgnoreCase(currentToAnalyze)) continue;
                return j;
            }
        }
        return 0;
    }

    public int getInstanceOf() {
        return this.isInstanceOf;
    }

    public boolean isSame(Mobile other) {
        return this.idnumber == other.getID() || this.idnumber == other.getInstanceOf() || this.isInstanceOf == other.getID() || this.isInstanceOf == other.getInstanceOf() && this.isInstanceOf != 0;
    }

    public boolean execCode(String routine, String dataSegment) throws EVASemanticException {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, dataSegment);
        }
        return false;
    }

    public boolean execCode(String routine, Object[] args) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args);
        }
        return false;
    }

    public boolean execCode(String routine, Object[] args, ReturnValue retval) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args, retval);
        }
        return false;
    }

    public long getSkill(String s) {
        if (this.caracteristicas == null) {
            this.caracteristicas = new Traits();
        }
        return this.caracteristicas.getSkill(s);
    }

    public int getStat(String s) {
        int value = 0;
        if (this.caracteristicas != null) {
            value = (int)this.caracteristicas.getStat(s);
        }
        if (value == 0) {
            return 12;
        }
        return value;
    }

    public Weapon getCurrentWeapon() {
        return this.usingWeapon;
    }

    public void setRoom(Room nuevaHabitacion) {
        this.habitacionAnterior = this.habitacionActual;
        if (this.habitacionActual != null) {
            this.habitacionActual.removeMob(this);
            this.habitacionActual = nuevaHabitacion;
            this.habitacionActual.addMob(this);
        } else {
            this.habitacionActual = nuevaHabitacion;
            if (!this.habitacionActual.hasMobile(this)) {
                this.habitacionActual.addMob(this);
            }
        }
    }

    public void setInventory(Inventory inv) {
        this.inventory = inv;
    }

    public Room getRoom() {
        return this.habitacionActual;
    }

    public Room getLastRoom() {
        return this.habitacionAnterior;
    }

    public Node getRelationshipListXMLRepresentation(Document doc) {
        Element e = doc.createElement("RelationshipList");
        for (int i = 0; i < this.relationships.size(); ++i) {
            Element eRel = doc.createElement("Relationship");
            Element ePropList = doc.createElement("PropertyList");
            Entity objetivo = (Entity)this.relationships.elementAt(i);
            eRel.setAttribute("id", String.valueOf(objetivo.getID()));
            List propertiesList = (List)this.relationship_properties.elementAt(i);
            for (int j = 0; j < propertiesList.size(); ++j) {
                PropertyEntry pe = (PropertyEntry)propertiesList.get(j);
                Node nodoProp = pe.getXMLRepresentation(doc);
                ePropList.appendChild(nodoProp);
            }
            eRel.appendChild(ePropList);
            e.appendChild(eRel);
        }
        return e;
    }

    public void readRelationshipListFromXML(World mundo, Node n) throws XMLtoWorldException {
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Mobile node not Element");
        }
        Element e = (Element)n;
        NodeList nl = e.getElementsByTagName("RelationshipList");
        if (nl.getLength() >= 1) {
            Element relationshipListNode = (Element)nl.item(0);
            NodeList relaciones = relationshipListNode.getElementsByTagName("Relationship");
            for (int i = 0; i < relaciones.getLength(); ++i) {
                ArrayList<PropertyEntry> propertiesList;
                Element thisRelationshipNode = (Element)relaciones.item(i);
                if (!thisRelationshipNode.hasAttribute("id")) {
                    throw new XMLtoWorldException("Relationship node lacking attribute id");
                }
                this.relationships.add(mundo.getObject(thisRelationshipNode.getAttribute("id")));
                NodeList pListNodes = thisRelationshipNode.getElementsByTagName("PropertyList");
                if (pListNodes.getLength() < 0) {
                    propertiesList = new ArrayList<PropertyEntry>();
                } else {
                    propertiesList = new ArrayList();
                    Element elementoPropertyList = (Element)pListNodes.item(0);
                    NodeList listaPropertyEntries = elementoPropertyList.getElementsByTagName("PropertyEntry");
                    for (int k = 0; k < listaPropertyEntries.getLength(); ++k) {
                        Node nod = listaPropertyEntries.item(k);
                        PropertyEntry pe = new PropertyEntry(mundo, nod);
                        propertiesList.add(pe);
                    }
                }
                this.relationship_properties.add(propertiesList);
            }
        }
    }

    private void loadPSISpecs(World mundo, Node n) throws XMLtoWorldException {
        Element e;
        try {
            e = (Element)n;
        }
        catch (ClassCastException cce) {
            throw new XMLtoWorldException("Mobile node not Element");
        }
        NodeList convAINodes = e.getElementsByTagName("ConversationalAI");
        if (convAINodes.getLength() > 0) {
            Element convAINode = (Element)convAINodes.item(0);
            NodeList mappingNodes = convAINode.getElementsByTagName("Mapping");
            for (int i = 0; i < mappingNodes.getLength(); ++i) {
                Element curMappingNode = (Element)mappingNodes.item(i);
                if (!curMappingNode.hasAttribute("command")) {
                    throw new XMLtoWorldException("Mapping node lacking attribute command");
                }
                NodeList desNodes = curMappingNode.getElementsByTagName("Description");
                if (desNodes.getLength() < 1) {
                    throw new XMLtoWorldException("Mapping node lacking Description element");
                }
                Description[] answer = Utility.loadDescriptionListFromXML(mundo, curMappingNode);
                if (answer == null) continue;
                if (this.PSIkeywords == null) {
                    this.PSIkeywords = new Vector();
                }
                if (this.PSIanswers == null) {
                    this.PSIanswers = new Vector();
                }
                this.PSIkeywords.add(curMappingNode.getAttribute("command"));
                this.PSIanswers.add(answer);
                System.out.println("Adding answers to " + curMappingNode.getAttribute("command"));
                System.out.println("They are for example " + answer[0].getText());
            }
        } else {
            return;
        }
    }

    private void loadPSISpecs(String PSISpecList) {
        int len = StringMethods.numToks(PSISpecList, '\n');
        this.PSIanswers = new Vector();
        this.PSIkeywords = new Vector();
        StringTokenizer lineas = new StringTokenizer(PSISpecList, "\n");
        int nlinea = -1;
        while (lineas.hasMoreTokens()) {
            ++nlinea;
            String linea = lineas.nextToken();
            this.PSIanswers.addElement(Utility.loadDescriptionListFromString(StringMethods.getTok(linea, StringMethods.numToks(linea, '$'), '$')));
            this.PSIkeywords.addElement(StringMethods.getToks(linea, 1, StringMethods.numToks(linea, '$') - 1, '$').trim());
        }
    }

    public String getPSIAnswer(String question) {
        if (this.PSIanswers == null || this.PSIanswers.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.PSIanswers.size(); ++i) {
            StringTokenizer st = new StringTokenizer((String)this.PSIkeywords.elementAt(i), "$");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (!StringMethods.isSubstringOf(tok.toLowerCase(), question.toLowerCase())) continue;
                Description[] nuestraRespuesta = (Description[])this.PSIanswers.elementAt(i);
                String stringRespuesta = null;
                for (int j = 0; j < nuestraRespuesta.length; ++j) {
                    if (!nuestraRespuesta[j].matches(this.getState())) continue;
                    stringRespuesta = stringRespuesta == null ? nuestraRespuesta[j].getText() : stringRespuesta + nuestraRespuesta[j].getText();
                }
                return stringRespuesta;
            }
        }
        return null;
    }

    public void reactToRoomText(String text) {
        boolean ejecutado = false;
        try {
            ejecutado = this.execCode("onRoomText", new Object[]{text});
        }
        catch (TargetError te) {
            this.write("" + (Object)((Object)te));
            te.printStackTrace();
        }
        if (ejecutado) {
            return;
        }
        if (StringMethods.isSubstringOf(" dice ", text.toLowerCase())) {
            String resto;
            System.out.println("Full-string: " + text);
            Vector<String> sepvector = new Vector<String>();
            sepvector.addElement(" te dice ");
            sepvector.addElement(" dice ");
            Vector analisis = StringMethods.tokenizeWithComplexSeparators(text, sepvector, true);
            String elSujeto = ((String)analisis.elementAt(0)).trim();
            boolean vaPorTi = false;
            if (analisis.size() < 2) {
                resto = "";
            } else if (((String)analisis.elementAt(1)).equals(" te dice ")) {
                vaPorTi = true;
                resto = ((String)analisis.elementAt(2)).trim();
            } else {
                resto = ((String)analisis.elementAt(2)).trim();
            }
            System.out.println("El sujeto's string: " + elSujeto);
            Mobile elSujetoEnSi = null;
            Mobile elObjetoEnSi = null;
            Vector patternMatchVectorSing = this.habitacionActual.mobsInRoom.patternMatch(elSujeto, false);
            elSujetoEnSi = patternMatchVectorSing != null && patternMatchVectorSing.size() > 0 ? (Mobile)patternMatchVectorSing.elementAt(0) : null;
            String loQueDice = null;
            StringTokenizer st = new StringTokenizer(resto, "\"", false);
            if (!st.hasMoreTokens()) {
                return;
            }
            loQueDice = st.nextToken();
            if (st.hasMoreTokens()) {
                resto = st.nextToken();
                System.out.println("Resto's string: " + resto);
                Vector patternMatchVectorSing2 = this.habitacionActual.mobsInRoom.patternMatch(resto, false);
                if (patternMatchVectorSing2 != null && patternMatchVectorSing2.size() > 0) {
                    elObjetoEnSi = (Mobile)patternMatchVectorSing2.elementAt(0);
                }
                System.out.println("El objeto: " + elObjetoEnSi);
            }
            if (vaPorTi) {
                elObjetoEnSi = this;
            }
            try {
                System.out.println("Calling event say with " + elSujetoEnSi + "," + loQueDice);
                this.execCode("event_say", "this: " + this.getID() + "\n" + "speaker_id: " + (elSujetoEnSi != null ? String.valueOf(elSujetoEnSi.getID()) : null) + "\n" + "speaker_name: " + elSujeto + "\n" + "sentence: " + loQueDice);
                ejecutado = false;
                ejecutado = this.execCode("onSayTo", new Object[]{elSujetoEnSi, loQueDice, elObjetoEnSi});
                if (!ejecutado) {
                    this.execCode("onSay", new Object[]{elSujetoEnSi, loQueDice});
                }
            }
            catch (EVASemanticException exc) {
                this.write(this.io.getColorCode("error") + "EVASemanticException found at event_say, mob number " + this.getID() + this.io.getColorCode("reset"));
            }
            catch (TargetError te) {
                this.write(this.io.getColorCode("error") + "bsh.TargetError found at event_say, mob number " + this.getID() + this.io.getColorCode("reset"));
            }
            String respuesta = this.getPSIAnswer(loQueDice);
            if (respuesta != null) {
                this.say(respuesta);
            } else {
                respuesta = this.getPSIAnswer("default");
                if (respuesta != null) {
                    this.say(respuesta);
                }
            }
        }
    }

    public void say(String text) {
        if (text.trim().equals("")) {
            return;
        }
        this.habitacionActual.informActionAuto(this, null, null, "$1 dice \"" + text + "\".\n", true);
    }

    public void sayTo(Mobile m, String text) {
        this.habitacionActual.informAction(this, m, null, "$1 dice \"" + text + "\" a $2.\n", "$1 te dice \"" + text + "\".\n", "dices \"" + text + "\" a $2.\n", true);
    }

    protected void comandoDecir(String args) {
        StringTokenizer st = new StringTokenizer(" " + args, "\"");
        boolean tamosDentro = false;
        String dentro = "";
        String fuera = "";
        while (st.hasMoreTokens()) {
            if (tamosDentro) {
                dentro = dentro + st.nextToken();
            } else {
                fuera = fuera + st.nextToken();
            }
            tamosDentro = !tamosDentro;
        }
        dentro = dentro.trim();
        fuera = fuera.trim();
        System.out.println("DENTRO:" + dentro);
        System.out.println("FUERA:" + fuera);
        if (dentro.equalsIgnoreCase("")) {
            this.say(fuera);
        } else {
            MobileList ml = this.getRoom().getMobiles();
            Vector patternMatchVectorSing = ml.patternMatch(fuera, false);
            Vector patternMatchVectorPlur = ml.patternMatch(fuera, true);
            if (patternMatchVectorSing.size() > 0) {
                this.sayTo((Mobile)patternMatchVectorSing.elementAt(0), dentro);
            } else if (patternMatchVectorPlur.size() > 0) {
                for (int i = 0; i < patternMatchVectorPlur.size(); ++i) {
                    Mobile ourMob = (Mobile)patternMatchVectorPlur.elementAt(i);
                    this.sayTo(ourMob, dentro);
                }
            } else {
                this.say(dentro);
            }
        }
    }

    public void escribir(String s) {
        this.write(s);
    }

    public void write(String s) {
    }

    public boolean makeRandomValidMove() {
        int nsal = this.habitacionActual.getRandomValidExitAsNumber();
        if (nsal < 0) {
            return false;
        }
        if (nsal < 10) {
            return this.go(this.habitacionActual.getExit(true, nsal));
        }
        return this.go(this.habitacionActual.getExit(false, 10 - nsal));
    }

    public boolean goTo(int roomid) {
        int i;
        System.out.println("Called goTo with id: " + roomid);
        Path[] std = this.habitacionActual.getStandardExits();
        Path[] nonstd = this.habitacionActual.getNonStandardExits();
        for (i = 0; i < std.length; ++i) {
            if (std[i].getDestinationID() != roomid || !this.go(this.habitacionActual.getExit(true, i))) continue;
            return true;
        }
        for (i = 0; i < nonstd.length; ++i) {
            if (nonstd[i].getDestinationID() != roomid || !this.go(this.habitacionActual.getExit(false, i))) continue;
            return true;
        }
        return false;
    }

    public boolean goTo(Room r) {
        System.out.println("Called goTo with room: " + r);
        return this.goTo(r.getID());
    }

    public boolean go(Path p) {
        System.out.println("EXECCING GO " + p);
        if (!p.isValid()) {
            if (p.isStandard()) {
                this.write(this.io.getColorCode("denial") + "No parece haber salida en esa direcci\u00f3n.\n" + this.io.getColorCode("reset"));
            } else {
                this.write(this.io.getColorCode("denial") + "\u00bfC\u00f3mo? \u00bfIr a d\u00f3nde?\n" + this.io.getColorCode("reset"));
            }
            return false;
        }
        boolean endfound = false;
        System.out.println("EXECCING GO: ENDFOUND INIT");
        try {
            endfound = this.habitacionActual.execCode("onWalkAway", new Object[]{this, p});
            System.out.println("EXECCING GO: ENDFOUND ASSIGN " + endfound);
        }
        catch (TargetError bshte) {
            this.write(this.io.getColorCode("error") + "bsh.TargetError found onExitRoom , room number " + this.habitacionActual.getID() + ": " + (Object)((Object)bshte) + this.io.getColorCode("reset"));
        }
        if (!endfound) {
            try {
                endfound = this.habitacionActual.execCode("beforeExit", new Object[]{this, p});
                System.out.println("EXECCING GO: ENDFOUND ASSIGN " + endfound);
            }
            catch (TargetError bshte) {
                this.write(this.io.getColorCode("error") + "bsh.TargetError found onExitRoom , room number " + this.habitacionActual.getID() + ": " + (Object)((Object)bshte) + this.io.getColorCode("reset"));
            }
        }
        if (!endfound) {
            this.movingState_Path = p;
            if (p.isOpen()) {
                this.exitname = this.habitacionActual.getExitName(p);
                p.go(this);
                System.out.println("Path::go() called");
                return true;
            }
            if (this.movingState_Path != null) {
                this.write(this.io.getColorCode("action") + this.movingState_Path.getDescription(this) + "\n" + this.io.getColorCode("reset"));
            }
            System.out.println("Closed path");
            return false;
        }
        return true;
    }

    public void changeState(World mundo) {
        switch (this.getState()) {
            case 1: {
                if (!this.hasEnemies()) break;
                System.out.println("Bicho has enemies.");
                List atacantes = this.getAttackingEnemies();
                System.out.println("Bicho has " + atacantes.size() + " attacking enemies.");
                System.out.println("A " + this + " lo atacan " + atacantes);
                if (atacantes.size() == 0) {
                    for (int i = 0; i < this.combatRefs.size(); ++i) {
                        int destRoomID;
                        Mobile m = this.combatRefs.elementAt(i);
                        if (!this.habitacionActual.hasMobile(m) || m.getState() != 2 || !this.goTo(destRoomID = m.getTarget())) continue;
                        return;
                    }
                    boolean success = this.attackBestTarget();
                    System.out.println("It's " + success + " to say that the bicho found targets.");
                    if (success) {
                        return;
                    }
                    Weapon w = this.bestNonWieldedWeapon(5);
                    System.out.println("Best non-wielded weapon set to " + w);
                    if (w == null) break;
                    boolean success2 = this.intentarBlandir(w, true);
                    System.out.println("Weapon wield success " + success2);
                    return;
                }
                int aleat = this.getRandom().nextInt();
                boolean success = this.blockBestTarget();
                if (success) break;
                this.dodge((Mobile)atacantes.get(0));
                break;
            }
            case 2: {
                if (this.movingState_Path != null) {
                    this.write(this.io.getColorCode("action") + this.movingState_Path.getDescription(this) + "\n" + this.io.getColorCode("reset"));
                }
                try {
                    this.habitacionActual.execCode("event_exitroom", "this: " + this.habitacionActual.getID() + "\n" + "player: " + this.getID() + "\n" + "dest: " + this.getTarget());
                    this.habitacionActual.execCode("onExitRoom", new Object[]{this});
                }
                catch (EVASemanticException exc) {
                    this.write(this.io.getColorCode("denial") + "EVASemanticException found at event_exitroom , room number " + this.habitacionActual.getID() + this.io.getColorCode("reset"));
                }
                catch (TargetError bshte) {
                    this.write(this.io.getColorCode("error") + "bsh.TargetError found onExitRoom , room number " + this.habitacionActual.getID() + ": " + (Object)((Object)bshte) + this.io.getColorCode("reset"));
                }
                this.habitacionActual.informAction(this, null, "$1 se va hacia " + this.exitname + ".\n", null, null, false);
                System.out.println("Trying room set.");
                this.setRoom(mundo.getRoom(this.getTarget()));
                System.out.println("Trying invert inform.");
                this.habitacionActual.informAction(this, null, "$1 llega desde " + Path.invert(this.exitname) + ".\n", null, null, false);
                Room destino = mundo.getRoom(this.getTarget());
                MobileList ml = destino.getMobiles();
                for (int i = 0; i < ml.size(); ++i) {
                    Mobile current = (Mobile)ml.get(i);
                    if (!this.hasEnemy(current) && !current.hasEnemy(this) || current.getState() != 2 || mundo.getRoom(current.getTarget()) != this.getRoom()) continue;
                    current.setNewState(14, 10L);
                    current.write("Ibas a dirigirte hacia " + current.exitname + "; pero te ves sorprendido por la aparici\u00f3n de " + this.constructName2OneItem(current) + ", que te bloquea el paso.\n");
                    this.write("Has sorprendido a " + current.constructName2OneItem(this) + ", que parec\u00eda querer dirigirse hacia " + current.exitname + ".\n");
                }
                try {
                    this.habitacionActual.execCode("event_enterroom", "this: " + this.habitacionActual.getID() + "\n" + "player: " + this.getID() + "\n" + "orig: " + this.habitacionAnterior);
                    this.habitacionActual.execCode("onEnterRoom", new Object[]{this});
                }
                catch (EVASemanticException exc) {
                    this.write(this.io.getColorCode("error") + "EVASemanticException found at event_enterroom , room number " + this.habitacionActual.getID() + this.io.getColorCode("reset"));
                }
                catch (TargetError bshte) {
                    this.write(this.io.getColorCode("error") + "bsh.TargetError found onEnterRoom , room number " + this.habitacionActual.getID() + ": " + (Object)((Object)bshte) + this.io.getColorCode("reset"));
                }
                MobileList mlist = this.habitacionActual.getMobiles();
                if (mlist != null) {
                    for (int i = 0; i < mlist.size(); ++i) {
                        Mobile bichoActual = mlist.elementAt(i);
                        try {
                            boolean ejecutado = bichoActual.execCode("onEnterRoom", new Object[]{this});
                            if (ejecutado) {
                                return;
                            }
                            continue;
                        }
                        catch (TargetError bshte) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found onEnterRoom , mobile number " + bichoActual.getID() + ": " + (Object)((Object)bshte) + this.io.getColorCode("reset"));
                        }
                    }
                }
                this.setNewState(1, 0L);
                break;
            }
            case 3: {
                this.manageEndOfAttackState();
                break;
            }
            case 16: {
                System.out.println("Calling manageEndOfCastState()");
                this.manageEndOfCastState();
                break;
            }
            case 8: {
                this.write("Mobile's attack-recover time is over.");
                this.setNewState(1, 0L);
                break;
            }
            case 10: {
                this.write("Mobile's damage-recover time is over.");
                this.setNewState(1, 0L);
                break;
            }
            case 9: {
                this.write("Mobile's block-recover time is over.");
                this.setNewState(1, 0L);
                break;
            }
            case 4: {
                this.write("");
                this.setNewState(5, 0L);
                break;
            }
            case 5: {
                this.setNewState(5, 0L);
                break;
            }
            case 6: {
                this.write("");
                this.setNewState(7, 0L);
                break;
            }
            case 7: {
                this.setNewState(7, 0L);
                break;
            }
            case 12: {
                this.die();
                break;
            }
            case 13: {
                this.setNewState(13, 5L);
            }
        }
    }

    public void manageEndOfAttackState() {
        boolean ejec;
        Entity objetivo = null;
        for (int i = 0; i < this.combatRefs.size(); ++i) {
            if (this.combatRefs.elementAt(i).getID() != this.getTarget()) continue;
            objetivo = this.combatRefs.elementAt(i);
            break;
        }
        if (objetivo == null) {
            System.out.println("Oops... El bicho atacado no est\u00e1.");
            return;
        }
        if (objetivo.getState() != 5 && objetivo.getState() != 7) {
            if (this.getAttackSuccessFromProbability(this.usingWeapon)) {
                if (objetivo.getState() == 3 && objetivo.getPropertyTimeLeft("state") < 3L) {
                    ejec = false;
                    try {
                        ejec = this.usingWeapon.execCode("infoChoqueArmas", new Object[]{this, objetivo});
                        if (!ejec) {
                            ejec = this.execCode("infoChoqueArmas", new Object[]{objetivo});
                        }
                    }
                    catch (TargetError te) {
                        this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoChoqueArmas(), target id was " + ((Mobile)objetivo).getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                    }
                    if (!ejec) {
                        this.habitacionActual.informAction(this, (Mobile)objetivo, "Las armas de $1 y $2 chocan en el aire...\n", "Tu arma y la de $1 chocan en el aire...\n", "Tu arma y la de $2 chocan en el aire...\n", true);
                    }
                    this.setNewState(8, this.generateAttackRecoverTime(this.usingWeapon));
                    objetivo.setNewState(8, ((Mobile)objetivo).generateAttackRecoverTime(((Mobile)objetivo).getCurrentWeapon()));
                } else {
                    boolean ejec2;
                    Item limbToHit = ((Mobile)objetivo).getRandomLimbToHit();
                    int danyo = this.usingWeapon.dealDamage(this, (Mobile)objetivo, false, limbToHit);
                    if (objetivo.getState() == 4) {
                        ejec2 = false;
                        try {
                            ejec2 = this.usingWeapon.execCode("infoNoTiempoBloquear", new Object[]{this, objetivo});
                            if (!ejec2) {
                                ejec2 = this.execCode("infoNoTiempoBloquear", new Object[]{objetivo});
                            }
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoNoTiempoBloquear(), target id was " + ((Mobile)objetivo).getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                        }
                        if (!ejec2) {
                            this.habitacionActual.informAction(this, (Mobile)objetivo, null, "No te da tiempo a bloquear el ataque de $1...\n", "A $2 no le da tiempo a bloquear tu ataque...\n", true);
                        }
                    }
                    if (objetivo.getState() == 6) {
                        ejec2 = false;
                        try {
                            ejec2 = this.usingWeapon.execCode("infoNoTiempoEsquivar", new Object[]{this, objetivo});
                            if (!ejec2) {
                                ejec2 = this.execCode("infoNoTiempoEsquivar", new Object[]{objetivo});
                            }
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoNoTiempoEsquivar(), target id was " + ((Mobile)objetivo).getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                        }
                        if (!ejec2) {
                            this.habitacionActual.informAction(this, (Mobile)objetivo, null, "No te da tiempo a esquivar el ataque de $1...\n", "A $2 no le da tiempo a esquivar tu ataque...\n", true);
                        }
                    }
                    if (danyo > 0) {
                        ejec2 = false;
                        try {
                            ejec2 = this.usingWeapon.execCode("infoAcierto", new Object[]{this, objetivo, new Integer(danyo)});
                            if (!ejec2) {
                                ejec2 = this.execCode("infoAcierto", new Object[]{objetivo, new Integer(danyo)});
                            }
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoAcierto(), target id was " + ((Mobile)objetivo).getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                        }
                        if (!ejec2) {
                            if (this.numeric_damage) {
                                this.habitacionActual.informAction(this, (Mobile)objetivo, "$1 acierta a $2 con " + this.usingWeapon.constructName2OneItem() + " infligi\u00e9ndole " + danyo + " puntos de da\u00f1o...\n", "$1 te acierta con " + this.usingWeapon.constructName2OneItem(objetivo) + " infligi\u00e9ndote " + danyo + " puntos de da\u00f1o...\n", "Aciertas a $2 con " + this.usingWeapon.constructName2OneItem(this) + " infligi\u00e9ndole " + danyo + " puntos de da\u00f1o...\n", true);
                            } else {
                                this.habitacionActual.informAction(this, (Mobile)objetivo, "$1 acierta a $2 con " + this.usingWeapon.constructName2OneItem() + " infligi\u00e9ndole " + ((Mobile)objetivo).estimateDamage(danyo) + "...\n", "$1 te acierta con " + this.usingWeapon.constructName2OneItem(objetivo) + " infligi\u00e9ndote " + ((Mobile)objetivo).estimateDamage(danyo) + "...\n", "Aciertas a $2 con " + this.usingWeapon.constructName2OneItem(this) + " infligi\u00e9ndole " + ((Mobile)objetivo).estimateDamage(danyo) + "...\n", true);
                                this.habitacionActual.informActionAuto(objetivo, null, null, "$1 " + ((Mobile)objetivo).estimateStatus() + ".\n", true);
                            }
                        }
                    } else {
                        ejec2 = false;
                        try {
                            ejec2 = this.usingWeapon.execCode("infoAcierto", new Object[]{this, objetivo, new Integer(danyo)});
                            if (!ejec2) {
                                ejec2 = this.execCode("infoAcierto", new Object[]{objetivo, new Integer(danyo)});
                            }
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoAcierto(), target id was " + ((Mobile)objetivo).getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                        }
                        if (!ejec2) {
                            this.habitacionActual.informAction(this, (Mobile)objetivo, "$1 acierta a $2 con " + this.usingWeapon.constructName2OneItem() + " pero no le hace da\u00f1o...\n", "$1 te acierta con " + this.usingWeapon.constructName2OneItem(objetivo) + " pero no te hace da\u00f1o...\n", "Aciertas a $2 con " + this.usingWeapon.constructName2OneItem(this) + " pero no le haces da\u00f1o...\n", true);
                        }
                    }
                    this.setNewState(8, this.generateAttackRecoverTime(this.usingWeapon));
                    if (objetivo.getState() != 12) {
                        ((Mobile)objetivo).interrupt("el golpe");
                        objetivo.setNewState(10, ((Mobile)objetivo).generateRecoverFromUnblockedHitTime());
                    }
                }
            } else {
                ejec = false;
                try {
                    ejec = this.usingWeapon.execCode("infoFallo", new Object[]{this, objetivo});
                    if (!ejec) {
                        ejec = this.execCode("infoFallo", new Object[]{objetivo});
                    }
                }
                catch (TargetError te) {
                    this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoAcierto(), target id was " + ((Mobile)objetivo).getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                }
                if (!ejec) {
                    this.habitacionActual.informAction(this, (Mobile)objetivo, "El ataque de $1 falla a $2.\n", "El ataque de $1 te falla.\n", "Tu ataque falla a $2.\n", true);
                }
                this.setNewState(8, this.generateAttackRecoverTime(this.usingWeapon));
                if (objetivo.getState() == 4) {
                    objetivo.setNewState(1, 1L);
                    ejec = false;
                    try {
                        ejec = this.usingWeapon.execCode("infoIniciativaTrasBloquear", new Object[]{this, objetivo});
                        if (!ejec) {
                            ejec = this.execCode("infoIniciativaTrasBloquear", new Object[]{objetivo});
                        }
                    }
                    catch (TargetError te) {
                        this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoAcierto(), target id was " + ((Mobile)objetivo).getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                    }
                    if (!ejec) {
                        this.habitacionActual.informAction(this, (Mobile)objetivo, null, "Tienes la iniciativa...\n", "$2 interrumpe su intento de bloquear...\n", true);
                    }
                }
                if (objetivo.getState() == 6) {
                    objetivo.setNewState(1, 1L);
                    ejec = false;
                    try {
                        ejec = this.usingWeapon.execCode("infoIniciativaTrasEsquivar", new Object[]{this, objetivo});
                        if (!ejec) {
                            ejec = this.execCode("infoIniciativaTrasEsquivar", new Object[]{objetivo});
                        }
                    }
                    catch (TargetError te) {
                        this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoAcierto(), target id was " + ((Mobile)objetivo).getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                    }
                    if (!ejec) {
                        this.habitacionActual.informAction(this, (Mobile)objetivo, null, "Tienes la iniciativa...\n", "$2 interrumpe su intento de esquivar...\n", true);
                    }
                }
            }
            this.usingWeapon.incrementAttackUsage(this);
        } else if (objetivo.getState() == 5) {
            if (this.getAttackSuccessFromProbability(this.usingWeapon)) {
                if (((Mobile)objetivo).getBlockSuccessFromProbability(((Mobile)objetivo).getCurrentWeapon())) {
                    Item limbHit = ((Mobile)objetivo).getRandomLimbToHit();
                    int danyo = this.usingWeapon.dealDamageDefended(this, (Mobile)objetivo, false, limbHit);
                    boolean ejec3 = false;
                    try {
                        ejec3 = this.usingWeapon.execCode("infoBloqueo", new Object[]{this, objetivo, new Integer(danyo)});
                        if (!ejec3) {
                            ejec3 = this.execCode("infoBloqueo", new Object[]{objetivo, new Integer(danyo)});
                        }
                    }
                    catch (TargetError te) {
                        this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoBloqueo(), target id was " + ((Mobile)objetivo).getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                    }
                    if (!ejec3) {
                        if (danyo > 0) {
                            if (this.numeric_damage) {
                                this.habitacionActual.informAction(this, (Mobile)objetivo, "$2 se defiende de $1 con " + ((Mobile)objetivo).getCurrentWeapon().constructName2OneItem() + " recibiendo " + danyo + " puntos de da\u00f1o...\n", "Te defiendes de $1 con " + ((Mobile)objetivo).getCurrentWeapon().constructName2OneItem(objetivo) + " recibiendo " + danyo + " puntos de da\u00f1o...\n", "$2 se defiende con " + ((Mobile)objetivo).getCurrentWeapon().constructName2OneItem(this) + " recibiendo " + danyo + " puntos de da\u00f1o...\n", true);
                            } else {
                                this.habitacionActual.informAction(this, (Mobile)objetivo, "$2 se defiende de $1 con " + ((Mobile)objetivo).getCurrentWeapon().constructName2OneItem() + " recibiendo " + ((Mobile)objetivo).estimateDamage(danyo) + "...\n", "Te defiendes de $1 con " + ((Mobile)objetivo).getCurrentWeapon().constructName2OneItem(objetivo) + " recibiendo " + ((Mobile)objetivo).estimateDamage(danyo) + "...\n", "$2 se defiende con " + ((Mobile)objetivo).getCurrentWeapon().constructName2OneItem(this) + " recibiendo " + ((Mobile)objetivo).estimateDamage(danyo) + "...\n", true);
                                this.habitacionActual.informActionAuto(objetivo, null, null, "$1 " + ((Mobile)objetivo).estimateStatus() + ".\n", true);
                            }
                        } else {
                            this.habitacionActual.informAction(this, (Mobile)objetivo, "$2 se defiende de $1 con " + ((Mobile)objetivo).getCurrentWeapon().constructName2OneItem() + ", desviando el ataque...\n", "Te defiendes de $1 con " + ((Mobile)objetivo).getCurrentWeapon().constructName2OneItem(objetivo) + ", desviando el ataque...\n", "$2 se defiende con " + ((Mobile)objetivo).getCurrentWeapon().constructName2OneItem(this) + ", desviando el ataque...\n", true);
                        }
                    }
                    this.setNewState(8, this.generateAttackRecoverTime(this.usingWeapon));
                    objetivo.setNewState(9, ((Mobile)objetivo).generateBlockRecoverTime(((Mobile)objetivo).getCurrentWeapon()));
                } else {
                    Item limbHit = ((Mobile)objetivo).getRandomLimbToHit();
                    int danyo = this.usingWeapon.dealDamage(this, (Mobile)objetivo, false, limbHit);
                    if (danyo > 0) {
                        boolean ejec4 = false;
                        try {
                            ejec4 = this.usingWeapon.execCode("infoBloqueoFallido", new Object[]{this, objetivo, new Integer(danyo)});
                            if (!ejec4) {
                                ejec4 = this.execCode("infoBloqueoFallido", new Object[]{objetivo, new Integer(danyo)});
                            }
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoBloqueo(), target id was " + ((Mobile)objetivo).getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                        }
                        if (!ejec4) {
                            if (this.numeric_damage) {
                                this.habitacionActual.informAction(this, (Mobile)objetivo, "$2 no consigue parar el ataque de $1, que le acierta con " + this.usingWeapon.constructName2OneItem() + " infligi\u00e9ndole " + danyo + " puntos de da\u00f1o...\n", "No consigues parar el ataque de $1, que te acierta con " + this.usingWeapon.constructName2OneItem(objetivo) + " infligi\u00e9ndote " + danyo + " puntos de da\u00f1o...\n", "$2 no consigue parar tu ataque, le aciertas con " + this.usingWeapon.constructName2OneItem(this) + " infligi\u00e9ndole " + danyo + " puntos de da\u00f1o...\n", true);
                            } else {
                                this.habitacionActual.informAction(this, (Mobile)objetivo, "$2 no consigue parar el ataque de $1, que le acierta con " + this.usingWeapon.constructName2OneItem() + " infligi\u00e9ndole " + ((Mobile)objetivo).estimateDamage(danyo) + "...\n", "No consigues parar el ataque de $1, que te acierta con " + this.usingWeapon.constructName2OneItem(objetivo) + " infligi\u00e9ndote " + ((Mobile)objetivo).estimateDamage(danyo) + "...\n", "$2 no consigue parar tu ataque, le aciertas con " + this.usingWeapon.constructName2OneItem(this) + " infligi\u00e9ndole " + ((Mobile)objetivo).estimateDamage(danyo) + "...\n", true);
                                this.habitacionActual.informActionAuto(objetivo, null, null, "$1 " + ((Mobile)objetivo).estimateStatus() + ".\n", true);
                            }
                        }
                    } else {
                        boolean ejec5 = false;
                        try {
                            ejec5 = this.usingWeapon.execCode("infoBloqueoFallido", new Object[]{this, objetivo, new Integer(danyo)});
                            if (!ejec5) {
                                ejec5 = this.execCode("infoBloqueoFallido", new Object[]{objetivo, new Integer(danyo)});
                            }
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoBloqueo(), target id was " + ((Mobile)objetivo).getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                        }
                        if (!ejec5) {
                            this.habitacionActual.informAction(this, (Mobile)objetivo, "$2 no consigue parar el ataque de $1, que le acierta con " + this.usingWeapon.constructName2OneItem() + " pero no le hace da\u00f1o...\n", "No consigues parar el ataque de $1, que te acierta con " + this.usingWeapon.constructName2OneItem(objetivo) + " pero no te hace da\u00f1o...\n", "$2 no consigue parar tu ataque, le aciertas con " + this.usingWeapon.constructName2OneItem(this) + " pero no le haces da\u00f1o...\n", true);
                        }
                    }
                    this.setNewState(8, this.generateAttackRecoverTime(this.usingWeapon));
                    if (objetivo.getState() != 12) {
                        ((Mobile)objetivo).interrupt("el golpe");
                        objetivo.setNewState(10, ((Mobile)objetivo).generateRecoverFromUnblockedHitTime());
                    }
                }
            } else {
                ejec = false;
                try {
                    ejec = this.usingWeapon.execCode("infoFallo", new Object[]{this, objetivo});
                    if (!ejec) {
                        ejec = this.execCode("infoFallo", new Object[]{objetivo});
                    }
                }
                catch (TargetError te) {
                    this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoFallo(), target id was " + ((Mobile)objetivo).getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                }
                if (!ejec) {
                    this.habitacionActual.informAction(this, (Mobile)objetivo, "El ataque de $1 falla a $2.\n", "El ataque de $1 te falla.\n", "Tu ataque falla a $2.\n", true);
                }
                this.setNewState(8, this.generateAttackRecoverTime(this.usingWeapon));
                objetivo.setNewState(1, 1L);
            }
        } else if (objetivo.getState() == 7) {
            if (this.getAttackSuccessFromProbability(this.usingWeapon)) {
                if (((Mobile)objetivo).getDodgeSuccessFromProbability()) {
                    ejec = false;
                    try {
                        ejec = this.usingWeapon.execCode("infoEsquivada", new Object[]{this, objetivo});
                        if (!ejec) {
                            ejec = this.execCode("infoEsquivada", new Object[]{objetivo});
                        }
                    }
                    catch (TargetError te) {
                        this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoEsquivada(), target id was " + ((Mobile)objetivo).getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                    }
                    if (!ejec) {
                        this.habitacionActual.informAction(this, (Mobile)objetivo, "$2 esquiva h\u00e1bilmente el ataque de $1.\n", "Esquivas el ataque de $1.\n", "$2 esquiva tu ataque.\n", true);
                    }
                    this.setNewState(8, this.generateAttackRecoverTime(this.usingWeapon));
                    objetivo.setNewState(11, ((Mobile)objetivo).generateDodgeRecoverTime());
                } else {
                    Item limbHit = ((Mobile)objetivo).getRandomLimbToHit();
                    int danyo = this.usingWeapon.dealDamage(this, (Mobile)objetivo, false, limbHit);
                    if (danyo > 0) {
                        boolean ejec6 = false;
                        try {
                            ejec6 = this.usingWeapon.execCode("infoEsquivadaFallida", new Object[]{this, objetivo});
                            if (!ejec6) {
                                ejec6 = this.execCode("infoEsquivadaFallida", new Object[]{objetivo});
                            }
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoEsquivadaFallida(), target id was " + ((Mobile)objetivo).getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                        }
                        if (!ejec6) {
                            if (this.numeric_damage) {
                                this.habitacionActual.informAction(this, (Mobile)objetivo, "$2 intenta esquivar el golpe de $1; pero no lo consigue, $1 le acierta con " + this.usingWeapon.constructName2OneItem() + " infligi\u00e9ndole " + danyo + " puntos de da\u00f1o...\n", "Tu intento de esquivar falla, y $1 te acierta con " + this.usingWeapon.constructName2OneItem(objetivo) + " infligi\u00e9ndote " + danyo + " puntos de da\u00f1o...\n", "A pesar de su intento de esquivar el ataque, aciertas a $2 con " + this.usingWeapon.constructName2OneItem(this) + ", infligi\u00e9ndole " + danyo + " puntos de da\u00f1o...\n", true);
                            } else {
                                this.habitacionActual.informAction(this, (Mobile)objetivo, "$2 intenta esquivar el golpe de $1; pero no lo consigue, $1 le acierta con " + this.usingWeapon.constructName2OneItem() + " infligi\u00e9ndole " + ((Mobile)objetivo).estimateDamage(danyo) + ".\n", "Tu intento de esquivar falla, y $1 te acierta con " + this.usingWeapon.constructName2OneItem(objetivo) + " infligi\u00e9ndote " + ((Mobile)objetivo).estimateDamage(danyo) + ".\n", "A pesar de su intento de esquivar el ataque, aciertas a $2 con " + this.usingWeapon.constructName2OneItem(this) + ", infligi\u00e9ndole " + ((Mobile)objetivo).estimateDamage(danyo) + ".\n", true);
                                this.habitacionActual.informActionAuto(objetivo, null, null, "$1 " + ((Mobile)objetivo).estimateStatus() + ".\n", true);
                            }
                        }
                    } else {
                        boolean ejec7 = false;
                        try {
                            ejec7 = this.usingWeapon.execCode("infoEsquivadaFallida", new Object[]{this, objetivo});
                            if (!ejec7) {
                                ejec7 = this.execCode("infoEsquivadaFallida", new Object[]{objetivo});
                            }
                        }
                        catch (TargetError te) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoEsquivadaFallida(), target id was " + ((Mobile)objetivo).getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                        }
                        if (!ejec7) {
                            this.habitacionActual.informAction(this, (Mobile)objetivo, "$2 intenta esquivar el golpe de $1; pero no lo consigue, $1 le acierta con " + this.usingWeapon.constructName2OneItem() + " pero no le hace da\u00f1o.\n", "Tu intento de esquivar falla, y $1 te acierta con " + this.usingWeapon.constructName2OneItem(objetivo) + " pero no te hace da\u00f1o.\n", "A pesar de su intento de esquivar el ataque, aciertas a $2 con " + this.usingWeapon.constructName2OneItem(this) + "; pero no le haces da\u00f1o.\n", true);
                        }
                    }
                    this.setNewState(8, this.generateAttackRecoverTime(this.usingWeapon));
                    if (objetivo.getState() != 12) {
                        ((Mobile)objetivo).interrupt("el golpe");
                        objetivo.setNewState(10, ((Mobile)objetivo).generateRecoverFromUnblockedHitTime());
                    }
                }
            } else {
                this.habitacionActual.informAction(this, (Mobile)objetivo, "El ataque de $1 falla a $2.\n", "El ataque de $1 te falla. Tienes la iniciativa...\n", "Tu ataque falla a $2. Te desequilibras...\n", true);
                this.setNewState(8, this.generateAttackRecoverTime(this.usingWeapon));
                objetivo.setNewState(1, 1L);
            }
        }
    }

    public void addEnemy(Mobile nuevo) {
        if (this.combatRefs == null) {
            this.combatRefs = new MobileList();
        }
        this.combatRefs.addMobile(nuevo);
        if (!nuevo.hasEnemy(this)) {
            nuevo.addEnemy(this);
        }
    }

    public boolean removeEnemy(Mobile viejo) {
        if (this.combatRefs == null) {
            return false;
        }
        return this.combatRefs.removeElement(viejo);
    }

    public void addItem(Item nuevo) throws WeightLimitExceededException, VolumeLimitExceededException {
        if (this.inventory == null) {
            this.inventory = new Inventory(50, 50);
        }
        this.inventory.addItem(nuevo);
        nuevo.addMobileReference(this);
    }

    public void addSpell(Spell nuevo) {
        if (this.spellRefs == null) {
            this.spellRefs = new SpellList();
        }
        this.spellRefs.addSpell(nuevo);
    }

    public boolean removeItem(Item viejo) {
        if (this.inventory == null) {
            return false;
        }
        viejo.removeMobileReference(this);
        return this.inventory.removeItem(viejo);
    }

    public boolean hasItem(Item it) {
        return this.inventory != null && this.inventory.contains(it);
    }

    public boolean hasSpell(Spell s) {
        return this.spellRefs != null && this.spellRefs.contains(s);
    }

    public boolean hasEnemy(Mobile m) {
        return this.combatRefs != null && this.combatRefs.contains(m);
    }

    public boolean hasEnemies() {
        return this.combatRefs != null && this.combatRefs.size() > 0;
    }

    public Inventory getInventory() {
        if (this.inventory == null) {
            this.inventory = new Inventory(50, 50);
        }
        return this.inventory;
    }

    public SpellList getSpells() {
        if (this.spellRefs == null) {
            this.spellRefs = new SpellList();
        }
        return this.spellRefs;
    }

    public Wearable getWornItem(Item limb) {
        List l = limb.getRelatedEntitiesByValue("wears", true);
        if (l == null || l.size() < 1) {
            return null;
        }
        return (Wearable)l.get(0);
    }

    public Inventory getWornItems() {
        Inventory limbs = this.getFlattenedPartsInventory();
        Inventory result = new Inventory(10000, 10000);
        if (limbs == null) {
            return result;
        }
        for (int i = 0; i < limbs.size(); ++i) {
            Item limb = limbs.elementAt(i);
            Wearable worn = this.getWornItem(limb);
            if (worn == null) continue;
            try {
                result.addItem(worn);
                continue;
            }
            catch (WeightLimitExceededException wle) {
                wle.printStackTrace();
                continue;
            }
            catch (VolumeLimitExceededException vle) {
                vle.printStackTrace();
            }
        }
        this.wornItems = result;
        return result;
    }

    public Weapon getWieldedItem(Item limb) {
        List l = limb.getRelatedEntitiesByValue("wields", true);
        if (l == null || l.size() < 1) {
            return null;
        }
        return (Weapon)l.get(0);
    }

    public int tryToDealDamage(int damtype, int damage, boolean simulated) {
        if (!simulated) {
            this.decreaseHP(damage);
        }
        return damage;
    }

    public int tryToDealDamage(List damList, boolean simulated) {
        Item limbToHit = this.getRandomLimbToHit();
        return this.tryToDealDamage(damList, simulated, limbToHit);
    }

    public int tryToDealDamage(List damList, boolean simulated, Item limb) {
        Wearable armadura = null;
        if (limb != null) {
            armadura = this.getWornItem(limb);
        }
        List armorDamList = null;
        if (armadura != null) {
            armorDamList = armadura.getDamageList(this);
        }
        if (armorDamList == null) {
            int damDealt = 0;
            for (int i = 0; i < damList.size(); ++i) {
                int thisDam = (Integer)damList.get(i);
                if (!simulated) {
                    this.decreaseHP(thisDam);
                }
                damDealt += thisDam;
            }
            return damDealt;
        }
        int damDealt = 0;
        for (int i = 0; i < damList.size(); ++i) {
            int thisDam = i < armorDamList.size() ? (Integer)damList.get(i) - (Integer)armorDamList.get(i) : (Integer)damList.get(i);
            if (thisDam <= 0) {
                thisDam = 0;
            }
            if (!simulated && thisDam > 0) {
                this.decreaseHP(thisDam);
            }
            damDealt += thisDam;
        }
        if (damDealt == 0) {
            this.habitacionActual.informAction(this, null, armadura.constructName2OneItem() + " de $1 absorbe totalmente el impacto.\n", null, "Tu armadura absorbe totalmente el impacto.\n", true);
        }
        return damDealt;
    }

    public int decreaseHP(int amount) {
        this.hp -= amount;
        if (this.hp <= 0) {
            this.prepareToDie();
        }
        return amount;
    }

    public void setHP(int amt) {
        this.hp = amt;
    }

    public void setMP(int amt) {
        this.mp = amt;
    }

    public void prepareToDie() {
        this.setNewState(12, 1L);
    }

    public void die() {
        System.out.println(this + " est\u00e1 m\u00e1s que muerto.");
        boolean ejecutado = false;
        try {
            ejecutado = this.execCode("beforeDie", new Object[0]);
        }
        catch (TargetError bshte) {
            this.write("bsh.TargetError found at die routine");
        }
        if (ejecutado) {
            return;
        }
        this.habitacionActual.informAction(this, null, "$1 muere.\n", null, "Mueres.\n", true);
        Item cadaver = Item.initCorpse(this);
        this.mundo.addItemAssigningID(cadaver);
        try {
            this.habitacionActual.addItem(cadaver);
            this.habitacionActual.removeMob(this);
            this.setNewState(13, 1L);
        }
        catch (WeightLimitExceededException wlee) {
            System.out.println("Can't add corpse to room: " + wlee);
        }
        catch (VolumeLimitExceededException vlee) {
            System.out.println("Can't add corpse to room: " + vlee);
        }
        try {
            ejecutado = this.execCode("afterDie", new Object[]{cadaver});
        }
        catch (TargetError bshte) {
            this.write("bsh.TargetError found at die routine");
        }
    }

    public void setID(int newid) {
        this.idnumber = newid < 20000000 ? newid + 20000000 : newid;
    }

    public Weapon bestNonWieldedWeapon(int numberOfSimulations) {
        if (this.inventory == null) {
            return null;
        }
        int max = -1;
        Weapon resultado = null;
        for (int i = 0; i < this.inventory.size(); ++i) {
            Weapon w;
            try {
                w = (Weapon)this.inventory.elementAt(i);
            }
            catch (ClassCastException cce) {
                continue;
            }
            if (this.wieldedWeapons != null && this.wieldedWeapons.contains(w)) continue;
            int acum = 0;
            for (int k = 0; k < numberOfSimulations; ++k) {
                acum += w.dealDamage(this, this, true);
            }
            int media = acum / numberOfSimulations;
            if (media <= max) continue;
            resultado = w;
        }
        return resultado;
    }

    public Object[] bestBlockTargetAndWeapon(int numberOfSimulations) {
        List atacantes = this.getAttackingEnemies();
        Inventory usableWeapons = this.getUsableWeapons();
        if (this.combatRefs == null || usableWeapons == null) {
            return null;
        }
        if (atacantes.size() < 1) {
            return null;
        }
        Object[] resultado = new Object[2];
        System.out.println("Best block function result initted.");
        double max = -1.0;
        for (int i = 0; i < atacantes.size(); ++i) {
            Mobile m = (Mobile)atacantes.get(i);
            if (!this.habitacionActual.hasMobile(m)) continue;
            System.out.println("Checking a mob.");
            for (int j = 0; j < usableWeapons.size(); ++j) {
                Weapon w = (Weapon)usableWeapons.elementAt(j);
                System.out.println("Checking a weapon.");
                if (w != null) {
                    System.out.println("It's not null, this weapon.");
                    double deftime = w.getTypicalDefenseTime(m);
                    int attime = (int)m.getPropertyTimeLeft("state");
                    if (deftime < (double)attime) {
                        System.out.println("ME CONVENCE.");
                        double evalf = 100.0 - deftime;
                        if (!(evalf > max)) continue;
                        max = evalf;
                        resultado[0] = m;
                        resultado[1] = w;
                        continue;
                    }
                    System.out.println("NO ME CONVENCE.");
                    continue;
                }
                System.out.println("It was null, the weapon.");
            }
        }
        if (resultado[0] == null) {
            return null;
        }
        return resultado;
    }

    public Object[] bestAttackTargetAndWeapon(int numberOfSimulations) {
        Inventory usableWeapons = this.getUsableWeapons();
        System.out.println("Usable weapons for " + this.getTitle() + ": " + usableWeapons);
        if (this.combatRefs == null || usableWeapons == null) {
            return null;
        }
        int max = -1;
        Object[] resultado = new Object[2];
        for (int i = 0; i < this.combatRefs.size(); ++i) {
            Mobile m = this.combatRefs.elementAt(i);
            if (!this.habitacionActual.hasMobile(m)) continue;
            for (int j = 0; j < usableWeapons.size(); ++j) {
                Weapon w = (Weapon)usableWeapons.elementAt(j);
                if (w == null) continue;
                int acum = 0;
                for (int k = 0; k < numberOfSimulations; ++k) {
                    acum += w.dealDamage(this, m, true);
                }
                int media = acum / numberOfSimulations;
                if (media <= max) continue;
                max = media;
                resultado[0] = m;
                resultado[1] = w;
            }
        }
        if (resultado[0] == null) {
            return null;
        }
        return resultado;
    }

    public boolean attackBestTarget() {
        Object[] obj = this.bestAttackTargetAndWeapon(5);
        System.out.println("Best attack target and weapon: " + obj);
        if (obj == null) {
            return false;
        }
        Mobile target = (Mobile)obj[0];
        Weapon w = (Weapon)obj[1];
        this.attack(target, w);
        return true;
    }

    public boolean blockBestTarget() {
        Object[] obj = this.bestBlockTargetAndWeapon(5);
        System.out.println("Best block target and weapon: " + obj);
        if (obj == null) {
            return false;
        }
        Mobile target = (Mobile)obj[0];
        Weapon w = (Weapon)obj[1];
        this.block(target, w);
        return true;
    }

    public void attack(Mobile target, Weapon w) {
        this.setNewTarget(target.getID());
        this.usingWeapon = w;
        this.setNewState(3, this.generateAttackTime(w));
        boolean ejec = false;
        try {
            ejec = this.usingWeapon.execCode("infoIntentoAtaque", new Object[]{this, target});
            if (!ejec) {
                ejec = this.execCode("infoIntentoAtaque", new Object[]{target});
            }
        }
        catch (TargetError te) {
            this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoIntentoAtaque(), target id was " + target.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
        }
        if (!ejec) {
            this.habitacionActual.informAction(this, target, "$1 ataca a $2 con " + w.constructName2OneItem() + ".\n", "$1 te ataca con " + w.constructName2OneItem(target) + ".\n", "Atacas a $2 con " + w.constructName2OneItem(this) + ".\n", true);
        }
    }

    public void block(Mobile target, Weapon w) {
        this.setNewTarget(target.getID());
        this.usingWeapon = w;
        this.setNewState(4, this.generateBlockTime(w));
        boolean ejec = false;
        try {
            ejec = this.usingWeapon.execCode("infoIntentoBloqueo", new Object[]{this, target});
            if (!ejec) {
                ejec = this.execCode("infoIntentoBloqueo", new Object[]{target});
            }
        }
        catch (TargetError te) {
            this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoIntentoBloqueo(), target id was " + target.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
        }
        if (!ejec) {
            this.habitacionActual.informAction(this, target, "$1 intenta defenderse de $2 con " + w.constructName2OneItem() + ".\n", "$1 intenta defenderse con " + w.constructName2OneItem(target) + ".\n", "Intentas defenderte de $2 con " + w.constructName2OneItem(this) + ".\n", true);
        }
    }

    public void dodge(Mobile target) {
        this.setNewTarget(target.getID());
        this.setNewState(6, this.generateDodgeTime());
        boolean ejec = false;
        try {
            ejec = this.execCode("infoIntentoEsquivada", new Object[]{target});
        }
        catch (TargetError te) {
            this.write(this.io.getColorCode("error") + "bsh.TargetError found at infoIntentoEsquivada(), target id was " + target.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
        }
        if (!ejec) {
            this.habitacionActual.informAction(this, target, "$1 intenta esquivar el ataque de $2.\n", "$1 intenta esquivarte.\n", "Intentas esquivar el ataque de $2.\n", true);
        }
    }

    public MobileList getEnemies() {
        return this.combatRefs;
    }

    public void removeAllEnemies() {
        for (int i = 0; i < this.combatRefs.size(); ++i) {
            this.combatRefs.removeElement(this.combatRefs.elementAt(i));
        }
    }

    public List getAttackingEnemies() {
        if (!this.hasEnemies()) {
            return new ArrayList();
        }
        ArrayList<Mobile> res = new ArrayList<Mobile>();
        for (int i = 0; i < this.combatRefs.size(); ++i) {
            Mobile enemigo = this.combatRefs.elementAt(i);
            if (enemigo.getState() != 3 || enemigo.getTarget() != this.getID()) continue;
            res.add(enemigo);
        }
        return res;
    }

    public boolean getAttackSuccessFromProbability(Weapon w) {
        double prob;
        double dado = this.getRandom().nextDouble();
        return dado < (prob = this.generateAttackProbability(w));
    }

    public boolean getSuccessFromProbability(Spell s) {
        double prob;
        double dado = this.getRandom().nextDouble();
        return dado < (prob = this.generateCastProbability(s));
    }

    public boolean getBlockSuccessFromProbability(Weapon w) {
        double prob;
        double dado = this.getRandom().nextDouble();
        return dado < (prob = this.generateDefenseProbability(w));
    }

    public boolean getDodgeSuccessFromProbability() {
        double prob;
        double dado = this.getRandom().nextDouble();
        return dado < (prob = this.generateDodgeProbability());
    }

    public double generateCastProbability(Spell s) {
        double basicProb = s.getTypicalCastProbability(this);
        System.out.println("Basic probability: " + basicProb);
        return basicProb;
    }

    public double generateAttackProbability(Weapon w) {
        double basicProb = w.getTypicalAttackProbability(this);
        return basicProb;
    }

    public double generateDefenseProbability(Weapon w) {
        double basicProb = w.getTypicalDefenseProbability(this);
        return basicProb;
    }

    public double generateDodgeProbability() {
        return 0.2;
    }

    public int generateAttackTime(Weapon w) {
        double basicTime = w.getTypicalAttackTime(this);
        double variedTime = Utility.applyGaussianVariation(basicTime, this.getRandom(), 0.3333333333333333);
        System.out.println("Attack time with " + w + ": " + variedTime);
        if ((int)variedTime < 1) {
            return 1;
        }
        return (int)variedTime;
    }

    public int generateCastTime(Spell s) {
        double basicTime = s.getTypicalCastTime(this);
        double variedTime = Utility.applyGaussianVariation(basicTime, this.getRandom(), 0.3333333333333333);
        System.out.println("Cast time with " + s + ": " + variedTime);
        if ((int)variedTime < 1) {
            return 1;
        }
        return (int)variedTime;
    }

    public int generateBlockTime(Weapon w) {
        double basicTime = w.getTypicalDefenseTime(this);
        double variedTime = Utility.applyGaussianVariation(basicTime, this.getRandom(), 0.3333333333333333);
        System.out.println("Defense time with " + w + ": " + variedTime);
        if ((int)variedTime < 1) {
            return 1;
        }
        return (int)variedTime;
    }

    public int generateAttackRecoverTime(Weapon w) {
        double basicTime = w.getTypicalAttackRecoverTime(this);
        double variedTime = Utility.applyGaussianVariation(basicTime, this.getRandom(), 0.3333333333333333);
        System.out.println("Attack recover time with " + w + ": " + (int)variedTime);
        if ((int)variedTime < 1) {
            return 1;
        }
        return (int)variedTime;
    }

    public int generateBlockRecoverTime(Weapon w) {
        double basicTime = w.getTypicalDefenseRecoverTime(this);
        double variedTime = Utility.applyGaussianVariation(basicTime, this.getRandom(), 0.3333333333333333);
        System.out.println("Defense recover time with " + w + ": " + variedTime);
        if ((int)variedTime < 1) {
            return 1;
        }
        return (int)variedTime;
    }

    public int generateRecoverFromUnblockedHitTime() {
        double basicTime = 30.0;
        double variedTime = Utility.applyGaussianVariation(basicTime, this.getRandom(), 0.6666666666666666);
        System.out.println("Recover from unblocked hit time generated: " + variedTime);
        if ((int)variedTime < 1) {
            return 1;
        }
        return (int)variedTime;
    }

    public int generateDodgeTime() {
        return 15;
    }

    public int generateDodgeRecoverTime() {
        return 15;
    }

    public Node getXMLRepresentation(Document doc) {
        Text elNombre;
        Element esteNombre;
        String tok;
        StringTokenizer st;
        Element suElemento = doc.createElement("Mobile");
        suElemento.setAttribute("id", String.valueOf(this.idnumber));
        suElemento.setAttribute("name", String.valueOf(this.title));
        suElemento.setAttribute("extends", String.valueOf(this.inheritsFrom));
        suElemento.setAttribute("clones", String.valueOf(this.isInstanceOf));
        suElemento.setAttribute("type", String.valueOf(this.mobileType));
        suElemento.setAttribute("properName", String.valueOf(this.properName));
        suElemento.setAttribute("hp", String.valueOf(this.hp));
        suElemento.setAttribute("mp", String.valueOf(this.mp));
        suElemento.setAttribute("maxhp", String.valueOf(this.maxhp));
        suElemento.setAttribute("maxmp", String.valueOf(this.maxmp));
        suElemento.appendChild(this.getPropListXMLRepresentation(doc));
        suElemento.appendChild(this.getRelationshipListXMLRepresentation(doc));
        Element habitacAct = doc.createElement("CurrentRoom");
        if (this.habitacionActual != null) {
            habitacAct.setAttribute("id", String.valueOf(this.habitacionActual.getID()));
            suElemento.appendChild(habitacAct);
        }
        habitacAct = doc.createElement("LastRoom");
        if (this.habitacionAnterior != null) {
            habitacAct.setAttribute("id", String.valueOf(this.habitacionAnterior.getID()));
            suElemento.appendChild(habitacAct);
        }
        suElemento.setAttribute("gender", String.valueOf(this.gender));
        Element listaDesc = doc.createElement("DescriptionList");
        for (int i = 0; i < this.descriptionList.length; ++i) {
            Description nuestraDescripcion = this.descriptionList[i];
            listaDesc.appendChild(nuestraDescripcion.getXMLRepresentation(doc));
        }
        suElemento.appendChild(listaDesc);
        Element listaSing = doc.createElement("SingularNames");
        for (int i = 0; i < this.singNames.length; ++i) {
            Description nuestraDescripcion = this.singNames[i];
            listaSing.appendChild(nuestraDescripcion.getXMLRepresentation(doc));
        }
        suElemento.appendChild(listaSing);
        Element listaPlur = doc.createElement("PluralNames");
        for (int i = 0; i < this.plurNames.length; ++i) {
            Description nuestraDescripcion = this.plurNames[i];
            listaPlur.appendChild(nuestraDescripcion.getXMLRepresentation(doc));
        }
        suElemento.appendChild(listaPlur);
        if (this.respondToSing != null) {
            Element respTo = doc.createElement("SingularReferenceNames");
            st = new StringTokenizer(this.respondToSing, "$");
            while (st.hasMoreTokens()) {
                tok = st.nextToken();
                esteNombre = doc.createElement("Name");
                elNombre = doc.createTextNode(tok);
                esteNombre.appendChild(elNombre);
                respTo.appendChild(esteNombre);
            }
            suElemento.appendChild(respTo);
        }
        if (this.respondToPlur != null) {
            Element respTo = doc.createElement("PluralReferenceNames");
            st = new StringTokenizer(this.respondToPlur, "$");
            while (st.hasMoreTokens()) {
                tok = st.nextToken();
                esteNombre = doc.createElement("Name");
                elNombre = doc.createTextNode(tok);
                esteNombre.appendChild(elNombre);
                respTo.appendChild(esteNombre);
            }
            suElemento.appendChild(respTo);
        }
        if (this.inventory != null) {
            suElemento.appendChild(this.inventory.getXMLRepresentation(doc));
        }
        if (this.spellRefs != null) {
            suElemento.appendChild(this.spellRefs.getXMLRepresentation(doc));
        }
        if (this.virtualInventory != null) {
            Element vi = doc.createElement("VirtualInventory");
            vi.appendChild(this.virtualInventory.getXMLRepresentation(doc));
            suElemento.appendChild(vi);
        }
        if (this.wieldedWeapons != null) {
            Element ww = doc.createElement("WieldedWeaponsInventory");
            ww.appendChild(this.wieldedWeapons.getXMLRepresentation(doc));
            suElemento.appendChild(ww);
        }
        if (this.wornItems != null) {
            Element ww = doc.createElement("WornItemsInventory");
            ww.appendChild(this.wornItems.getXMLRepresentation(doc));
            suElemento.appendChild(ww);
        }
        if (this.wieldingLimbs != null) {
            Element wl = doc.createElement("WieldingLimbsInventory");
            wl.appendChild(this.wieldingLimbs.getXMLRepresentation(doc));
            suElemento.appendChild(wl);
        }
        if (this.partsInventory != null) {
            Element p = doc.createElement("Parts");
            p.appendChild(this.partsInventory.getXMLRepresentation(doc));
            suElemento.appendChild(p);
        }
        if (this.extraDescriptions != null) {
            Element extraDes = doc.createElement("ExtraDescriptionList");
            StringTokenizer st1 = new StringTokenizer(this.extraDescriptions, "@");
            while (st1.hasMoreTokens()) {
                String desActual = st1.nextToken();
                Element unaDescripcion = doc.createElement("ExtraDescription");
                StringTokenizer st2 = new StringTokenizer(desActual, "$");
                while (st2.hasMoreTokens()) {
                    String wordActual = st2.nextToken();
                    if (st2.hasMoreTokens()) {
                        Element comando = doc.createElement("Name");
                        Text contenido = doc.createTextNode(wordActual);
                        comando.appendChild(contenido);
                        unaDescripcion.appendChild(comando);
                        continue;
                    }
                    Text texto = doc.createTextNode(wordActual);
                    unaDescripcion.appendChild(texto);
                }
                extraDes.appendChild(unaDescripcion);
            }
            suElemento.appendChild(extraDes);
        }
        if (this.caracteristicas != null) {
            suElemento.appendChild(this.caracteristicas.getXMLRepresentation(doc));
        }
        if (this.itsCode != null) {
            suElemento.appendChild(this.itsCode.getXMLRepresentation(doc));
        }
        if (this.PSIkeywords != null) {
            Element PSISpecElement = doc.createElement("ConversationalAI");
            for (int i = 0; i < this.PSIkeywords.size(); ++i) {
                Element mappingElement = doc.createElement("Mapping");
                mappingElement.setAttribute("command", (String)this.PSIkeywords.elementAt(i));
                Description[] respuesta = (Description[])this.PSIanswers.elementAt(i);
                for (int j = 0; j < respuesta.length; ++j) {
                    Description nuestraDescripcion = respuesta[j];
                    mappingElement.appendChild(nuestraDescripcion.getXMLRepresentation(doc));
                }
                PSISpecElement.appendChild(mappingElement);
            }
            suElemento.appendChild(PSISpecElement);
        }
        return suElemento;
    }

    public void loadNumberGenerator(World mundo) {
        this.aleat = mundo.getRandom();
    }

    public Random getRandom() {
        return this.aleat;
    }

    public void incSkill(String skillName) {
        this.caracteristicas.incSkill(skillName);
    }

    public void setSkill(String skillN, long val) {
        this.caracteristicas.setSkill(skillN, val);
    }

    public void setStat(String stat, int val) {
        this.caracteristicas.setStat(stat, val);
    }

    public Inventory getInventoryForCorpse() {
        if (this instanceof Player) {
            return this.inventory;
        }
        return this.virtualInventory;
    }

    public void loadRelationshipsFromXML(World mundo) throws XMLtoWorldException {
        this.relationships = new Vector();
        this.relationship_properties = new Vector();
        Element n = mundo.getMobileNode(String.valueOf(this.getID()));
        Element e = null;
        try {
            e = n;
        }
        catch (ClassCastException cce) {
            throw new XMLtoWorldException("Mobile node not Element");
        }
        NodeList relListNodes = e.getElementsByTagName("RelationshipList");
        if (relListNodes.getLength() > 0) {
            NodeList relationshipNodes;
            try {
                relationshipNodes = ((Element)relListNodes.item(0)).getElementsByTagName("Relationship");
            }
            catch (ClassCastException cce) {
                throw new XMLtoWorldException("Relationship list node not Element");
            }
            if (relationshipNodes.getLength() > 0) {
                for (int i = 0; i < relationshipNodes.getLength(); ++i) {
                    ArrayList<PropertyEntry> thisRelPropList = new ArrayList<PropertyEntry>();
                    Entity thisRelEntity = null;
                    Element relationshipNode = (Element)relationshipNodes.item(i);
                    NodeList propListNodes = relationshipNode.getElementsByTagName("PropertyList");
                    if (propListNodes.getLength() <= 0) continue;
                    Element relationshipPropertyList = (Element)propListNodes.item(i);
                    NodeList propEntryNodes = relationshipPropertyList.getElementsByTagName("PropertyEntry");
                    if (propEntryNodes.getLength() > 0) {
                        for (int j = 0; j < propEntryNodes.getLength(); ++j) {
                            Node nod = propEntryNodes.item(j);
                            PropertyEntry pe = new PropertyEntry(mundo, nod);
                            thisRelPropList.add(pe);
                        }
                    }
                    if (relationshipNode.hasAttribute("id")) {
                        thisRelEntity = mundo.getObject(relationshipNode.getAttribute("id"));
                        if (thisRelEntity == null) {
                            throw new XMLtoWorldException("Entity referenced at Relationship node's ID attribute is nonexistent or null");
                        }
                        this.relationships.add(thisRelEntity);
                        this.relationship_properties.add(thisRelPropList);
                        continue;
                    }
                    throw new XMLtoWorldException("Relationship node lacks attribute id");
                }
            }
        }
    }

    public Inventory getUsableWeapons() {
        int i;
        Inventory result = new Inventory(1000000, 1000000);
        for (i = result.size() - 1; i >= 0; --i) {
            Item current = result.elementAt(i);
            List blandidos = current.getRelatedEntitiesByValue("wields", true);
            if (blandidos.size() <= 0) continue;
            result.removeItem(current);
        }
        if (this.wieldedWeapons != null) {
            for (i = 0; i < this.wieldedWeapons.size(); ++i) {
                Item arma = this.wieldedWeapons.elementAt(i);
                if (arma == null) continue;
                try {
                    result.addItem(arma);
                    continue;
                }
                catch (WeightLimitExceededException wle) {
                    wle.printStackTrace();
                    continue;
                }
                catch (VolumeLimitExceededException vle) {
                    vle.printStackTrace();
                }
            }
        }
        Inventory nat = this.getNaturalWeapons();
        for (int i2 = 0; i2 < nat.size(); ++i2) {
            try {
                result.addItem(nat.elementAt(i2));
                continue;
            }
            catch (WeightLimitExceededException wle) {
                wle.printStackTrace();
                continue;
            }
            catch (VolumeLimitExceededException vle) {
                vle.printStackTrace();
            }
        }
        System.out.println("Usable weapons: " + result);
        return result;
    }

    public Inventory getNaturalWeapons() {
        Inventory miembros = this.getFlattenedPartsInventory();
        if (miembros == null) {
            return new Inventory(10000, 10000);
        }
        for (int i = miembros.size() - 1; i >= 0; --i) {
            Item it = miembros.elementAt(i);
            if (it instanceof Weapon) continue;
            miembros.removeItem(it);
        }
        return miembros;
    }

    public Inventory getPartsInventory() {
        return this.partsInventory;
    }

    public Inventory getFlattenedPartsInventory() {
        if (this.partsInventory == null) {
            this.partsInventory = new Inventory(10000, 10000);
        }
        Inventory result = new Inventory(this.partsInventory.getWeightLimit(), this.partsInventory.getVolumeLimit());
        for (int i = 0; i < this.partsInventory.size(); ++i) {
            Item thisPart = this.partsInventory.elementAt(i);
            Inventory subInv = thisPart.getFlattenedPartsInventory();
            try {
                result.setVolumeLimit(result.getVolumeLimit() + subInv.getVolumeLimit());
                result.setWeightLimit(result.getWeightLimit() + subInv.getWeightLimit());
            }
            catch (Exception e) {
                System.out.println("Impossible exception thrown: " + e);
                e.printStackTrace();
            }
            for (int j = 0; j < subInv.size(); ++j) {
                try {
                    result.addItem(subInv.elementAt(j));
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Impossible exception thrown: " + e);
                    e.printStackTrace();
                }
            }
            try {
                result.addItem(thisPart);
                continue;
            }
            catch (Exception e) {
                System.out.println("Impossible exception thrown: " + e);
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean intentarVestir(Item it, boolean freeLimbsNeeded) {
        if (!(it instanceof Wearable)) {
            if (it instanceof Weapon) {
                this.write(this.io.getColorCode("denial") + "\u00bfVestir " + it.constructName2OneItem(this) + "? Parece m\u00e1s adecuado blandir" + (it.getGender() ? "lo" : "la") + ".\n");
            } else {
                this.write(this.io.getColorCode("denial") + "No parece que " + it.constructName2OneItem(this) + " sea algo que se pueda vestir." + "\n");
            }
            return false;
        }
        Inventory ourLimbs = this.getFlattenedPartsInventory();
        if (ourLimbs.size() < 1) {
            this.write(this.io.getColorCode("error") + "No puedes ponerte ropa si no tienes ning\u00fan miembro.");
        }
        for (int i = 0; i < ourLimbs.size(); ++i) {
            Item limb = ourLimbs.elementAt(i);
            if (!limb.getRelationshipPropertyValueAsBoolean(it, "wears")) continue;
            this.write(this.io.getColorCode("denial") + "Ya llevas puesto " + it.constructName2OneItem(this) + ".\n");
            return false;
        }
        List requirements = ((Wearable)it).getLimbRequirementsList();
        Vector<Item> usedLimbs = new Vector<Item>();
        for (int i = 0; i < requirements.size(); ++i) {
            List vestidos;
            int k;
            String requirementString = (String)requirements.get(i);
            StringTokenizer st = new StringTokenizer(requirementString, "$");
            Vector matchingLimbs = new Vector();
            while (st.hasMoreTokens()) {
                Vector temp = ourLimbs.patternMatch(st.nextToken(), false);
                for (int l = 0; l < temp.size(); ++l) {
                    if (matchingLimbs.contains(temp.elementAt(l))) continue;
                    matchingLimbs.add(temp.elementAt(l));
                }
            }
            if (matchingLimbs.size() < 1) {
                this.write(this.io.getColorCode("denial") + "No parece adecuado para los de tu especie." + this.io.getColorCode("reset") + "\n");
                return false;
            }
            for (k = 0; k < matchingLimbs.size(); ++k) {
                Item thisLimb = (Item)matchingLimbs.get(k);
                vestidos = thisLimb.getRelatedEntitiesByValue("wears", true);
                if (vestidos.size() >= 1 || usedLimbs.contains(thisLimb)) continue;
                usedLimbs.add(thisLimb);
                break;
            }
            if (k != matchingLimbs.size()) continue;
            if (!freeLimbsNeeded) {
                Item busyLimb = (Item)matchingLimbs.get(0);
                vestidos = busyLimb.getRelatedEntitiesByValue("wears", true);
                for (int z = 0; z < vestidos.size(); ++z) {
                    if (this.desvestir((Item)vestidos.get(z))) continue;
                    return false;
                }
                continue;
            }
            for (int n = 0; n < matchingLimbs.size(); ++n) {
                Item current = (Item)matchingLimbs.get(n);
                List vestidos2 = current.getRelatedEntitiesByValue("wears", true);
                if (vestidos2.size() > 0) {
                    Item vestido = (Item)vestidos2.get(0);
                    this.write(this.io.getColorCode("information") + "Llevas puesto " + vestido.constructName2OneItem(this) + " en " + current.constructName2OneItem(this) + "." + this.io.getColorCode("reset") + "\n");
                    continue;
                }
                this.write(this.io.getColorCode("information") + "Tienes libre " + current.constructName2OneItem(this));
            }
            this.write(this.io.getColorCode("denial") + "Tienes que quitarte algo para poder vestir " + it.constructName2OneItem(this) + "." + this.io.getColorCode("reset") + "\n");
            return false;
        }
        String toOutput = "";
        for (int i = 0; i < usedLimbs.size(); ++i) {
            Item limb = (Item)usedLimbs.get(i);
            limb.setRelationshipProperty((Entity)it, "wears", true);
            toOutput = i == 0 ? toOutput + limb.constructName2OneItem(this) : (i > 0 && i == usedLimbs.size() - 1 ? toOutput + " y " + limb.constructName2OneItem(this) : toOutput + ", " + limb.constructName2OneItem(this));
        }
        this.write(this.io.getColorCode("action") + "Te pones " + it.constructName2OneItem(this) + " en " + toOutput + ".\n" + this.io.getColorCode("reset"));
        this.habitacionActual.informActionAuto(this, null, "$1 se pone " + it.constructName2OneItem() + ".\n", false);
        if (this.wornItems == null) {
            this.wornItems = new Inventory(10000, 10000);
        }
        try {
            this.wornItems.addItem(it);
        }
        catch (WeightLimitExceededException wlee) {
            this.write(this.io.getColorCode("denial") + "No puedes vestir eso, pesa demasiado." + ".\n" + this.io.getColorCode("reset"));
        }
        catch (VolumeLimitExceededException vlee) {
            this.write(this.io.getColorCode("denial") + "No puedes blandir eso, pesa demasiado." + ".\n" + this.io.getColorCode("reset"));
        }
        return true;
    }

    public boolean intentarBlandir(Item it, boolean freeLimbsNeeded) {
        if (!(it instanceof Weapon)) {
            if (it instanceof Wearable) {
                this.write(this.io.getColorCode("denial") + "\u00bfBlandir " + it.constructName2OneItem(this) + "? Parece m\u00e1s adecuado vestir" + (it.getGender() ? "lo" : "la") + ".\n");
            } else {
                this.write(this.io.getColorCode("denial") + "No parece que " + it.constructName2OneItem(this) + " sea un arma." + "\n");
            }
            return false;
        }
        Inventory ourLimbs = this.getFlattenedPartsInventory();
        for (int i = 0; i < ourLimbs.size(); ++i) {
            Item limb = ourLimbs.elementAt(i);
            if (!limb.getRelationshipPropertyValueAsBoolean(it, "wields")) continue;
            this.write(this.io.getColorCode("denial") + "Ya est\u00e1s blandiendo " + it.constructName2OneItem(this) + ".\n");
            return false;
        }
        List requirements = ((Weapon)it).getLimbRequirementsList();
        Vector<Item> usedLimbs = new Vector<Item>();
        for (int i = 0; i < requirements.size(); ++i) {
            List vestidos;
            int k;
            String requirementString = (String)requirements.get(i);
            StringTokenizer st = new StringTokenizer(requirementString, "$");
            Vector matchingLimbs = new Vector();
            while (st.hasMoreTokens()) {
                Vector temp = ourLimbs.patternMatch(st.nextToken(), false);
                for (int l = 0; l < temp.size(); ++l) {
                    if (matchingLimbs.contains(temp.elementAt(l))) continue;
                    matchingLimbs.add(temp.elementAt(l));
                }
            }
            if (matchingLimbs.size() < 1) {
                this.write(this.io.getColorCode("denial") + "No parece adecuado para los de tu especie." + this.io.getColorCode("reset") + "\n");
                return false;
            }
            for (k = 0; k < matchingLimbs.size(); ++k) {
                Item thisLimb = (Item)matchingLimbs.get(k);
                vestidos = thisLimb.getRelatedEntitiesByValue("wields", true);
                if (vestidos.size() >= 1 || usedLimbs.contains(thisLimb)) continue;
                usedLimbs.add(thisLimb);
                break;
            }
            if (k != matchingLimbs.size()) continue;
            if (!freeLimbsNeeded) {
                Item busyLimb = (Item)matchingLimbs.get(0);
                vestidos = busyLimb.getRelatedEntitiesByValue("wields", true);
                for (int z = 0; z < vestidos.size(); ++z) {
                    if (this.guardarArma((Item)vestidos.get(z))) continue;
                    return false;
                }
                continue;
            }
            for (int n = 0; n < matchingLimbs.size(); ++n) {
                Item current = (Item)matchingLimbs.get(n);
                List vestidos2 = current.getRelatedEntitiesByValue("wields", true);
                if (vestidos2.size() > 0) {
                    Item vestido = (Item)vestidos2.get(0);
                    this.write(this.io.getColorCode("information") + "Est\u00e1s blandiendo " + vestido.constructName2OneItem(this) + " en " + current.constructName2OneItem(this) + "." + this.io.getColorCode("reset") + "\n");
                    continue;
                }
                this.write(this.io.getColorCode("information") + "Tienes libre " + current.constructName2OneItem(this));
            }
            this.write(this.io.getColorCode("denial") + "Tienes que guardar alg\u00fan arma para poder blandir " + it.constructName2OneItem(this) + "." + this.io.getColorCode("reset") + "\n");
            return false;
        }
        String toOutput = "";
        for (int i = 0; i < usedLimbs.size(); ++i) {
            Item limb = (Item)usedLimbs.get(i);
            limb.setRelationshipProperty((Entity)it, "wields", true);
            toOutput = i == 0 ? toOutput + limb.constructName2OneItem(this) : (i > 0 && i == usedLimbs.size() - 1 ? toOutput + " y " + limb.constructName2OneItem(this) : toOutput + ", " + limb.constructName2OneItem(this));
        }
        this.write(this.io.getColorCode("action") + "Blandes " + it.constructName2OneItem(this) + " en " + toOutput + ".\n" + this.io.getColorCode("reset"));
        this.habitacionActual.informActionAuto(this, null, "$1 blande " + it.constructName2OneItem() + ".\n", false);
        if (this.wieldedWeapons == null) {
            this.wieldedWeapons = new Inventory(10000, 10000);
        }
        try {
            this.wieldedWeapons.addItem(it);
        }
        catch (WeightLimitExceededException wlee) {
            this.write(this.io.getColorCode("denial") + "No puedes blandir eso, pesa demasiado." + ".\n" + this.io.getColorCode("reset"));
        }
        catch (VolumeLimitExceededException vlee) {
            this.write(this.io.getColorCode("denial") + "No puedes blandir eso, pesa demasiado." + ".\n" + this.io.getColorCode("reset"));
        }
        return true;
    }

    public boolean intentarGuardar(Item it) {
        if (it instanceof Wearable) {
            // empty if block
        }
        return false;
    }

    public boolean desvestir(Item it) {
        if (this.wornItems == null) {
            return false;
        }
        boolean success = this.wornItems.removeItem(it);
        if (success) {
            Inventory ourLimbs = this.getFlattenedPartsInventory();
            for (int i = 0; i < ourLimbs.size(); ++i) {
                Item curLimb = ourLimbs.elementAt(i);
                if (!curLimb.getRelationshipPropertyValueAsBoolean(it, "wears")) continue;
                curLimb.setRelationshipProperty((Entity)it, "wears", false);
            }
            this.write(this.io.getColorCode("action") + "Te quitas " + it.constructName2OneItem() + ".\n" + this.io.getColorCode("reset"));
            this.habitacionActual.informActionAuto(this, null, "$1 se quita " + it.constructName2OneItem() + ".\n", false);
            return true;
        }
        return false;
    }

    public boolean guardarArma(Item it) {
        if (this.wieldedWeapons == null) {
            return false;
        }
        boolean success = this.wieldedWeapons.removeItem(it);
        if (success) {
            Inventory ourLimbs = this.getFlattenedPartsInventory();
            for (int i = 0; i < ourLimbs.size(); ++i) {
                Item curLimb = ourLimbs.elementAt(i);
                if (!curLimb.getRelationshipPropertyValueAsBoolean(it, "wields")) continue;
                curLimb.setRelationshipProperty((Entity)it, "wields", false);
            }
            this.write(this.io.getColorCode("action") + "Dejas de blandir " + it.constructName2OneItem() + ".\n" + this.io.getColorCode("reset"));
            this.habitacionActual.informActionAuto(this, null, "$1 deja de blandir " + it.constructName2OneItem() + ".\n", false);
            return true;
        }
        return false;
    }

    public String getName(boolean s_p, Entity viewer) {
        Description[] theList = s_p ? this.singNames : this.plurNames;
        String desString = "";
        for (int i = 0; i < theList.length; ++i) {
            if (!theList[i].matchesConditions(this, viewer)) continue;
            desString = desString + theList[i].getText();
        }
        return desString;
    }

    public String getSingName(Entity viewer) {
        return this.getName(true, viewer);
    }

    public String getSingNameTrue(Entity viewer) {
        String s = this.getName(true, viewer);
        if (s != null & s.length() > 0) {
            return s;
        }
        return Character.toLowerCase(this.title.charAt(0)) + this.title.substring(1);
    }

    public String getPlurName(Entity viewer) {
        return this.getName(false, viewer);
    }

    public String getPlurNameTrue(Entity viewer) {
        String s = this.getName(false, viewer);
        if (s != null & s.length() > 0) {
            return s;
        }
        return Character.toLowerCase(this.title.charAt(0)) + this.title.substring(1);
    }

    public String constructName(int nItems, Entity viewer) {
        if (nItems == 1) {
            if (this.properName) {
                return this.getSingName(viewer);
            }
            if (this.gender) {
                return "un " + this.getSingName(viewer);
            }
            return "una " + this.getSingName(viewer);
        }
        if (nItems < 10) {
            String str;
            switch (nItems) {
                case 2: {
                    str = "dos";
                    break;
                }
                case 3: {
                    str = "tres";
                    break;
                }
                case 4: {
                    str = "cuatro";
                    break;
                }
                case 5: {
                    str = "cinco";
                    break;
                }
                case 6: {
                    str = "seis";
                    break;
                }
                case 7: {
                    str = "siete";
                    break;
                }
                case 8: {
                    str = "ocho";
                    break;
                }
                default: {
                    str = "nueve";
                }
            }
            return str + " " + this.getPlurName(viewer);
        }
        return nItems + " " + this.getPlurName(viewer);
    }

    public String constructName2(int nItems, Entity viewer) {
        if (nItems == 1) {
            if (this.properName) {
                return this.getSingName(viewer);
            }
            if (this.gender) {
                return "el " + this.getSingName(viewer);
            }
            return "la " + this.getSingName(viewer);
        }
        return nItems + " " + this.getPlurName(viewer);
    }

    public String constructName2True(int nItems, Entity viewer) {
        if (nItems == 1) {
            if (this.properName) {
                return this.getSingName(viewer);
            }
            if (this.gender) {
                return "el " + this.getSingNameTrue(viewer);
            }
            return "la " + this.getSingNameTrue(viewer);
        }
        return nItems + " " + this.getPlurNameTrue(viewer);
    }

    public String constructName2OneItem(Entity viewer) {
        return this.constructName2True(1, viewer);
    }

    public Item getRandomLimbToHit() {
        Inventory limbs = this.getFlattenedPartsInventory();
        if (limbs == null || limbs.size() == 0) {
            return null;
        }
        int volTot = limbs.getVolume();
        if (volTot == 0) {
            return null;
        }
        int volElegido = Math.abs(this.aleat.nextInt()) % volTot;
        Item chosen = null;
        int volsum = 0;
        int j = 0;
        while (volsum <= volElegido) {
            chosen = limbs.elementAt(j);
            volsum += chosen.getVolume();
            ++j;
        }
        return chosen;
    }

    public String estimateDamage(int damAmt) {
        double percent = (double)damAmt / (double)this.maxhp * 100.0;
        String result = percent < 5.0 ? "muy ligeros da\u00f1os" : (percent < 10.0 ? "ligeros da\u00f1os" : (percent < 18.0 ? "alg\u00fan da\u00f1o" : (percent < 25.0 ? "un da\u00f1o significativo" : (percent < 33.0 ? "da\u00f1os moderados" : (percent < 40.0 ? "bastante da\u00f1o" : (percent < 50.0 ? "severos da\u00f1os" : (percent < 60.0 ? "mucho da\u00f1o" : (percent < 70.0 ? "gran da\u00f1o" : (percent < 80.0 ? "enorme da\u00f1o" : (percent < 90.0 ? "terribles heridas" : "da\u00f1o mortal"))))))))));
        return result;
    }

    public String estimateStatus() {
        double percent = (double)(this.maxhp - this.hp) / (double)this.maxhp * 100.0;
        if (percent <= 0.0) {
            String string = "est\u00e1 intacto";
        }
        String result = percent < 5.0 ? "tiene alg\u00fan rasgu\u00f1o" : (percent < 10.0 ? "tiene ligeras heridas" : (percent < 18.0 ? "tiene heridas poco graves" : (percent < 25.0 ? "tiene heridas de cierta consideraci\u00f3n" : (percent < 33.0 ? "tiene heridas importantes" : (percent < 40.0 ? "tiene heridas graves" : (percent < 50.0 ? "tiene heridas preocupantes" : (percent < 60.0 ? "est\u00e1 gravemente herido" : (percent < 70.0 ? "est\u00e1 muy gravemente herido" : (percent < 80.0 ? "est\u00e1 cr\u00edticamente herido" : (percent < 90.0 ? "est\u00e1 en las \u00faltimas" : "est\u00e1 a un paso de la tumba"))))))))));
        return result;
    }

    public int getHP() {
        return this.hp;
    }

    public int getMaxHP() {
        return this.maxhp;
    }

    public int getMP() {
        return this.mp;
    }

    public int getMaxMP() {
        return this.maxmp;
    }

    public Object clone() {
        Mobile it = new Mobile();
        this.copyMobileFieldsTo(it);
        return it;
    }

    public void cast(Spell s, Entity target) {
        System.out.println(this + " is actually tryin' to cast " + s);
        int manaCost = (int)s.getTypicalManaCost(this);
        System.out.println("Mana Cost: " + manaCost);
        if (manaCost > this.mp) {
            System.out.println("Mana Cost Flubbed!");
            this.write("No tienes suficiente man\u00e1 para ejecutar ese hechizo.");
            return;
        }
        this.mp -= manaCost;
        if (target != null) {
            this.setNewTarget(target.getID());
        } else {
            this.setNewTarget(-1);
        }
        boolean ejecutado = false;
        try {
            ejecutado = s.execCode("prepare", new Object[]{this, target});
        }
        catch (TargetError bshte) {
            // empty catch block
        }
        if (ejecutado) {
            return;
        }
        this.setNewState(16, this.generateCastTime(s));
        this.usingSpell = s;
        this.usingSpell.incrementUsage(this);
        System.out.println("Cast state set!");
    }

    public void manageEndOfCastState() {
        System.out.println("End of cast state!");
        if (this.getSuccessFromProbability(this.usingSpell)) {
            System.out.println("Cast.");
            if (this.getTarget() == -1) {
                this.usingSpell.cast(this, null);
            } else {
                this.usingSpell.cast(this, this.mundo.getObject(this.getTarget()));
            }
        } else {
            System.out.println("Fail.");
            if (this.getTarget() == -1) {
                this.usingSpell.fail(this, null);
            } else {
                this.usingSpell.fail(this, this.mundo.getObject(this.getTarget()));
            }
        }
        this.setNewState(1, 1L);
    }

    void interrupt(String cause) {
        System.out.println("INTERRUPT!!!!!!!!!!!!");
        switch (this.getState()) {
            case 2: {
                this.write(Character.toUpperCase(cause.charAt(0)) + cause.substring(1) + " interrumpe tu intento de irte.\n");
                break;
            }
            case 3: {
                this.write(Character.toUpperCase(cause.charAt(0)) + cause.substring(1) + " interrumpe tu intento de ataque.\n");
                break;
            }
            case 16: {
                this.write(Character.toUpperCase(cause.charAt(0)) + cause.substring(1) + " interrumpe tu intento de hacer magia.\n");
            }
        }
    }

    boolean getItem(Item ourItem, Inventory inv, String toAppend) {
        try {
            this.addItem(ourItem);
            this.write(this.io.getColorCode("action") + this.lenguaje.gramaticalizar("Coges " + ourItem.constructName2True(1, this) + toAppend + ".") + "\n" + this.io.getColorCode("reset"));
            this.habitacionActual.informActionAuto(this, null, "$1 coge " + ourItem.constructName2OneItem() + toAppend + ".\n", false);
            try {
                ourItem.execCode("event_get", "this: " + ourItem.getID() + "\n" + "player: " + this.getID());
                ourItem.execCode("onGet", new Object[]{this});
            }
            catch (EVASemanticException exc) {
                this.write(this.io.getColorCode("error") + "EVASemanticException found at event_get , item number " + ourItem.getID() + this.io.getColorCode("reset") + "\n");
            }
            catch (TargetError te) {
                this.write(this.io.getColorCode("error") + "bsh.TargetError found at event onGet , item number " + ourItem.getID() + this.io.getColorCode("reset") + "\n");
            }
            this.write(this.io.getColorCode("description") + ourItem.getDescription(this) + '\n' + this.io.getColorCode("reset"));
            double factorApr = 0.9 + Math.random() / 5.0;
            int pesoApr = (int)Math.round(factorApr * (double)ourItem.getWeight());
            int pesoApr_kilos = pesoApr / 8;
            int pesoApr_cuartos = pesoApr % 8 / 2;
            String pesoDescription = "";
            if (pesoApr_kilos == 0) {
                if (pesoApr_cuartos == 0) {
                    pesoDescription = "Pesa muy poquito.";
                } else if (pesoApr_cuartos == 2) {
                    pesoDescription = "Pesar\u00e1 medio kilo.";
                } else if (pesoApr_cuartos == 1) {
                    pesoDescription = "Pesar\u00e1 un cuarto kilo, m\u00e1s o menos.";
                } else if (pesoApr_cuartos == 3) {
                    pesoDescription = "Pesar\u00e1 cerca de un kilo.";
                }
            } else if (pesoApr_cuartos == 0 || pesoApr_cuartos == 1) {
                pesoDescription = "Pesar\u00e1 aproximadamente " + pesoApr_kilos + " kilo" + (pesoApr_kilos > 1 ? "s" : "") + ".";
            } else if (pesoApr_cuartos == 2 || pesoApr_cuartos == 3) {
                pesoDescription = "Debe de pesar algo m\u00e1s de " + pesoApr_kilos + " kilo" + (pesoApr_kilos > 1 ? "s" : "") + ".";
            }
            this.write(this.io.getColorCode("description") + pesoDescription + this.io.getColorCode("reset") + "\n");
            inv.removeItem(ourItem);
        }
        catch (WeightLimitExceededException we) {
            this.write(this.io.getColorCode("denial") + "\u00a1Llevas demasiado peso para coger " + ourItem.constructName2True(1, this) + "!\n" + this.io.getColorCode("reset"));
        }
        catch (VolumeLimitExceededException ve) {
            this.write(this.io.getColorCode("denial") + "\u00a1Llevas objetos demasiado voluminosos para coger " + ourItem.constructName2True(1, this) + "!\n" + this.io.getColorCode("reset"));
        }
        return true;
    }

    protected boolean cogerItem(String args, Inventory inv, String extraInfo) {
        boolean mirado = false;
        String toAppend = extraInfo == null ? "" : extraInfo;
        if (inv == null || inv.isEmpty()) {
            return false;
        }
        Vector patternMatchVectorSing = inv.patternMatch(args, false);
        Vector patternMatchVectorPlur = inv.patternMatch(args, true);
        if (patternMatchVectorSing.size() > 0) {
            Item ourItem = (Item)patternMatchVectorSing.elementAt(0);
            mirado = true;
            this.executeAction("get", new Object[]{ourItem, inv, toAppend});
        } else if (patternMatchVectorPlur.size() > 0) {
            mirado = true;
            for (int i = 0; i < patternMatchVectorPlur.size(); ++i) {
                Item ourItem = (Item)patternMatchVectorPlur.elementAt(i);
                this.executeAction("get", new Object[]{ourItem, inv, toAppend});
            }
        }
        return mirado;
    }

    boolean executeAction(String actionName, Object[] actionArgs) {
        boolean ejecutado_algo = false;
        Object[] generalArgs = new Object[]{actionName, this, actionArgs};
        try {
            ejecutado_algo = this.mundo.execCode("before", generalArgs);
        }
        catch (TargetError bshte) {
            this.write("bsh.TargetError found at general before method");
            bshte.printStackTrace();
        }
        if (ejecutado_algo) {
            return true;
        }
        try {
            ejecutado_algo = this.execCode("before_" + actionName, actionArgs);
        }
        catch (TargetError bshte) {
            this.write("bsh.TargetError found at subject before method");
            bshte.printStackTrace();
        }
        if (ejecutado_algo) {
            return true;
        }
        Object[] do_args = new Object[actionArgs.length];
        if (actionArgs.length > 0 && actionArgs[0] instanceof SupportingCode) {
            SupportingCode directObject = (SupportingCode)actionArgs[0];
            do_args[0] = this;
            for (int i = 1; i < actionArgs.length; ++i) {
                do_args[i] = actionArgs[i];
            }
            try {
                ejecutado_algo = directObject.execCode("before_do_" + actionName, do_args);
            }
            catch (TargetError bshte) {
                this.write("bsh.TargetError found at direct object before method");
                bshte.printStackTrace();
            }
            if (ejecutado_algo) {
                return true;
            }
        }
        if (actionArgs.length > 1 && actionArgs[1] instanceof SupportingCode) {
            do_args[1] = actionArgs[0];
            SupportingCode indirectObject = (SupportingCode)actionArgs[1];
            try {
                ejecutado_algo = indirectObject.execCode("before_io_" + actionName, do_args);
            }
            catch (TargetError bshte) {
                this.write("bsh.TargetError found at indirect object before method");
                bshte.printStackTrace();
            }
            if (ejecutado_algo) {
                return true;
            }
        }
        if (actionName.equalsIgnoreCase("go")) {
            return this.go((Path)actionArgs[0]);
        }
        if (actionName.equalsIgnoreCase("get")) {
            return this.getItem((Item)actionArgs[0], (Inventory)actionArgs[1], (String)actionArgs[2]);
        }
        if (actionName.equalsIgnoreCase("unwear")) {
            boolean retval = this.desvestir((Item)actionArgs[0]);
            if (retval) {
                this.setNewState(1, 5L);
            }
            return retval;
        }
        if (actionName.equalsIgnoreCase("wear")) {
            boolean retval = this.intentarVestir((Item)actionArgs[0], true);
            if (retval) {
                this.setNewState(1, 5L);
            }
            return retval;
        }
        if (actionName.equalsIgnoreCase("wield")) {
            boolean retval = this.intentarBlandir((Item)actionArgs[0], true);
            if (retval) {
                this.setNewState(1, 5L);
            }
            return retval;
        }
        if (actionName.equalsIgnoreCase("unwield")) {
            boolean retval = this.guardarArma((Item)actionArgs[0]);
            if (retval) {
                this.setNewState(1, 5L);
            }
            return retval;
        }
        return false;
    }

    protected boolean mirarItem(String arguments, Inventory inv) {
        boolean mirado = false;
        if (inv == null || inv.isEmpty()) {
            return false;
        }
        Vector patternMatchVectorSing = inv.patternMatch(arguments, false);
        Vector patternMatchVectorPlur = inv.patternMatch(arguments, true);
        if (patternMatchVectorSing.size() > 0 && !((Item)patternMatchVectorSing.elementAt(0)).getDescription(this).equals("")) {
            this.write(this.io.getColorCode("description") + ((Item)patternMatchVectorSing.elementAt(0)).getDescription(this) + this.io.getColorCode("reset") + "\n");
            mirado = true;
        } else if (patternMatchVectorPlur.size() > 0) {
            mirado = true;
            for (int i = 0; i < patternMatchVectorPlur.size(); ++i) {
                Item ourItem = (Item)patternMatchVectorPlur.elementAt(i);
                if (ourItem.getDescription(this).equals("")) continue;
                this.write("\nMiras " + ourItem.constructName2True(1, this) + ": ");
                this.write(this.io.getColorCode("description") + ourItem.getDescription(this) + this.io.getColorCode("reset") + "\n");
            }
        }
        return mirado;
    }

    protected boolean mirarExtrasItems(String arguments, Inventory inv) {
        boolean mirado = false;
        if (inv == null || inv.isEmpty()) {
            return false;
        }
        for (int i = 0; i < inv.size(); ++i) {
            System.out.println("Seein' if item " + inv.elementAt(i) + " has extra.");
            String s = inv.elementAt(i).getExtraDescription(arguments, this);
            if (s == null) continue;
            this.write(this.io.getColorCode("description") + s + this.io.getColorCode("reset") + "\n");
            return true;
        }
        return false;
    }

    protected boolean mirarBicho(String arguments, MobileList ml) {
        boolean mirado = false;
        if (ml == null || ml.isEmpty()) {
            return false;
        }
        Vector patternMatchVectorSing = ml.patternMatch(arguments, false);
        Vector patternMatchVectorPlur = ml.patternMatch(arguments, true);
        if (patternMatchVectorSing.size() > 0 && !((Mobile)patternMatchVectorSing.elementAt(0)).getDescription(this).equals("")) {
            this.write(this.io.getColorCode("description") + ((Mobile)patternMatchVectorSing.elementAt(0)).getDescription(this) + this.io.getColorCode("reset") + '\n');
            mirado = true;
        } else if (patternMatchVectorPlur.size() > 0) {
            mirado = true;
            for (int i = 0; i < patternMatchVectorPlur.size(); ++i) {
                Mobile ourMob = (Mobile)patternMatchVectorPlur.elementAt(i);
                if (ourMob.getDescription(this).equals("")) continue;
                this.write("\nMiras " + ourMob.constructName2(1, this) + ": ");
                this.write(this.io.getColorCode("description") + ourMob.getDescription(this) + this.io.getColorCode("reset") + "\n");
            }
        }
        return mirado;
    }

    protected boolean mirarContenido(String arguments, Inventory inv) {
        int i;
        boolean mirado = false;
        if (inv == null || inv.isEmpty()) {
            return false;
        }
        for (i = 0; !(i >= inv.size() || inv.elementAt(i).isContainer() && (mirado = this.mirarItem(arguments, inv.elementAt(i).getContents()))); ++i) {
        }
        if (!mirado) {
            for (i = 0; !(i >= inv.size() || inv.elementAt(i).isContainer() && (mirado = this.mirarContenido(arguments, inv.elementAt(i).getContents()))); ++i) {
            }
        }
        return mirado;
    }

    public Inventory getFlattenedInventory() {
        if (this.inventory == null) {
            return new Inventory(1, 1);
        }
        Inventory result = new Inventory(this.inventory.getWeightLimit(), this.inventory.getVolumeLimit());
        for (int i = 0; i < this.inventory.size(); ++i) {
            Item thisPart = this.inventory.elementAt(i);
            Inventory subInv = thisPart.getFlattenedInventory();
            try {
                result.setVolumeLimit(result.getVolumeLimit() + subInv.getVolumeLimit());
                result.setWeightLimit(result.getWeightLimit() + subInv.getWeightLimit());
            }
            catch (Exception e) {
                System.out.println("Impossible exception thrown: " + e);
                e.printStackTrace();
            }
            for (int j = 0; j < subInv.size(); ++j) {
                try {
                    result.addItem(subInv.elementAt(j));
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Impossible exception thrown: " + e);
                    e.printStackTrace();
                }
            }
            try {
                result.addItem(thisPart);
                continue;
            }
            catch (Exception e) {
                System.out.println("Impossible exception thrown: " + e);
                e.printStackTrace();
            }
        }
        return result;
    }

    public void copyMobileFieldsTo(Mobile m) {
        int i;
        m.copyEntityFields(this);
        m.aleat = this.getRandom();
        m.habitacionActual = this.habitacionActual;
        m.habitacionAnterior = this.habitacionAnterior;
        m.lenguaje = this.lenguaje;
        m.movingState_Path = this.movingState_Path;
        m.mundo = this.mundo;
        m.PSIanswers = this.PSIanswers;
        m.PSIkeywords = this.PSIkeywords;
        m.io = this.io;
        m.caracteristicas = (Traits)this.caracteristicas.clone();
        m.exitname = this.exitname;
        m.extraDescriptions = this.extraDescriptions;
        m.gender = this.gender;
        m.idnumber = this.idnumber;
        m.inheritsFrom = this.inheritsFrom;
        m.inventory = this.inventory != null ? (Inventory)this.inventory.clone() : null;
        m.isInstanceOf = this.isInstanceOf;
        m.mobileType = this.mobileType;
        m.itsCode = this.itsCode.cloneIfNecessary();
        m.partsInventory = this.partsInventory != null ? (Inventory)this.partsInventory.clone() : null;
        m.wieldedWeapons = this.wieldedWeapons != null ? (Inventory)this.wieldedWeapons.clone() : null;
        m.wieldingLimbs = this.wieldingLimbs != null ? (Inventory)this.wieldingLimbs.clone() : null;
        m.wornItems = this.wornItems != null ? (Inventory)this.wornItems.clone() : null;
        m.virtualInventory = this.virtualInventory != null ? (Inventory)this.virtualInventory.clone() : null;
        m.respondToPlur = this.respondToPlur;
        m.respondToSing = this.respondToSing;
        m.title = this.title;
        m.hp = this.hp;
        m.mp = this.mp;
        m.maxhp = this.maxhp;
        m.maxmp = this.maxmp;
        m.descriptionList = new Description[this.descriptionList.length];
        for (i = 0; i < m.descriptionList.length; ++i) {
            m.descriptionList[i] = (Description)this.descriptionList[i].clone();
        }
        m.singNames = new Description[this.singNames.length];
        for (i = 0; i < m.singNames.length; ++i) {
            m.singNames[i] = (Description)this.singNames[i].clone();
        }
        m.plurNames = new Description[this.plurNames.length];
        for (i = 0; i < m.plurNames.length; ++i) {
            m.plurNames[i] = (Description)this.plurNames[i].clone();
        }
    }

    public Mobile createNewInstance(World mundo, boolean cloneInventory, boolean cloneParts, boolean cloneVirtual) {
        int i;
        Inventory inv;
        Inventory parts;
        Mobile it = (Mobile)this.clone();
        it.inheritsFrom = 0;
        if (this.isInstanceOf == 0) {
            it.isInstanceOf = this.idnumber;
            System.out.println("1) instanceOf set to " + this.idnumber);
        } else {
            it.isInstanceOf = this.isInstanceOf;
            System.out.println("2) instanceOf set to " + this.isInstanceOf);
        }
        boolean[][] limb_wielded_relationship_map = null;
        boolean[][] limb_worn_relationship_map = null;
        if (cloneParts || cloneInventory) {
            parts = it.getFlattenedPartsInventory();
            inv = it.getInventory();
            if (parts != null && inv != null) {
                limb_wielded_relationship_map = new boolean[parts.size()][inv.size()];
                limb_worn_relationship_map = new boolean[parts.size()][inv.size()];
                for (i = 0; i < parts.size(); ++i) {
                    Weapon w = it.getWieldedItem(parts.elementAt(i));
                    for (int j = 0; j < inv.size(); ++j) {
                        if (!inv.elementAt(j).equals(w)) continue;
                        limb_wielded_relationship_map[i][j] = true;
                    }
                    Wearable w2 = it.getWornItem(parts.elementAt(i));
                    for (int j = 0; j < inv.size(); ++j) {
                        if (!inv.elementAt(j).equals(w2)) continue;
                        limb_worn_relationship_map[i][j] = true;
                    }
                }
            }
        }
        if (cloneInventory && it.inventory != null) {
            it.inventory = it.inventory.cloneCopyingItems(mundo, cloneInventory, cloneParts);
        }
        if (cloneVirtual && it.virtualInventory != null) {
            it.virtualInventory = it.virtualInventory.cloneCopyingItems(mundo, cloneVirtual, cloneParts);
        }
        if (cloneParts && it.partsInventory != null) {
            it.partsInventory = it.partsInventory.cloneCopyingItems(mundo, cloneInventory, cloneParts);
        }
        it.wieldedWeapons = (Inventory)it.wieldedWeapons.clone();
        it.wornItems = (Inventory)it.wornItems.clone();
        if (cloneParts || cloneInventory) {
            parts = it.getFlattenedPartsInventory();
            inv = it.getInventory();
            it.wieldedWeapons.empty();
            it.wornItems.empty();
            for (i = 0; i < parts.size(); ++i) {
                for (int j = 0; j < inv.size(); ++j) {
                    try {
                        Wearable w2;
                        Weapon w = it.getWieldedItem(parts.elementAt(i));
                        if (w != null) {
                            parts.elementAt(i).setRelationshipProperty((Entity)w, "wields", false);
                        }
                        if (limb_wielded_relationship_map[i][j]) {
                            parts.elementAt(i).setRelationshipProperty((Entity)inv.elementAt(j), "wields", true);
                            it.wieldedWeapons.addItem(inv.elementAt(j));
                            System.out.println("Adding wielded item " + inv.elementAt(j) + " to " + it);
                        }
                        if ((w2 = it.getWornItem(parts.elementAt(i))) != null) {
                            parts.elementAt(i).setRelationshipProperty((Entity)w2, "wears", false);
                        }
                        if (!limb_worn_relationship_map[i][j]) continue;
                        parts.elementAt(i).setRelationshipProperty((Entity)inv.elementAt(j), "wears", true);
                        it.wornItems.addItem(inv.elementAt(j));
                        System.out.println("Adding worn item " + inv.elementAt(j) + " to " + it);
                        continue;
                    }
                    catch (WeightLimitExceededException wlee) {
                        wlee.printStackTrace();
                        continue;
                    }
                    catch (VolumeLimitExceededException vlee) {
                        vlee.printStackTrace();
                    }
                }
            }
        }
        mundo.addMobileAssigningID(it);
        return it;
    }

    public void suicide() {
        Inventory weaponInv = this.getUsableWeapons();
        Inventory natInv = this.getNaturalWeapons();
        for (int i = 0; i < weaponInv.size(); ++i) {
            Weapon current = (Weapon)weaponInv.elementAt(i);
            if (natInv.contains(current)) continue;
            this.suicideWith(current);
            return;
        }
        this.write("No est\u00e1s blandiendo ning\u00fan arma \u00fatil para suicidarte.\n");
    }

    public void suicideWith(Weapon w) {
        this.habitacionActual.informAction(this, null, new Entity[]{w}, "$1 se suicida con $3.\n", "Te suicidas con $3.\n", "Te suicidas con $3.\n", true);
        this.decreaseHP(this.getHP());
    }

    public EntityList getReachableEntities() {
        int i;
        EntityList possibleSpellTargets = new EntityList();
        for (i = 0; i < this.habitacionActual.mobsInRoom.size(); ++i) {
            possibleSpellTargets.addEntity(this.habitacionActual.mobsInRoom.elementAt(i));
        }
        for (i = 0; i < this.inventory.size(); ++i) {
            possibleSpellTargets.addEntity(this.inventory.elementAt(i));
        }
        for (i = 0; i < this.habitacionActual.getInventory().size(); ++i) {
            possibleSpellTargets.addEntity(this.habitacionActual.getInventory().elementAt(i));
        }
        return possibleSpellTargets;
    }

    protected List[] patternMatchPairs(EntityList el1, EntityList el2, String arguments) {
        List[] result;
        block6: {
            Vector[] patternMatchVectorPlurPlur;
            ArrayList list2;
            ArrayList list1;
            block8: {
                Vector[] patternMatchVectorPlurSing;
                block7: {
                    Vector[] patternMatchVectorSingPlur;
                    block5: {
                        result = new ArrayList[2];
                        list1 = new ArrayList();
                        list2 = new ArrayList();
                        result[0] = list1;
                        result[1] = list2;
                        if (el1 == null || el1.isEmpty() || el2 == null || el2.isEmpty()) {
                            return result;
                        }
                        Vector[] patternMatchVectorSingSing = el1.patternMatchTwo(el2, arguments, false, false);
                        patternMatchVectorSingPlur = el1.patternMatchTwo(el2, arguments, false, true);
                        patternMatchVectorPlurSing = el1.patternMatchTwo(el2, arguments, true, false);
                        patternMatchVectorPlurPlur = el1.patternMatchTwo(el2, arguments, true, true);
                        if (patternMatchVectorSingSing == null || patternMatchVectorSingSing[0].size() <= 0) break block5;
                        list1.add(patternMatchVectorSingSing[0].get(0));
                        list2.add(patternMatchVectorSingSing[1].get(0));
                        break block6;
                    }
                    if (patternMatchVectorSingPlur == null || patternMatchVectorSingPlur[0].size() <= 0) break block7;
                    for (int i = 0; i < patternMatchVectorSingPlur[1].size(); ++i) {
                        list1.add(patternMatchVectorSingPlur[0].get(0));
                        list2.add(patternMatchVectorSingPlur[1].get(i));
                    }
                    break block6;
                }
                if (patternMatchVectorPlurSing == null || patternMatchVectorPlurSing[0].size() <= 0) break block8;
                for (int j = 0; j < patternMatchVectorPlurSing[0].size(); ++j) {
                    list1.add(patternMatchVectorPlurSing[0].get(j));
                    list2.add(patternMatchVectorPlurSing[1].get(0));
                }
                break block6;
            }
            if (patternMatchVectorPlurPlur == null || patternMatchVectorPlurPlur[0].size() <= 0) break block6;
            for (int i = 0; i < patternMatchVectorPlurPlur[0].size(); ++i) {
                for (int j = 0; j < patternMatchVectorPlurPlur[1].size(); ++j) {
                    list1.add(patternMatchVectorPlurPlur[0].get(i));
                    list2.add(patternMatchVectorPlurPlur[1].get(j));
                }
            }
        }
        return result;
    }
}

