/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.Entity;
import eu.irreality.age.EntityList;
import eu.irreality.age.Item;
import eu.irreality.age.StringMethods;
import eu.irreality.age.VolumeLimitExceededException;
import eu.irreality.age.WeightLimitExceededException;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Inventory
extends EntityList {
    private int weight;
    private int volume;
    private int weightLimit;
    private int volumeLimit;

    private void addElement(Item o) {
        this.laLista.addElement(o);
    }

    private boolean removeElement(Item o) {
        return this.laLista.removeElement(o);
    }

    public void addItem(Item o) throws WeightLimitExceededException, VolumeLimitExceededException {
        if (this.weight + o.getWeight() > this.weightLimit) {
            throw new WeightLimitExceededException();
        }
        if (this.volume + o.getVolume() > this.volumeLimit) {
            throw new VolumeLimitExceededException();
        }
        this.addElement(o);
        this.weight += o.getWeight();
        this.volume += o.getVolume();
    }

    public boolean removeItem(Item o) {
        boolean valor = this.removeElement(o);
        if (valor) {
            this.weight -= o.getWeight();
            this.volume -= o.getVolume();
        }
        return valor;
    }

    public void empty() {
        for (int i = 0; i < this.size(); ++i) {
            this.removeItem(this.elementAt(i));
        }
    }

    public int size() {
        return this.laLista.size();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Entity viewer) {
        int j;
        int i = 0;
        String cadena = "";
        boolean[] considerados = new boolean[this.size()];
        boolean vacio = true;
        int nconsiderados = 0;
        for (j = 0; j < this.size(); ++j) {
            considerados[j] = false;
        }
        while (i < this.size()) {
            int numeroitems = 1;
            for (int k = i + 1; k < this.size(); ++k) {
                if (!this.elementAt(k).isSame(this.elementAt(i))) continue;
                ++numeroitems;
            }
            if (StringMethods.numToks(this.elementAt(i).constructName(1, viewer), ' ') < 2) {
                considerados[i] = true;
                ++nconsiderados;
            }
            ++i;
        }
        i = 0;
        j = 0;
        while (i < this.size()) {
            if (!considerados[i]) {
                considerados[i] = true;
                ++nconsiderados;
                int numeroitems = 1;
                for (int k = i + 1; k < this.size(); ++k) {
                    if (!this.elementAt(k).isSame(this.elementAt(i))) continue;
                    considerados[k] = true;
                    ++nconsiderados;
                    ++numeroitems;
                }
                if (StringMethods.numToks(this.elementAt(i).constructName(numeroitems, viewer), ' ') < 2) {
                    ++i;
                    continue;
                }
                vacio = false;
                if (j != 0) {
                    cadena = nconsiderados < this.size() ? cadena + ", " : cadena + " y ";
                }
                cadena = cadena + this.elementAt(i).constructName(numeroitems, viewer);
                ++j;
            }
            ++i;
        }
        if (vacio) {
            return "nada.";
        }
        return cadena + ".";
    }

    public Inventory(int weightLimit, int volumeLimit) {
        this.laLista = new Vector();
        this.weight = 0;
        this.volume = 0;
        this.weightLimit = weightLimit;
        this.volumeLimit = volumeLimit;
    }

    public Inventory(int weightLimit, int volumeLimit, int initSize) {
        this.laLista = new Vector(initSize);
        this.weight = 0;
        this.volume = 0;
        this.weightLimit = weightLimit;
        this.volumeLimit = volumeLimit;
    }

    public void incrementSize(int increment) {
        if (increment > 0) {
            this.laLista.setSize(this.laLista.size() + increment);
        }
    }

    public int getWeightLimit() {
        return this.weightLimit;
    }

    public int getVolumeLimit() {
        return this.volumeLimit;
    }

    public void setWeightLimit(int nuevo) throws WeightLimitExceededException {
        this.weightLimit = nuevo;
        if (this.weight > this.weightLimit) {
            throw new WeightLimitExceededException();
        }
    }

    public void setVolumeLimit(int nuevo) throws VolumeLimitExceededException {
        this.volumeLimit = nuevo;
        if (this.volume > this.volumeLimit) {
            throw new VolumeLimitExceededException();
        }
    }

    public boolean isEmpty() {
        return this.laLista.isEmpty();
    }

    public Item elementAt(int i) {
        return (Item)this.laLista.elementAt(i);
    }

    public void setElementAt(Item nuevo, int i) throws WeightLimitExceededException, VolumeLimitExceededException {
        if (i < this.size() && this.elementAt(i) != null) {
            this.volume -= this.elementAt(i).getVolume();
            this.weight -= this.elementAt(i).getWeight();
        }
        this.volume += nuevo.getVolume();
        this.weight += nuevo.getWeight();
        this.laLista.setElementAt(nuevo, i);
        if (this.volume > this.volumeLimit) {
            throw new VolumeLimitExceededException();
        }
        if (this.weight > this.weightLimit) {
            throw new WeightLimitExceededException();
        }
    }

    public boolean contains(Item it) {
        for (int i = 0; i < this.size(); ++i) {
            System.out.println(this.laLista);
            System.out.println("i=" + i);
            if (this.elementAt(i) == null || !this.elementAt(i).equals(it)) continue;
            return true;
        }
        return false;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getVolume() {
        return this.volume;
    }

    public Node getXMLRepresentation(Document doc) {
        Element suElemento = doc.createElement("Inventory");
        suElemento.setAttribute("weight", String.valueOf(this.weight));
        suElemento.setAttribute("volume", String.valueOf(this.volume));
        suElemento.setAttribute("weightLimit", String.valueOf(this.weightLimit));
        suElemento.setAttribute("volumeLimit", String.valueOf(this.volumeLimit));
        for (int i = 0; i < this.size(); ++i) {
            Element nuevoElemento = doc.createElement("ItemRef");
            Item nuestroItem = (Item)this.laLista.elementAt(i);
            if (nuestroItem != null) {
                nuevoElemento.setAttribute("id", String.valueOf(nuestroItem.getID()));
            }
            suElemento.appendChild(nuevoElemento);
        }
        return suElemento;
    }

    public Inventory(World mundo, Node n) throws XMLtoWorldException {
        int volumeLimit;
        int weightLimit;
        int volume;
        int weight;
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Inventory node not Element");
        }
        try {
            Element e = (Element)n;
            weight = !e.hasAttribute("weight") ? 0 : Integer.valueOf(e.getAttribute("weight"));
            volume = !e.hasAttribute("volume") ? 0 : Integer.valueOf(e.getAttribute("volume"));
            weightLimit = !e.hasAttribute("weightLimit") ? 50000 : Integer.valueOf(e.getAttribute("weightLimit"));
            volumeLimit = !e.hasAttribute("volumeLimit") ? 50000 : Integer.valueOf(e.getAttribute("volumeLimit"));
        }
        catch (NumberFormatException nfe) {
            throw new XMLtoWorldException("Inventory attribute value not found or invalid");
        }
        this.laLista = new Vector();
        this.weightLimit = weightLimit;
        this.volumeLimit = volumeLimit;
        this.weight = 0;
        this.volume = 0;
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node hijo = nl.item(i);
            if (!(hijo instanceof Element)) continue;
            Element h = (Element)hijo;
            try {
                if (h.hasAttribute("id")) {
                    this.addItem(mundo.getItem(h.getAttribute("id")));
                    continue;
                }
                this.incrementSize(1);
                continue;
            }
            catch (WeightLimitExceededException wle) {
                throw new XMLtoWorldException("Inventory overloaded in weight");
            }
            catch (VolumeLimitExceededException wle) {
                throw new XMLtoWorldException("Inventory overloaded in volume");
            }
        }
        if (this.volume != volume || this.weight != weight) {
            System.out.println("Warning: Inventory volume or weight do not match items: " + this.toString());
        }
    }

    public Object clone() {
        Inventory inv = new Inventory(this.weightLimit, this.volumeLimit);
        inv.laLista = new Vector(this.laLista.size());
        for (int i = 0; i < this.laLista.size(); ++i) {
            try {
                inv.addItem((Item)this.laLista.get(i));
                continue;
            }
            catch (WeightLimitExceededException wlee) {
                continue;
            }
            catch (VolumeLimitExceededException volumeLimitExceededException) {
                // empty catch block
            }
        }
        return inv;
    }

    public Inventory cloneCopyingItems(World w, boolean cloneContents, boolean cloneParts) {
        Inventory inv = new Inventory(this.weightLimit, this.volumeLimit);
        inv.laLista = new Vector(this.laLista.size());
        for (int i = 0; i < this.laLista.size(); ++i) {
            try {
                Item original = (Item)this.laLista.get(i);
                Item copia = original.createNewInstance(w, cloneContents, cloneParts);
                w.addItemAssigningID(copia);
                inv.addItem(copia);
                continue;
            }
            catch (WeightLimitExceededException wlee) {
                continue;
            }
            catch (VolumeLimitExceededException wlee) {
                // empty catch block
            }
        }
        return inv;
    }
}

