/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import bsh.TargetError;
import eu.irreality.age.Nameable;
import eu.irreality.age.PropertyEntry;
import eu.irreality.age.SupportingCode;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Entity {
    List propertiesList = new ArrayList();
    protected Vector relationships = new Vector();
    protected Vector relationship_properties = new Vector();
    private List pushToFront = new ArrayList();

    public void copyEntityFields(Entity e) {
        int i;
        this.propertiesList = new ArrayList(e.propertiesList.size());
        for (i = 0; i < e.propertiesList.size(); ++i) {
            this.propertiesList.add(((PropertyEntry)e.propertiesList.get(i)).clone());
        }
        this.relationships = new Vector(e.relationships.size());
        for (i = 0; i < e.relationships.size(); ++i) {
            this.relationships.add((Entity)e.relationships.get(i));
        }
        this.relationship_properties = new Vector(e.relationship_properties.size());
        for (i = 0; i < e.relationship_properties.size(); ++i) {
            ArrayList<Object> ofProperties = new ArrayList<Object>(((List)e.relationship_properties.get(i)).size());
            this.relationship_properties.add(ofProperties);
            for (int j = 0; j < ofProperties.size(); ++j) {
                ofProperties.add(((PropertyEntry)((List)e.relationship_properties.get(i)).get(j)).clone());
            }
        }
    }

    public boolean update(World mundo) {
        int i;
        if (this.pushToFront.size() > 0) {
            this.pushRequestedPropertiesToFront();
        }
        for (i = 0; i < this.propertiesList.size(); ++i) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            pe.decreaseTime();
            if (!pe.needsUpdate()) continue;
            this.update(pe, mundo);
        }
        for (i = 0; i < this.relationships.size(); ++i) {
            Entity ent = (Entity)this.relationships.get(i);
            List propertyEntries = (List)this.relationship_properties.get(i);
            for (int j = 0; j < propertyEntries.size(); ++j) {
                PropertyEntry entrada = (PropertyEntry)propertyEntries.get(j);
                entrada.decreaseTime();
                if (!entrada.needsUpdate()) continue;
                this.updateRelationship(ent, entrada, mundo);
            }
        }
        return true;
    }

    public boolean update(PropertyEntry pe, World mundo) {
        if (pe.getTimeLeft() < -2L) {
            return false;
        }
        boolean ejecutado = false;
        if (this instanceof SupportingCode) {
            SupportingCode esto = (SupportingCode)((Object)this);
            try {
                ejecutado = esto.execCode("update", new Object[]{pe, mundo});
            }
            catch (TargetError bshte) {
                mundo.write(mundo.getIO().getColorCode("error"));
                mundo.write("bsh.TargetError found at update routine, entity is " + this + ", property entry is " + pe.getName() + "\n");
                mundo.write("Target exception: " + bshte.printTargetError(bshte.getTarget()) + "\n");
                mundo.write(mundo.getIO().getColorCode("reset"));
                bshte.printStackTrace();
            }
            if (ejecutado) {
                return true;
            }
        }
        try {
            ejecutado = mundo.execCode("update", new Object[]{pe, this});
        }
        catch (TargetError bshte) {
            mundo.write("bsh.TargetError found at world's update routine, property entry is " + pe.getName());
            bshte.printStackTrace();
        }
        if (ejecutado) {
            return true;
        }
        if (pe.getName().equalsIgnoreCase("state")) {
            this.changeState(mundo);
        }
        return true;
    }

    public boolean updateRelationship(Entity e, PropertyEntry pe, World mundo) {
        return true;
    }

    public List getProperties() {
        return this.propertiesList;
    }

    public String getPropertyValue(String propertyName) {
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
            return pe.getValue();
        }
        return null;
    }

    public String getPropertyValueAsString(String propertyName) {
        return this.getPropertyValue(propertyName);
    }

    public void pushPropertyToFront(String propertyName) {
        this.pushToFront.add(propertyName);
    }

    private void pushRequestedPropertiesToFront() {
        for (int i = 0; i < this.pushToFront.size(); ++i) {
            this.pushPropertyToFrontReally((String)this.pushToFront.get(i));
        }
        this.pushToFront = new ArrayList();
    }

    private void pushPropertyToFrontReally(String propertyName) {
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
            this.propertiesList.remove(pe);
            this.propertiesList.add(0, pe);
        }
    }

    public Object getPropertyValueAsObject(String propertyName) {
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
            return pe.getValueAsObject();
        }
        return null;
    }

    public boolean getPropertyValueAsBoolean(String propertyName) {
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
            return pe.getValueAsBoolean();
        }
        return false;
    }

    public int getPropertyValueAsInteger(String propertyName) {
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
            return pe.getValueAsInteger();
        }
        return 0;
    }

    public double getPropertyValueAsDouble(String propertyName) {
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
            return pe.getValueAsDouble();
        }
        return 0.0;
    }

    public float getPropertyValueAsFloat(String propertyName) {
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
            return pe.getValueAsFloat();
        }
        return 0.0f;
    }

    public long getPropertyTimeLeft(String propertyName) {
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
            return pe.getTimeLeft();
        }
        return 0L;
    }

    public void setPropertyTimeLeft(String propertyName, long newTime) {
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
            pe.setTime(newTime);
        }
    }

    public PropertyEntry getPropertyEntry(String propertyName) {
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
            return pe;
        }
        return null;
    }

    public void setProperty(String propertyName, String propertyValue) {
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
            pe.setValue(propertyValue);
            return;
        }
        this.propertiesList.add(new PropertyEntry(propertyName, propertyValue, 0L));
    }

    public void setProperty(String propertyName, Object propertyValue) {
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
            pe.setValue(propertyValue.toString());
            pe.setObjectValue(propertyValue);
            return;
        }
        PropertyEntry pe = new PropertyEntry(propertyName, propertyValue.toString(), 0L);
        pe.setObjectValue(propertyValue);
        this.propertiesList.add(pe);
    }

    public void setProperty(String propertyName, int propertyValue) {
        this.setProperty(propertyName, String.valueOf(propertyValue));
    }

    public void setProperty(String propertyName, double propertyValue) {
        this.setProperty(propertyName, String.valueOf(propertyValue));
    }

    public void setProperty(String propertyName, float propertyValue) {
        this.setProperty(propertyName, String.valueOf(propertyValue));
    }

    public void setProperty(String propertyName, boolean propertyValue) {
        this.setProperty(propertyName, String.valueOf(propertyValue));
    }

    public void setProperty(String propertyName, String propertyValue, long timeLeft) {
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
            pe.setValueAndTime(propertyValue, timeLeft);
            return;
        }
        this.propertiesList.add(new PropertyEntry(propertyName, propertyValue, timeLeft));
    }

    public void setProperty(String propertyName, int propertyValue, long timeLeft) {
        this.setProperty(propertyName, String.valueOf(propertyValue), timeLeft);
    }

    public void setProperty(String propertyName, boolean propertyValue, long timeLeft) {
        this.setProperty(propertyName, String.valueOf(propertyValue), timeLeft);
    }

    public boolean hasBooleanProperty(String propertyName) {
        return this.getPropertyValueAsBoolean(propertyName);
    }

    public int matchesCommand(String commandArgs, boolean pluralOrSingular) {
        return 0;
    }

    public void setNewTarget(int ntarget) {
        this.setProperty("target", ntarget);
    }

    public int getTarget() {
        return this.getPropertyValueAsInteger("target");
    }

    public void setNewState(int nstate, long TUs) {
        if (this.getPropertyValueAsInteger("state") == 16) {
            System.out.println("setNewState: ");
            new Exception().printStackTrace();
        }
        this.setProperty("state", nstate, TUs);
    }

    protected void setNewState(int nstate) {
        this.setProperty("state", nstate);
    }

    public int getState() {
        return this.getPropertyValueAsInteger("state");
    }

    public abstract void changeState(World var1);

    public boolean stateMatches(int comparand, int mask) {
        return (mask & (this.getPropertyValueAsInteger("state") ^ comparand)) == 0;
    }

    public Node getPropListXMLRepresentation(Document doc) {
        Element e = doc.createElement("PropertyList");
        for (int i = 0; i < this.propertiesList.size(); ++i) {
            PropertyEntry pe = (PropertyEntry)this.propertiesList.get(i);
            Node nodoProp = pe.getXMLRepresentation(doc);
            e.appendChild(nodoProp);
        }
        return e;
    }

    public void readPropListFromXML(World mundo, Node n) throws XMLtoWorldException {
        Element e = null;
        try {
            e = (Element)n;
        }
        catch (ClassCastException cce) {
            throw new XMLtoWorldException("Entity node not Element");
        }
        NodeList nl = e.getElementsByTagName("PropertyList");
        if (nl.getLength() > 0) {
            Element elementoPropertyList = (Element)nl.item(0);
            NodeList listaPropertyEntries = elementoPropertyList.getElementsByTagName("PropertyEntry");
            for (int i = 0; i < listaPropertyEntries.getLength(); ++i) {
                Node nod = listaPropertyEntries.item(i);
                PropertyEntry pe = new PropertyEntry(mundo, nod);
                String nombre = pe.getName();
                for (int j = this.propertiesList.size() - 1; j >= 0; --j) {
                    PropertyEntry actual = (PropertyEntry)this.propertiesList.get(j);
                    if (!actual.getName().equals(nombre)) continue;
                    this.propertiesList.remove(actual);
                }
                this.propertiesList.add(pe);
            }
        }
    }

    public abstract int getID();

    public Node getRelationshipListXMLRepresentation(Document doc) {
        Element e = doc.createElement("RelationshipList");
        for (int i = 0; i < this.relationships.size(); ++i) {
            Element eRel = doc.createElement("Relationship");
            Element ePropList = doc.createElement("PropertyList");
            Entity objetivo = (Entity)this.relationships.elementAt(i);
            eRel.setAttribute("id", String.valueOf(objetivo.getID()));
            List propertiesList = (List)this.relationship_properties.elementAt(i);
            for (int j = 0; j < propertiesList.size(); ++j) {
                PropertyEntry pe = (PropertyEntry)propertiesList.get(j);
                Node nodoProp = pe.getXMLRepresentation(doc);
                ePropList.appendChild(nodoProp);
            }
            eRel.appendChild(ePropList);
            e.appendChild(eRel);
        }
        return e;
    }

    public void readRelationshipListFromXML(World mundo, Node n) throws XMLtoWorldException {
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Mobile node not Element");
        }
        Element e = (Element)n;
        NodeList nl = e.getElementsByTagName("RelationshipList");
        if (nl.getLength() > 0) {
            Element relationshipListNode = (Element)nl.item(0);
            NodeList relaciones = relationshipListNode.getElementsByTagName("Relationship");
            for (int i = 0; i < relaciones.getLength(); ++i) {
                ArrayList<PropertyEntry> propertiesList;
                Element thisRelationshipNode = (Element)relaciones.item(i);
                if (!thisRelationshipNode.hasAttribute("id")) {
                    throw new XMLtoWorldException("Relationship node lacking attribute id");
                }
                this.relationships.add(mundo.getObject(thisRelationshipNode.getAttribute("id")));
                NodeList pListNodes = thisRelationshipNode.getElementsByTagName("PropertyList");
                if (pListNodes.getLength() < 0) {
                    propertiesList = new ArrayList<PropertyEntry>();
                } else {
                    propertiesList = new ArrayList();
                    Element elementoPropertyList = (Element)pListNodes.item(0);
                    NodeList listaPropertyEntries = elementoPropertyList.getElementsByTagName("PropertyEntry");
                    for (int k = 0; k < listaPropertyEntries.getLength(); ++k) {
                        Node nod = listaPropertyEntries.item(k);
                        PropertyEntry pe = new PropertyEntry(mundo, nod);
                        propertiesList.add(pe);
                    }
                }
                this.relationship_properties.add(propertiesList);
            }
        }
    }

    public int getRelationshipState(Entity e) {
        return this.getRelationshipPropertyValueAsInteger(e, "state");
    }

    public int getRelationshipPropertyValueAsInteger(Entity e, String propertyName) {
        int lim = this.relationships.size();
        for (int k = 0; k < lim; ++k) {
            if (!this.relationships.elementAt(k).equals(e)) continue;
            List propertiesList = (List)this.relationship_properties.elementAt(k);
            for (int i = 0; i < propertiesList.size(); ++i) {
                PropertyEntry pe = (PropertyEntry)propertiesList.get(i);
                if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
                return pe.getValueAsInteger();
            }
        }
        return 0;
    }

    public String getRelationshipPropertyValueAsString(Entity e, String propertyName) {
        System.out.println("Relationships size is " + this.relationships.size());
        int lim = this.relationships.size();
        for (int k = 0; k < lim; ++k) {
            System.out.println("Checking a relationship. Entity: " + e.getID());
            if (!this.relationships.elementAt(k).equals(e)) continue;
            System.out.println("Entity found.");
            List propertiesList = (List)this.relationship_properties.elementAt(k);
            for (int i = 0; i < propertiesList.size(); ++i) {
                System.out.println("Name: " + ((PropertyEntry)propertiesList.get(i)).getName());
                PropertyEntry pe = (PropertyEntry)propertiesList.get(i);
                if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
                return pe.getValue();
            }
        }
        return null;
    }

    public List getRelatedEntities(String propertyName) {
        int lim = this.relationships.size();
        ArrayList<Entity> result = new ArrayList<Entity>();
        block0: for (int k = 0; k < lim; ++k) {
            Entity other = (Entity)this.relationships.elementAt(k);
            List propertiesList = (List)this.relationship_properties.elementAt(k);
            for (int i = 0; i < propertiesList.size(); ++i) {
                PropertyEntry pe = (PropertyEntry)propertiesList.get(i);
                if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
                result.add(other);
                continue block0;
            }
        }
        return result;
    }

    public List getRelatedEntitiesByValue(String propertyName, boolean boolVal) {
        int lim = this.relationships.size();
        ArrayList<Entity> result = new ArrayList<Entity>();
        block0: for (int k = 0; k < lim; ++k) {
            Entity other = (Entity)this.relationships.elementAt(k);
            List propertiesList = (List)this.relationship_properties.elementAt(k);
            for (int i = 0; i < propertiesList.size(); ++i) {
                PropertyEntry pe = (PropertyEntry)propertiesList.get(i);
                if (!pe.getName().equalsIgnoreCase(propertyName) || pe.getValueAsBoolean() != boolVal) continue;
                result.add(other);
                continue block0;
            }
        }
        return result;
    }

    public List getRelatedEntitiesByValue(String propertyName, int intVal) {
        int lim = this.relationships.size();
        ArrayList<Entity> result = new ArrayList<Entity>();
        block0: for (int k = 0; k < lim; ++k) {
            Entity other = (Entity)this.relationships.elementAt(k);
            List propertiesList = (List)this.relationship_properties.elementAt(k);
            for (int i = 0; i < propertiesList.size(); ++i) {
                PropertyEntry pe = (PropertyEntry)propertiesList.get(i);
                if (!pe.getName().equalsIgnoreCase(propertyName) || pe.getValueAsInteger() != intVal) continue;
                result.add(other);
                continue block0;
            }
        }
        return result;
    }

    public boolean getRelationshipPropertyValueAsBoolean(Entity e, String propertyName) {
        int lim = this.relationships.size();
        for (int k = 0; k < lim; ++k) {
            if (!this.relationships.elementAt(k).equals(e)) continue;
            List propertiesList = (List)this.relationship_properties.elementAt(k);
            for (int i = 0; i < propertiesList.size(); ++i) {
                PropertyEntry pe = (PropertyEntry)propertiesList.get(i);
                if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
                return pe.getValueAsBoolean();
            }
        }
        return false;
    }

    public void setRelationshipProperty(Entity e, String propertyName, String propertyValue) {
        int lim = this.relationships.size();
        for (int k = 0; k < lim; ++k) {
            if (!this.relationships.elementAt(k).equals(e)) continue;
            List propertiesList = (List)this.relationship_properties.elementAt(k);
            for (int i = 0; i < propertiesList.size(); ++i) {
                PropertyEntry pe = (PropertyEntry)propertiesList.get(i);
                if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
                pe.setValue(propertyValue);
                return;
            }
            propertiesList.add(new PropertyEntry(propertyName, propertyValue, 0L));
            return;
        }
        this.relationships.addElement(e);
        ArrayList<PropertyEntry> nuevaPropEntryList = new ArrayList<PropertyEntry>();
        PropertyEntry pe = new PropertyEntry(propertyName, propertyValue, 0L);
        nuevaPropEntryList.add(pe);
        this.relationship_properties.addElement(nuevaPropEntryList);
    }

    public void setRelationshipProperty(Entity e, String propertyName, int propertyValue) {
        this.setRelationshipProperty(e, propertyName, String.valueOf(propertyValue));
    }

    public void setRelationshipProperty(Entity e, String propertyName, boolean propertyValue) {
        this.setRelationshipProperty(e, propertyName, String.valueOf(propertyValue));
    }

    public void setRelationshipPropertyTimeLeft(Entity e, String propertyName, long newtime) {
        int lim = this.relationships.size();
        for (int k = 0; k < lim; ++k) {
            if (!this.relationships.elementAt(k).equals(e)) continue;
            List propertiesList = (List)this.relationship_properties.elementAt(k);
            for (int i = 0; i < propertiesList.size(); ++i) {
                PropertyEntry pe = (PropertyEntry)propertiesList.get(i);
                if (!pe.getName().equalsIgnoreCase(propertyName)) continue;
                pe.setTime(newtime);
                return;
            }
            propertiesList.add(new PropertyEntry(propertyName, "false", newtime));
            return;
        }
        this.relationships.addElement(e);
        ArrayList<PropertyEntry> nuevaPropEntryList = new ArrayList<PropertyEntry>();
        PropertyEntry pe = new PropertyEntry(propertyName, "false", newtime);
        nuevaPropEntryList.add(pe);
        this.relationship_properties.addElement(nuevaPropEntryList);
    }

    public void setRelationshipState(Entity e, int newState) {
        this.setRelationshipProperty(e, "state", newState);
    }

    public String toString() {
        String s = "[ " + this.getClass().getName() + ":" + this.getID();
        if (this instanceof Nameable) {
            s = s + ":";
            s = s + ((Nameable)((Object)this)).constructName2(1, null);
        }
        s = s + " ]";
        return s;
    }
}

