/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.AGESoundClient;
import eu.irreality.age.MultimediaInputOutputClient;
import eu.irreality.age.Player;
import eu.irreality.age.SoundClient;
import eu.irreality.age.SwingAetheriaGameLoader;
import eu.irreality.age.SwingAetheriaGameLoaderInterface;
import eu.irreality.age.SwingEditBoxListener;
import eu.irreality.age.SwingMenuAetheria;
import eu.irreality.age.VisualConfiguration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ColoredSwingClient
implements MultimediaInputOutputClient {
    private JTextField elCampoTexto;
    private JTextPane elAreaTexto;
    private JScrollPane elScrolling;
    private SwingEditBoxListener elEscuchador;
    private Vector gameLog;
    private SwingAetheriaGameLoader laVentana;
    private Document doc;
    private MutableAttributeSet atributos = new SimpleAttributeSet();
    private String currentInput;
    private Stack back = new Stack();
    private Stack forward = new Stack();
    private VisualConfiguration vc;
    private SoundClient sonido;
    private Hashtable colorCodesTable = new Hashtable();
    private JMenu clientConfigurationMenu = new JMenu("Cliente");

    public boolean isSoundEnabled() {
        return true;
    }

    public SoundClient getSoundClient() {
        if (this.sonido == null) {
            this.sonido = new AGESoundClient();
        }
        return this.sonido;
    }

    public boolean isDisconnected() {
        return false;
    }

    public String getColorCode(String colorType) {
        String code = (String)this.colorCodesTable.get(colorType);
        if (code == null) {
            return "";
        }
        return code;
    }

    public void setDefaultConfiguration() {
        this.colorCodesTable.put("description", "%00CC00%");
        this.colorCodesTable.put("important", "%FFFF00%");
        this.colorCodesTable.put("information", "%FFFF00%");
        this.colorCodesTable.put("action", "%9999FF%");
        this.colorCodesTable.put("denial", "%CC0000%");
        this.colorCodesTable.put("error", "%FF0000%");
        this.colorCodesTable.put("story", "%FFFFFF%");
        this.colorCodesTable.put("default", "%FFFFFF%");
        this.colorCodesTable.put("input", "%AAAAAA%");
        this.colorCodesTable.put("reset", "% %");
        this.elAreaTexto.setBackground(Color.black);
        this.elAreaTexto.setForeground(Color.white);
        StyleConstants.setForeground(this.atributos, Color.black);
        this.elAreaTexto.setFont(SwingAetheriaGameLoaderInterface.font);
        this.elAreaTexto.repaint();
    }

    public void setPergaminoConfiguration() {
        this.colorCodesTable.put("description", "%006600%");
        this.colorCodesTable.put("important", "%555500%");
        this.colorCodesTable.put("information", "%555500%");
        this.colorCodesTable.put("action", "%0000FF%");
        this.colorCodesTable.put("denial", "%C00000%");
        this.colorCodesTable.put("error", "%800000%");
        this.colorCodesTable.put("story", "%000001%");
        this.colorCodesTable.put("default", "%000001%");
        this.colorCodesTable.put("input", "%555555%");
        this.colorCodesTable.put("reset", " ");
        this.elAreaTexto.setBackground(new Color(255, 255, 211));
        this.elAreaTexto.setForeground(Color.black);
        StyleConstants.setForeground(this.atributos, Color.white);
        String fontName = "Lucida Handwriting Cursiva";
        float fontSize = 16.0f;
        Font laFuente = SwingAetheriaGameLoaderInterface.font;
        Font[] fuentes = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int f = 0; f < fuentes.length; ++f) {
            System.out.println("FONT: " + fuentes[f].getFontName());
            if (!fuentes[f].getFontName().equalsIgnoreCase(fontName)) continue;
            laFuente = fuentes[f].deriveFont(fontSize);
            break;
        }
        this.elAreaTexto.setFont(laFuente);
        this.elAreaTexto.repaint();
    }

    public void setVisualConfiguration(VisualConfiguration c) {
        Enumeration keys = c.getColorKeys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.colorCodesTable.put(key, c.getColorCode(key));
            System.out.println(this.getClass() + " putting " + " " + key + " " + c.getColorCode(key));
        }
        this.elAreaTexto.setBackground(c.getBackgroundColor());
        this.elAreaTexto.setForeground(c.getForegroundColor());
        StyleConstants.setForeground(this.atributos, c.getForegroundColor());
        this.elAreaTexto.repaint();
        this.elAreaTexto.setFont(c.getFont());
        this.vc = c;
    }

    public VisualConfiguration getVisualConfiguration() {
        if (this.vc != null) {
            return this.vc;
        }
        return new VisualConfiguration();
    }

    public void addToBackStack(String s) {
        if (this.back.isEmpty() || !s.equalsIgnoreCase((String)this.back.peek())) {
            this.back.push(s);
        }
    }

    public void addToForwardStack(String s) {
        if (this.forward.isEmpty() || !s.equalsIgnoreCase((String)this.back.peek())) {
            this.forward.push(s);
        }
    }

    public void forwardStackIntoBackStack() {
        while (!this.forward.isEmpty()) {
            Object o = this.forward.pop();
            if (o.equals("")) continue;
            this.back.push(o);
        }
    }

    public void goBack() {
        if (!this.back.isEmpty()) {
            this.addToForwardStack(this.elCampoTexto.getText());
            this.elCampoTexto.setText((String)this.back.pop());
        }
    }

    public void goForward() {
        if (!this.forward.isEmpty()) {
            this.addToBackStack(this.elCampoTexto.getText());
            this.elCampoTexto.setText((String)this.forward.pop());
        }
    }

    public void refreshFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ColoredSwingClient.this.elCampoTexto.requestFocus();
            }
        });
    }

    public void escribirTitulo(String s) {
        this.writeTitle(s);
    }

    public void writeTitle(String s) {
        this.laVentana.setTitle(s);
    }

    public void escribirTitulo(String s, int pos) {
        this.writeTitle(s, pos);
    }

    public void writeTitle(String s, int pos) {
        String titAct = this.laVentana.getTitle();
        StringTokenizer st = new StringTokenizer(titAct, "-");
        int npos = 1;
        String result = "";
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            result = npos == pos ? result + s : result + tok.trim();
            ++npos;
            if (!st.hasMoreTokens()) continue;
            result = result + " - ";
        }
        if (npos == pos) {
            result = result + " - " + s;
        }
        this.laVentana.setTitle(result);
    }

    public boolean isColorEnabled() {
        return true;
    }

    public boolean isMemoryEnabled() {
        return true;
    }

    public boolean isLoggingEnabled() {
        return true;
    }

    public boolean isTitleEnabled() {
        return true;
    }

    public ColoredSwingClient(SwingAetheriaGameLoader window, JTextField nCampo, JScrollPane scrolling, JTextPane nArea, Vector gameLog) {
        this.laVentana = window;
        this.elCampoTexto = nCampo;
        this.elAreaTexto = nArea;
        this.elScrolling = scrolling;
        this.gameLog = gameLog;
        this.elEscuchador = new SwingEditBoxListener(this.elCampoTexto, gameLog, this);
        this.elCampoTexto.addActionListener(this.elEscuchador);
        this.elCampoTexto.addKeyListener(this.elEscuchador);
        this.doc = this.elAreaTexto.getDocument();
        this.setDefaultConfiguration();
        this.initClientMenu(this.laVentana);
    }

    public void uninitClientMenu(final SwingAetheriaGameLoader window) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUninitClientMenu(window);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ColoredSwingClient.this.doUninitClientMenu(window);
                        window.repaint();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void initClientMenu(final SwingAetheriaGameLoader window) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doInitClientMenu(window);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ColoredSwingClient.this.doInitClientMenu(window);
                        window.repaint();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void doUninitClientMenu(SwingAetheriaGameLoader window) {
        JMenuBar mb = window.getTheJMenuBar();
        mb.remove(this.clientConfigurationMenu);
    }

    public void doInitClientMenu(final SwingAetheriaGameLoader window) {
        JMenu colorConfigurationMenu = new JMenu("Temas de color");
        final JCheckBoxMenuItem fullScreenOption = new JCheckBoxMenuItem("Pantalla completa", window.isFullScreenMode());
        JMenuBar mb = window.getTheJMenuBar();
        window.setTheJMenuBar(mb);
        this.clientConfigurationMenu.add(colorConfigurationMenu);
        this.clientConfigurationMenu.add(fullScreenOption);
        JRadioButtonMenuItem itemDefaultJuego = new JRadioButtonMenuItem("Por defecto (juego)", true);
        JRadioButtonMenuItem itemDefault = new JRadioButtonMenuItem("Por defecto (AGE)", false);
        JRadioButtonMenuItem itemPergamino = new JRadioButtonMenuItem("Pergamino", false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(itemDefaultJuego);
        bg.add(itemDefault);
        bg.add(itemPergamino);
        itemDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColoredSwingClient.this.setDefaultConfiguration();
            }
        });
        itemDefaultJuego.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VisualConfiguration vc;
                if (window.getMundo() != null && (vc = window.getMundo().getVisualConfiguration()) != null) {
                    ColoredSwingClient.this.setVisualConfiguration(vc);
                }
            }
        });
        itemPergamino.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColoredSwingClient.this.setPergaminoConfiguration();
            }
        });
        fullScreenOption.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (fullScreenOption.isSelected()) {
                    window.setFullScreenMode(true);
                } else {
                    window.setFullScreenMode(false);
                }
            }
        });
        colorConfigurationMenu.add(itemDefaultJuego);
        colorConfigurationMenu.add(itemDefault);
        colorConfigurationMenu.add(itemPergamino);
        mb.add(this.clientConfigurationMenu);
        window.repaint();
    }

    public ColoredSwingClient(SwingAetheriaGameLoader window, Vector gameLog) {
        this.laVentana = window;
        this.gameLog = gameLog;
        this.laVentana.getMainPanel().setLayout(new BorderLayout());
        this.laVentana.update(this.laVentana.getGraphics());
        this.laVentana.repaint();
        this.laVentana.updateNow();
        this.elAreaTexto = new JTextPane();
        this.laVentana.updateNow();
        this.elScrolling = new JScrollPane(this.elAreaTexto);
        this.elScrolling.setVerticalScrollBarPolicy(22);
        this.elAreaTexto.setForeground(Color.white);
        this.elAreaTexto.setBackground(Color.black);
        this.elAreaTexto.setFont(SwingAetheriaGameLoaderInterface.font);
        this.elAreaTexto.setVisible(true);
        this.elScrolling.setVisible(true);
        this.laVentana.getMainPanel().add((Component)this.elScrolling, "Center");
        this.elCampoTexto = new JTextField(200);
        this.elCampoTexto.setVisible(true);
        this.laVentana.getMainPanel().add((Component)this.elCampoTexto, "South");
        this.elCampoTexto.requestFocus();
        this.elCampoTexto.setCaretColor(Color.red);
        this.elAreaTexto.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent evt) {
                ColoredSwingClient.this.elCampoTexto.requestFocus();
            }

            public void focusLost(FocusEvent evt) {
            }
        });
        this.laVentana.setJMenuBar(new SwingMenuAetheria(this.laVentana));
        this.laVentana.setVisible(true);
        this.laVentana.repaint();
        this.laVentana.updateNow();
        this.elEscuchador = new SwingEditBoxListener(this.elCampoTexto, gameLog, this);
        this.elCampoTexto.addActionListener(this.elEscuchador);
        this.elCampoTexto.addKeyListener(this.elEscuchador);
        this.elAreaTexto.setText("--");
        this.doc = this.elAreaTexto.getDocument();
        this.initClientMenu(this.laVentana);
        this.laVentana.updateNow();
    }

    public static Color stringToColor(String colorString) {
        try {
            String colorClean = colorString;
            if (colorClean.charAt(0) == '%') {
                colorClean = colorClean.substring(1, colorClean.length() - 1);
            }
            if (colorClean.length() > 0 && colorClean.charAt(0) == '#') {
                colorClean = colorClean.substring(1);
            }
            int ncolor = Integer.parseInt(colorClean, 16);
            return new Color(ncolor);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static String colorToString(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return Integer.toString(red, 16) + Integer.toString(green, 16) + Integer.toString(blue, 16);
    }

    public void escribir(String s) {
        this.write(s);
    }

    public void write(String s) {
        boolean iscode;
        StringTokenizer st = new StringTokenizer(s, "%");
        boolean bl = iscode = s.length() > 0 && s.charAt(0) == '%';
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (iscode) {
                if (tok.equalsIgnoreCase("red")) {
                    StyleConstants.setForeground(this.atributos, Color.red);
                } else if (tok.equalsIgnoreCase("green")) {
                    StyleConstants.setForeground(this.atributos, Color.green);
                } else if (tok.equalsIgnoreCase("white")) {
                    StyleConstants.setForeground(this.atributos, Color.white);
                } else if (tok.equalsIgnoreCase("blue")) {
                    StyleConstants.setForeground(this.atributos, Color.blue);
                } else if (tok.equalsIgnoreCase("yellow")) {
                    StyleConstants.setForeground(this.atributos, Color.blue);
                } else if (tok.equalsIgnoreCase("lightgray")) {
                    StyleConstants.setForeground(this.atributos, Color.blue);
                } else if (tok.equalsIgnoreCase("magenta")) {
                    StyleConstants.setForeground(this.atributos, Color.blue);
                } else if (tok.trim().equalsIgnoreCase("")) {
                    System.out.println(this.getColorCode("default"));
                    System.out.println(ColoredSwingClient.stringToColor(this.getColorCode("default")));
                    StyleConstants.setForeground(this.atributos, ColoredSwingClient.stringToColor(this.getColorCode("default")));
                } else {
                    try {
                        String colortok = tok.length() > 0 && tok.charAt(0) == '#' ? tok.substring(1) : tok;
                        int ncolor = Integer.parseInt(colortok, 16);
                        StyleConstants.setForeground(this.atributos, new Color(ncolor));
                    }
                    catch (NumberFormatException nfe) {}
                }
            } else {
                try {
                    this.doc.insertString(this.elAreaTexto.getText().length(), tok, this.atributos);
                }
                catch (Exception ble) {
                    System.out.println(ble);
                }
            }
            iscode = !iscode;
        }
        this.elAreaTexto.setCaretColor(Color.red);
        this.elAreaTexto.moveCaretPosition(this.elAreaTexto.getText().length());
        this.elAreaTexto.setVisible(true);
    }

    public void insertIcon(String fileName) {
        this.elAreaTexto.setSelectionStart(this.elAreaTexto.getText().length());
        this.elAreaTexto.setSelectionEnd(this.elAreaTexto.getText().length());
        System.out.println("Icon Insert.\n");
        this.elAreaTexto.insertIcon(new ImageIcon(fileName));
    }

    public void insertCenteredIcon(String fileName) {
        this.elAreaTexto.setSelectionStart(this.elAreaTexto.getText().length());
        this.elAreaTexto.setSelectionEnd(this.elAreaTexto.getText().length());
        JPanel jp = new JPanel();
        jp.setBackground(this.elAreaTexto.getBackground());
        FlowLayout fl = new FlowLayout();
        fl.setAlignment(1);
        jp.add(new JLabel(new ImageIcon(fileName)));
        this.elAreaTexto.insertComponent(jp);
    }

    public boolean isGraphicsEnabled() {
        return true;
    }

    public void loguear(String s) {
        this.gameLog.addElement(s);
    }

    public void forzarEntrada(String s, boolean output_enabled) {
        this.forceInput(s, output_enabled);
    }

    public void forceInput(String s, boolean output_enabled) {
        this.gameLog.addElement(s);
        this.elEscuchador.countCommand();
        if (output_enabled) {
            this.write("\n");
            this.write(this.getColorCode("input") + "[COMANDO] " + s.trim() + this.getColorCode("reset") + "\n");
        }
    }

    public synchronized void waitKeyPress() {
        System.out.println("Keywait");
        this.elEscuchador.setPressAnyKeyState(true);
        System.out.println("Keywait flag set");
        try {
            System.out.println("Keywait I said");
            this.wait();
            System.out.println("Keywait I yelled");
        }
        catch (InterruptedException intex) {
            System.out.println(intex);
        }
    }

    public synchronized String getInput(Player pl) {
        this.setTextFieldForeground(Color.black);
        try {
            this.wait();
        }
        catch (InterruptedException intex) {
            System.out.println(intex);
        }
        String temp = this.currentInput;
        this.currentInput = null;
        this.setTextFieldForeground(Color.red);
        return temp;
    }

    private void setTextFieldForeground(final Color color) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.elCampoTexto.setForeground(color);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ColoredSwingClient.this.elCampoTexto.setForeground(color);
                    }
                });
            }
            catch (Exception ie) {
                ie.printStackTrace();
            }
        }
    }

    public synchronized String getRealTimeInput(Player pl) {
        String temp = this.currentInput;
        this.setTextFieldForeground(Color.black);
        this.currentInput = null;
        if (temp == null) {
            this.loguear("");
        } else {
            this.setTextFieldForeground(Color.red);
        }
        return temp;
    }

    public synchronized void setInputString(String s) {
        this.currentInput = s;
        this.notify();
    }

    public void borrarPantalla() {
        this.elAreaTexto.setText("");
    }
}

