/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import bsh.TargetError;
import eu.irreality.age.Effect;
import eu.irreality.age.Entity;
import eu.irreality.age.ObjectCode;
import eu.irreality.age.ReturnValue;
import eu.irreality.age.SupportingCode;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import java.util.Random;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AbstractEntity
extends Entity
implements SupportingCode {
    private String absentType;
    private int idnumber;
    private int inheritsFrom;
    protected String title;
    private int isInstanceOf;
    protected ObjectCode itsCode;
    private Random aleat;

    public Object clone() {
        AbstractEntity ae = new AbstractEntity();
        this.copyAbstractEntityFieldsTo(ae);
        return ae;
    }

    public void copyAbstractEntityFieldsTo(AbstractEntity ae) {
        System.out.println("Copying fields.");
        ae.copyEntityFields(this);
        if (this.itsCode != null) {
            ae.itsCode = this.itsCode.cloneIfNecessary();
        }
        ae.aleat = this.getRandom();
        ae.absentType = this.absentType;
    }

    public int getID() {
        return this.idnumber;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean execCode(String routine, Object[] args) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args);
        }
        return false;
    }

    public boolean execCode(String routine, Object[] args, ReturnValue retval) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args, retval);
        }
        return false;
    }

    public void changeState(World mundo) {
    }

    public void setID(int newid) {
        this.idnumber = newid < 40000000 ? newid + 40000000 : newid;
    }

    public void loadNumberGenerator(World mundo) {
        this.aleat = mundo.getRandom();
    }

    public Random getRandom() {
        return this.aleat;
    }

    public Node getXMLRepresentation(Document doc) {
        Element suElemento = doc.createElement("AbstractEntity");
        suElemento.setAttribute("id", String.valueOf(this.idnumber));
        suElemento.setAttribute("name", String.valueOf(this.title));
        suElemento.setAttribute("extends", String.valueOf(this.inheritsFrom));
        suElemento.setAttribute("clones", String.valueOf(this.isInstanceOf));
        suElemento.setAttribute("type", String.valueOf(this.absentType));
        suElemento.appendChild(this.getPropListXMLRepresentation(doc));
        suElemento.appendChild(this.getRelationshipListXMLRepresentation(doc));
        if (this.itsCode != null) {
            suElemento.appendChild(this.itsCode.getXMLRepresentation(doc));
        }
        return suElemento;
    }

    public AbstractEntity() {
    }

    public static AbstractEntity getInstance(World mundo, Node n) throws XMLtoWorldException {
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("AbstractEntity node not Element");
        }
        Element e = (Element)n;
        AbstractEntity ourNewAbstractEntity = !e.hasAttribute("type") ? new AbstractEntity(mundo, n) : (e.getAttribute("type").equalsIgnoreCase("effect") ? new Effect(mundo, n) : new AbstractEntity(mundo, n));
        return ourNewAbstractEntity;
    }

    public AbstractEntity(World mundo, Node n) throws XMLtoWorldException {
        this.constructAbstractEntity(mundo, n, true, "none");
    }

    public void constructAbstractEntity(World mundo, Node n, boolean allowInheritance, String absenttype) throws XMLtoWorldException {
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("AbstractEntity node not Element");
        }
        Element e = (Element)n;
        this.absentType = absenttype;
        if (e.hasAttribute("extends") && !e.getAttribute("extends").equals("0") && allowInheritance) {
            this.constructAbstractEntity(mundo, mundo.getAbstractEntityNode(e.getAttribute("extends")), true, absenttype);
            this.constructAbstractEntity(mundo, n, false, absenttype);
            return;
        }
        if (e.hasAttribute("clones") && !e.getAttribute("clones").equals("0") && allowInheritance) {
            this.constructAbstractEntity(mundo, mundo.getAbstractEntityNode(e.getAttribute("clones")), true, absenttype);
            this.constructAbstractEntity(mundo, n, false, absenttype);
            return;
        }
        if (!e.hasAttribute("name")) {
            throw new XMLtoWorldException("Item node lacks attribute name");
        }
        try {
            if (e.hasAttribute("id")) {
                this.idnumber = Integer.valueOf(e.getAttribute("id"));
            }
        }
        catch (NumberFormatException nfe) {
            throw new XMLtoWorldException("Bad number format at attribute id in abstract entity node");
        }
        this.title = e.getAttribute("name");
        this.readPropListFromXML(mundo, n);
        NodeList codeNodes = e.getElementsByTagName("Code");
        if (codeNodes.getLength() > 0) {
            try {
                this.itsCode = new ObjectCode(mundo, codeNodes.item(0));
            }
            catch (XMLtoWorldException ex) {
                throw new XMLtoWorldException("Exception at Code node: " + ex.getMessage());
            }
        }
        if (this.absentType.equalsIgnoreCase("effect")) {
            ((Effect)this).readEffectSpecifics(mundo, e);
        }
        if (this.getID() < 10000000) {
            this.idnumber += 40000000;
        }
    }

    public AbstractEntity createNewInstance(World mundo) {
        System.out.println("Creatin' new instance.");
        AbstractEntity it = (AbstractEntity)this.clone();
        System.out.println("Clone made.");
        it.inheritsFrom = 0;
        if (this.isInstanceOf == 0) {
            it.isInstanceOf = this.idnumber;
            System.out.println("1) instanceOf set to " + this.idnumber);
        } else {
            it.isInstanceOf = this.isInstanceOf;
            System.out.println("2) instanceOf set to " + this.isInstanceOf);
        }
        mundo.addAbstractEntityAssigningID(it);
        return it;
    }
}

