/*
 * Decompiled with CFR 0.152.
 */
package parser;

import Universo.ComandoAnterior;
import auxiliares.Debug;
import auxiliares.Func;
import auxiliares.Lectura;
import java.util.ArrayList;
import parser.Alias;
import parser.Articulos;
import parser.CCLugar;
import parser.Comando;
import parser.Comandos;
import parser.Orden;
import parser.Palabra;
import parser.SeparadorPorPalabras;
import parser.Verbos;

public class Parser {
    private String input;

    public Parser() {
        new Articulos();
        new CCLugar();
        this.crearVerbos();
        Alias.inicialiarAlias();
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<Orden> getComando(String inputLine) {
        this.input = inputLine;
        ArrayList<Object> comandos = new ArrayList();
        ArrayList<Orden> listaOrdenes = new ArrayList<Orden>();
        Palabra verbo = null;
        Palabra cDirecto = null;
        Palabra ccLugar = null;
        ArrayList<Palabra> args = null;
        inputLine = inputLine.toLowerCase();
        inputLine = this.normalizarEntrada(inputLine);
        inputLine = this.eliminarCaracteresNoDeseados(inputLine);
        inputLine = this.eliminarArticulos(inputLine);
        inputLine = this.buscarAlias(inputLine);
        comandos = this.crearComando(inputLine);
        for (ArrayList arrayList : comandos) {
            void var8_10;
            inputLine = "";
            for (Palabra unaPalabra : arrayList) {
                Debug.writeDebug(this, "Creamos el input line");
                if (unaPalabra == null) continue;
                Debug.writeDebug(this, "Comando desglosado: " + unaPalabra.palabra());
                inputLine = String.valueOf(inputLine) + " " + unaPalabra.palabra();
            }
            args = new ArrayList();
            verbo = Verbos.buscarUnVerbo(arrayList);
            if (verbo != null) {
                void var8_14;
                ArrayList<Palabra> arrayList2 = SeparadorPorPalabras.eliminarPalabra((ArrayList<Palabra>)arrayList, SeparadorPorPalabras.palabraPorPosicion(arrayList, verbo.getPosicion()));
                ccLugar = CCLugar.getCCLugar(arrayList2);
                if (ccLugar != null) {
                    ArrayList<Palabra> arrayList3 = SeparadorPorPalabras.eliminarPalabra(arrayList2, SeparadorPorPalabras.palabraPorPosicion(arrayList2, ccLugar.getPosicion()));
                }
                if ((cDirecto = SeparadorPorPalabras.palabraPorPosicion((ArrayList<Palabra>)var8_14, verbo.getPosicion())) != null) {
                    ArrayList<Palabra> arrayList4 = SeparadorPorPalabras.eliminarPalabra((ArrayList<Palabra>)var8_14, SeparadorPorPalabras.palabraPorPosicion((ArrayList<Palabra>)var8_14, cDirecto.getPosicion()));
                }
            }
            for (Palabra unaPalabra : var8_10) {
                Debug.writeDebug(this, "A\u00f1adiendo al args: " + unaPalabra.palabra());
                args.add(unaPalabra);
            }
            String aux = "";
            for (Palabra unaPalabra : args) {
                aux = String.valueOf(aux) + " " + unaPalabra.palabra();
            }
            Debug.writeDebug(this, "Args creado: " + aux);
            listaOrdenes.add(new Orden(verbo, cDirecto, ccLugar, args, this.input));
        }
        if (listaOrdenes.size() == 0) {
            Debug.writeDebug(this, "No hay ninguna orden creada.");
            args = new ArrayList<Palabra>();
            String[] stringArray = inputLine.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                args.add(new Palabra(string));
                Debug.writeDebug(this, "A\u00f1adiendo a args: " + string);
                ++n2;
            }
            listaOrdenes.add(new Orden(verbo, cDirecto, ccLugar, args, inputLine));
        }
        return listaOrdenes;
    }

    private ArrayList<ArrayList<Palabra>> crearComando(String inText) {
        ArrayList<Palabra> words = null;
        ArrayList<Palabra> endWords = new ArrayList<Palabra>();
        words = SeparadorPorPalabras.listarFraseEnPalabras(inText);
        for (Palabra word : words) {
            if (word.palabra().length() > 3 && (word.endsWith("la") || word.endsWith("lo") || word.endsWith("te") || word.endsWith("se") || word.endsWith("me") || word.endsWith("los") || word.endsWith("las")) && Verbos.buscarUnVerbo(word.palabra()) != null) {
                int longArticulo = 2;
                if (word.endsWith("las") || word.endsWith("los")) {
                    longArticulo = 3;
                }
                String auxWord = word.palabra().substring(0, word.palabra().length() - longArticulo);
                auxWord = this.buscarAlias(auxWord);
                if ((auxWord = Verbos.buscarUnVerbo(auxWord)) != null) {
                    Palabra newWord = new Palabra(auxWord);
                    newWord.setPosicion(word.getPosicion());
                    Debug.writeDebug(this, "Guardando la posicion: " + word.getPosicion());
                    endWords.add(newWord);
                    auxWord = word.palabra().substring(word.palabra().length() - longArticulo, word.palabra().length());
                    Palabra newArt = new Palabra(auxWord);
                    newArt.setPosicion(newWord.getPosicion() + 1);
                    endWords.add(newArt);
                    continue;
                }
                Debug.writeDebug(this, "No verbo. Guardando: " + word.palabra());
                endWords.add(word);
                continue;
            }
            if (Verbos.buscarUnVerbo(word.palabra()) != null) {
                word.setPalabra(Verbos.buscarUnVerbo(word.palabra()));
            }
            Debug.writeDebug(this, "Guardando palabra: " + word.palabra());
            endWords.add(word);
        }
        return this.separarComandosPorVerbos(endWords);
    }

    private ArrayList<ArrayList<Palabra>> separarComandosPorVerbos(ArrayList<Palabra> words) {
        ArrayList<Palabra> verbos = null;
        ArrayList<ArrayList<Palabra>> comandos = new ArrayList<ArrayList<Palabra>>();
        boolean hayVerbo = false;
        int auxNumVerbos = 0;
        verbos = Verbos.buscarTodosLosVerbos(words);
        int auxNumPalabras = 0;
        int posSiguienteVerbo = 0;
        int posActualVerbo = 0;
        while (auxNumVerbos < verbos.size()) {
            int i;
            ArrayList<Palabra> aux = new ArrayList<Palabra>();
            posSiguienteVerbo = words.size();
            if (hayVerbo) {
                auxNumPalabras = posActualVerbo + 1;
            }
            boolean primerVerboEncontrado = false;
            while (!primerVerboEncontrado && auxNumPalabras < words.size()) {
                if (Verbos.buscarUnVerbo(words.get(auxNumPalabras).palabra()) != null) {
                    primerVerboEncontrado = true;
                    posActualVerbo = auxNumPalabras;
                }
                ++auxNumPalabras;
            }
            boolean segundoVerboEncontrado = false;
            while (!segundoVerboEncontrado && auxNumPalabras < words.size()) {
                if (Verbos.buscarUnVerbo(words.get(auxNumPalabras).palabra()) != null) {
                    segundoVerboEncontrado = true;
                    posSiguienteVerbo = auxNumPalabras;
                }
                ++auxNumPalabras;
            }
            ++auxNumVerbos;
            if (!hayVerbo && verbos.size() > 0) {
                i = 0;
                hayVerbo = true;
            } else {
                i = posActualVerbo;
            }
            int j = i;
            while (j < posSiguienteVerbo) {
                aux.add(words.get(j));
                ++j;
            }
            comandos.add(aux);
        }
        if (comandos.size() == 0 && ComandoAnterior.getUltimaOrden() != null && ComandoAnterior.getUltimaOrden().getComando() != Comando.GO && !Comandos.buscarComandoValido(words)) {
            Debug.writeDebug(this, "A\u00f1adiendo comando anterior:" + ComandoAnterior.getUltimaOrden().getVerbo());
            if (ComandoAnterior.getUltimaOrden().getVerbo() != null) {
                words.add(0, ComandoAnterior.getUltimaOrden().getVerbo());
                comandos.add(words);
            }
        }
        return comandos;
    }

    private String eliminarArticulos(String inText) {
        String output = "";
        String[] words = inText.split(" ");
        String prep = "a ante con contra de desde hacia hasta para por seg\u00fan segun sin tras durante mediante en";
        int i = 0;
        while (i < words.length) {
            words[i] = words[i].trim();
            if (words[i].equals("y") || words[i].equals("la") || words[i].equals("las") || words[i].equals("el") || words[i].equals("los") || words[i].equals("un") || words[i].equals("unos") || words[i].equals("unas") || words[i].equals("al") || words[i].equals("del") || Func.textosExactos(words[i], prep)) {
                words[i] = "";
            }
            ++i;
        }
        i = 0;
        while (i < words.length) {
            if (words[i].length() > 0) {
                output = String.valueOf(output) + words[i] + " ";
            }
            ++i;
        }
        return output.trim();
    }

    private String eliminarCaracteresNoDeseados(String inText) {
        String output = "";
        int i = 0;
        while (i < inText.length()) {
            output = !(inText.charAt(i) >= 'a' && inText.charAt(i) <= 'z' || inText.charAt(i) >= '0' && inText.charAt(i) <= '9' || inText.charAt(i) == '\u00f1') ? String.valueOf(output) + " " : String.valueOf(output) + inText.charAt(i);
            ++i;
        }
        return output;
    }

    private String normalizarEntrada(String inText) {
        String originalchars = "\u00e1\u00e9\u00ed\u00f3\u00fa\u00e4\u00eb\u00ef\u00f6\u00fc\u00e2\u00ea\u00ee\u00f4\u00fb\u00e0\u00e8\u00ec\u00f2\u00f9\u00c1\u00c9\u00cd\u00d3\u00da\u00c4\u00cb\u00cf\u00d6\u00dc\u00c2\u00ca\u00ce\u00d4\u00db\u00c0\u00c8\u00cc\u00d2\u00d9";
        String output = "";
        int i = 0;
        while (i < inText.length()) {
            char ch;
            int pos = originalchars.indexOf(inText.charAt(i));
            output = pos != -1 ? String.valueOf(output) + "aeiou".charAt(pos % 5) : ((ch = inText.charAt(i)) == '.' || ch == ',' || ch == ';' || ch == '\"' || ch == '\'' ? String.valueOf(output) + " , " : String.valueOf(output) + inText.charAt(i));
            ++i;
        }
        return output;
    }

    private String buscarAlias(String inText) {
        String output = "";
        String[] words = inText.split(" ");
        Debug.writeDebug(this, "Sustituyendo alias de frase:" + inText);
        int i = 0;
        while (i < words.length) {
            String pronombre = "";
            words[i] = words[i].trim();
            if (Verbos.buscarUnVerbo(words[i]) != null) {
                words[i] = Verbos.buscarUnVerbo(words[i]);
                pronombre = Articulos.obtenerArticuloTeminancion(words[i]);
                if (pronombre != null) {
                    words[i] = words[i].substring(0, words[i].length() - pronombre.length());
                }
            }
            words[i] = Alias.findAlias(words[i]);
            if (pronombre != null) {
                words[i] = String.valueOf(words[i]) + pronombre;
            }
            Debug.writeDebug(this, "Alias encotrado: " + words[i]);
            ++i;
        }
        i = 0;
        while (i < words.length) {
            if (words[i].length() > 0) {
                output = String.valueOf(output) + words[i] + " ";
            }
            ++i;
        }
        Debug.writeDebug(this, "Resultado de findAlias: " + output.trim());
        return this.eliminarComandosRepetidos(output.trim());
    }

    private String eliminarComandosRepetidos(String inText) {
        String output = "";
        String[] words = inText.split(" ");
        int i = 0;
        while (i < words.length) {
            words[i] = words[i].trim();
            if (Verbos.buscarUnVerbo(words[i]) != null && i < words.length - 1 && Verbos.buscarUnVerbo(words[i + 1]) != null && Verbos.buscarUnVerbo(words[i]).equals(Verbos.buscarUnVerbo(words[i + 1]))) {
                words[i] = "";
            }
            ++i;
        }
        i = 0;
        while (i < words.length) {
            if (words[i].length() > 0) {
                output = String.valueOf(output) + words[i] + " ";
            }
            ++i;
        }
        return output.trim();
    }

    private void crearVerbos() {
        Comandos.crearComandos();
        new Lectura("verbos").leerFichero(0);
    }
}

