/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import parser.Comando;
import parser.Comandos;
import parser.Palabra;

public class Orden {
    private Palabra verbo;
    private Palabra cDirecto;
    private Palabra cIndirecto;
    private Palabra cInstrumento;
    private Palabra cLugar;
    private ArrayList<Palabra> args;
    private String inputLine;

    public Orden(Palabra verbo, Palabra cDirecto, Palabra ccLugar, ArrayList<Palabra> args, String inputLine) {
        this.verbo = verbo;
        this.cDirecto = cDirecto;
        this.args = args;
        this.inputLine = inputLine;
        this.cIndirecto = null;
        this.cLugar = ccLugar;
        this.cInstrumento = null;
    }

    public Orden() {
        this.verbo = null;
        this.cDirecto = null;
        this.args = null;
        this.inputLine = null;
        this.cIndirecto = null;
        this.cLugar = null;
        this.cInstrumento = null;
        this.inputLine = null;
    }

    public Palabra getVerbo() {
        return this.verbo;
    }

    public String verbo() {
        if (this.verbo != null) {
            return this.verbo.palabra();
        }
        return "";
    }

    public Comando getComando() {
        if (this.verbo != null) {
            return Comandos.getComando(this.verbo());
        }
        String[] stringArray = this.listaArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (Comandos.esComando(word)) {
                return Comandos.getComando(word);
            }
            ++n2;
        }
        return Comando.UNKNOWN;
    }

    public void setVerbo(Palabra verbo) {
        this.verbo = verbo;
    }

    public Palabra getcDirecto() {
        return this.cDirecto;
    }

    public String cDirecto() {
        if (this.cDirecto != null) {
            return this.cDirecto.palabra();
        }
        return null;
    }

    public void setcDirecto(Palabra cDirecto) {
        this.cDirecto = cDirecto;
    }

    public Palabra getcIndirecto() {
        return this.cIndirecto;
    }

    public String cIndirecto() {
        if (this.cIndirecto != null) {
            return this.cIndirecto.palabra();
        }
        return "";
    }

    public void setcIndirecto(Palabra cIndirecto) {
        this.cIndirecto = cIndirecto;
    }

    public Palabra getcInstrumento() {
        return this.cInstrumento;
    }

    public String cInstrumento() {
        if (this.cInstrumento != null) {
            return this.cInstrumento.palabra();
        }
        return "";
    }

    public void setcInstrumento(Palabra cModo) {
        this.cInstrumento = cModo;
    }

    public Palabra getcLugar() {
        return this.cLugar;
    }

    public String cLugar() {
        if (this.cLugar != null) {
            return this.cLugar.palabra();
        }
        return "";
    }

    public void setcLugar(Palabra cLugar) {
        this.cLugar = cLugar;
    }

    public ArrayList<Palabra> getArgs() {
        return this.args;
    }

    public String args() {
        String out = "";
        if (this.args != null && this.args.size() > 0) {
            for (Palabra unaPalabra : this.args) {
                out = String.valueOf(out) + " " + unaPalabra.palabra();
            }
        }
        return out.trim();
    }

    public String cDyArgs() {
        if (this.getcDirecto() != null) {
            return (String.valueOf(this.cDirecto()) + " " + this.args()).trim();
        }
        return this.args().trim();
    }

    public String[] listaArgs() {
        return this.args().split(" ");
    }

    public void eliminarDelArgs(String inTxt) {
        ArrayList<Palabra> aux = new ArrayList<Palabra>();
        if (this.args != null && this.args.size() > 0) {
            for (Palabra unaPalabra : this.args) {
                if (unaPalabra.palabra().equals(inTxt)) continue;
                aux.add(unaPalabra);
            }
        }
        this.args = aux;
    }

    public void setArgs(ArrayList<Palabra> args) {
        this.args = args;
    }

    public void addArgs(Palabra pal) {
        this.args.add(pal);
    }

    public void delArgs(Palabra pal) {
        this.args.remove(pal);
    }

    public String getInputLine() {
        return this.inputLine;
    }

    public void setInputLine(String inputLine) {
        this.inputLine = inputLine;
    }

    public String toString() {
        String out = "";
        out = this.verbo != null ? "%v=" + this.verbo.palabra() + " " + this.verbo.getPosicion() : "%v=null -1";
        out = this.cDirecto != null ? String.valueOf(out) + "%d=" + this.cDirecto.palabra() + " " + this.cDirecto.getPosicion() : String.valueOf(out) + "%d=null -1";
        out = this.cIndirecto != null ? String.valueOf(out) + "%i=" + this.cIndirecto.palabra() + " " + this.cIndirecto.getPosicion() : String.valueOf(out) + "%i=null -1";
        out = this.cLugar != null ? String.valueOf(out) + "%l=" + this.cLugar.palabra() + " " + this.cLugar.getPosicion() : String.valueOf(out) + "%l=null -1";
        out = this.cInstrumento != null ? String.valueOf(out) + "%h=" + this.cInstrumento.palabra() + " " + this.cInstrumento.getPosicion() : String.valueOf(out) + "%h=null -1";
        if (this.args != null && this.args.size() > 0) {
            out = String.valueOf(out) + "%args=";
            for (Palabra unaPalabra : this.args) {
                out = String.valueOf(out) + "&" + unaPalabra.palabra() + " " + unaPalabra.getPosicion();
            }
            out = out.trim();
        } else {
            out = String.valueOf(out) + "%args=null";
        }
        out = this.inputLine != null ? String.valueOf(out) + "%il=" + this.inputLine.trim() : String.valueOf(out) + out + "%il=null";
        return out;
    }
}

