/*
 * Decompiled with CFR 0.152.
 */
package objeto;

import Universo.Mundo;
import auxiliares.Debug;
import entidad.Entidad;
import java.util.ArrayList;
import objeto.InventarioObjeto;
import objeto.Objeto;
import objeto.ObjetoAbrible;
import parser.Orden;
import propiedades.Accion;

public class ObjetoContenedor
extends ObjetoAbrible {
    private boolean esContenedor = true;
    private Objeto other;
    private ArrayList<Entidad> others;
    private InventarioObjeto inventario = new InventarioObjeto(this);

    public ObjetoContenedor(String nombre) {
        super(nombre);
    }

    @Override
    public String getDescripcion() {
        return String.valueOf(super.getDescripcion()) + "\n" + this.inventario.mostrar();
    }

    public InventarioObjeto getInventario() {
        if (this.inventario == null) {
            System.out.println("No hay inventario creado para " + this.getNombre());
        }
        return this.inventario;
    }

    public void anadirObjetoInventario(Objeto item) {
        Debug.writeDebug(this, "A\u00f1adiendo a inventario el item: " + item.getNombre());
        item.setObjeto(this);
        if (item.getEstancia() != null) {
            item.setEstancia(null);
        }
        if (item.getPersona() != null) {
            item.setPersona(null);
        }
    }

    public void eliminarObjetoDeInventario(Objeto item) {
        item.setObjeto(null);
    }

    public void mostrarInventario() {
        this.inventario.mostrar();
    }

    public boolean vacio() {
        return this.inventario.getInventario().size() == 0;
    }

    public boolean tieneAlaVista(Entidad item) {
        return this.inventario.getInventario().contains(item);
    }

    @Override
    public Accion parseCommand(Orden orden, ArrayList<Entidad> entitys) {
        Accion resultado = this.proccesCommand(orden, entitys);
        if (resultado == Accion.NEXT) {
            resultado = super.parseCommand(orden, entitys);
        }
        return resultado;
    }

    private Accion proccesCommand(Orden orden, ArrayList<Entidad> entitys) {
        if (orden.verbo().equals("meter")) {
            Debug.writeDebug(this, "Entidad: " + this.unNombre() + " Meter algo dentro de otra cosa");
            Accion accion = this.putintoConditions(orden, entitys);
            Accion.execute(accion);
            if (accion == Accion.PUTINTO_OK) {
                Mundo.writeln(Accion.printCondition(Accion.PUTINTO_OK, this.other, this));
                this.anadirObjetoInventario(this.other);
                if (this.others.size() > 0) {
                    for (Entidad unaEntidad : this.others) {
                        Mundo.writeln(Accion.printCondition(Accion.PUTINTO_OK, unaEntidad, this));
                        this.anadirObjetoInventario((Objeto)unaEntidad);
                    }
                }
                return Accion.STOP;
            }
            return accion;
        }
        if (orden.verbo().equals("sacar")) {
            Debug.writeDebug(this, "Entidad: " + this.unNombre() + " sacar algo de otra cosa");
            Accion accion = this.takeoutConditions(orden, entitys);
            Accion.execute(accion);
            if (accion == Accion.TAKEOUT_OK) {
                Mundo.writeln(Accion.printCondition(Accion.TAKEOUT_OK, this.other, this));
                Mundo.getJugador().anadirObjetoInventario(this.other);
                if (this.others.size() > 0) {
                    for (Entidad unaEntidad : this.others) {
                        Mundo.writeln(Accion.printCondition(Accion.TAKEOUT_OK, unaEntidad, this));
                        this.anadirObjetoInventario((Objeto)unaEntidad);
                    }
                }
                return Accion.STOP;
            }
            return accion;
        }
        return Accion.NEXT;
    }

    private Accion putintoConditions(Orden orden, ArrayList<Entidad> entitys) {
        if (this.preConditionContainer(orden, entitys)) {
            if (!this.presenteYvisible() || !this.other.presenteYvisible()) {
                Debug.writeDebug(this, "Uno de los objetos no est\u00e1 presente.");
                return Accion.PUTINTO_NO_OK;
            }
            if (this.other.esEstatico()) {
                Debug.writeDebug(this, "El item " + this.other.unNombre() + " es est\u00e1tico.");
                return Accion.PUTINTO_NO_OK;
            }
            if (this.esAbrible() && !this.estaAbierto()) {
                Mundo.writeln(Accion.printCondition(Accion.IS_CLOSED, this));
                return Accion.STOP;
            }
        } else {
            return Accion.PUTINTO_NO_OK;
        }
        return Accion.PUTINTO_OK;
    }

    private Accion takeoutConditions(Orden orden, ArrayList<Entidad> entitys) {
        if (this.preConditionContainer(orden, entitys)) {
            if (!this.presenteYvisible() || !this.tieneAlaVista(this.other)) {
                Debug.writeDebug(this, "Uno de los objetos no est\u00e1 presente.");
                return Accion.TAKEOUT_NO_OK;
            }
            if (this.esAbrible() && !this.estaAbierto()) {
                Mundo.writeln(Accion.printCondition(Accion.IS_CLOSED, this));
                return Accion.STOP;
            }
        } else {
            return Accion.TAKEOUT_NO_OK;
        }
        return Accion.TAKEOUT_OK;
    }

    private boolean preConditionContainer(Orden orden, ArrayList<Entidad> entitys) {
        boolean out = false;
        this.others = new ArrayList();
        if (orden.getcDirecto() != null) {
            this.other = (Objeto)Mundo.buscarEntidad(orden.cDirecto());
            if (this.other != null) {
                out = true;
            }
        }
        if (entitys.size() > 1) {
            for (Entidad unaEntidad : entitys) {
                if (unaEntidad.equals(this) || unaEntidad.equals(this.other)) continue;
                this.others.add(unaEntidad);
            }
        }
        return out;
    }

    public boolean estaDentro(Entidad item) {
        return this.estaAbierto() && this.tieneAlaVista(item);
    }
}

