/*
 * Decompiled with CFR 0.152.
 */
package objeto;

import Universo.Mundo;
import Universo.Persona;
import auxiliares.Debug;
import entidad.Entidad;
import estancia.Estancia;
import java.util.ArrayList;
import objeto.ObjetoContenedor;
import parser.Articulos;
import parser.Comando;
import parser.Orden;
import parser.PalYGen;
import propiedades.Accion;

public class Objeto
extends Entidad {
    private boolean esEstatico = false;
    private boolean prenda = false;
    private boolean llevaPuesto = false;
    private Persona persona;
    private ObjetoContenedor objeto;

    public Objeto(String nombre) {
        super(nombre);
    }

    public boolean esEstatico() {
        return this.esEstatico;
    }

    public boolean esPrenda() {
        return this.prenda;
    }

    public boolean llevaPuesto() {
        if (this.esPrenda()) {
            return this.llevaPuesto;
        }
        return false;
    }

    public void setLlevaPuesto(boolean stt) {
        this.llevaPuesto = stt;
    }

    public void setPrenda(boolean prn) {
        this.prenda = prn;
    }

    public void setEstatico(boolean estatico) {
        this.esEstatico = estatico;
    }

    public Persona getPersona() {
        return this.persona;
    }

    public void setPersona(Object loc) {
        if (loc instanceof Persona) {
            this.persona = (Persona)loc;
            this.persona.getInventario().nuevoObjeto(this);
        } else if (loc == null) {
            this.persona.getInventario().quitarObjeto(this);
            this.persona = null;
        }
    }

    public ObjetoContenedor getItem() {
        return this.objeto;
    }

    public void setObjeto(Object loc) {
        if (loc instanceof ObjetoContenedor) {
            this.objeto = (ObjetoContenedor)loc;
            this.objeto.getInventario().nuevoObjeto(this);
        } else if (loc == null) {
            if (this.objeto instanceof ObjetoContenedor) {
                this.objeto.getInventario().quitarObjeto(this);
            }
            this.objeto = null;
        }
    }

    public String elNombre() {
        String out = "el";
        String aName = this.getNombreParaMostrar();
        PalYGen nombre = this.getShowNameAndGen();
        String articulo = Articulos.getArticuloPorGenero(nombre.getGeneroYnumero());
        int numero = nombre.getNumero();
        out = !this.esMasculino() ? (numero == 13 ? "la" : "las") : (numero == 13 ? "el" : "los");
        out = String.valueOf(out) + " " + aName;
        return out;
    }

    public String unNombre() {
        String out = "un";
        String aName = this.getNombreParaMostrar();
        PalYGen nombre = this.getShowNameAndGen();
        int numero = nombre.getNumero();
        out = !this.esMasculino() ? (numero == 13 ? "una" : "unas") : (numero == 13 ? "un" : "unos");
        out = String.valueOf(out) + " " + aName;
        return out.trim();
    }

    @Override
    public Accion parseCommand(Orden orden, ArrayList<Entidad> entidades) {
        return this.proccesCommand(orden, entidades);
    }

    private Accion proccesCommand(Orden orden, ArrayList<Entidad> entidades) {
        if (orden.verbo().equals("coger")) {
            Debug.writeDebug(this, "Quieres coger algo.");
            Debug.writeDebug(this, "Item: " + this.getNombre());
            Accion accion = this.getConditions();
            Accion.execute(accion);
            if (accion == Accion.GET_OK) {
                Mundo.getJugador().anadirObjetoInventario(this);
                Mundo.writeln(Accion.printCondition(Accion.GET_OK, this));
                return Accion.END;
            }
            if (accion == Accion.ALREADY_GET || accion == Accion.GET_NO_OK) {
                Mundo.writeln(Accion.printCondition(accion, this));
                return this.end();
            }
            return accion;
        }
        if (orden.getComando() == Comando.DRESS) {
            Accion accion = this.dressConditions();
            Accion.execute(accion);
            if (accion == Accion.DRESS_OK) {
                this.setLlevaPuesto(true);
                Mundo.writeln(Accion.printCondition(Accion.DRESS_OK, this));
                return this.end();
            }
            if (accion == Accion.GET_AND_DRESS) {
                this.setLlevaPuesto(true);
                Mundo.getJugador().anadirObjetoInventario(this);
                Mundo.writeln(Accion.printCondition(Accion.GET_OK, this));
                Mundo.writeln(Accion.printCondition(Accion.DRESS_OK, this));
                return this.end();
            }
            if (accion == Accion.ALREADY_DRESS) {
                Mundo.writeln(Accion.printCondition(Accion.ALREADY_DRESS, this));
                return this.end();
            }
            return accion;
        }
        if (orden.getComando() == Comando.UNDRESS) {
            Accion accion = this.undressConditions();
            Accion.execute(accion);
            if (accion == Accion.UNDRESS_OK) {
                this.setLlevaPuesto(false);
                Mundo.writeln(Accion.printCondition(Accion.UNDRESS_OK, this));
                return this.end();
            }
            return accion;
        }
        if (orden.getComando() == Comando.LOOK) {
            Debug.writeDebug(this, "Quieres examinar algo.");
            Debug.writeDebug(this, "Item: " + this.getNombre());
            Accion accion = this.lookConditions();
            Accion.execute(accion);
            if (accion == Accion.LOOK_OK) {
                Mundo.writeln(this.getDescripcion());
                this.post_descripcion();
                return Accion.END;
            }
            return accion;
        }
        if (orden.verbo().equals("dejar")) {
            Debug.writeDebug(this, "Quieres soltar algo.");
            Debug.writeDebug(this, "Item: " + this.getNombre());
            Accion accion = this.dropConditions();
            Accion.execute(accion);
            if (accion == Accion.DROP_OK) {
                if (this.esPrenda()) {
                    this.setLlevaPuesto(false);
                }
                Estancia.getHabitacionActual().anadirObjetoInventario(this);
                Mundo.writeln(Accion.printCondition(Accion.DROP_OK, this));
                return Accion.END;
            }
            Mundo.writeln(Accion.printCondition(Accion.DROP_NO_OK, this));
            return Accion.END;
        }
        if (orden.verbo().equals("mover") && Estancia.getHabitacionActual().tieneAlaVista(this)) {
            if (this.esEstatico()) {
                Accion.execute(Accion.MOVE_NO_OK);
                Mundo.writeln(Accion.printCondition(Accion.MOVE_NO_OK, this));
                return this.end();
            }
            Accion.execute(Accion.MOVE_OK);
            Mundo.writeln(Accion.printCondition(Accion.MOVE_OK, this));
            return this.end();
        }
        return Accion.NEXT;
    }

    private Accion getConditions() {
        if (this instanceof Persona) {
            return Accion.GET_NO_OK;
        }
        if (Mundo.getJugador().tiene(this)) {
            return Accion.ALREADY_GET;
        }
        if (!Estancia.getHabitacionActual().tiene(this)) {
            return Accion.NO_PRESENT_AT_GET;
        }
        if (this.esEstatico()) {
            return Accion.GET_NO_OK;
        }
        return Accion.GET_OK;
    }

    private Accion dressConditions() {
        if (!this.esPrenda()) {
            return Accion.DRESS_NO_OK;
        }
        if (this.getConditions() == Accion.ALREADY_GET) {
            if (this.esPrenda()) {
                if (this.llevaPuesto()) {
                    return Accion.ALREADY_DRESS;
                }
                return Accion.DRESS_OK;
            }
            return Accion.DRESS_NO_OK;
        }
        if (this.getConditions() == Accion.GET_OK) {
            if (this.esPrenda()) {
                return Accion.GET_AND_DRESS;
            }
            return Accion.DRESS_NO_OK;
        }
        return this.getConditions();
    }

    private Accion undressConditions() {
        if (this.getConditions() == Accion.ALREADY_GET && this.esPrenda() && this.llevaPuesto()) {
            return Accion.UNDRESS_OK;
        }
        return Accion.UNDRESS_NO_OK;
    }

    private Accion lookConditions() {
        if (!this.presente()) {
            return Accion.LOOK_NO_OK;
        }
        return Accion.LOOK_OK;
    }

    private Accion dropConditions() {
        if (!Mundo.getJugador().tieneAlaVista(this)) {
            return Accion.DROP_NO_OK;
        }
        return Accion.DROP_OK;
    }
}

