/*
 * Decompiled with CFR 0.152.
 */
package componentes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class Grafico
extends JPanel {
    private Image imagen;
    private String n_imagen;

    public Grafico() {
        this.setBackground(Color.BLACK);
    }

    public Grafico(String nombreImagen) {
        if (nombreImagen != null) {
            this.n_imagen = nombreImagen;
            this.imagen = new ImageIcon(nombreImagen).getImage();
        }
    }

    public Grafico(Image imagenInicial) {
        if (imagenInicial != null) {
            this.imagen = imagenInicial;
        }
    }

    public void setImagen(String nombreImagen) {
        if (nombreImagen != null) {
            File url = new File("recursos/Imagenes/" + nombreImagen);
            this.n_imagen = url.getAbsolutePath();
            this.imagen = new ImageIcon(this.n_imagen).getImage();
        } else {
            this.imagen = null;
        }
        this.repaint();
    }

    public Image getImagen() {
        return this.imagen;
    }

    public static Image getImagen(String nombreImagen) {
        Image img;
        if (nombreImagen != null) {
            File url = new File("recursos/Imagenes/" + nombreImagen);
            String n_imagen = url.getAbsolutePath();
            img = new ImageIcon(n_imagen).getImage();
        } else {
            img = null;
        }
        return img;
    }

    public void setImagen(Image nuevaImagen) {
        this.imagen = nuevaImagen;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        this.setBackground(Color.black);
        if (this.imagen != null) {
            Dimension tamano = this.getSize();
            int w = this.imagen.getWidth(this);
            int h = this.imagen.getHeight(this);
            int maxWidth = tamano.width;
            int maxHeight = tamano.height;
            if (w < h) {
                h = h * maxWidth / w;
                w = maxWidth;
            } else {
                w = w * maxHeight / h;
                h = maxHeight;
            }
            g.drawImage(this.imagen, tamano.width / 2 - w / 2, tamano.height / 3 - h / 3, w, h, this);
            this.setOpaque(false);
        } else {
            this.setOpaque(true);
        }
    }
}

