/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.Habitaciones.Ram;
import Game.Memoria;
import Game.Objetos.Cdl;
import Universo.Jugador;
import Universo.Mundo;
import Universo.Universo;
import auxiliares.Func;
import entidad.Entidad;
import estancia.Estancia;
import java.awt.Color;
import java.util.ArrayList;
import parser.Comando;
import parser.Orden;
import propiedades.Accion;
import propiedades.Temporizador;

public class Player
extends Jugador {
    public static final int DESINTEGRADO = 0;
    public static final int RESET = 1;
    public static final int BUG = 2;
    public static final int ANTIVIRUS = 3;
    public static final int DIGITAYA = 4;
    public static final int VICTORIA = -1;
    public static boolean FIN = false;
    private boolean primer_ciclo = true;

    public Player(String name) {
        super(name);
    }

    @Override
    public void init() {
    }

    @Override
    public void descripcion() {
        this.setDescripcion("Eres pura energ\u00eda digital.");
        super.descripcion();
    }

    @Override
    public Accion parseCommand(Orden orden) {
        String digitaly = "digitaly F4D3";
        if (orden.getComando() == Comando.LOOK && (Func.textosExactos(orden.cDirecto(), digitaly) || Func.textosExactos(orden.args(), digitaly))) {
            Mundo.writeln(Mundo.entidad("digitaly").getDescripcion());
            return Accion.END;
        }
        if ((orden.verbo().equals("cargar") || orden.verbo().equals("descargar")) && (Func.textosExactos(orden.cDirecto(), digitaly) || Func.textosExactos(orden.args(), digitaly))) {
            Mundo.writeln("Tu equipo CDL no est\u00e1 dise\u00f1ado para alojar una copia de Digitaly.");
            return Accion.END;
        }
        return super.parseCommand(orden);
    }

    public void escenaFinal(boolean rslt, int muerte) {
        if (rslt) {
            Mundo.writeln("\u00a1\u00a1\u00a1ENHORABUENA!!! Has conseguido rescatar a Digitaly.");
            Player.playAudio("extra.wav");
        } else {
            Player.playAudio("muerte.wav");
            switch (muerte) {
                case 0: {
                    Mundo.writeln("Un bombardeo de electrones acaba desintegrando tu existencia.\nEst\u00e1s muerto.");
                    break;
                }
                case 1: {
                    Mundo.writeln("Un fallo general en el sistema provoca un reset del equipo acabando con tu existencia.\nEst\u00e1s muerto.");
                    break;
                }
                case 2: {
                    Mundo.writeln("La escritura en la memoria de datos provoca a KillBug, dando lugar a un reset del equipo y acabando con tu existencia.\nEst\u00e1s muerto.");
                    break;
                }
                case 3: {
                    Mundo.writeln("La escritura en la zona de programa provoca a BadBear. Este hace que seas borrado de la memoria acabando con tu existencia.\nEst\u00e1s muerto.");
                    break;
                }
                case 4: {
                    Mundo.writeln("Tu misi\u00f3n ha fracasado, Digitaly ha sido aniquilado.");
                }
            }
        }
        Estancia.setHabitacionSiguiente(Mundo.habitacion("limbo"));
        Estancia.getHabitacionActual().cambiaDeEstancia(Mundo.habitacion("limbo"));
    }

    @Override
    public Accion parseCommand(Orden orden, ArrayList<Entidad> entidades) {
        if (orden.getComando() == Comando.GET || orden.getComando() == Comando.DROP || orden.getComando() == Comando.TAKEOUT || orden.getComando() == Comando.TAKEOUT) {
            Mundo.writeln("No puedes coger/sacar ni dejar/meter nada. Lo \u00fanica opci\u00f3n que tienes es {color%green%CARGAR} o {color%green%DESCARGAR} datos / programas de / a tu CDL");
            return Accion.STOP;
        }
        return super.parseCommand(orden, entidades);
    }

    @Override
    public void update(Temporizador temp) {
        if (Mundo.habitacion("ram").getPropiedadInt("movimientos") % 10 == 0) {
            Mundo.habitacion("ram").set("movimientos", 1);
            this.ciclo();
        }
        Mundo.habitacion("ram").incrementarPropiedad("movimientos");
        String dir_actual = Mundo.habitacion("ram").getPropiedadString("direccion actual");
        int dir = Memoria.hex2decimal(dir_actual);
        if (Estancia.getHabitacionActual().equals(Mundo.habitacion("interrupciones")) && Mundo.entidad("bitInterrupcion").getPropiedadBoolean("bitactivo") && Mundo.entidad("direccionInterrupcion").getPropiedadString("direccion").equals("ninguna")) {
            Mundo.writelnColor("-- ERROR EN EL SERVICIO DE INTERRUPCI\u00d3N: SIN DIRECCI\u00d3N CARGADA -- ", Color.ORANGE);
        }
        if (Mundo.entidad("bitInterrupcion").getPropiedadBoolean("bitactivo")) {
            String direcc = Mundo.entidad("direccionInterrupcion").getPropiedadString("direccion");
            int direccDec = Memoria.hex2decimal(direcc);
            if (!direcc.equals("ninguna")) {
                String pc = Mundo.entidad("pc").getPropiedadString("direccion actual");
                while (pc.length() < 3) {
                    pc = "0" + pc;
                }
                int lP = ((Cdl)Mundo.entidad("cdl")).longitudPrograma();
                Mundo.entidad("pc").set("direccion actual", direcc);
                Mundo.entidad("bitInterrupcion").set("bitactivo", false);
                int i = 0;
                while (i < lP) {
                    this.ciclo();
                    if (i == lP - 2) {
                        Mundo.entidad("pc").set("direccion actual", pc);
                    }
                    ++i;
                }
                Mundo.writeln(" -- PROGRAMA DE INTERRUPCI\u00d3N EJECUTADO -- ");
            }
        }
        if (Estancia.getHabitacionActual().equals(Mundo.habitacion("ram"))) {
            if (Memoria.memoriaPrograma(dir) && Mundo.entidad("mapa memoria").getPropiedadBoolean("examinado")) {
                Mundo.writeln("Est\u00e1s en zona de programa");
            }
            if (Memoria.memoriaDatos(dir)) {
                if (Mundo.entidad("mapa memoria").getPropiedadBoolean("examinado")) {
                    Mundo.writeln("Est\u00e1s en zona de datos.");
                }
            } else if (Memoria.memoriaLibre(dir) && Mundo.entidad("mapa memoria").getPropiedadBoolean("examinado")) {
                Mundo.writeln("Est\u00e1s en zona de memoria libre.");
            }
        }
        if (Estancia.getHabitacionActual().equals(Mundo.habitacion("bus ES"))) {
            if (Mundo.entidad("rs232").getPropiedadBoolean("conectado")) {
                Mundo.writeln("La alta energ\u00eda procedente del RS232 te aniquila.");
                this.escenaFinal(false, 0);
            } else if (Mundo.entidad("rs485").getPropiedadBoolean("conectado")) {
                Mundo.writeln("La alta energ\u00eda procedente del RS485 te aniquila.");
                this.escenaFinal(false, 0);
            } else if (Mundo.entidad("usb").getPropiedadBoolean("conectado")) {
                Mundo.writeln("El puerto USB te absorbe, junto a la copia de Digitaly, hacia el host madre, liber\u00e1ndote del Universo Digital.");
                this.escenaFinal(true, -1);
            }
        }
    }

    public void ciclo() {
        this.ejecutar(Mundo.entidad("ir").getPropiedadString("instruccion actual"));
        Player.playAudio("ejecuta instruccion.wav");
        String dir_pc_hex = Mundo.entidad("pc").getPropiedadString("direccion actual");
        int dir_pc_dec = Memoria.hex2decimal(dir_pc_hex);
        int dato = ((Ram)Mundo.habitacion("ram")).getDato(dir_pc_hex);
        String aux = Integer.toHexString(dato).toUpperCase();
        while (aux.length() < 4) {
            aux = "0" + aux;
        }
        Mundo.entidad("ir").set("instruccion actual", aux);
        if (++dir_pc_dec > 511) {
            dir_pc_dec = 0;
        }
        aux = Integer.toHexString(dir_pc_dec).toUpperCase();
        while (aux.length() < 3) {
            aux = "0" + aux;
        }
        Mundo.entidad("pc").set("direccion actual", aux);
    }

    public void ejecutar(String in) {
        String cod = in.substring(0, 1);
        if (cod.equals("0")) {
            return;
        }
        String dir = in.substring(1, in.length());
        int dir_dec = Memoria.hex2decimal(dir);
        if (!Memoria.comprobarDireccion(dir_dec)) {
            Mundo.writeColor(" -- EJECUTANDO INSTRUCCI\u00d3N : " + in + " --", Color.red);
            Mundo.writelnColor("\n -- ERROR VIOLACI\u00d3N DE MEMORIA --\n -- DIRECCION: " + dir, Color.RED);
            this.escenaFinal(false, 0);
            return;
        }
        if (!cod.equals("8")) {
            Mundo.writelnColor("\nNotificaci\u00f3n de tu CDL: ", Color.green);
            Mundo.writelnColor(" -- CPU >> Ejecutando instrucci\u00f3n c\u00f3digo de operaci\u00f3n: " + cod + " direcci\u00f3n: " + dir, Color.orange);
            if (this.primer_ciclo) {
                Universo.setItalic(true);
                Mundo.writelnColor(" La CPU de Universo Digital ir\u00e1 ejecutando las instrucciones del programa que est\u00e1 en ejecuci\u00f3n y que se encuentra alojado en memoria principal. Tu equipo CDL te notificar\u00e1 cuando la CPU ejecuta una instrucci\u00f3n as\u00ed como el tipo instrucci\u00f3n que ejecuta.", Color.green);
                Universo.setItalic(false);
                this.primer_ciclo = false;
            }
        }
        String acc = Mundo.entidad("ac").getPropiedadString("dato actual");
        int acc_dec = Memoria.hex2decimal(acc);
        switch (cod) {
            case "1": {
                int dat_aux = ((Ram)Mundo.habitacion("ram")).getDato(dir);
                if (Mundo.entidad("ac").getPropiedadString("dato actual").equals("F4D3")) {
                    Mundo.writeln("Una c\u00f3pia del c\u00f3digo de m\u00e1quina de Digitaly se encontraba en el registro acumulador... una instrucci\u00f3n ha modificado este registro.");
                }
                String aux = Integer.toHexString(dat_aux).toUpperCase();
                while (aux.length() < 4) {
                    aux = "0" + aux;
                }
                Mundo.entidad("ac").set("dato actual", aux);
                if (!Estancia.getHabitacionActual().equals(Mundo.habitacion("ram")) || !Mundo.habitacion("ram").getPropiedadString("direccion actual").equals(dir)) break;
                Mundo.writeln("Est\u00e1s en una direcci\u00f3n cuyo contenido va a ser movido al registro acumulador por la cpu.");
                this.escenaFinal(false, 0);
                break;
            }
            case "2": {
                if (((Ram)Mundo.habitacion("ram")).getDatoHex(dir).equals("F4D3")) {
                    Mundo.writeln("La posici\u00f3n de memoria donde se encontraba una copia del c\u00f3digo digitaly ha sido modificada por la cpu...");
                }
                ((Ram)Mundo.habitacion("ram")).setDato(dir_dec, acc);
                break;
            }
            case "3": {
                if (Estancia.getHabitacionActual().equals(Mundo.habitacion("ram")) && Mundo.habitacion("ram").getPropiedadString("direccion actual").equals(dir)) {
                    Mundo.writeln("Est\u00e1s en una direcci\u00f3n cuyo contenido va a ser movido al bus de entrada salida.");
                }
                if (!((Ram)Mundo.habitacion("ram")).getDatoHex(dir).equals("F4D3")) break;
                Mundo.writeln("Digitaly es trasladado al bus de entrada y salida.");
                Mundo.entidad("digitaly").setEstancia(Mundo.habitacion("bus ES"));
                Mundo.entidad("digitaly").setVisible(true);
                Mundo.entidad("puerta").set("abierta", true);
                break;
            }
            case "4": {
                int dat_aux = ((Ram)Mundo.habitacion("ram")).getDato(dir);
                Mundo.writeln("\n\nRepeticiones " + dat_aux);
                Mundo.writeln("Valor acumulador " + acc_dec);
                int i = 0;
                while (i < dat_aux) {
                    ++acc_dec;
                    ++i;
                }
                Mundo.writeln("Valor acumulador " + acc_dec);
                String aux = Integer.toHexString(acc_dec).toUpperCase();
                while (aux.length() < 4) {
                    aux = "0" + aux;
                }
                Mundo.entidad("ac").set("dato actual", aux);
                break;
            }
            case "5": {
                int dat_aux = ((Ram)Mundo.habitacion("ram")).getDato(dir);
                Mundo.writeln("\n\nRepeticiones " + dat_aux);
                Mundo.writeln("Valor acumulador " + acc_dec);
                int i = 0;
                while (i < dat_aux) {
                    --acc_dec;
                    ++i;
                }
                Mundo.writeln("Valor acumulador " + acc_dec);
                String aux = Integer.toHexString(acc_dec).toUpperCase();
                while (aux.length() < 4) {
                    aux = "0" + aux;
                }
                Mundo.entidad("ac").set("dato actual", aux);
                break;
            }
            case "6": {
                int dat_aux = ((Ram)Mundo.habitacion("ram")).getDato(dir);
                if (Mundo.entidad("ac").getPropiedadString("dato actual").equals("F4D3")) {
                    Mundo.writeln("Digitaly se encontraba en el registro acumulador... una instrucci\u00f3n ha modificado este registro.");
                }
                String aux = Integer.toHexString(acc_dec -= dat_aux).toUpperCase();
                while (aux.length() < 4) {
                    aux = "0" + aux;
                }
                Mundo.entidad("ac").set("dato actual", aux);
                break;
            }
            case "7": {
                int dat_aux = ((Ram)Mundo.habitacion("ram")).getDato(dir);
                if (Mundo.entidad("ac").getPropiedadString("dato actual").equals("F4D3")) {
                    Mundo.writeln("Digitaly se encontraba en el registro acumulador... una instrucci\u00f3n ha modificado este registro.");
                }
                String aux = Integer.toHexString(acc_dec += dat_aux).toUpperCase();
                while (aux.length() < 4) {
                    aux = "0" + aux;
                }
                Mundo.entidad("ac").set("dato actual", aux);
                break;
            }
            case "8": {
                Mundo.entidad("pc").set("direccion actual", dir);
                break;
            }
            default: {
                Mundo.writeColor(" -- EJECUTANDO INSTRUCCI\u00d3N : " + in + " --", Color.red);
                Mundo.writelnColor("\n -- ERROR EJECUTANDO INSTRUCCI\u00d3N -- ", Color.RED);
                this.escenaFinal(false, 0);
            }
        }
    }
}

