/*
 * Decompiled with CFR 0.152.
 */
package Game.Objetos;

import Game.Memoria;
import Universo.Mundo;
import entidad.Entidad;
import java.util.ArrayList;
import objeto.Objeto;
import parser.Orden;
import propiedades.Accion;

public class Pc
extends Objeto {
    public Pc(String nombre) {
        super(nombre);
        this.setEstancia(Mundo.habitacion("cpu"));
        this.setVisible(false);
        this.setEstatico(true);
    }

    @Override
    public void init() {
        this.set("direccion actual", Memoria.getPcHex());
    }

    @Override
    public void descripcion() {
        this.setDescripcion("PC {color%resaltado%registro contador de programa} (12bits). En este registro se aloja la direcci\u00f3n de memoria donde se encuentra la siguiente instrucci\u00f3n a ejecutar por la cpu. Antes de ejecutarse la cpu debe cargar la instrucci\u00f3n que hay en esa direcci\u00f3n de memoria en el registro IN.\nEn el registro PC aparece la direcci\u00f3n {color%resaltado%" + this.getPropiedadString("direccion actual") + "}.");
    }

    @Override
    public void nombreReferencia() {
        this.nuevoNombreDeReferencia("pc", 1);
        this.nuevoNombreDeReferencia("contador", 1);
        this.nuevoNombreDeReferencia("programa", 5);
    }

    @Override
    public void nombreParaMostrar() {
        this.setNombreParaMostrar("registro PC", 1);
    }

    @Override
    public Accion parseCommand(Orden command, ArrayList<Entidad> entitys) {
        if (command.verbo().equals("cargar") || command.verbo().equals("descargar")) {
            Mundo.writeln("No puedes cargar ni descargar nada de/a el registro contador de programa. Eso es tarea exclusiva de la cpu.");
            return Accion.STOP;
        }
        if (command.verbo().equals("descargar")) {
            Mundo.writeln("S\u00f3lo la cpu puede escribir en el registro contador de programa.");
            return Accion.END;
        }
        return super.parseCommand(command, entitys);
    }
}

