/*
 * Decompiled with CFR 0.152.
 */
package Game.Objetos;

import Game.Habitaciones.Ram;
import Game.Memoria;
import Game.Player;
import Universo.Mundo;
import auxiliares.Func;
import entidad.Entidad;
import estancia.Estancia;
import java.awt.Color;
import java.util.ArrayList;
import objeto.Objeto;
import parser.Orden;
import propiedades.Accion;

public class Cdl
extends Objeto {
    String[] programa = new String[3];

    public Cdl(String nombre) {
        super(nombre);
    }

    @Override
    public void init() {
        Mundo.getJugador().anadirObjetoInventario(this);
        this.programa[2] = "----";
        this.programa[1] = "----";
        this.programa[0] = "----";
    }

    @Override
    public void nombreReferencia() {
        this.nuevoNombreDeReferencia("cdl", 1);
        this.nuevoNombreDeReferencia("contenedor", 1);
    }

    @Override
    public void nombreParaMostrar() {
        this.setNombreParaMostrar("CDL", 1);
    }

    @Override
    public void descripcion() {
        String s = "{color%red%Equipo Contenedor de datos digitales.}";
        String s1 = "\nEl equipo CDL es necesario para programar tus propias rutinas en c\u00f3digo m\u00e1quina. Para que se ejecuten tendr\u00e1s que cargarlos en memoria RAM.\nTambi\u00e9n te notificar\u00e1 cada vez que la CPU de Universo Digital ejecute una instrucci\u00f3n, inform\u00e1ndote de la instrucci\u00f3n ejecutada as\u00ed como cualquier informaci\u00f3n adicional que sea relevante tras la ejecuci\u00f3n de la instrucci\u00f3n.";
        String s2 = "\nOpciones disponibles:\n - {color%resaltado%prg CDL :} Mostrar programa cargado en CDL.\n - {color%resaltado%inf CDL :} Mostrar informaci\u00f3n cargada en CDL.\n - {color%resaltado%ins CDL :} Instrucciones para programar el CDL.\n - {color%resaltado%ers CDL :} Eliminar programa cargado en CDL.\n";
        String total = "";
        total = String.valueOf(s) + s1 + s2;
        this.setDescripcion(total);
    }

    @Override
    public Accion parseCommand(Orden orden, ArrayList<Entidad> entitys) {
        int dat_valido = -1;
        Object dir = null;
        String dat = null;
        boolean datoCargado = false;
        String digitaly = "digitaly F4D3";
        if (entitys.size() > 1) {
            return Accion.NEXT;
        }
        if (orden.verbo().equals("prg")) {
            this.programa();
            return Accion.END;
        }
        if (orden.verbo().equals("inf")) {
            this.informacion();
            return Accion.END;
        }
        if (orden.verbo().equals("ins")) {
            this.instrucciones();
            return Accion.END;
        }
        if (orden.verbo().equals("ers")) {
            this.borrarPrograma();
            return Accion.END;
        }
        if (orden.verbo().equals("cargar")) {
            if (Func.textosExactos(orden.cDirecto(), digitaly) || Func.textosExactos(orden.args(), digitaly)) {
                Mundo.writeln("Tu equipo CDL no est\u00e1 dise\u00f1ado para alojar una copia de Digitaly.");
                return Accion.END;
            }
            Mundo.writeln(" -- Cargando en CDL --");
            if (orden.cDirecto().length() > 0 && Mundo.buscarEntidad(orden.cDirecto()) != this && Memoria.comprobarDato(orden.cDirecto())) {
                dat_valido = Memoria.hex2decimal(orden.cDirecto().trim());
                dat = orden.cDirecto();
            } else if (orden.args().length() > 0 && Mundo.buscarEntidad(orden.args()) != this && Memoria.comprobarDato(orden.args())) {
                dat_valido = Memoria.hex2decimal(orden.args().trim());
                dat = orden.args();
            }
            if (dat_valido == -1) {
                Mundo.writelnColor("Instrucci\u00f3n incorrecta. Revisar informaci\u00f3n cargada en CDL.", Color.red);
                Cdl.playAudio("muerte.wav");
                return Accion.END;
            }
            int i = 0;
            while (!datoCargado && i < this.programa.length) {
                if (this.programa[i].equals("----")) {
                    this.programa[i] = dat.trim().toUpperCase();
                    datoCargado = true;
                }
                ++i;
            }
            if (datoCargado) {
                Mundo.writeln("{color%resaltado%Instrucci\u00f3n cargada en CDL.}");
                Cdl.playAudio("escritura en memoria.wav");
            } else {
                Mundo.writelnColor(" -- Error memoria llena, no se carga la instrucci\u00f3n --", Color.red);
                Cdl.playAudio("muerte.wav");
            }
            return Accion.END;
        }
        if (orden.verbo().equals("descargar")) {
            if (!Estancia.getHabitacionActual().equals(Mundo.habitacion("ram"))) {
                Mundo.writeln("El programa cargado en el CDL s\u00f3lo se puede descargar en memoria RAM.");
                return Accion.END;
            }
            if (!this.hayPrograma()) {
                Mundo.writeln(" -- No existe programa cargado en CDL. --");
                return Accion.END;
            }
            int aux = ((Ram)Mundo.habitacion("ram")).setDato(this.secuenciaPrograma());
            if (aux == 1) {
                ((Player)Mundo.getJugador()).escenaFinal(false, 2);
                return Accion.END;
            }
            if (aux == 2) {
                ((Player)Mundo.getJugador()).escenaFinal(false, 3);
                return Accion.END;
            }
            Mundo.writeln("Programa de cargado en memoria.");
            return Accion.END;
        }
        return super.parseCommand(orden, entitys);
    }

    private void programa() {
        if (!this.hayPrograma()) {
            Mundo.writeln(" -- Ning\u00fan programa cargado en CDL -- ");
        } else {
            Mundo.writeln(" Programa cargado: " + this.programa[0] + " " + this.programa[1] + " " + this.programa[2] + " ");
        }
    }

    public int longitudPrograma() {
        int l = 1;
        int i = 0;
        while (i < this.programa.length) {
            if (this.programa[i] != "----") {
                ++l;
            }
            ++i;
        }
        return l;
    }

    private boolean hayPrograma() {
        boolean resultado = false;
        String[] stringArray = this.programa;
        int n = this.programa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != "----") {
                resultado = true;
            }
            ++n2;
        }
        return resultado;
    }

    private void informacion() {
        String s = "{color%red%Informaci\u00f3n adicional cargada por el control externo.}\n";
        String s1 = "Formato de las instrucciones que ejecuta la CPU de Universo Digital:\nCODIGO DE OPERACION (4bits) + DIRECCI\u00d3N DE MEMORIA (12bits)\nC\u00f3digos de operaci\u00f3n:\n- (1h): Cargar el AC desde memoria.\n- (2h): Almacenar el AC en memoria.\n- (3h): Cargar en controlador de E/S desde memoria.\n- (6h): Restar el AC de memoria.\n- (7h): Sumar el AC de memoria.\n";
        Mundo.writeln(String.valueOf(s) + s1);
    }

    private void borrarPrograma() {
        int i = 0;
        while (i < 3) {
            this.programa[i] = "----";
            ++i;
        }
        Mundo.writeln(" -- Programa cargado en CDL eliminado -- ");
    }

    private void instrucciones() {
        String s = "En la informaci\u00f3n cargada en el CDL est\u00e1 el formato de las instrucciones que ejecuta la CPU de Universo Digital.";
        String s1 = "\nLa capacidad de memoria de tu CDL es de 48 bits, lo que se corresponden con 3 instrucciones, seg\u00fan el formato de instrucciones que ejecuta la CPU.";
        String s2 = "\nPara cargar una instrucci\u00f3n en el CDL teclear: \"{color%resaltado%cargar en cdl XXXX}\", siendo XXXX la instrucci\u00f3n que deseas cargar.";
        String s3 = "\nPara descargar el programa creado en el CDL a memoria RAM teclear: \"{color%resaltado%descargar cdl}\". Deber\u00e1s estar dentro de la memoria RAM.\nEl programa se debe descargar en memoria RAM y estando dentro de ella. Ocupar\u00e1 tantas posiciones de memoria como instrucciones v\u00e1lidas ( distintas de \"----\" ) existan,  y a partir de la direcci\u00f3n de memoria RAM donde se descarge.";
        Mundo.writeln(String.valueOf(s) + s1 + s2 + s3);
    }

    private String secuenciaPrograma() {
        return String.valueOf(this.programa[0]) + this.programa[1] + this.programa[2];
    }
}

