/*
 * Decompiled with CFR 0.152.
 */
package Game.Objetos;

import Universo.Mundo;
import entidad.Entidad;
import java.util.ArrayList;
import objeto.Objeto;
import parser.Comando;
import parser.Orden;
import propiedades.Accion;

public class BitInterrupcion
extends Objeto {
    public BitInterrupcion(String nombre) {
        super(nombre);
        this.setEstancia(Mundo.habitacion("interrupciones"));
        this.setVisible(false);
        this.setEstatico(true);
    }

    @Override
    public void init() {
        this.set("bitactivo", false);
    }

    @Override
    public void descripcion() {
        String s = "Bit activaci\u00f3n servicio de interrupci\u00f3n se encuentra ";
        s = this.getPropiedadBoolean("bitactivo") ? String.valueOf(s) + "{color%resaltado%activo}" : String.valueOf(s) + "{color%red%NO activo}";
        s = String.valueOf(s) + "\nEl bit del servicio de interrupci\u00f3n lo puedes {color%resaltado%activar} o " + "{color%resaltado%desactivar}";
        this.setDescripcion(s);
    }

    @Override
    public void nombreReferencia() {
        this.nuevoNombreDeReferencia("bit", 1);
    }

    @Override
    public void nombreParaMostrar() {
        this.setNombreParaMostrar("Bit servicio de interrupci\u00f3n", 1);
    }

    @Override
    public Accion parseCommand(Orden command, ArrayList<Entidad> entitys) {
        if (command.verbo().equals("activar")) {
            if (this.getPropiedadBoolean("bitactivo")) {
                Mundo.writeln("El bit se encuentra activo.");
                return Accion.END;
            }
            Mundo.writeln("Activas el bit del servicio de interrupci\u00f3n.");
            this.set("bitactivo", true);
            BitInterrupcion.playAudio("cambio bit.wav");
            return Accion.END;
        }
        if (command.verbo().equals("desactivar")) {
            if (this.getPropiedadBoolean("bitactivo")) {
                Mundo.writeln("Desactivas el bit del servicio de interrupci\u00f3n.");
                this.set("bitactivo", false);
                BitInterrupcion.playAudio("cambio bit.wav");
                return Accion.END;
            }
            Mundo.writeln("El bit se encuentra NO activo.");
            return Accion.END;
        }
        if (command.getComando() != Comando.LOOK) {
            Mundo.writeln("El bit del servicio de interrupci\u00f3n lo puedes {color%resaltado%ACTIVAR} o {color%resaltado%DESACTIVAR}");
            return Accion.END;
        }
        return super.parseCommand(command, entitys);
    }
}

