/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Universo.Mundo;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.Random;

public class Memoria {
    public static ArrayList<String> memoria;
    private static int inicioMemoriaLibre;
    private static String[] memoriaLibre;
    private static int[] memoriaLibreInt;
    private static String[] memoriaLibreInicial;
    private static String pc;
    private static String pcInicial;
    private static int pcInt;
    private static String in;
    private static String inInicial;
    private static char[] operacion;

    static {
        memoriaLibreInicial = new String[3];
        operacion = new char[]{'1', '2', '6', '7', '3', '4', '5', '0'};
    }

    public static void crearMemoria() {
        memoria = new ArrayList();
        memoriaLibre = new String[3];
        memoriaLibreInt = new int[3];
    }

    public static String getPcHex() {
        return pc;
    }

    public static int _getPcInt() {
        return pcInt;
    }

    public static String getIn() {
        return in;
    }

    public static String[] getMemoriaLibre() {
        return memoriaLibre;
    }

    public static int getInicioMemoriaLibreInt() {
        return inicioMemoriaLibre;
    }

    public static String getInicioMemoriaLibreHex() {
        return Integer.toHexString(inicioMemoriaLibre);
    }

    public static void rellenarMemoria() {
        Random random = new Random();
        int randomInt = 256 + random.nextInt(255);
        int i = 0;
        while (i < 256) {
            memoria.add(Integer.toHexString(randomInt).toUpperCase());
            randomInt = 256 + random.nextInt(255);
            ++i;
        }
        randomInt = random.nextInt(3);
        i = 0;
        while (i < 256) {
            memoria.set(i, String.valueOf(operacion[randomInt]) + memoria.get(i));
            randomInt = random.nextInt(3);
            ++i;
        }
        randomInt = random.nextInt(65535);
        i = 256;
        while (i < 512) {
            memoria.add(Integer.toHexString(randomInt).toUpperCase());
            randomInt = random.nextInt(65535);
            ++i;
        }
    }

    public static boolean memoriaDatos(String direccion) {
        int dir = Memoria.hex2decimal(direccion);
        return Memoria.memoriaDatos(dir);
    }

    public static boolean memoriaDatos(int dir) {
        return !Memoria.memoriaLibre(dir) && dir > 255;
    }

    public static boolean memoriaPrograma(String direccion) {
        int dir = Memoria.hex2decimal(direccion);
        return Memoria.memoriaPrograma(dir);
    }

    public static boolean memoriaPrograma(int dir) {
        return dir > 0 && dir < 256;
    }

    public static boolean memoriaLibre(String direccion) {
        int dir = Memoria.hex2decimal(direccion);
        return Memoria.memoriaLibre(dir);
    }

    public static boolean memoriaLibre(int direccion) {
        boolean esLibre = false;
        int i = 0;
        while (i < 3) {
            if (memoriaLibreInt[i] == direccion) {
                esLibre = true;
            }
            ++i;
        }
        return esLibre;
    }

    public static void crearMemoriaLibre() {
        int randomInt;
        Random random = new Random();
        inicioMemoriaLibre = randomInt = 256 + random.nextInt(250);
        int i = 0;
        while (i < 3) {
            Memoria.memoriaLibre[i] = Integer.toHexString(randomInt).toUpperCase();
            Memoria.memoriaLibreInt[i] = randomInt;
            Memoria.memoriaLibreInicial[i] = memoria.get(randomInt);
            ++randomInt;
            ++i;
        }
    }

    public static void buscarPC() {
        Random randomOp = new Random();
        Random random = new Random();
        int randomInt = random.nextInt(235);
        pc = Integer.toHexString(randomInt).toUpperCase();
        while (pc.length() < 3) {
            pc = "0" + pc;
        }
        pcInicial = pc;
        pcInt = randomInt;
        int randomInt2 = 256 + random.nextInt(235);
        while (randomInt2 > inicioMemoriaLibre - 20 && randomInt2 < inicioMemoriaLibre + 20) {
            randomInt2 = 256 + random.nextInt(235);
        }
        memoria.set(pcInt, String.valueOf('2') + Integer.toHexString(randomInt2++).toUpperCase());
        int op = randomOp.nextInt(3);
        int i = 1;
        while (i < 10) {
            memoria.set(pcInt + i, String.valueOf(operacion[op]) + Integer.toHexString(randomInt2++).toUpperCase());
            op = randomOp.nextInt(3);
            ++i;
        }
    }

    public static void crearIn() {
        Random random = new Random();
        int randomInt = 256 + random.nextInt(235);
        while (randomInt > inicioMemoriaLibre - 20 && randomInt < inicioMemoriaLibre + 20) {
            randomInt = 256 + random.nextInt(235);
        }
        inInicial = in = String.valueOf('7') + Integer.toHexString(randomInt).toUpperCase();
    }

    public static boolean comprobarDireccion(String direccion) {
        if (direccion.length() > 3) {
            return false;
        }
        int decimal = Memoria.hex2decimal(direccion);
        return Memoria.comprobarDireccion(decimal);
    }

    public static boolean comprobarDireccion(int dir) {
        return dir >= 0 && dir <= 511;
    }

    public static boolean comprobarDato(String dato) {
        int decimal;
        if (dato.length() > 4) {
            return false;
        }
        boolean codigoCorrecto = false;
        boolean direccionCorrecta = false;
        char cod = dato.charAt(0);
        char[] cArray = operacion;
        int n = operacion.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == cod) {
                codigoCorrecto = true;
            }
            ++n2;
        }
        if (!codigoCorrecto) {
            Mundo.writelnColor(" -- C\u00f3digo de operaci\u00f3n incorrecto -- ", Color.red);
        }
        if ((decimal = Memoria.hex2decimal(dato.substring(2, dato.length()))) >= 0 && decimal < 4096) {
            direccionCorrecta = true;
        }
        if (!direccionCorrecta) {
            Mundo.writelnColor(" -- Direcci\u00f3n fuera de rango -- ", Color.red);
        }
        return codigoCorrecto && direccionCorrecta;
    }

    public static int hex2decimal(String s) {
        String digits = "0123456789ABCDEF";
        s = s.toUpperCase().trim();
        int val = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            int d = digits.indexOf(c);
            if (d < 0) {
                return -1;
            }
            val = 16 * val + d;
            ++i;
        }
        return val;
    }

    public static void grabar(BufferedWriter out) {
        try {
            out.write("\n");
            for (String unaDireccion : memoria) {
                out.write(String.valueOf(unaDireccion) + "\n");
            }
            out.write("[[REGISTROS]]\n");
            out.write(String.valueOf(pcInicial) + "\n");
            out.write(String.valueOf(inInicial) + "\n");
            int i = 0;
            while (i < 3) {
                out.write(String.valueOf(memoriaLibre[i]) + "\n");
                out.write(String.valueOf(memoriaLibreInicial[i]) + "\n");
                ++i;
            }
        }
        catch (Exception e) {
            Mundo.writeln("-- Error al escribir en fichero -- ");
        }
    }

    public static void load(BufferedReader _in) {
        boolean registros = false;
        try {
            String line = _in.readLine();
            while (line != null) {
                if (line.equals("[[REGISTROS]]")) {
                    registros = true;
                }
                if (!registros) {
                    memoria.add(line);
                } else {
                    pcInicial = pc = (line = _in.readLine());
                    inInicial = in = (line = _in.readLine());
                    line = _in.readLine();
                    int i = 0;
                    while (i < 3) {
                        Memoria.memoriaLibre[i] = line;
                        Memoria.memoriaLibreInt[i] = Memoria.hex2decimal(line.trim());
                        Memoria.memoriaLibreInicial[i] = line = _in.readLine();
                        memoria.set(memoriaLibreInt[i], memoriaLibreInicial[i]);
                        line = _in.readLine();
                        ++i;
                    }
                }
                line = _in.readLine();
            }
        }
        catch (Exception e) {
            Mundo.writeln("-- Error al leer fichero memoria. --");
        }
    }

    public static void test() {
        Mundo.writeln("PC: " + pc);
        Mundo.writeln("Instruccion a la que apunta el pc y sus 10 seguidas:");
        int i = 0;
        while (i < 10) {
            Mundo.writeln(memoria.get(pcInt + i));
            ++i;
        }
        Mundo.writeln("\nIn: " + in);
        Mundo.writeln("Memoria libre: ");
        i = 0;
        while (i < 3) {
            Mundo.writeln(memoriaLibre[i]);
            ++i;
        }
    }
}

