/*
 * Decompiled with CFR 0.152.
 */
package Game.Habitaciones;

import Game.CargadorImagenes;
import Game.Memoria;
import Universo.Mundo;
import auxiliares.Func;
import estancia.Estancia;
import java.awt.Color;
import parser.Comando;
import parser.Orden;
import propiedades.Accion;

public class VectorMemoria2
extends Estancia {
    public VectorMemoria2(String nombre) {
        super(nombre);
    }

    @Override
    public void init() {
    }

    @Override
    public void descripciones() {
        String s = "\n{color%red% >> VECTOR DE MEMORIA DE DIRECCIONES <<}\n";
        String s1 = "\nLa entrada a la {color%resaltado%RAM} est\u00e1 protegida por el vector de memoria. Por este acceso a la ram necesitar\u00e1s cargar una direcci\u00f3n v\u00e1lida en el vector.\nPara cargar una direcci\u00f3n: {color%resaltado%cargar XXX en el vector}, siendo XXX la direcci\u00f3n en hexadecimal a la que quieras acceder.";
        this.setDescripcion(String.valueOf(s) + s1);
        this.imagen(CargadorImagenes.nombreImagen());
        VectorMemoria2.playAudio("cambio room.wav");
    }

    @Override
    public void salidas() {
        this.nuevaSalida("bus", Mundo.habitacion("bus de direcciones"));
        this.nuevaSalida("vector", Mundo.habitacion("vectorMemoria2"));
    }

    @Override
    public boolean antesDeSalir() {
        if (Estancia.getHabitacionSiguiente().equals(Estancia.getHabitacionActual())) {
            Mundo.writeln("Es donde est\u00e1s ahora.");
            return false;
        }
        return super.antesDeSalir();
    }

    @Override
    public void entrar() {
        super.entrar();
    }

    @Override
    public Accion parseCommand(Orden orden) {
        int dir_valida = -1;
        String dir = null;
        String mem = "memoria ram";
        String vector = "vector";
        String bus = "bus";
        if (orden.verbo().equals("ir") && Func.textosExactos(orden.cDirecto(), mem)) {
            Mundo.writeln("Debes cargar en el vector de memoria una direcci\u00f3n v\u00e1lida para poder acceder a la ram.\nPara cargar una direcci\u00f3n: {color%resaltado%cargar XXX en el vector}, siendo XXX la direcci\u00f3n en hexadecimal a la que quieras acceder.");
            return this.end();
        }
        if (orden.getComando() == Comando.LOOK) {
            if (Func.textosExactos(orden.cDirecto(), bus)) {
                Mundo.writeln("Has llegado al vector de direcciones a trav\u00e9s del bus de direcci\u00f3n.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), vector)) {
                Mundo.writeln("Es donde est\u00e1s ahora, en el vector de memoria de datos.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), mem)) {
                Mundo.writeln("Para acceder a la ram debes cargar en el vector de memoria una direcci\u00f3n v\u00e1lida.\nPara cargar una direcci\u00f3n: {color%resaltado%cargar XXX en el vector}, siendo XXX la direcci\u00f3n en hexadecimal a la que quieras acceder.");
                return this.end();
            }
        }
        if (orden.verbo().equals("cargar") && orden.cDyArgs().length() == 0) {
            Mundo.writelnColor("Direcci\u00f3n fuera de rango.", Color.red);
            Mundo.writeln(" -- ERROR EN DIRECCI\u00d3N -- ");
            return Accion.END;
        }
        if (orden.verbo().equals("cargar")) {
            if (orden.cDirecto().length() > 0 && Memoria.comprobarDireccion(orden.cDirecto())) {
                dir_valida = Memoria.hex2decimal(orden.cDirecto());
                dir = orden.cDirecto();
            } else if (orden.args().length() > 0 && Memoria.comprobarDireccion(orden.args())) {
                dir_valida = Memoria.hex2decimal(orden.args());
                dir = orden.args();
            }
            if (dir_valida == -1) {
                Mundo.writelnColor("Direcci\u00f3n fuera de rango.", Color.red);
                Mundo.writeln(" -- ERROR EN DIRECCI\u00d3N -- ");
                return Accion.END;
            }
            Mundo.habitacion("ram").set("direccion actual", dir.trim().toUpperCase());
            this.cambiaDeEstancia(Mundo.habitacion("ram"));
            return Accion.END;
        }
        return super.parseCommand(orden);
    }
}

