/*
 * Decompiled with CFR 0.152.
 */
package Game.Habitaciones;

import Game.CargadorImagenes;
import Universo.Mundo;
import auxiliares.Func;
import estancia.Estancia;
import parser.Comando;
import parser.Orden;
import propiedades.Accion;

public class Cpu
extends Estancia {
    public Cpu(String nombre) {
        super(nombre);
    }

    @Override
    public void init() {
    }

    @Override
    public void descripciones() {
        String s1 = "\n{color%red% >> CPU <<}\n\n";
        String s = "En condiciones normales s\u00f3lo la entrada en la cpu provocar\u00eda tu aniquilaci\u00f3n por las se\u00f1ales de control y el continuo flujo de datos que por aqu\u00ed pasan. Tu control externo ha conseguido ralentizar los ciclos de la cpu, por lo que cada operaci\u00f3n se realiza un mill\u00f3n de veces m\u00e1s lenta que de forma normal lo har\u00eda. Esto te garantiza que no seas desintegrado por una r\u00e1faga de datos que circulan entre la ram y la cpu.\nDentro de la cpu est\u00e1n los registros {color%resaltado%PC}, {color%resaltado%IN} y {color%resaltado%AC}, adem\u00e1s de la sala de activaci\u00f3n del {color%resaltado%servicio de interrupciones} as\u00ed como la zona del {color%resaltado%mapa de memoria}.\nDesde la cpu se accede al {color%resaltado%bus de datos} o al {color%resaltado%bus de direcciones}.";
        this.setDescripcion(String.valueOf(s1) + s);
        this.imagen(CargadorImagenes.nombreImagen());
        Cpu.playAudio("cambio room.wav");
    }

    @Override
    public void salidas() {
        this.nuevaSalida("busdireccion", Mundo.habitacion("bus de direcciones"));
        this.nuevaSalida("busdatos", Mundo.habitacion("bus de datos"));
        this.nuevaSalida("interrupcion", Mundo.habitacion("interrupciones"));
        this.nuevaSalida("interrupciones", Mundo.habitacion("interrupciones"));
        this.nuevaSalida("servicio", Mundo.habitacion("interrupciones"));
        this.nuevaSalida("sala", Mundo.habitacion("interrupciones"));
        this.nuevaSalida("mapa", Mundo.habitacion("mapa de memoria"));
        this.nuevaSalida("zona", Mundo.habitacion("mapa de memoria"));
        this.nuevaSalida("memoria", Mundo.habitacion("mapa de memoria"));
        this.nuevaSalida("cpu", Mundo.habitacion("cpu"));
        this.nuevaSalida("microprocesador", Mundo.habitacion("cpu"));
        this.nuevaSalida("micro", Mundo.habitacion("cpu"));
    }

    @Override
    public void entrar() {
        super.entrar();
    }

    @Override
    public boolean antesDeSalir() {
        if (Estancia.getHabitacionSiguiente().equals(Estancia.getHabitacionActual())) {
            Mundo.writeln("Es donde est\u00e1s ahora.");
            return false;
        }
        return super.antesDeSalir();
    }

    @Override
    public Accion parseCommand(Orden orden) {
        String bus = "bus";
        String cpu = "cpu microprocesador microcontrolador";
        String interrup = "sala interrupciones interrupcion servicio";
        String mem = "zona mapa memoria";
        String senales = "se\u00f1ales se\u00f1al datos dato";
        String direccion = "direccion direcciones";
        String ram = "ram";
        if (orden.getComando() == Comando.LOOK) {
            if (Func.textosExactos(orden.cDirecto(), bus)) {
                Mundo.writeln("Por el bus de datos circulan datos que van y vienen entre la cpu y la memoria. Tambi\u00e9n los datos que son enviados a los dispositivos de entrada/salidas previo paso por el bus de entrada y salida. Por el bus de direcciones las direcciones que van a ser consultadas por la cpu.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), cpu)) {
                Mundo.writeln("El cerebro de esta m\u00e1quina...");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), interrup)) {
                Mundo.writeln("Es una sala de la cpu, puedes {color%resaltado%ir a la sala del servicio de interrupciones}.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), mem)) {
                Mundo.writeln("Es una zona de la cpu, puedes {color%resaltado%ir a la zona del mapa de memoria}.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), senales)) {
                Mundo.writeln("Electrones que fluyen por la cpu...");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), direccion)) {
                Mundo.writeln("Direcciones de memoria donde la cpu ir\u00e1 a buscar un dato o una instrucci\u00f3n.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), ram)) {
                Mundo.writeln("En la memoria Ram se encuentra el programa que est\u00e1 en ejecuci\u00f3n, as\u00ed como los datos que est\u00e1 usando el programa. La ram se comunica con la cpu de datos a traves del bus de datos y del bus de direcciones.");
                return this.end();
            }
            return super.parseCommand(orden);
        }
        return super.parseCommand(orden);
    }
}

