/*
 * Decompiled with CFR 0.152.
 */
package Game.Habitaciones;

import Game.CargadorImagenes;
import Universo.Mundo;
import Universo.Universo;
import auxiliares.Func;
import estancia.Estancia;
import parser.Comando;
import parser.Orden;
import propiedades.Accion;

public class BusDireccion
extends Estancia {
    public BusDireccion(String nombre) {
        super(nombre);
    }

    @Override
    public void init() {
    }

    @Override
    public void descripciones() {
        String s1 = "\n{color%red% << BUS DE DIRECCIONES >>}\n\n";
        String s = "Por el bus de direcciones accedes al {color%resaltado%vector de memoria} y a la {color%resaltado%cpu}.";
        this.setDescripcion(String.valueOf(s1) + s);
        this.imagen(CargadorImagenes.nombreImagen());
        BusDireccion.playAudio("cambio room.wav");
    }

    @Override
    public void salidas() {
        this.nuevaSalida("cpu", Mundo.habitacion("cpu"));
        this.nuevaSalida("microprocesador", Mundo.habitacion("cpu"));
        this.nuevaSalida("micro", Mundo.habitacion("cpu"));
        this.nuevaSalida("bus", Mundo.habitacion("bus de direcciones"));
        this.nuevaSalida("vector", Mundo.habitacion("vectorMemoria2"));
    }

    @Override
    public void entrar() {
        super.entrar();
    }

    @Override
    public boolean antesDeSalir() {
        if (Estancia.getHabitacionSiguiente().equals(Estancia.getHabitacionActual())) {
            Mundo.writeln("Es donde est\u00e1s ahora.");
            return false;
        }
        return super.antesDeSalir();
    }

    @Override
    public Accion parseCommand(Orden orden) {
        String bus = "bus";
        String cpu = "cpu microprocesador microcontrolador";
        String mem = "ram memoria";
        String vector = "vector";
        if (orden.verbo().equals("ir") && Func.textosExactos(orden.cDirecto(), mem)) {
            Universo.getMundo().forceCommandNoEco("ve al vector");
            return this.end();
        }
        if (orden.getComando() == Comando.LOOK) {
            if (Func.textosExactos(orden.cDirecto(), bus)) {
                Mundo.writeln("Por el bus de datos circulan datos que van y vienen entre la cpu y la memoria. Tambi\u00e9n los datos que son enviados a los dispositivos de entrada/salidas previo paso por el bus de entrada y salida. Por el bus de direcciones las direcciones que van a ser consultadas por la cpu.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), cpu)) {
                Mundo.writeln("El cerebro de esta m\u00e1quina...");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), mem)) {
                Mundo.writeln("En la memoria Ram se encuentra el programa que est\u00e1 en ejecuci\u00f3n, as\u00ed como los datos que est\u00e1 usando el programa. La ram se comunica con el bus de direcci\u00f3n a traves del vector de direcciones de la ram.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), vector)) {
                Mundo.writeln("Puedes {color%resaltado%ir al vector de memoria} de direcci\u00f3n.");
                return this.end();
            }
            return super.parseCommand(orden);
        }
        return super.parseCommand(orden);
    }
}

