/*
 * Decompiled with CFR 0.152.
 */
package Game.Habitaciones;

import Game.CargadorImagenes;
import Universo.Mundo;
import Universo.Universo;
import auxiliares.Func;
import estancia.Estancia;
import parser.Comando;
import parser.Orden;
import propiedades.Accion;

public class BusDatos
extends Estancia {
    public BusDatos(String name) {
        super(name);
    }

    @Override
    public void init() {
        this.set("visitado", false);
    }

    @Override
    public void descripciones() {
        String s1 = "\n{color%red% << BUS DE DATOS >>}\n\n";
        String s = !this.getPropiedadBoolean("visitado") ? "Est\u00e1s en el {color%resaltado%bus de datos}, has pasado a trav\u00e9s de la {color%resaltado%puerta triestado} que comunica el {color%resaltado%bus de entrada y salida} con el {color%resaltado%bus de datos} y la {color%resaltado%cpu}. Este bus se extiende desde la {color%resaltado%cpu} hasta el {color%resaltado%vector de memoria de datos}, pasando por la {color%resaltado%puerta triestado} que da acceso al {color%resaltado%bus de entrada y salida}." : "Est\u00e1s en el {color%resaltado%bus de datos}. Este bus se extiende desde la {color%resaltado%cpu} hasta el {color%resaltado%vector de memoria de datos}, pasando por la {color%resaltado%puerta triestado} que da acceso al {color%resaltado%bus de entrada y salida}.";
        this.setDescripcion(String.valueOf(s1) + s);
        this.imagen(CargadorImagenes.nombreImagen());
        BusDatos.playAudio("cambio room.wav");
    }

    @Override
    public void post_descripcion() {
        this.set("visitado", true);
    }

    @Override
    public void salidas() {
        this.nuevaSalida("vector", Mundo.habitacion("vectorMemoria1"));
        this.nuevaSalida("bus", Mundo.habitacion("bus de datos"));
        this.nuevaSalida("cpu", Mundo.habitacion("cpu"));
        this.nuevaSalida("microprocesador", Mundo.habitacion("cpu"));
        this.nuevaSalida("micro", Mundo.habitacion("cpu"));
    }

    @Override
    public void entrar() {
        super.entrar();
    }

    @Override
    public boolean antesDeSalir() {
        if (Estancia.getHabitacionSiguiente().equals(Estancia.getHabitacionActual())) {
            Mundo.writeln("Es donde est\u00e1s ahora.");
            return false;
        }
        return super.antesDeSalir();
    }

    @Override
    public Accion parseCommand(Orden orden) {
        String mem = "memoria ram";
        String busES = "entrada salida";
        String bus = "bus";
        String cpu = "cpu microprocesador microcontrolador micro";
        String vector = "vector";
        String datos = "datos dato";
        if (orden.verbo().equals("ir") && Func.textosExactos(orden.cDirecto(), mem)) {
            Universo.getMundo().forceCommandNoEco("ve al vector");
            return this.end();
        }
        if (orden.verbo().equals("ir") && Func.textosExactos(orden.cDirecto(), busES)) {
            Mundo.writeln("Quiere ir al bus ES");
            if (!Mundo.entidad("puerta").getPropiedadBoolean("abierta")) {
                Mundo.writeln("La puerta triestado comunica el bus de datos y la cpu con el bus de entrada y salida. No puedes pasar por la puerta triestado, solo podr\u00e1s pasar cuando se ejecute la instrucci\u00f3n correspondiente en la CPU.");
                return this.end();
            }
            Estancia.setHabitacionSiguiente(Mundo.habitacion("bus ES"));
            Estancia.getHabitacionActual().cambiaDeEstancia(Mundo.habitacion("bus ES"));
            return this.end();
        }
        if (orden.getComando() == Comando.LOOK) {
            if (Func.textosExactos(orden.cDirecto(), bus)) {
                Mundo.writeln("Por el bus de datos circulan datos que van y vienen entre la cpu y la memoria. Tambi\u00e9n los datos que son enviados a los dispositivos de entrada/salidas previo paso por el bus de entrada y salida.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), cpu)) {
                Mundo.writeln("El cerebro de esta m\u00e1quina... desde aqu\u00ed puedes acceder a la cpu a trav\u00e9s del bus de datos.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), mem)) {
                Mundo.writeln("En la memoria Ram se encuentra el programa que est\u00e1 en ejecuci\u00f3n, as\u00ed como los datos que est\u00e1 usando el programa. La ram se comunica con el bus de datos a trav\u00e9s del vector de salida de la ram.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), vector)) {
                Mundo.writeln("Puedes {color%resaltado%ir al vector de memoria} de datos.");
                return this.end();
            }
            if (Func.textosExactos(orden.cDirecto(), datos)) {
                Mundo.writeln("Electrones que fluyen por el bus de datos.");
                return this.end();
            }
            return super.parseCommand(orden);
        }
        return super.parseCommand(orden);
    }
}

