/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ui.search;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.fife.rsta.ui.EscapableDialog;
import org.fife.rsta.ui.MaxWidthComboBox;
import org.fife.rsta.ui.UIUtil;
import org.fife.rsta.ui.search.RegexAwareComboBox;
import org.fife.rsta.ui.search.SearchDialogSearchContext;

public class AbstractSearchDialog
extends EscapableDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String MATCH_CASE_PROPERTY = "SearchDialog.MatchCase";
    public static final String MATCH_WHOLE_WORD_PROPERTY = "SearchDialog.MatchWholeWord";
    public static final String USE_REG_EX_PROPERTY = "SearchDialog.UseRegularExpressions";
    protected SearchDialogSearchContext context;
    protected JCheckBox caseCheckBox;
    protected JCheckBox wholeWordCheckBox;
    protected JCheckBox regExpCheckBox;
    protected JPanel searchConditionsPanel;
    private static Image contentAssistImage;
    protected JComboBox findTextCombo;
    protected JButton cancelButton;
    private static final ResourceBundle msg;

    public AbstractSearchDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    public AbstractSearchDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("FlipMatchCase")) {
            boolean matchCase = this.caseCheckBox.isSelected();
            this.context.setMatchCase(matchCase);
            this.firePropertyChange(MATCH_CASE_PROPERTY, !matchCase, matchCase);
        } else if (command.equals("FlipWholeWord")) {
            boolean wholeWord = this.wholeWordCheckBox.isSelected();
            this.context.setWholeWord(wholeWord);
            this.firePropertyChange(MATCH_WHOLE_WORD_PROPERTY, !wholeWord, wholeWord);
        } else if (command.equals("FlipRegEx")) {
            boolean useRegEx = this.regExpCheckBox.isSelected();
            this.context.setRegularExpression(useRegEx);
            this.handleRegExCheckBoxClicked();
            this.firePropertyChange(USE_REG_EX_PROPERTY, !useRegEx, useRegEx);
        } else if (command.equals("Cancel")) {
            this.setVisible(false);
        }
    }

    private JCheckBox createCheckBox(ResourceBundle msg, String keyRoot) {
        JCheckBox cb = new JCheckBox(msg.getString(keyRoot));
        cb.setMnemonic((int)msg.getString(keyRoot + "Mnemonic").charAt(0));
        cb.setActionCommand("Flip" + keyRoot);
        cb.addActionListener(this);
        return cb;
    }

    protected MaxWidthComboBox createSearchComboBox(boolean replace) {
        RegexAwareComboBox combo = new RegexAwareComboBox(replace);
        UIUtil.fixComboOrientation(combo);
        return combo;
    }

    protected Border createTitledBorder(String title) {
        if (title != null && title.charAt(title.length() - 1) != ':') {
            title = title + ":";
        }
        return BorderFactory.createTitledBorder(title);
    }

    protected void escapePressed() {
        RegexAwareComboBox racb;
        if (this.findTextCombo instanceof RegexAwareComboBox && (racb = (RegexAwareComboBox)this.findTextCombo).hideAutoCompletePopups()) {
            return;
        }
        super.escapePressed();
    }

    protected void focusFindTextField() {
        JTextComponent textField = AbstractSearchDialog.getTextComponent(this.findTextCombo);
        textField.requestFocusInWindow();
        textField.selectAll();
    }

    protected ResourceBundle getBundle() {
        return msg;
    }

    public final String getCancelButtonText() {
        return this.cancelButton.getText();
    }

    public static Image getContentAssistImage() {
        if (contentAssistImage == null) {
            URL url = AbstractSearchDialog.class.getResource("lightbulb.png");
            try {
                contentAssistImage = ImageIO.read(url);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return contentAssistImage;
    }

    public final String getMatchCaseCheckboxText() {
        return this.caseCheckBox.getText();
    }

    public final String getRegularExpressionCheckboxText() {
        return this.regExpCheckBox.getText();
    }

    public SearchDialogSearchContext getSearchContext() {
        return this.context;
    }

    public String getSearchString() {
        return (String)this.findTextCombo.getSelectedItem();
    }

    public Vector getSearchStrings() {
        int selectedIndex = this.findTextCombo.getSelectedIndex();
        if (selectedIndex == -1) {
            this.findTextCombo.addItem(this.getSearchString());
        } else if (selectedIndex > 0) {
            Object item = this.findTextCombo.getSelectedItem();
            this.findTextCombo.removeItem(item);
            this.findTextCombo.insertItemAt(item, 0);
            this.findTextCombo.setSelectedIndex(0);
        }
        int itemCount = this.findTextCombo.getItemCount();
        Vector vector = new Vector(itemCount);
        for (int i = 0; i < itemCount; ++i) {
            vector.add(this.findTextCombo.getItemAt(i));
        }
        return vector;
    }

    public static String getString(String key) {
        return msg.getString(key);
    }

    protected static JTextComponent getTextComponent(JComboBox combo) {
        return (JTextComponent)combo.getEditor().getEditorComponent();
    }

    public final String getWholeWordCheckboxText() {
        return this.wholeWordCheckBox.getText();
    }

    protected void handleRegExCheckBoxClicked() {
        this.handleToggleButtons();
        boolean b = this.regExpCheckBox.isSelected();
        if (this.findTextCombo instanceof RegexAwareComboBox) {
            RegexAwareComboBox racb = (RegexAwareComboBox)this.findTextCombo;
            racb.setAutoCompleteEnabled(b);
        }
    }

    protected EnableResult handleToggleButtons() {
        JTextComponent tc = AbstractSearchDialog.getTextComponent(this.findTextCombo);
        String text = tc.getText();
        if (text.length() == 0) {
            return new EnableResult(false, null);
        }
        if (this.regExpCheckBox.isSelected()) {
            try {
                Pattern.compile(text);
            }
            catch (PatternSyntaxException pse) {
                return new EnableResult(false, pse.getMessage());
            }
        }
        return new EnableResult(true, null);
    }

    private void init() {
        this.context = new SearchDialogSearchContext();
        this.searchConditionsPanel = new JPanel();
        this.searchConditionsPanel.setLayout(new BoxLayout(this.searchConditionsPanel, 1));
        this.caseCheckBox = this.createCheckBox(msg, "MatchCase");
        this.searchConditionsPanel.add(this.caseCheckBox);
        this.wholeWordCheckBox = this.createCheckBox(msg, "WholeWord");
        this.searchConditionsPanel.add(this.wholeWordCheckBox);
        this.regExpCheckBox = this.createCheckBox(msg, "RegEx");
        this.searchConditionsPanel.add(this.regExpCheckBox);
        this.findTextCombo = this.createSearchComboBox(false);
        this.cancelButton = new JButton(AbstractSearchDialog.getString("Cancel"));
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(this);
    }

    protected static boolean isPreJava6JRE() {
        String version = System.getProperty("java.specification.version");
        return version.startsWith("1.5") || version.startsWith("1.4");
    }

    public static final boolean isWholeWord(CharSequence searchIn, int offset, int len) {
        boolean wsAfter;
        boolean wsBefore;
        try {
            wsBefore = Character.isWhitespace(searchIn.charAt(offset - 1));
        }
        catch (IndexOutOfBoundsException e) {
            wsBefore = true;
        }
        try {
            wsAfter = Character.isWhitespace(searchIn.charAt(offset + len));
        }
        catch (IndexOutOfBoundsException e) {
            wsAfter = true;
        }
        return wsBefore && wsAfter;
    }

    protected void refreshUIFromContext() {
        this.caseCheckBox.setSelected(this.context.getMatchCase());
        this.regExpCheckBox.setSelected(this.context.isRegularExpression());
        this.wholeWordCheckBox.setSelected(this.context.getWholeWord());
    }

    public void requestFocus() {
        super.requestFocus();
        this.focusFindTextField();
    }

    public final void setCancelButtonText(String text) {
        this.cancelButton.setText(text);
    }

    public final void setMatchCaseCheckboxText(String text) {
        this.caseCheckBox.setText(text);
    }

    public final void setRegularExpressionCheckboxText(String text) {
        this.regExpCheckBox.setText(text);
    }

    public void setSearchContext(SearchDialogSearchContext context) {
        this.context = context;
        this.refreshUIFromContext();
    }

    public void setSearchString(String newSearchString) {
        this.findTextCombo.addItem(newSearchString);
        this.findTextCombo.setSelectedIndex(0);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.refreshUIFromContext();
            boolean regexEnabled = this.regExpCheckBox.isSelected();
            if (this.findTextCombo instanceof RegexAwareComboBox) {
                RegexAwareComboBox racb = (RegexAwareComboBox)this.findTextCombo;
                racb.setAutoCompleteEnabled(regexEnabled);
            }
        }
        super.setVisible(visible);
    }

    public final void setWholeWordCheckboxText(String text) {
        this.wholeWordCheckBox.setText(text);
    }

    static {
        msg = ResourceBundle.getBundle("org.fife.rsta.ui.search.Search");
    }

    protected static class EnableResult {
        private boolean enable;
        private String tooltip;

        public EnableResult(boolean enable, String tooltip) {
            this.enable = enable;
            this.tooltip = tooltip;
        }

        public boolean getEnable() {
            return this.enable;
        }

        public String getToolTip() {
            return this.tooltip;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }
    }
}

