/*
 * Decompiled with CFR 0.152.
 */
package bsh.classpath;

import bsh.BshClassManager;
import bsh.ClassPathException;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.TargetError;
import bsh.UtilEvalError;
import bsh.classpath.BshClassLoader;
import bsh.classpath.BshClassPath;
import bsh.classpath.DiscreteFilesClassLoader;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClassManagerImpl
extends BshClassManager {
    static final String BSH_PACKAGE = "bsh";
    private BshClassPath baseClassPath;
    private boolean superImport;
    private BshClassPath fullClassPath;
    private Vector listeners = new Vector();
    private ReferenceQueue refQueue = new ReferenceQueue();
    private BshClassLoader baseLoader;
    private Map loaderMap;

    public ClassManagerImpl() {
        this.reset();
        this.absoluteNonClasses.put(BSH_PACKAGE, BSH_PACKAGE);
        this.absoluteNonClasses.put("java", "java");
        this.absoluteNonClasses.put("lang", "lang");
        this.absoluteClassCache.put("String", String.class);
        this.absoluteClassCache.put("StringBuffer", StringBuffer.class);
        this.absoluteClassCache.put("Integer", Integer.class);
        this.absoluteClassCache.put("Character", Character.class);
        this.absoluteClassCache.put("StringBuffer", StringBuffer.class);
        this.absoluteClassCache.put("Exception", Exception.class);
        this.absoluteClassCache.put("Throwable", Throwable.class);
        this.absoluteClassCache.put("IOException", IOException.class);
        this.absoluteClassCache.put("FileNotFoundException", FileNotFoundException.class);
        this.absoluteClassCache.put("System", System.class);
        this.absoluteClassCache.put("FileInputStream", FileInputStream.class);
        this.absoluteClassCache.put("InputStream", InputStream.class);
        this.absoluteClassCache.put("InputStreamReader", InputStreamReader.class);
        this.absoluteClassCache.put("Object", Object.class);
        this.absoluteClassCache.put("BufferedReader", BufferedReader.class);
        this.absoluteClassCache.put("File", File.class);
        this.absoluteClassCache.put("URL", URL.class);
        this.absoluteClassCache.put("Thread", Thread.class);
        this.absoluteClassCache.put("StringTokenizer", StringTokenizer.class);
        this.absoluteClassCache.put("TargetError", TargetError.class);
        this.absoluteClassCache.put("Vector", Vector.class);
        this.absoluteClassCache.put("Dimension", Dimension.class);
        this.absoluteClassCache.put("Set", Set.class);
        this.absoluteClassCache.put("HashSet", HashSet.class);
        this.absoluteClassCache.put("LinkedHashSet", LinkedHashSet.class);
        try {
            this.absoluteClassCache.put("Entity", Class.forName("eu.irreality.age.Entity"));
            this.absoluteClassCache.put("World", Class.forName("eu.irreality.age.World"));
            this.absoluteClassCache.put("Item", Class.forName("eu.irreality.age.Item"));
            this.absoluteClassCache.put("Mobile", Class.forName("eu.irreality.age.Mobile"));
            this.absoluteClassCache.put("Spell", Class.forName("eu.irreality.age.Spell"));
            this.absoluteClassCache.put("AbstractEntity", Class.forName("eu.irreality.age.AbstractEntity"));
            this.absoluteClassCache.put("Effect", Class.forName("eu.irreality.age.Effect"));
            this.absoluteClassCache.put("Inventory", Class.forName("eu.irreality.age.Inventory"));
            this.absoluteClassCache.put("MobileList", Class.forName("eu.irreality.age.MobileList"));
            this.absoluteClassCache.put("Player", Class.forName("eu.irreality.age.Player"));
            this.absoluteClassCache.put("BSHCodeExecutedOKException", Class.forName("eu.irreality.age.BSHCodeExecutedOKException"));
            this.absoluteClassCache.put("MultimediaInputOutputClient", Class.forName("eu.irreality.age.MultimediaInputOutputClient"));
            this.absoluteClassCache.put("InputOutputClient", Class.forName("eu.irreality.age.InputOutputClient"));
            this.absoluteClassCache.put("Random", Class.forName("java.util.Random"));
            this.absoluteClassCache.put("Debug", Class.forName("eu.irreality.age.debug.Debug"));
            this.absoluteClassCache.put("BshMethod", Class.forName("bsh.BshMethod"));
            this.absoluteClassCache.put("PropertyEntry", Class.forName("eu.irreality.age.PropertyEntry"));
            this.absoluteClassCache.put("ImageConstants", Class.forName("eu.irreality.age.ImageConstants"));
            this.absoluteClassCache.put("ColoredSwingClient", Class.forName("eu.irreality.age.ColoredSwingClient"));
            this.absoluteClassCache.put("AGESoundClient", Class.forName("eu.irreality.age.AGESoundClient"));
            this.absoluteClassCache.put("Messages", Class.forName("eu.irreality.age.messages.Messages"));
            this.absoluteClassCache.put("Weapon", Class.forName("eu.irreality.age.Weapon"));
            this.absoluteClassCache.put("Wearable", Class.forName("eu.irreality.age.Wearable"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public Class classForName(String string) {
        ClassLoader classLoader;
        if (string.equals(BSH_PACKAGE) || string.endsWith(".bsh")) {
            return null;
        }
        if (string.equals("java") || string.endsWith(".java")) {
            return null;
        }
        if (string.equals("lang") || string.endsWith(".lang")) {
            return null;
        }
        if (string.equals("io") || string.endsWith(".io")) {
            return null;
        }
        if (string.equals("util") || string.endsWith(".util")) {
            return null;
        }
        Class<?> clazz = (Class<?>)this.absoluteClassCache.get(string);
        if (clazz != null) {
            return clazz;
        }
        if (this.absoluteNonClasses.get(string) != null) {
            if (Interpreter.DEBUG) {
                Interpreter.debug("absoluteNonClass list hit: " + string);
            }
            return null;
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("Trying to load class: " + string);
        }
        if ((classLoader = this.getLoaderForClass(string)) != null) {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (Exception exception) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw ClassManagerImpl.noClassDefFound(string, noClassDefFoundError);
            }
        }
        if (clazz == null && string.startsWith(BSH_PACKAGE)) {
            try {
                clazz = Interpreter.class.getClassLoader().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null && this.baseLoader != null) {
            try {
                clazz = this.baseLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null && this.externalClassLoader != null) {
            try {
                clazz = this.externalClassLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
                if (classLoader2 != null) {
                    clazz = Class.forName(string, true, classLoader2);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                clazz = this.plainClassForName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = this.loadSourceClass(string);
        }
        this.cacheClassInfo(string, clazz);
        return clazz;
    }

    public URL getResource(String string) {
        URL uRL = null;
        if (this.baseLoader != null) {
            uRL = this.baseLoader.getResource(string.substring(1));
        }
        if (uRL == null) {
            uRL = super.getResource(string);
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (this.baseLoader != null) {
            inputStream = this.baseLoader.getResourceAsStream(string.substring(1));
        }
        if (inputStream == null) {
            inputStream = super.getResourceAsStream(string);
        }
        return inputStream;
    }

    ClassLoader getLoaderForClass(String string) {
        return (ClassLoader)this.loaderMap.get(string);
    }

    public void addClassPath(URL uRL) throws IOException {
        if (this.baseLoader == null) {
            this.setClassPath(new URL[]{uRL});
        } else {
            this.baseLoader.addURL(uRL);
            this.baseClassPath.add(uRL);
            this.classLoaderChanged();
        }
    }

    public void reset() {
        this.baseClassPath = new BshClassPath("baseClassPath");
        this.baseLoader = null;
        this.loaderMap = new HashMap();
        this.classLoaderChanged();
    }

    public void setClassPath(URL[] uRLArray) {
        this.baseClassPath.setPath(uRLArray);
        this.initBaseLoader();
        this.loaderMap = new HashMap();
        this.classLoaderChanged();
    }

    public void reloadAllClasses() throws ClassPathException {
        BshClassPath bshClassPath = new BshClassPath("temp");
        bshClassPath.addComponent(this.baseClassPath);
        bshClassPath.addComponent(BshClassPath.getUserClassPath());
        this.setClassPath(bshClassPath.getPathComponents());
    }

    private void initBaseLoader() {
        this.baseLoader = new BshClassLoader((BshClassManager)this, this.baseClassPath);
    }

    public void reloadClasses(String[] stringArray) throws ClassPathException {
        Object object;
        if (this.baseLoader == null) {
            this.initBaseLoader();
        }
        DiscreteFilesClassLoader.ClassSourceMap classSourceMap = new DiscreteFilesClassLoader.ClassSourceMap();
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            BshClassPath.ClassSource classSource = this.baseClassPath.getClassSource((String)object);
            if (classSource == null) {
                BshClassPath.getUserClassPath().insureInitialized();
                classSource = BshClassPath.getUserClassPath().getClassSource((String)object);
            }
            if (classSource == null) {
                throw new ClassPathException("Nothing known about class: " + (String)object);
            }
            if (classSource instanceof BshClassPath.JarClassSource) {
                throw new ClassPathException("Cannot reload class: " + (String)object + " from source: " + classSource);
            }
            classSourceMap.put((String)object, classSource);
        }
        DiscreteFilesClassLoader discreteFilesClassLoader = new DiscreteFilesClassLoader((BshClassManager)this, classSourceMap);
        object = classSourceMap.keySet().iterator();
        while (object.hasNext()) {
            this.loaderMap.put((String)object.next(), discreteFilesClassLoader);
        }
        this.classLoaderChanged();
    }

    public void reloadPackage(String string) throws ClassPathException {
        Set set = this.baseClassPath.getClassesForPackage(string);
        if (set == null) {
            set = BshClassPath.getUserClassPath().getClassesForPackage(string);
        }
        if (set == null) {
            throw new ClassPathException("No classes found for package: " + string);
        }
        this.reloadClasses(set.toArray(new String[0]));
    }

    public BshClassPath getClassPath() throws ClassPathException {
        if (this.fullClassPath != null) {
            return this.fullClassPath;
        }
        this.fullClassPath = new BshClassPath("BeanShell Full Class Path");
        this.fullClassPath.addComponent(BshClassPath.getUserClassPath());
        try {
            this.fullClassPath.addComponent(BshClassPath.getBootClassPath());
        }
        catch (ClassPathException classPathException) {
            System.err.println("Warning: can't get boot class path");
        }
        this.fullClassPath.addComponent(this.baseClassPath);
        return this.fullClassPath;
    }

    public void doSuperImport() throws UtilEvalError {
        try {
            this.getClassPath().insureInitialized();
            this.getClassNameByUnqName("");
        }
        catch (ClassPathException classPathException) {
            throw new UtilEvalError("Error importing classpath " + classPathException);
        }
        this.superImport = true;
    }

    protected boolean hasSuperImport() {
        return this.superImport;
    }

    public String getClassNameByUnqName(String string) throws ClassPathException {
        return this.getClassPath().getClassNameByUnqName(string);
    }

    public void addListener(BshClassManager.Listener listener) {
        Reference reference;
        this.listeners.addElement(new WeakReference<BshClassManager.Listener>(listener, this.refQueue));
        while ((reference = this.refQueue.poll()) != null) {
            boolean bl = this.listeners.removeElement(reference);
            if (bl || !Interpreter.DEBUG) continue;
            Interpreter.debug("tried to remove non-existent weak ref: " + reference);
        }
    }

    public void removeListener(BshClassManager.Listener listener) {
        throw new Error("unimplemented");
    }

    public ClassLoader getBaseLoader() {
        return this.baseLoader;
    }

    public Class defineClass(String string, byte[] byArray) {
        this.baseClassPath.setClassSource(string, new BshClassPath.GeneratedClassSource(byArray));
        try {
            this.reloadClasses(new String[]{string});
        }
        catch (ClassPathException classPathException) {
            throw new InterpreterError("defineClass: " + classPathException);
        }
        return this.classForName(string);
    }

    protected void classLoaderChanged() {
        this.clearCaches();
        Vector<WeakReference> vector = new Vector<WeakReference>();
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            WeakReference weakReference = (WeakReference)enumeration.nextElement();
            BshClassManager.Listener listener = (BshClassManager.Listener)weakReference.get();
            if (listener == null) {
                vector.add(weakReference);
                continue;
            }
            listener.classLoaderChanged();
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.listeners.removeElement(enumeration.nextElement());
        }
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("Bsh Class Manager Dump: ");
        printWriter.println("----------------------- ");
        printWriter.println("baseLoader = " + this.baseLoader);
        printWriter.println("loaderMap= " + this.loaderMap);
        printWriter.println("----------------------- ");
        printWriter.println("baseClassPath = " + this.baseClassPath);
    }
}

