/*
 * Decompiled with CFR 0.152.
 */
package micromod;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import micromod.DataReader;
import micromod.Instrument;
import micromod.Module;
import micromod.Sequence;

public class ModuleLoader {
    public static boolean identify(DataInput modStream) throws IOException {
        modStream.skipBytes(1080);
        String info = DataReader.readText(modStream, 4);
        System.out.println(" Checking MOD type : " + info);
        try {
            ModuleLoader.getFormatInfo(info);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static Module read(DataInput dataInput) throws IOException, IllegalArgumentException {
        int n;
        String name = DataReader.readText(dataInput, 20);
        Instrument[] instruments = new Instrument[32];
        for (int n2 = 1; n2 < 32; ++n2) {
            instruments[n2] = ModuleLoader.readInstrument(dataInput);
        }
        Sequence sequence = new Sequence();
        sequence.songLengthPatterns = DataReader.readUnsigned7Bit(dataInput);
        sequence.restartPosition = DataReader.readUnsigned7Bit(dataInput);
        sequence.defaultBPM = 125;
        sequence.defaultTempo = 6;
        for (int n3 = 0; n3 < 128; ++n3) {
            sequence.patternOrder[n3] = DataReader.readUnsigned7Bit(dataInput);
            if (sequence.numberOfPatterns >= sequence.patternOrder[n3]) continue;
            sequence.numberOfPatterns = sequence.patternOrder[n3];
        }
        ++sequence.numberOfPatterns;
        String id = DataReader.readText(dataInput, 4);
        ModFormatInfo fInfo = ModuleLoader.getFormatInfo(id);
        sequence.numberOfChannels = fInfo.numChan;
        for (n = 0; n < sequence.numberOfPatterns; ++n) {
            sequence.patterns[n] = ModuleLoader.readPattern(dataInput, sequence.numberOfChannels);
        }
        try {
            for (n = 1; n < 32; ++n) {
                if (instruments[n] == null) continue;
                ModuleLoader.readSampleData(instruments[n], dataInput);
            }
        }
        catch (EOFException e) {
            System.out.println("Warning : Module is truncated!");
        }
        return new Module(name, id, fInfo.supportsPan, fInfo.pal, sequence, instruments);
    }

    protected static ModFormatInfo getFormatInfo(String id) throws IllegalArgumentException {
        ModFormatInfo mfi = new ModFormatInfo();
        if (id.equals("M.K.") || id.equals("M!K!") || id.equals("FLT4") || id.equals("N.T.") || id.equals("M&K!")) {
            mfi.numChan = 4;
            mfi.pal = true;
            mfi.supportsPan = false;
            return mfi;
        }
        if (id.equals("CD81") || id.equals("OKTA") || id.equals("FLT8")) {
            mfi.numChan = 8;
            mfi.pal = true;
            mfi.supportsPan = false;
            return mfi;
        }
        if (id.regionMatches(false, 1, "CHN", 0, 3)) {
            mfi.numChan = Integer.parseInt(id.substring(0, 1));
            mfi.pal = false;
            mfi.supportsPan = true;
            return mfi;
        }
        if (id.regionMatches(false, 0, "TDZ", 0, 3)) {
            mfi.numChan = Integer.parseInt(id.substring(3, 4));
            mfi.pal = false;
            mfi.supportsPan = false;
            return mfi;
        }
        if (id.regionMatches(false, 2, "CH", 0, 2) || id.regionMatches(false, 2, "CN", 0, 2)) {
            mfi.numChan = Integer.parseInt(id.substring(0, 2));
            mfi.pal = false;
            mfi.supportsPan = true;
            return mfi;
        }
        throw new IllegalArgumentException("Module format \"" + id + "\" unrecognised!");
    }

    protected static Sequence.Pattern readPattern(DataInput dataInput, int numChannels) throws IOException {
        Sequence.Pattern patt = new Sequence.Pattern(numChannels);
        for (int m = 0; m < 64; ++m) {
            for (int c = 0; c < numChannels; ++c) {
                int note = DataReader.readInt32(dataInput);
                patt.instrument[m][c] = (note & 0xF000) >> 12 | (note & 0x10000000) >> 24;
                patt.period[m][c] = (note & 0xFFF0000) >> 16;
                patt.effectCommand[m][c] = (note & 0xF00) >> 8;
                if (patt.effectCommand[m][c] == 14) {
                    patt.effectCommand[m][c] = 0xE0 | (note & 0xF0) >> 4;
                    patt.effectValue[m][c] = note & 0xF;
                    continue;
                }
                patt.effectValue[m][c] = note & 0xFF;
                if (patt.effectCommand[m][c] != 13) continue;
                patt.effectValue[m][c] = ModuleLoader.nibbleDecimal2Bin((byte)patt.effectValue[m][c]);
            }
        }
        return patt;
    }

    protected static Instrument readInstrument(DataInput dataInput) throws IOException {
        Instrument inst = new Instrument();
        inst.name = DataReader.readText(dataInput, 22);
        inst.sampleLength = DataReader.readUnsigned16Bit(dataInput) << 1;
        int fineTuneByte = DataReader.readUnsigned8Bit(dataInput) & 0xF;
        inst.fineTune = (fineTuneByte & 7) - (fineTuneByte & 8);
        inst.volume = DataReader.readSigned8Bit(dataInput);
        inst.loopStart = DataReader.readUnsigned16Bit(dataInput) << 1;
        int loopLength = DataReader.readUnsigned16Bit(dataInput) << 1;
        inst.data = new byte[inst.sampleLength + 3];
        inst.looped = true;
        if (inst.loopStart + loopLength > inst.sampleLength) {
            loopLength = inst.sampleLength - inst.loopStart;
        }
        if (inst.loopStart >= inst.sampleLength) {
            loopLength = 0;
        }
        if (loopLength < 3) {
            inst.looped = false;
            inst.loopStart = 0;
            inst.sampleEnd = inst.sampleLength;
        } else {
            inst.sampleEnd = inst.loopStart + loopLength;
        }
        return inst;
    }

    protected static void readSampleData(Instrument instrument, DataInput dataInput) throws IOException {
        if (instrument.sampleEnd > 0) {
            DataReader.readSigned8BitArray(dataInput, instrument.data, 0, instrument.sampleLength);
        }
        instrument.data[0] = 0;
        instrument.data[1] = 0;
    }

    protected static byte nibbleDecimal2Bin(byte decValue) {
        return (byte)(((decValue & 0xF0) >> 4) * 10 + (decValue & 0xF));
    }

    protected static class ModFormatInfo {
        public int numChan;
        public boolean pal;
        public boolean supportsPan;

        protected ModFormatInfo() {
        }
    }
}

