/*
 * Decompiled with CFR 0.152.
 */
package micromod;

import micromod.Channel;
import micromod.Instrument;
import micromod.ProTrackerLFO;

public class Modulator {
    public static final int FX_ARPEGGIO = 0;
    public static final int FX_SLIDEUP = 1;
    public static final int FX_SLIDEDOWN = 2;
    public static final int FX_TONEPORTA = 3;
    public static final int FX_VIBRATO = 4;
    public static final int FX_TONEPORTAVOLSLIDE = 5;
    public static final int FX_VIBRATOVOLSLIDE = 6;
    public static final int FX_TREMOLO = 7;
    public static final int FX_PANNING = 8;
    public static final int FX_SETSAMPLEOFFSET = 9;
    public static final int FX_VOLSLIDE = 10;
    public static final int FX_SETVOLUME = 12;
    public static final int FX_LOWPASS = 224;
    public static final int FX_FINESLIDEUP = 225;
    public static final int FX_FINESLIDEDOWN = 226;
    public static final int FX_SETGLISSANDO = 227;
    public static final int FX_SETVIBRATOWAVE = 228;
    public static final int FX_SETFINETUNE = 229;
    public static final int FX_SETTREMOLOWAVE = 231;
    public static final int FX_EXTPAN = 232;
    public static final int FX_RETRIG = 233;
    public static final int FX_FINEVOLUP = 234;
    public static final int FX_FINEVOLDOWN = 235;
    public static final int FX_NOTECUT = 236;
    public static final int FX_NOTEDELAY = 237;
    public static final int FX_INVERTLOOP = 239;
    protected Channel channel;
    protected boolean supportsPanning;
    protected ProTrackerLFO vibratoLFO;
    protected ProTrackerLFO tremoloLFO;
    protected int currentFXCommand;
    protected int currentFXValue;
    protected int fxSubValue1;
    protected int fxSubValue2;
    protected int currentFXPeriod;
    protected int currentFXCounter;
    protected int tonePortaDestination;
    protected int tonePortaSpeed;
    protected int sampleOffset;
    protected int vibSpeed;
    protected int vibDepth;
    protected int tremSpeed;
    protected int tremDepth;
    protected int[] arpeggio = new int[3];
    protected static int[] sinTable = new int[]{0, 24, 49, 74, 97, 120, 141, 161, 180, 197, 212, 224, 235, 244, 250, 253, 255, 253, 250, 244, 235, 224, 212, 197, 180, 161, 141, 120, 97, 74, 49, 24};
    protected static int[] periodTable = new int[]{856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453, 428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226, 214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113};

    public Modulator(Channel chan, boolean supportsPanning) {
        this.channel = chan;
        this.vibratoLFO = new ProTrackerLFO();
        this.tremoloLFO = new ProTrackerLFO();
        this.supportsPanning = supportsPanning;
    }

    public void reset() {
        this.currentFXPeriod = 0;
        this.currentFXValue = 0;
        this.currentFXCommand = 0;
        this.sampleOffset = 0;
        this.tonePortaSpeed = 0;
        this.tonePortaDestination = 0;
        this.vibDepth = 0;
        this.vibSpeed = 0;
        this.tremDepth = 0;
        this.tremSpeed = 0;
        this.vibratoLFO.reset();
        this.tremoloLFO.reset();
    }

    public void initialiseFX(int fxPeriod, Instrument fxInstrument, int fxCommand, int fxValue) {
        this.currentFXPeriod = fxPeriod;
        this.currentFXCommand = fxCommand;
        this.currentFXValue = fxValue;
        if (fxPeriod != 0) {
            this.tonePortaDestination = fxPeriod;
        }
        if (fxCommand == 3 || fxCommand == 5) {
            this.channel.trigger(fxInstrument, -1);
        } else if (fxCommand == 237) {
            this.channel.trigger(fxInstrument, 0);
        } else {
            this.channel.trigger(fxInstrument, fxPeriod);
        }
        switch (fxCommand) {
            case 0: {
                if (fxValue == 0) break;
                this.initialiseArpeggio();
                break;
            }
            case 3: {
                if (fxValue == 0) break;
                this.tonePortaSpeed = fxValue;
                break;
            }
            case 4: {
                this.initialiseVibrato(fxPeriod != 0);
                break;
            }
            case 5: {
                this.getFXSubValues();
                break;
            }
            case 6: {
                this.getFXSubValues();
                break;
            }
            case 7: {
                this.initialiseTremolo(fxPeriod != 0);
                break;
            }
            case 8: {
                if (!this.supportsPanning) break;
                if (fxValue <= 128) {
                    this.channel.setPanning(128 - fxValue << 9, fxValue << 9);
                    break;
                }
                if (fxValue != 164) break;
                this.channel.setPanning(Short.MIN_VALUE, 32768);
                break;
            }
            case 9: {
                if (this.currentFXValue != 0) {
                    this.sampleOffset = this.currentFXValue;
                }
                this.channel.setSamplePosition(this.sampleOffset << 8);
                break;
            }
            case 10: {
                this.getFXSubValues();
                break;
            }
            case 12: {
                this.channel.setVolume(fxValue, true);
                break;
            }
            case 225: {
                this.channel.setPeriod(this.channel.getPeriod() - (fxValue << 1), true);
                break;
            }
            case 226: {
                this.channel.setPeriod(this.channel.getPeriod() + (fxValue << 1), true);
                break;
            }
            case 228: {
                this.setVibratoWave(fxValue);
                break;
            }
            case 229: {
                this.adjustFineTune();
                break;
            }
            case 231: {
                this.setTremoloWave(fxValue);
                break;
            }
            case 232: {
                if (!this.supportsPanning) break;
                this.channel.setPanning((15 - fxValue) * 4369, fxValue * 4369);
                break;
            }
            case 233: {
                this.currentFXCounter = fxValue;
                break;
            }
            case 236: {
                this.currentFXCounter = fxValue;
                this.updateNoteCut();
                break;
            }
            case 237: {
                this.currentFXCounter = fxValue;
                this.updateNoteDelay();
                break;
            }
            case 234: {
                this.channel.setVolume(this.channel.getVolume() + fxValue, true);
                break;
            }
            case 235: {
                this.channel.setVolume(this.channel.getVolume() - fxValue, true);
            }
        }
    }

    public void updateFX() {
        switch (this.currentFXCommand) {
            case 0: {
                if (this.currentFXValue == 0) break;
                this.updateArpeggio();
                break;
            }
            case 1: {
                this.channel.setPeriod(this.channel.getPeriod() - this.currentFXValue, true);
                break;
            }
            case 2: {
                this.channel.setPeriod(this.channel.getPeriod() + this.currentFXValue, true);
                break;
            }
            case 3: {
                this.updateTonePorta();
                break;
            }
            case 4: {
                this.updateVibrato(false);
                break;
            }
            case 5: {
                this.updateTonePorta();
                this.updateVolSlide();
                break;
            }
            case 6: {
                this.updateVibrato(false);
                this.updateVolSlide();
                break;
            }
            case 7: {
                this.updateTremolo(false);
                break;
            }
            case 10: {
                this.updateVolSlide();
                break;
            }
            case 233: {
                --this.currentFXCounter;
                if (this.currentFXCounter != 0) break;
                this.channel.trigger(null, this.channel.getPeriod());
                this.currentFXCounter = this.currentFXValue;
                break;
            }
            case 236: {
                this.updateNoteCut();
                break;
            }
            case 237: {
                this.updateNoteDelay();
            }
        }
    }

    protected void getFXSubValues() {
        this.fxSubValue1 = (this.currentFXValue & 0xF0) >> 4;
        this.fxSubValue2 = this.currentFXValue & 0xF;
    }

    protected void initialiseArpeggio() {
        this.currentFXCounter = 0;
        int period = this.channel.getPeriod();
        int firstAdd = (this.currentFXValue & 0xF0) >> 4;
        int secondAdd = this.currentFXValue & 0xF;
        for (int n = 0; n < 36; ++n) {
            if (periodTable[n] > period) continue;
            this.arpeggio[0] = periodTable[n];
            if (n + firstAdd > 35) {
                firstAdd = 35 - n;
            }
            if (n + secondAdd > 35) {
                secondAdd = 35 - n;
            }
            this.arpeggio[1] = periodTable[n + firstAdd];
            this.arpeggio[2] = periodTable[n + secondAdd];
            break;
        }
    }

    protected void updateArpeggio() {
        ++this.currentFXCounter;
        if (this.currentFXCounter > 2) {
            this.currentFXCounter = 0;
        }
        this.channel.setPeriod(this.arpeggio[this.currentFXCounter], false);
    }

    protected void updateTonePorta() {
        int source = this.channel.getPeriod();
        if (source == 0) {
            return;
        }
        if (source > this.tonePortaDestination) {
            if ((source -= this.tonePortaSpeed) < this.tonePortaDestination) {
                source = this.tonePortaDestination;
            }
        } else if ((source += this.tonePortaSpeed) > this.tonePortaDestination) {
            source = this.tonePortaDestination;
        }
        this.channel.setPeriod(source, true);
    }

    protected void updateVolSlide() {
        this.channel.setVolume(this.channel.getVolume() + this.fxSubValue1 - this.fxSubValue2, true);
    }

    protected void initialiseVibrato(boolean newNote) {
        this.getFXSubValues();
        if (this.fxSubValue1 != 0) {
            this.vibSpeed = this.fxSubValue1;
        }
        if (this.fxSubValue2 != 0) {
            this.vibDepth = this.fxSubValue2;
        }
        this.updateVibrato(newNote);
    }

    protected void updateVibrato(boolean trig) {
        int pdelta = this.vibratoLFO.update(this.vibSpeed, trig) * this.vibDepth >> 7;
        this.channel.setPeriod(pdelta + this.channel.getPeriod(), false);
    }

    protected void setVibratoWave(int waveform) {
        boolean retrig = true;
        if (waveform > 3) {
            waveform -= 4;
            retrig = false;
        }
        switch (waveform) {
            case 0: {
                this.vibratoLFO.setWaveform(1, retrig);
                break;
            }
            case 1: {
                this.vibratoLFO.setWaveform(3, retrig);
                break;
            }
            case 2: {
                this.vibratoLFO.setWaveform(4, retrig);
                break;
            }
            case 3: {
                this.vibratoLFO.setWaveform(5, retrig);
            }
        }
    }

    protected void initialiseTremolo(boolean newNote) {
        this.getFXSubValues();
        if (this.fxSubValue1 != 0) {
            this.tremSpeed = this.fxSubValue1;
        }
        if (this.fxSubValue2 != 0) {
            this.tremDepth = this.fxSubValue2;
        }
        this.updateTremolo(newNote);
    }

    protected void updateTremolo(boolean trig) {
        int vdelta = this.tremoloLFO.update(this.tremSpeed, trig) * this.tremDepth >> 7;
        this.channel.setVolume(vdelta + this.channel.getVolume(), false);
    }

    protected void setTremoloWave(int waveform) {
        boolean retrig = true;
        if (waveform > 3) {
            waveform -= 4;
            retrig = false;
        }
        switch (waveform) {
            case 0: {
                this.tremoloLFO.setWaveform(1, retrig);
                break;
            }
            case 1: {
                this.tremoloLFO.setWaveform(3, retrig);
                break;
            }
            case 2: {
                this.tremoloLFO.setWaveform(4, retrig);
                break;
            }
            case 3: {
                this.tremoloLFO.setWaveform(5, retrig);
            }
        }
    }

    protected void updateNoteCut() {
        if (this.currentFXCounter == 0) {
            this.channel.setVolume(0, true);
        }
        --this.currentFXCounter;
    }

    protected void updateNoteDelay() {
        if (this.currentFXCounter == 0) {
            this.channel.trigger(null, this.currentFXPeriod);
        }
        --this.currentFXCounter;
    }

    protected void adjustFineTune() {
        int fine = this.currentFXValue < 8 ? this.currentFXValue : -16 + this.currentFXValue;
        this.channel.setFineTune(fine);
    }
}

