/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age.swing.applet;

import eu.irreality.age.ColoredSwingClient;
import eu.irreality.age.GameEngineThread;
import eu.irreality.age.InputOutputClient;
import eu.irreality.age.ObjectCode;
import eu.irreality.age.SwingAetheriaGameLoaderInterface;
import eu.irreality.age.SwingMenuAetheria;
import eu.irreality.age.World;
import eu.irreality.age.debug.Debug;
import eu.irreality.age.filemanagement.WorldLoader;
import eu.irreality.age.windowing.AGEClientWindow;
import eu.irreality.age.windowing.UpdatingRun;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

public class SwingSDIApplet
extends JApplet
implements AGEClientWindow {
    private World mundo;
    private boolean fullScreenMode;
    private InputOutputClient io;
    private JPanel mainPanel;
    private Vector gameLog;
    private Thread loaderThread = null;
    private GameEngineThread maquinaEstados;
    private String moduledir;
    private boolean usarLog;
    private String logFile;
    private String stateFile;
    private Object mundoSemaphore = new Object();
    protected Runnable updateCode = new UpdatingRun(this);
    private String title = "AGE Applet";

    public void setMainPanel(JPanel panel) {
        if (this.mainPanel != null) {
            this.getContentPane().remove(this.mainPanel);
        }
        this.mainPanel = panel;
        this.getContentPane().add(panel);
    }

    public void write(String s) {
        this.io.write(s);
    }

    public static String getVersion() {
        return "Swing Applet AGE client, v0.1";
    }

    public void start() {
        this.setVisible(true);
        this.requestFocus();
        this.requestFocusInWindow();
        this.requestFocus();
        if (this.io != null && this.io instanceof ColoredSwingClient) {
            ((ColoredSwingClient)this.io).refreshFocus();
        }
    }

    private void stopGameSaveAndUnlink() {
        if (this.maquinaEstados != null) {
            this.maquinaEstados.exitNow();
        } else {
            this.saveAndFreeResources();
        }
    }

    public void exitNow() {
        this.write("Para salir de este applet, simplemente cierra la pesta\u00f1a del navegador :)\n");
    }

    public void destroy() {
        this.exitNow();
    }

    public void saveAndFreeResources() {
        this.io.write("\u00a1Hasta la pr\u00f3xima!\n");
        if (this.getClient() instanceof ColoredSwingClient) {
            ((ColoredSwingClient)this.getClient()).uninitClientMenu(this);
            ((ColoredSwingClient)this.getClient()).exit();
        }
        if (this.maquinaEstados != null) {
            this.maquinaEstados.uninitServerMenu(this);
        }
        this.maquinaEstados = null;
        Runtime.getRuntime().gc();
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public void unlinkWorld() {
        this.mundo = null;
    }

    public InputOutputClient getClient() {
        return this.io;
    }

    public World getMundo() {
        return this.mundo;
    }

    public JMenuBar getTheJMenuBar() {
        return this.getJMenuBar();
    }

    public void setTheJMenuBar(JMenuBar jmb) {
        this.setJMenuBar(jmb);
    }

    public SwingSDIApplet() {
        this("AGE Applet");
    }

    public SwingSDIApplet(String title) {
        this.title = title;
        new SwingMenuAetheria(this).addToWindow();
        JMenu menuArchivo = this.getTheJMenuBar().getMenu(0);
        menuArchivo.add((Component)new JSeparator(), 3);
        this.setSize(500, 400);
    }

    public void startGame(String moduledir, boolean usarLog, String logFile, String stateFile) {
        if (this.loaderThread != null) {
            this.stopGameSaveAndUnlink();
        }
        this.moduledir = moduledir;
        this.usarLog = usarLog;
        this.logFile = logFile;
        this.stateFile = stateFile;
        System.out.println("B");
        Thread.currentThread().setPriority(10);
        if (moduledir.equalsIgnoreCase("")) {
            this.setTitle("Aetheria Game Engine. M\u00f3dulo: aetherworld");
        } else {
            this.setTitle("Aetheria Game Engine. M\u00f3dulo: " + moduledir);
        }
        this.setVisible(true);
        this.loaderThread = new LoaderThread();
        this.loaderThread.start();
    }

    public SwingSDIApplet(String moduledir, boolean usarLog, String logFile, String stateFile) {
        this(moduledir);
        this.startGame(moduledir, usarLog, logFile, stateFile);
    }

    public void reinit() {
        if (this.loaderThread != null) {
            this.maquinaEstados.exitNow();
            Thread thr = new Thread(){

                public void run() {
                    SwingSDIApplet.this.loaderThread = new LoaderThread();
                    SwingSDIApplet.this.loaderThread.start();
                    try {
                        SwingSDIApplet.this.loaderThread.join();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
            };
            thr.start();
        }
    }

    public void updateNow() {
        Thread c = new Thread(this.updateCode);
        c.setPriority(10);
        c.start();
    }

    public void guardarLog() {
        this.write("AVISO: Desde el navegador no se pueden guardar partidas. Pero puedes guardar partidas si te descargas el Aetheria Game Engine, que permite jugar a aventuras como \u00e9sta con plena funcionalidad. B\u00e1jalo en http://code.google.com/p/aetheria/downloads/list\n");
    }

    public void guardarEstado() {
        this.write("AVISO: Desde el navegador no se pueden guardar partidas. Pero puedes guardar partidas si te descargas el Aetheria Game Engine, que permite jugar a aventuras como \u00e9sta con plena funcionalidad. B\u00e1jalo en http://code.google.com/p/aetheria/downloads/list\n");
    }

    public void init() {
        System.err.println(this.getClass().getResource("worlds/Vampiro/world.xml"));
        System.err.println(this.getClass().getResource("libinvoke.bsh"));
        SwingAetheriaGameLoaderInterface.loadFont();
        this.startGame(this.getParameter("worldUrl"), this.usarLog, this.logFile, this.stateFile);
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isFullScreenMode() {
        return false;
    }

    public void setFullScreenMode(boolean b) {
    }

    public void setTitle(String s) {
        this.title = s;
    }

    public boolean supportsFullScreen() {
        return false;
    }

    public void repaint() {
        this.validate();
        super.repaint(100L);
    }

    class LoaderThread
    extends Thread {
        LoaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SwingSDIApplet.this.gameLog = new Vector();
            Debug.println("1");
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SwingSDIApplet.this.getContentPane().removeAll();
                        SwingSDIApplet.this.mainPanel = new JPanel();
                        SwingSDIApplet.this.setMainPanel(SwingSDIApplet.this.mainPanel);
                        SwingSDIApplet.this.io = new ColoredSwingClient(SwingSDIApplet.this, SwingSDIApplet.this.gameLog);
                        SwingSDIApplet.this.write("Aetheria Game Engine v 1.0\n");
                        SwingSDIApplet.this.write("\u00a9 1999-2011 Carlos G\u00f3mez (solrac888@yahoo.com)\n");
                        SwingSDIApplet.this.write("V\u00e9ase license.txt para consultar la licencia de AGE y del software de terceros incluido.\n");
                        SwingSDIApplet.this.write("\n=============================================================");
                        SwingSDIApplet.this.write("\n" + SwingSDIApplet.this.io.getColorCode("information") + "Engine-related Version Info:");
                        SwingSDIApplet.this.write("\n" + SwingSDIApplet.this.io.getColorCode("information") + "[OS Layer]           " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + SwingSDIApplet.this.io.getColorCode("reset"));
                        SwingSDIApplet.this.write("\n" + SwingSDIApplet.this.io.getColorCode("information") + "[Java Layer]         " + System.getProperty("java.version") + SwingSDIApplet.this.io.getColorCode("reset"));
                        SwingSDIApplet.this.write("\n" + SwingSDIApplet.this.io.getColorCode("information") + "[Simulation Layer]   " + GameEngineThread.getVersion() + SwingSDIApplet.this.io.getColorCode("reset"));
                        SwingSDIApplet.this.write("\n" + SwingSDIApplet.this.io.getColorCode("information") + "[Object Code Layer]  " + ObjectCode.getInterpreterVersion() + SwingSDIApplet.this.io.getColorCode("reset"));
                        SwingSDIApplet.this.write("\n" + SwingSDIApplet.this.io.getColorCode("information") + "[UI Layer]           " + SwingSDIApplet.getVersion() + SwingSDIApplet.this.io.getColorCode("reset"));
                        SwingSDIApplet.this.write("\n=============================================================\n");
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("2");
            World theWorld = null;
            if (SwingSDIApplet.this.moduledir == null || SwingSDIApplet.this.moduledir.length() == 0) {
                SwingSDIApplet.this.moduledir = "aetherworld";
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SwingSDIApplet.this.repaint();
                        SwingSDIApplet.this.updateNow();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("3");
            theWorld = WorldLoader.loadWorld(SwingSDIApplet.this.moduledir, SwingSDIApplet.this.gameLog, SwingSDIApplet.this.io, SwingSDIApplet.this.mundoSemaphore);
            if (theWorld == null) {
                return;
            }
            SwingSDIApplet.this.mundo = theWorld;
            final World theFinalWorld = theWorld;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SwingSDIApplet.this.updateNow();
                        if (theFinalWorld.getModuleName() != null && theFinalWorld.getModuleName().length() > 0) {
                            SwingSDIApplet.this.setTitle(theFinalWorld.getModuleName());
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Document d = null;
            try {
                d = theWorld.getXMLRepresentation();
                System.out.println("D=null?" + (d == null));
            }
            catch (ParserConfigurationException exc) {
                System.out.println(exc);
            }
            if (SwingSDIApplet.this.stateFile != null) {
                try {
                    theWorld.loadState(SwingSDIApplet.this.stateFile);
                }
                catch (Exception exc) {
                    SwingSDIApplet.this.write("\u00a1No se ha podido cargar el estado!\n");
                    SwingSDIApplet.this.write(exc.toString());
                    exc.printStackTrace();
                }
            }
            if (SwingSDIApplet.this.usarLog) {
                try {
                    theWorld.prepareLog(SwingSDIApplet.this.logFile);
                    theWorld.setRandomNumberSeed(SwingSDIApplet.this.logFile);
                }
                catch (Exception exc) {
                    SwingSDIApplet.this.write("Excepci\u00f3n al leer el fichero de log: " + exc + "\n");
                    exc.printStackTrace();
                    return;
                }
            } else {
                theWorld.setRandomNumberSeed();
            }
            SwingSDIApplet.this.gameLog.addElement(String.valueOf(theWorld.getRandomNumberSeed()));
            SwingSDIApplet.this.setVisible(true);
            SwingSDIApplet.this.mundo = theWorld;
            Object exc = SwingSDIApplet.this.mundoSemaphore;
            synchronized (exc) {
                SwingSDIApplet.this.mundoSemaphore.notifyAll();
            }
            SwingSDIApplet.this.maquinaEstados = new GameEngineThread(theWorld, SwingSDIApplet.this, false);
            System.out.println("STARTING ENGINE THREAD");
            SwingSDIApplet.this.maquinaEstados.start();
            System.out.println("ENGINE THREAD STARTED");
            System.out.println("noSerCliente = false");
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SwingSDIApplet.this.repaint();
                        SwingSDIApplet.this.updateNow();
                        SwingSDIApplet.this.setVisible(false);
                        SwingSDIApplet.this.setVisible(true);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (SwingSDIApplet.this.io instanceof ColoredSwingClient) {
                ((ColoredSwingClient)SwingSDIApplet.this.io).refreshFocus();
            }
        }
    }
}

