/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age.spell;

import eu.irreality.age.spell.Correction;
import eu.irreality.age.spell.SpellingCorrector;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class SimpleReverseCorrector
implements SpellingCorrector {
    private Set distance0 = new LinkedHashSet();
    private Map distance1 = new HashMap();
    private static final char WILDCARD = '?';

    public void init(Collection words) {
        this.distance0 = new LinkedHashSet();
        this.distance1 = new HashMap();
        Iterator iter = words.iterator();
        while (iter.hasNext()) {
            String nextWord = (String)iter.next();
            this.addDictionaryWord(nextWord);
        }
    }

    public void addDictionaryWord(String word) throws UnsupportedOperationException {
        this.distance0.add(word);
        for (int i = 0; i < word.length(); ++i) {
            StringBuffer sb = new StringBuffer(word);
            sb.setCharAt(i, '?');
            this.distance1.put(sb.toString(), word);
            sb.deleteCharAt(i);
            this.distance1.put(sb.toString(), word);
            sb = new StringBuffer(word);
            sb.insert(i, '?');
            this.distance1.put(sb.toString(), word);
            if (i >= word.length() - 1) continue;
            sb = new StringBuffer(word);
            char temp = sb.charAt(i);
            sb.setCharAt(i, sb.charAt(i + 1));
            sb.setCharAt(i + 1, temp);
            this.distance1.put(sb.toString(), word);
        }
        this.distance1.put(word + '?', word);
    }

    public Correction getBestCorrection(String word) {
        if (this.distance0.contains(word)) {
            return new Correction(word, 0.0);
        }
        String attempt = (String)this.distance1.get(word);
        if (attempt != null) {
            return new Correction(attempt, 1.0);
        }
        for (int i = 0; i < word.length(); ++i) {
            StringBuffer sb = new StringBuffer(word);
            sb.setCharAt(i, '?');
            attempt = (String)this.distance1.get(sb.toString());
            if (attempt != null) {
                return new Correction(attempt, 1.0);
            }
            sb = new StringBuffer(word);
            sb.insert(i, '?');
            attempt = (String)this.distance1.get(sb.toString());
            if (attempt == null) continue;
            return new Correction(attempt, 1.0);
        }
        attempt = (String)this.distance1.get(word + '?');
        if (attempt != null) {
            return new Correction(attempt, 1.0);
        }
        return null;
    }

    public static void main(String[] args) {
        SimpleReverseCorrector c = new SimpleReverseCorrector();
        c.addDictionaryWord("casa");
        c.addDictionaryWord("coche");
        System.out.println(c.getBestCorrection("casa"));
        System.out.println(c.getBestCorrection("coche"));
        System.out.println(c.getBestCorrection("cesa"));
        System.out.println(c.getBestCorrection("cocho"));
        System.out.println(c.getBestCorrection("acsa"));
        System.out.println(c.getBestCorrection("casar"));
        System.out.println(c.getBestCorrection("czsa"));
        System.out.println(c.getBestCorrection("czss"));
    }

    public String toString() {
        return "[simple reverse corrector with " + this.distance0.size() + " words , " + this.distance1.size() + " extended forms]";
    }
}

