/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age.messages;

import bsh.TargetError;
import eu.irreality.age.ReturnValue;
import eu.irreality.age.World;
import eu.irreality.age.debug.ExceptionPrinter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Messages {
    private static Messages defaultInstance;
    private Properties properties;
    private Map tempChanged = new HashMap();
    public static String defaultMessagePath;
    private World world = null;

    public void setWorld(World w) {
        this.world = w;
    }

    public Messages(String path) {
        this.properties = new Properties();
        try {
            URL u = this.getClass().getClassLoader().getResource(path);
            InputStream is = u.openStream();
            if (is == null) {
                throw new IOException("Could not read message file " + u);
            }
            this.properties.load(new InputStreamReader(is, "UTF-8"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public Messages(URL u) throws IOException {
        this.properties = new Properties();
        InputStream is = u.openStream();
        if (is == null) {
            throw new IOException("Could not read message file " + u);
        }
        this.properties.load(new InputStreamReader(is, "UTF-8"));
    }

    private String getEntryForKey(String key) {
        String tempChangedEntry = (String)this.tempChanged.get(key);
        if (tempChangedEntry != null) {
            this.tempChanged.remove(key);
            return tempChangedEntry;
        }
        return this.properties.getProperty(key);
    }

    public String getMessage(String key) {
        String mess = this.getEntryForKey(key);
        if (mess == null && this != Messages.getDefaultInstance()) {
            mess = Messages.getDefaultInstance().getMessage(key);
        }
        return mess != null ? mess : "??" + key + "??";
    }

    public String getMessage(String key, Object[] argumentsForScriptCode) {
        String mess;
        if (this.world != null) {
            try {
                ReturnValue retval = new ReturnValue(null);
                this.world.execCode("getMessage", new Object[]{key, argumentsForScriptCode}, retval);
                if (retval.getRetVal() != null) {
                    return (String)retval.getRetVal();
                }
            }
            catch (TargetError bshte) {
                this.world.writeError("bsh.TargetError found at getMessage routine\n");
                this.world.writeError(ExceptionPrinter.getExceptionReport(bshte));
                this.world.writeError(bshte.printTargetError((Throwable)bshte));
            }
        }
        if ((mess = this.getEntryForKey(key)) == null && this != Messages.getDefaultInstance()) {
            mess = Messages.getDefaultInstance().getMessage(key, argumentsForScriptCode);
        }
        return mess != null ? mess : "??" + key + "??";
    }

    public static Messages getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new Messages(defaultMessagePath);
        }
        return defaultInstance;
    }

    public void setMessage(String key, String message) {
        this.properties.setProperty(key, message);
    }

    public void setNextMessage(String key, String message) {
        this.tempChanged.put(key, message);
    }

    public String getMessage(String key, String placeholder, String substitution) {
        return Messages.buildMessage(this.getMessage(key), placeholder, substitution);
    }

    public String getMessage(String key, String p1, String s1, String p2, String s2) {
        return Messages.buildMessage(this.getMessage(key), p1, s1, p2, s2);
    }

    public String getMessage(String key, String placeholder, String substitution, Object[] argumentsForScriptCode) {
        return Messages.buildMessage(this.getMessage(key, argumentsForScriptCode), placeholder, substitution);
    }

    public String getMessage(String key, String p1, String s1, String p2, String s2, Object[] argumentsForScriptCode) {
        return Messages.buildMessage(this.getMessage(key, argumentsForScriptCode), p1, s1, p2, s2);
    }

    public static String buildMessage(String messString, String placeholder, String substitution) {
        return messString.replace(placeholder, substitution);
    }

    public static String buildMessage(String messString, String p1, String s1, String p2, String s2) {
        return Messages.buildMessage(Messages.buildMessage(messString, p1, s1), p2, s2);
    }

    public static String buildMessage(String messString, String p1, String s1, String p2, String s2, String p3, String s3) {
        return Messages.buildMessage(Messages.buildMessage(messString, p1, s1, p2, s2), p3, s3);
    }

    static {
        defaultMessagePath = "lang/messages.lan";
    }
}

