/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.ColoredSwingClient;
import eu.irreality.age.SwingAetheriaGameLoaderInterface;
import eu.irreality.age.XMLtoWorldException;
import eu.irreality.age.debug.Debug;
import eu.irreality.age.filemanagement.URLUtils;
import java.awt.AWTError;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VisualConfiguration {
    private Hashtable colorCodesTable = new Hashtable();
    private Color background;
    private Color foreground;
    private String fontName;
    private float fontSize;
    private String fontFileName;
    private Font laFuente;

    public VisualConfiguration() {
        this.colorCodesTable.put("description", "%00CC00%");
        this.colorCodesTable.put("important", "%FFFF00%");
        this.colorCodesTable.put("information", "%FFFF00%");
        this.colorCodesTable.put("action", "%9999FF%");
        this.colorCodesTable.put("denial", "%CC0000%");
        this.colorCodesTable.put("error", "%FF0000%");
        this.colorCodesTable.put("story", "%FFFFFF%");
        this.colorCodesTable.put("default", "%FFFFFF%");
        this.colorCodesTable.put("input", "%AAAAAA%");
        this.colorCodesTable.put("reset", "% %");
        this.background = Color.black;
        this.foreground = Color.white;
        this.laFuente = SwingAetheriaGameLoaderInterface.font;
    }

    public String getColorCode(String colorType) {
        String code = (String)this.colorCodesTable.get(colorType.toLowerCase());
        if (code == null) {
            return "";
        }
        return code;
    }

    public Enumeration getColorKeys() {
        return this.colorCodesTable.keys();
    }

    public Element getXMLRepresentation(Document doc) {
        Element suElemento = doc.createElement("VisualConfiguration");
        Element colorsElt = doc.createElement("Colors");
        Enumeration en = this.colorCodesTable.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Element eltCol = doc.createElement(Character.toUpperCase(key.charAt(0)) + key.substring(1));
            eltCol.setAttribute("color", this.getColorCode(key));
            colorsElt.appendChild(eltCol);
        }
        Element forCol = doc.createElement("Foreground");
        Element bacCol = doc.createElement("Background");
        forCol.setAttribute("color", ColoredSwingClient.colorToString(this.foreground));
        bacCol.setAttribute("color", ColoredSwingClient.colorToString(this.background));
        colorsElt.appendChild(forCol);
        colorsElt.appendChild(bacCol);
        Element fontElt = doc.createElement("Font");
        if (this.fontName != null) {
            fontElt.setAttribute("name", this.fontName);
            fontElt.setAttribute("size", String.valueOf(this.fontSize));
            if (this.fontFileName != null) {
                fontElt.setAttribute("filename", this.fontFileName);
            }
        }
        suElemento.appendChild(colorsElt);
        if (this.fontName != null) {
            suElemento.appendChild(fontElt);
        }
        return suElemento;
    }

    public VisualConfiguration(Node n, String fontDir) throws XMLtoWorldException {
        this();
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("VisualConfiguration node not Element");
        }
        Element e = (Element)n;
        if (!e.getTagName().equalsIgnoreCase("VisualConfiguration")) {
            throw new XMLtoWorldException("Element not named VisualConfiguration as expected");
        }
        NodeList nl = e.getElementsByTagName("Colors");
        if (nl.getLength() > 0) {
            Color c;
            Element elt1;
            Element el = (Element)nl.item(0);
            NodeList nl1 = el.getElementsByTagName("Description");
            if (nl1.getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                if (elt1.getAttribute("color").charAt(0) == '%') {
                    this.colorCodesTable.put("description", elt1.getAttribute("color"));
                } else {
                    this.colorCodesTable.put("description", "%" + elt1.getAttribute("color") + "%");
                }
            }
            if ((nl1 = el.getElementsByTagName("Important")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                if (elt1.getAttribute("color").charAt(0) == '%') {
                    this.colorCodesTable.put("important", elt1.getAttribute("color"));
                } else {
                    this.colorCodesTable.put("important", "%" + elt1.getAttribute("color") + "%");
                }
            }
            if ((nl1 = el.getElementsByTagName("Action")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                if (elt1.getAttribute("color").charAt(0) == '%') {
                    this.colorCodesTable.put("action", elt1.getAttribute("color"));
                } else {
                    this.colorCodesTable.put("action", "%" + elt1.getAttribute("color") + "%");
                }
            }
            if ((nl1 = el.getElementsByTagName("Information")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                if (elt1.getAttribute("color").charAt(0) == '%') {
                    this.colorCodesTable.put("information", elt1.getAttribute("color"));
                } else {
                    this.colorCodesTable.put("information", "%" + elt1.getAttribute("color") + "%");
                }
            }
            if ((nl1 = el.getElementsByTagName("Denial")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                if (elt1.getAttribute("color").charAt(0) == '%') {
                    this.colorCodesTable.put("denial", elt1.getAttribute("color"));
                } else {
                    this.colorCodesTable.put("denial", "%" + elt1.getAttribute("color") + "%");
                }
            }
            if ((nl1 = el.getElementsByTagName("Error")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                if (elt1.getAttribute("color").charAt(0) == '%') {
                    this.colorCodesTable.put("error", elt1.getAttribute("color"));
                } else {
                    this.colorCodesTable.put("error", "%" + elt1.getAttribute("color") + "%");
                }
            }
            if ((nl1 = el.getElementsByTagName("Story")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                if (elt1.getAttribute("color").charAt(0) == '%') {
                    this.colorCodesTable.put("story", elt1.getAttribute("color"));
                } else {
                    this.colorCodesTable.put("story", "%" + elt1.getAttribute("color") + "%");
                }
            }
            if ((nl1 = el.getElementsByTagName("Default")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                if (elt1.getAttribute("color").charAt(0) == '%') {
                    this.colorCodesTable.put("default", elt1.getAttribute("color"));
                } else {
                    this.colorCodesTable.put("default", "%" + elt1.getAttribute("color") + "%");
                }
            }
            if ((nl1 = el.getElementsByTagName("Input")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                Debug.println("Element:" + elt1);
                if (elt1.hasAttribute("color")) {
                    if (elt1.getAttribute("color").charAt(0) == '%') {
                        this.colorCodesTable.put("input", elt1.getAttribute("color"));
                    } else {
                        this.colorCodesTable.put("input", "%" + elt1.getAttribute("color") + "%");
                    }
                }
                Debug.println("Visconf init with input color" + this.colorCodesTable.get("input"));
            }
            if ((nl1 = el.getElementsByTagName("Foreground")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color") && (c = VisualConfiguration.stringToColor(elt1.getAttribute("color"))) != null) {
                this.foreground = c;
            }
            if ((nl1 = el.getElementsByTagName("Background")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color") && (c = VisualConfiguration.stringToColor(elt1.getAttribute("color"))) != null) {
                this.background = c;
            }
        }
        nl = e.getElementsByTagName("Font");
        boolean usingDefaultFont = true;
        if (nl.getLength() > 0) {
            this.fontName = "Courier New";
            this.fontSize = 12.0f;
            Element el = (Element)nl.item(0);
            if (el.hasAttribute("name")) {
                this.fontName = el.getAttribute("name");
            }
            if (el.hasAttribute("size")) {
                this.fontSize = Float.valueOf(el.getAttribute("size")).floatValue();
            }
            Font[] fuentes = null;
            try {
                fuentes = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            }
            catch (AWTError err) {
                System.err.println("Warning: couldn't get fonts from local graphics environment");
                return;
            }
            for (int f = 0; f < fuentes.length; ++f) {
                if (!fuentes[f].getFontName().equalsIgnoreCase(this.fontName)) continue;
                this.laFuente = fuentes[f].deriveFont(this.fontSize);
                usingDefaultFont = false;
                break;
            }
            if (el.hasAttribute("filename")) {
                try {
                    this.fontFileName = el.getAttribute("filename");
                    Debug.println("Font filename: " + this.fontFileName);
                    Debug.println("Font directory: " + fontDir);
                    String f = fontDir != null ? fontDir + this.fontFileName : this.fontFileName;
                    InputStream is = URLUtils.openFileOrURL(f);
                    Font fuente = Font.createFont(0, is);
                    this.laFuente = fuente.deriveFont(this.fontSize);
                    usingDefaultFont = false;
                }
                catch (Exception ex) {
                    Debug.println(ex);
                }
            }
            if (usingDefaultFont && el.hasAttribute("size") && this.laFuente != null) {
                this.laFuente = this.laFuente.deriveFont(this.fontSize);
            }
        }
    }

    public static Color stringToColor(String colorString) {
        try {
            String colorClean = colorString;
            if (colorClean.charAt(0) == '%') {
                colorClean = colorClean.substring(1, colorClean.length() - 1);
            }
            if (colorClean.length() > 0 && colorClean.charAt(0) == '#') {
                colorClean = colorClean.substring(1);
            }
            int ncolor = Integer.parseInt(colorClean, 16);
            return new Color(ncolor);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public Color getBackgroundColor() {
        return this.background;
    }

    public Color getForegroundColor() {
        return this.foreground;
    }

    public Font getFont() {
        return this.laFuente;
    }
}

