/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.Description;
import eu.irreality.age.StringMethods;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Utility {
    public static final String room_preffix = "10";
    public static final String mobile_preffix = "20";
    public static final String item_preffix = "30";
    public static final String absent_preffix = "40";
    public static final String spell_preffix = "50";
    public static final int room_summand = 10000000;
    public static final int mobile_summand = 20000000;
    public static final int item_summand = 30000000;
    public static final int absent_summand = 40000000;
    public static final int spell_summand = 50000000;

    public static double applyGaussianVariation(double number, Random r, double stdevFactor) {
        return number + r.nextGaussian() * number * stdevFactor;
    }

    public static InputStreamReader getBestInputStreamReader(InputStream is) {
        InputStreamReader isr;
        try {
            isr = new InputStreamReader(is, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            System.out.println("PELIGRO: Codificaci\u00f3n de caracteres ISO-8859-1 no soportada por la VM. Pueden verse mal algunos caracteres.\n");
            isr = new InputStreamReader(is);
        }
        return isr;
    }

    public static OutputStreamWriter getBestOutputStreamWriter(OutputStream os) {
        OutputStreamWriter osw;
        try {
            osw = new OutputStreamWriter(os, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            System.out.println("PELIGRO: Codificaci\u00f3n de caracteres ISO-8859-1 no soportada por la VM. Pueden verse mal algunos caracteres.\n");
            osw = new OutputStreamWriter(os);
        }
        return osw;
    }

    public static int completeRoomID(int ID) {
        return ID > 10000000 ? ID : ID + 10000000;
    }

    public static int completeItemID(int ID) {
        return ID > 30000000 ? ID : ID + 30000000;
    }

    public static int completeMobileID(int ID) {
        return ID > 20000000 ? ID : ID + 20000000;
    }

    public static String completeWithZeroes(int n, int nzeroes) {
        String s = String.valueOf(n);
        while (s.length() < nzeroes) {
            s = "0" + s;
        }
        return s;
    }

    public static String roomFile(World mundo, int n) {
        String s = Utility.completeWithZeroes(n, 6);
        return mundo.getWorldPath() + "objects" + File.separatorChar + room_preffix + s + ".ae";
    }

    public static String itemFile(World mundo, int n) {
        String s = Utility.completeWithZeroes(n, 6);
        return mundo.getWorldPath() + "objects" + File.separatorChar + item_preffix + s + ".ae";
    }

    public static String playerFile(World mundo) {
        return mundo.getWorldPath() + "objects" + File.separatorChar + mobile_preffix + "000000" + ".ae";
    }

    public static String mobFile(World mundo, int n) {
        String s = Utility.completeWithZeroes(n, 6);
        return mundo.getWorldPath() + "objects" + File.separatorChar + mobile_preffix + s + ".ae";
    }

    public static Description[] loadDescriptionListFromString(String linea) {
        if (linea == null) {
            return new Description[0];
        }
        if (linea.indexOf(38) < 0) {
            Description[] theList = new Description[]{new Description(linea, 0L, 0L)};
            return theList;
        }
        Description[] theList = new Description[StringMethods.numToks(linea, '&') / 3];
        int i = 0;
        while (i + 3 <= StringMethods.numToks(linea, '&')) {
            String text = StringMethods.getTok(linea, i + 3, '&');
            long comp = Long.valueOf(StringMethods.getTok(linea, i + 1, '&'));
            long mask = Long.valueOf(StringMethods.getTok(linea, i + 2, '&'));
            theList[i / 3] = new Description(StringMethods.textualSubstitution(text, "\\n", "\n"), comp, mask);
            i += 3;
        }
        return theList;
    }

    public static List loadExtraDescriptionsFromXML(World mundo, Element e, String tagName, boolean nullifyIfNotFound) throws XMLtoWorldException {
        NodeList interestingNodes = e.getElementsByTagName(tagName);
        if (interestingNodes.getLength() > 0) {
            Element interestingNode = (Element)interestingNodes.item(0);
            try {
                return Utility.loadExtraDescriptionsFromXML(mundo, interestingNode);
            }
            catch (XMLtoWorldException ex) {
                throw new XMLtoWorldException("When parsing " + tagName + ": " + ex.getMessage());
            }
        }
        return new ArrayList();
    }

    public static List loadExtraDescriptionsFromXML(World mundo, Element exDesListNode) throws XMLtoWorldException {
        ArrayList laLista = new ArrayList();
        ArrayList<String[]> listaArraysNombres = new ArrayList<String[]>();
        ArrayList<Description[]> listaArraysDescripciones = new ArrayList<Description[]>();
        laLista.add(listaArraysNombres);
        laLista.add(listaArraysDescripciones);
        NodeList exDesNodes = exDesListNode.getElementsByTagName("ExtraDescription");
        if (exDesNodes.getLength() > 0) {
            for (int i = 0; i < exDesNodes.getLength(); ++i) {
                Node hijo;
                Element currentExDes = (Element)exDesNodes.item(i);
                NodeList nameNodes = currentExDes.getElementsByTagName("Name");
                String[] nameArray = new String[nameNodes.getLength()];
                for (int j = 0; j < nameNodes.getLength(); ++j) {
                    hijo = (Element)nameNodes.item(j);
                    Node nieto = hijo.getFirstChild();
                    while (!(nieto instanceof Text)) {
                        nieto = nieto.getNextSibling();
                    }
                    nameArray[j] = nieto.getNodeValue();
                }
                Description[] desArray = Utility.loadDescriptionListFromXML(mundo, currentExDes, "DescriptionList", false);
                if (nameArray.length > 0 && desArray.length > 0) {
                    listaArraysNombres.add(nameArray);
                    listaArraysDescripciones.add(desArray);
                    continue;
                }
                hijo = currentExDes.getFirstChild();
                while (!(hijo instanceof Text) || hijo.getNodeValue().trim().length() == 0) {
                    hijo = hijo.getNextSibling();
                }
                if (hijo == null || nameArray.length <= 0) continue;
                listaArraysNombres.add(nameArray);
                listaArraysDescripciones.add(new Description[]{new Description(hijo.getNodeValue().trim(), 0L, 0L)});
            }
        }
        return laLista;
    }

    public static Description[] loadDescriptionListFromXML(World mundo, Element e, String tagName, boolean nullifyIfNotFound) throws XMLtoWorldException {
        NodeList interestingNodes = e.getElementsByTagName(tagName);
        if (interestingNodes.getLength() > 0) {
            Element interestingNode = (Element)interestingNodes.item(0);
            try {
                return Utility.loadDescriptionListFromXML(mundo, interestingNode);
            }
            catch (XMLtoWorldException ex) {
                throw new XMLtoWorldException("When parsing " + tagName + ": " + ex.getMessage());
            }
        }
        if (nullifyIfNotFound) {
            return null;
        }
        return new Description[0];
    }

    public static Description[] loadDescriptionListFromXML(World mundo, Element descrListNode) throws XMLtoWorldException {
        NodeList descrNodes = descrListNode.getElementsByTagName("Description");
        Description[] ourArray = new Description[descrNodes.getLength()];
        for (int i = 0; i < descrNodes.getLength(); ++i) {
            Element descrNode = (Element)descrNodes.item(i);
            try {
                ourArray[i] = new Description(mundo, descrNode);
                continue;
            }
            catch (XMLtoWorldException xe) {
                throw new XMLtoWorldException("Error at description: " + xe.getMessage());
            }
        }
        return ourArray;
    }

    private static String loadNameListFromXML(World mundo, Element namesNode) throws XMLtoWorldException {
        NodeList nameNodes = namesNode.getElementsByTagName("Name");
        String ourString = "";
        for (int i = 0; i < nameNodes.getLength(); ++i) {
            Element nameNode = (Element)nameNodes.item(i);
            Node hijo = nameNode.getFirstChild();
            while (!(hijo instanceof Text)) {
                hijo = hijo.getNextSibling();
            }
            ourString = ourString + hijo.getNodeValue();
            if (i >= nameNodes.getLength() - 1) continue;
            ourString = ourString + "$";
        }
        return ourString;
    }

    public static String loadNameListFromXML(World mundo, Element e, String tagName, boolean nullifyIfNotFound) throws XMLtoWorldException {
        NodeList singRefNamesNodes = e.getElementsByTagName(tagName);
        if (singRefNamesNodes.getLength() > 0) {
            Element singRefNamesNode = (Element)singRefNamesNodes.item(0);
            return Utility.loadNameListFromXML(mundo, singRefNamesNode);
        }
        if (nullifyIfNotFound) {
            return null;
        }
        return "";
    }

    public static String loadExtraDescriptionsFromXML(Element e, String tagName, boolean nullifyIfNotFound) throws XMLtoWorldException {
        NodeList extraDesListNodes = e.getElementsByTagName(tagName);
        if (extraDesListNodes.getLength() > 0) {
            Element theExtraDescriptionListNode = (Element)extraDesListNodes.item(0);
            return Utility.loadExtraDescriptionsFromXML(theExtraDescriptionListNode);
        }
        if (nullifyIfNotFound) {
            return null;
        }
        return "";
    }

    private static String loadExtraDescriptionsFromXML(Element extraDesElement) throws XMLtoWorldException {
        String extraDescriptions = "";
        NodeList extraDesNodes = extraDesElement.getElementsByTagName("ExtraDescription");
        for (int i = 0; i < extraDesNodes.getLength(); ++i) {
            Element extraDesNode = (Element)extraDesNodes.item(i);
            Node hijo = extraDesNode.getFirstChild();
            while (!(hijo instanceof Text)) {
                if (((Element)hijo).getTagName().equalsIgnoreCase("Name")) {
                    Node nieto = hijo.getFirstChild();
                    while (!(nieto instanceof Text)) {
                        nieto = nieto.getNextSibling();
                    }
                    extraDescriptions = extraDescriptions + nieto.getNodeValue();
                    extraDescriptions = extraDescriptions + "$";
                }
                hijo = hijo.getNextSibling();
            }
            extraDescriptions = extraDescriptions + hijo.getNodeValue();
            if (i >= extraDesNodes.getLength() - 1) continue;
            extraDescriptions = extraDescriptions + "@";
        }
        return extraDescriptions;
    }
}

