/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.ColoredSwingClient;
import eu.irreality.age.swing.FancyJTextField;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.SwingUtilities;

class SwingEditBoxListener
implements ActionListener,
KeyListener {
    FancyJTextField elCampoJTexto;
    ColoredSwingClient cl;
    Vector gameLog;
    boolean press_any_key = false;
    int ncommands = 0;
    private boolean consumeKeyEvents = false;
    private boolean inTransitoryState = false;

    public void countCommand() {
        ++this.ncommands;
    }

    public SwingEditBoxListener(FancyJTextField nCampoJTexto, Vector gameLog, ColoredSwingClient cl) {
        this.elCampoJTexto = nCampoJTexto;
        this.gameLog = gameLog;
        this.cl = cl;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.inTransitoryState) {
            return;
        }
        if (!this.press_any_key) {
            if (this.cl.isMemoryEnabled()) {
                this.cl.addToBackStack(this.elCampoJTexto.getText().trim());
                this.cl.forwardStackIntoBackStack();
                this.cl.addToBackStack(this.elCampoJTexto.getText().trim());
            }
            this.cl.write("\n");
            this.countCommand();
            if (this.cl.isEchoEnabled()) {
                this.cl.write(this.cl.getColorCode("input") + this.cl.getEchoText() + this.elCampoJTexto.getText().trim() + this.cl.getColorCode("reset") + "\n");
            }
            this.cl.writeTitle(this.ncommands + " comando" + (this.ncommands == 1 ? "" : "s"), 2);
            this.cl.setInputString(this.elCampoJTexto.getText());
            this.gameLog.addElement(this.elCampoJTexto.getText());
            this.elCampoJTexto.setText("");
        } else {
            this.setPressAnyKeyState(false);
            this.cl.setInputString(null);
        }
    }

    private static boolean isPageUpDownEvent(KeyEvent e) {
        return e.getKeyCode() == 33 || e.getKeyCode() == 34;
    }

    private void redirectToTextArea(KeyEvent e) {
        this.cl.getTextArea().dispatchEvent(e);
    }

    public void keyTyped(KeyEvent e) {
        if (SwingEditBoxListener.isPageUpDownEvent(e)) {
            this.redirectToTextArea(e);
        }
        if (this.press_any_key || this.consumeKeyEvents) {
            e.consume();
        }
    }

    public void keyReleased(KeyEvent e) {
        if (SwingEditBoxListener.isPageUpDownEvent(e)) {
            this.redirectToTextArea(e);
        }
        if (this.press_any_key || this.consumeKeyEvents) {
            e.consume();
            this.consumeKeyEvents = false;
        }
    }

    public boolean isModifierKey(KeyEvent e) {
        return e.getKeyCode() == 18 || e.getKeyCode() == 17 || e.getKeyCode() == 16 || e.getKeyCode() == 157 || e.getKeyCode() == 65406 || e.getKeyCode() == 19 || e.getKeyCode() == 154;
    }

    public void keyPressed(KeyEvent e) {
        if (SwingEditBoxListener.isPageUpDownEvent(e)) {
            this.redirectToTextArea(e);
            return;
        }
        if (this.isModifierKey(e)) {
            return;
        }
        if (this.press_any_key) {
            if (e.getKeyCode() != 10) {
                this.setPressAnyKeyState(false);
                this.cl.setInputString(null);
                e.consume();
                this.consumeKeyEvents = true;
            }
        } else if (this.cl.isMemoryEnabled()) {
            if (e.getKeyCode() == 38) {
                this.cl.goBack();
            } else if (e.getKeyCode() == 40) {
                this.cl.goForward();
            }
        }
    }

    public void setPressAnyKeyState(final boolean value) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetPressAnyKeyState(value);
        } else {
            try {
                this.inTransitoryState = true;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SwingEditBoxListener.this.doSetPressAnyKeyState(value);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void doSetPressAnyKeyState(boolean value) {
        this.press_any_key = value;
        if (value) {
            System.out.println("Setting PAK");
            this.elCampoJTexto.setForeground(Color.black);
            System.out.println("Setting PAK 1");
            this.elCampoJTexto.setPromptsEnabled(false);
            this.elCampoJTexto.setText(this.cl.getKeyRequestText());
            System.out.println("Setting PAK 2");
            this.elCampoJTexto.setEditable(false);
            this.elCampoJTexto.getCaret().setVisible(false);
            System.out.println("Setting PAK 3");
            this.elCampoJTexto.grabFocus();
            System.out.println("Set PAK");
        } else {
            System.out.println("Setting UNPAK 1");
            this.elCampoJTexto.setPromptsEnabled(true);
            this.elCampoJTexto.setText("");
            System.out.println("Setting UNPAK 2");
            this.elCampoJTexto.setEditable(true);
            this.elCampoJTexto.getCaret().setVisible(true);
            System.out.println("Setting UNPAK 3");
            this.elCampoJTexto.setForeground(Color.red);
        }
        this.inTransitoryState = false;
    }
}

