/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.StringMethods;
import eu.irreality.age.SwingAetheriaGameLoader;
import eu.irreality.age.Utility;
import eu.irreality.age.filemanagement.Paths;
import eu.irreality.age.swing.mdi.SwingAetheriaGUI;
import eu.irreality.age.swing.sdi.SwingSDIInterface;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.UIManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class SwingAetheriaGameLoaderInterface {
    public static Font font;

    public static void loadFont() {
        String fontName = "Courier New";
        int fontSize = 12;
        try {
            BufferedReader iniReader = new BufferedReader(Utility.getBestInputStreamReader(new FileInputStream("age.cfg")));
            for (int line = 1; line < 100; ++line) {
                String linea = iniReader.readLine();
                if (linea == null) continue;
                System.out.println("Linea " + linea);
                String codigo = StringMethods.getTok(linea, 1, '=').trim().toLowerCase();
                if (codigo.equals("font name")) {
                    System.out.println("Nombre: " + StringMethods.getTok(linea, 2, '=').trim());
                    fontName = StringMethods.getTok(linea, 2, '=').trim();
                    continue;
                }
                if (!codigo.equals("font size")) continue;
                fontSize = Integer.parseInt(StringMethods.getTok(linea, 2, '=').trim());
            }
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (NumberFormatException nfe) {
        }
        catch (IOException ioe) {
        }
        catch (SecurityException se) {
            // empty catch block
        }
        Font[] fuentes = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int f = 0; f < fuentes.length; ++f) {
            if (!fuentes[f].getFontName().equalsIgnoreCase(fontName)) continue;
            font = fuentes[f].deriveFont((float)fontSize);
            break;
        }
        if (font == null) {
            Object[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            Arrays.sort(fonts);
            if (Arrays.binarySearch(fonts, "Courier New") >= 0) {
                font = new Font("Courier New", 0, 12);
            } else if (Arrays.binarySearch(fonts, "Courier") >= 0) {
                font = new Font("Courier", 0, 12);
            } else if (Arrays.binarySearch(fonts, "Monospaced") >= 0) {
                font = new Font("Monospaced", 0, 13);
            }
        }
        if (font == null) {
            font = fuentes[0].deriveFont((float)fontSize);
        }
    }

    public static void setStandalone(boolean standalone) {
        if (standalone) {
            SwingAetheriaGUI.getInstance().setDefaultCloseOperation(3);
            SwingAetheriaGUI.getInstance().removeWindowListener(SwingAetheriaGUI.nonStandaloneWindowListener);
            SwingAetheriaGUI.getInstance().addWindowListener(SwingAetheriaGUI.standaloneWindowListener);
        } else {
            SwingAetheriaGUI.getInstance().setDefaultCloseOperation(1);
            SwingAetheriaGUI.getInstance().removeWindowListener(SwingAetheriaGUI.standaloneWindowListener);
            SwingAetheriaGUI.getInstance().addWindowListener(SwingAetheriaGUI.nonStandaloneWindowListener);
        }
    }

    public static void showIfAlreadyOpen() {
        if (SwingAetheriaGUI.getInstance() != null) {
            System.err.println("Showing previous instance...");
            SwingAetheriaGUI.getInstance().setVisible(true);
            System.err.flush();
        }
    }

    public static void setLookAndFeel() {
        try {
            boolean setLAF = true;
            setLAF = false;
            if (UIManager.getSystemLookAndFeelClassName().indexOf("gtk") >= 0) {
                String javaVersion = System.getProperty("java.version");
                StringTokenizer st = new StringTokenizer(javaVersion, ".-_");
                try {
                    int firstNum = Integer.valueOf(st.nextToken());
                    int secondNum = Integer.valueOf(st.nextToken());
                    setLAF = false;
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
            if (setLAF) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception ulafe) {
            ulafe.printStackTrace();
        }
    }

    public static void main(String[] args) {
        block16: {
            if (args.length > 0) {
                Option sdi = new Option("sdi", "use single-document interface");
                OptionBuilder.withArgName((String)"file");
                OptionBuilder.hasArg();
                OptionBuilder.withDescription((String)"The world file or URL to play");
                Option worldFile = OptionBuilder.create((String)"worldfile");
                OptionBuilder.withArgName((String)"file");
                OptionBuilder.hasArg();
                OptionBuilder.withDescription((String)"Log file to load the game from (requires a world file)");
                Option logFile = OptionBuilder.create((String)"logfile");
                OptionBuilder.withArgName((String)"file");
                OptionBuilder.hasArg();
                OptionBuilder.withDescription((String)"State file to load the game from (requires a world file)");
                Option stateFile = OptionBuilder.create((String)"statefile");
                OptionBuilder.withArgName((String)"errorlog");
                OptionBuilder.hasArg();
                OptionBuilder.withDescription((String)"A file to append the error output to");
                Option errorLog = OptionBuilder.create((String)"errorlog");
                OptionBuilder.withArgName((String)"pathToDir");
                OptionBuilder.hasArg();
                OptionBuilder.withDescription((String)"Path to the directory where saves will be stored by default");
                Option saveDir = OptionBuilder.create((String)"savedir");
                Options options = new Options();
                options.addOption(sdi);
                options.addOption(worldFile);
                options.addOption(logFile);
                options.addOption(stateFile);
                options.addOption(errorLog);
                options.addOption(saveDir);
                GnuParser parser = new GnuParser();
                try {
                    CommandLine line = parser.parse(options, args);
                    String desiredWorldFile = null;
                    String desiredLogFile = null;
                    String desiredStateFile = null;
                    String errorLogFile = null;
                    String saveDirPath = null;
                    if (line.hasOption("errorlog")) {
                        errorLogFile = line.getOptionValue("errorlog");
                    }
                    if (line.hasOption("statefile")) {
                        desiredStateFile = line.getOptionValue("statefile");
                    }
                    if (line.hasOption("logfile")) {
                        desiredLogFile = line.getOptionValue("logfile");
                    }
                    if (line.hasOption("worldfile")) {
                        desiredWorldFile = line.getOptionValue("worldfile");
                    }
                    if (line.hasOption("savedir")) {
                        saveDirPath = line.getOptionValue("savedir");
                    }
                    if (errorLogFile != null) {
                        SwingAetheriaGameLoaderInterface.redirectStandardError(errorLogFile);
                    }
                    if (saveDirPath != null) {
                        Paths.setSaveDir(saveDirPath);
                    }
                    if (desiredWorldFile == null && line.getArgs().length > 0) {
                        desiredWorldFile = line.getArgs()[0];
                    }
                    boolean desiredSdi = line.hasOption("sdi");
                    if (SwingAetheriaGUI.getInstance() != null && !desiredSdi) {
                        System.out.println("Opening file in existing instance...");
                        SwingAetheriaGameLoaderInterface.createLocalGameFromFile(desiredWorldFile, true, desiredLogFile != null, desiredLogFile, desiredStateFile);
                        return;
                    }
                    System.out.println("Working directory: " + Paths.getWorkingDirectory());
                    SwingAetheriaGameLoaderInterface.setLookAndFeel();
                    if (!desiredSdi) {
                        new SwingAetheriaGUI();
                        if (desiredWorldFile != null) {
                            SwingAetheriaGameLoaderInterface.createLocalGameFromFile(desiredWorldFile, !desiredSdi, desiredLogFile != null, desiredLogFile, desiredStateFile);
                        }
                        break block16;
                    }
                    if (desiredWorldFile != null) {
                        SwingAetheriaGameLoaderInterface.createLocalGameFromFile(desiredWorldFile, !desiredSdi, desiredLogFile != null, desiredLogFile, desiredStateFile);
                        break block16;
                    }
                    SwingSDIInterface.main(args);
                }
                catch (ParseException exp) {
                    System.err.println("Parsing failed.  Reason: " + exp.getMessage());
                }
            } else {
                SwingAetheriaGameLoaderInterface.setLookAndFeel();
                new SwingAetheriaGUI();
            }
        }
    }

    public static void redirectStandardError(String file) {
        File f = new File(file);
        if (!(f.exists() || f.getParentFile().exists() || f.getParentFile().mkdirs())) {
            System.err.println("Could not redirect standard error to " + file + ": unable to create directories.");
            return;
        }
        try {
            System.setErr(new PrintStream(new FileOutputStream(f, true)));
            System.err.println("[" + new Date() + "]");
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not redirect standard error to " + file + ":");
            e.printStackTrace();
        }
    }

    public static void createLocalGameFromFile(String file) {
        SwingAetheriaGameLoaderInterface.createLocalGameFromFile(file, true);
    }

    public static void createLocalGameFromFile(String file, boolean mdi) {
        if (mdi) {
            new SwingAetheriaGameLoader(file, SwingAetheriaGUI.getInstance().getPanel(), false, null, null, false);
        } else {
            new SwingSDIInterface(file, false, null, null);
        }
    }

    public static void createLocalGameFromFile(String file, boolean mdi, boolean usarLog, String logFile, String stateFile) {
        if (mdi) {
            new SwingAetheriaGameLoader(file, SwingAetheriaGUI.getInstance().getPanel(), usarLog, logFile, stateFile, false);
        } else {
            SwingAetheriaGameLoaderInterface.loadFont();
            new SwingSDIInterface(file, usarLog, logFile, stateFile);
        }
    }
}

