/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.AddGameWindow;
import eu.irreality.age.AddIrcNetworkWindow;
import eu.irreality.age.PartidaEntry;
import eu.irreality.age.server.IrcServerEntry;
import eu.irreality.age.server.ServerConfigurationOptions;
import eu.irreality.age.server.ServerHandler;
import eu.irreality.age.swing.mdi.SwingAetheriaGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ServerConfigurationWindow
extends JDialog {
    public static File configurationFile = new File("server.opt");
    private JCheckBox cbTel = new JCheckBox("Servir por Telnet, puerto:");
    private JCheckBox cbAge = new JCheckBox("Servir por AGE, puerto:");
    private JCheckBox cbIrc = new JCheckBox("Servir por IRC");
    private JCheckBox cbInitOnOK = new JCheckBox("Arrancar las partidas dedicadas al pulsar Aceptar");
    private JCheckBox cbInitOnStartup = new JCheckBox("Arrancar las partidas dedicadas al iniciar AGE");
    private JTextField tfTPort = new JTextField("8010");
    private JTextField tfAPort = new JTextField("8009");
    private DefaultListModel ircServerVector = new DefaultListModel();
    private JList ircServerList = new JList(this.ircServerVector);
    private JButton islAdd = new JButton("Agregar...");
    private JButton islRemove = new JButton("Quitar");
    private JButton islConfig = new JButton("Configurar");
    private DefaultListModel gameVector = new DefaultListModel();
    private JList gameList = new JList(this.gameVector);
    private JButton gameAdd = new JButton("Agregar...");
    private JButton gameRemove = new JButton("Quitar");
    private JButton gameConfig = new JButton("Configurar");
    private JButton botonAceptar = new JButton("Aceptar");
    private JButton botonCancelar = new JButton("Cancelar");
    private static ServerConfigurationWindow theInstance;
    private static JFrame madre;

    public ServerConfigurationOptions getEntrada() {
        int i;
        int aPort;
        int tPort;
        try {
            tPort = Integer.valueOf(this.tfTPort.getText());
        }
        catch (NumberFormatException nfe) {
            tPort = 8010;
        }
        try {
            aPort = Integer.valueOf(this.tfAPort.getText());
        }
        catch (NumberFormatException nfe) {
            aPort = 8009;
        }
        ArrayList servList = new ArrayList();
        ArrayList gList = new ArrayList();
        for (i = 0; i < this.ircServerVector.size(); ++i) {
            servList.add(this.ircServerVector.get(i));
        }
        for (i = 0; i < this.gameVector.size(); ++i) {
            gList.add(this.gameVector.get(i));
        }
        return new ServerConfigurationOptions(this.cbAge.isSelected(), this.cbTel.isSelected(), this.cbIrc.isSelected(), this.cbInitOnStartup.isSelected(), tPort, aPort, servList, gList);
    }

    public void saveConfiguration() throws FileNotFoundException, IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(configurationFile));
        oos.writeObject(this.getEntrada());
        ServerHandler.getInstance().setServerConfigurationOptions(this.getEntrada());
    }

    public static void setMadre(JFrame parent) {
        madre = parent;
    }

    public static ServerConfigurationWindow getInstance() {
        if (theInstance == null) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(configurationFile));
                ServerConfigurationOptions sco = (ServerConfigurationOptions)ois.readObject();
                theInstance = new ServerConfigurationWindow(sco);
            }
            catch (Exception e) {
                theInstance = new ServerConfigurationWindow();
            }
        }
        return theInstance;
    }

    private ServerConfigurationWindow(ServerConfigurationOptions sco) {
        this();
        int i;
        this.cbAge.setSelected(sco.sirveAge());
        this.cbTel.setSelected(sco.sirveTelnet());
        this.cbIrc.setSelected(sco.sirveIrc());
        this.cbInitOnStartup.setSelected(sco.initOnStartup());
        this.cbInitOnOK.setSelected(false);
        this.tfTPort.setText(String.valueOf(sco.getPuertoTelnet()));
        this.tfAPort.setText(String.valueOf(sco.getPuertoAge()));
        List lIrc = sco.getListaServidoresIrc();
        List lDed = sco.getListaPartidasDedicadas();
        for (i = 0; i < lIrc.size(); ++i) {
            this.ircServerVector.addElement(lIrc.get(i));
        }
        for (i = 0; i < lDed.size(); ++i) {
            this.gameVector.addElement(lDed.get(i));
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.cbInitOnOK.setSelected(false);
        }
        super.setVisible(visible);
    }

    private ServerConfigurationWindow() {
        super((Frame)madre, true);
        this.setTitle("Configuraci\u00f3n del servidor");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelPrincipal = new JPanel(new GridLayout(3, 1));
        JPanel subPan1 = new JPanel();
        subPan1.setLayout(new GridLayout(6, 1));
        JPanel subPan11 = new JPanel();
        subPan11.add(this.cbTel);
        subPan11.add(this.tfTPort);
        JPanel subPan12 = new JPanel();
        subPan12.add(this.cbAge);
        subPan12.add(this.tfAPort);
        JPanel subPan13 = new JPanel();
        subPan13.add(this.cbIrc);
        JPanel subPan15 = new JPanel();
        subPan15.add(this.cbInitOnStartup);
        JPanel subPan16 = new JPanel();
        subPan16.add(this.cbInitOnOK);
        subPan1.add(subPan12);
        subPan1.add(subPan11);
        subPan1.add(subPan13);
        subPan1.add(new JPanel());
        subPan1.add(subPan15);
        subPan1.add(subPan16);
        subPan1.setBorder(BorderFactory.createTitledBorder("Activar/Desactivar Servidores"));
        final JPanel subPan2 = new JPanel();
        subPan2.setBorder(BorderFactory.createTitledBorder("Servidor IRC"));
        subPan2.setLayout(new BorderLayout());
        JPanel subPan21 = new JPanel();
        subPan21.add(new JScrollPane(this.ircServerList));
        JPanel subPan22 = new JPanel();
        subPan22.add(this.islAdd);
        subPan22.add(this.islRemove);
        subPan22.add(this.islConfig);
        subPan2.add((Component)subPan21, "Center");
        subPan2.add((Component)subPan22, "South");
        JPanel subPan3 = new JPanel();
        subPan3.setBorder(BorderFactory.createTitledBorder("Partidas dedicadas"));
        subPan3.setLayout(new BorderLayout());
        JPanel subPan31 = new JPanel();
        subPan31.add(new JScrollPane(this.gameList));
        JPanel subPan32 = new JPanel();
        subPan32.add(this.gameAdd);
        subPan32.add(this.gameRemove);
        subPan32.add(this.gameConfig);
        subPan3.add((Component)subPan31, "Center");
        subPan3.add((Component)subPan32, "South");
        panelPrincipal.add(subPan1);
        panelPrincipal.add(subPan2);
        panelPrincipal.add(subPan3);
        JPanel panelBotones = new JPanel(new GridLayout(1, 4));
        panelBotones.add(new JPanel());
        panelBotones.add(new JPanel());
        panelBotones.add(this.botonAceptar);
        panelBotones.add(this.botonCancelar);
        panelPrincipal.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)panelPrincipal, "Center");
        this.getContentPane().add((Component)panelBotones, "South");
        this.pack();
        this.islAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddIrcNetworkWindow ainw = new AddIrcNetworkWindow(ServerConfigurationWindow.getInstance());
                ainw.setVisible(true);
            }
        });
        this.islConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IrcServerEntry ise = ServerConfigurationWindow.this.removeAndGetSelectedIrcServerEntry();
                if (ise == null) {
                    return;
                }
                AddIrcNetworkWindow ainw = new AddIrcNetworkWindow(ServerConfigurationWindow.getInstance(), ise);
                ainw.setVisible(true);
            }
        });
        this.islRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerConfigurationWindow.this.removeSelectedIrcServerEntries();
            }
        });
        this.gameAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddGameWindow agw = new AddGameWindow(ServerConfigurationWindow.getInstance());
                agw.setVisible(true);
            }
        });
        this.gameConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PartidaEntry pe = ServerConfigurationWindow.this.removeAndGetSelectedPartidaEntry();
                if (pe == null) {
                    return;
                }
                AddGameWindow ainw = new AddGameWindow(ServerConfigurationWindow.getInstance(), pe);
                ainw.setVisible(true);
            }
        });
        this.gameRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerConfigurationWindow.this.removeSelectedPartidaEntries();
            }
        });
        this.botonCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerConfigurationWindow.this.dispose();
                theInstance = new ServerConfigurationWindow(ServerHandler.getInstance().getServerConfigurationOptions());
            }
        });
        this.botonAceptar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServerConfigurationWindow.this.dispose();
                try {
                    ServerConfigurationWindow.this.saveConfiguration();
                    if (ServerConfigurationWindow.this.cbInitOnOK.isSelected()) {
                        ServerHandler.getInstance().initPartidasDedicadas(SwingAetheriaGUI.getInstance().getPanel());
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "No se ha podido guardar la configuraci\u00f3n del servidor a fichero: " + e, "\u00a1Oops!", 0);
                }
            }
        });
        this.cbIrc.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    subPan2.setEnabled(true);
                    ServerConfigurationWindow.this.islAdd.setEnabled(true);
                    ServerConfigurationWindow.this.islRemove.setEnabled(true);
                    ServerConfigurationWindow.this.islConfig.setEnabled(true);
                } else if (evt.getStateChange() == 2) {
                    subPan2.setEnabled(false);
                    ServerConfigurationWindow.this.islAdd.setEnabled(false);
                    ServerConfigurationWindow.this.islRemove.setEnabled(false);
                    ServerConfigurationWindow.this.islConfig.setEnabled(false);
                }
            }
        });
        this.islAdd.setEnabled(this.cbIrc.isSelected());
        this.islRemove.setEnabled(this.cbIrc.isSelected());
        this.islConfig.setEnabled(this.cbIrc.isSelected());
    }

    public void addIrcServerEntry(IrcServerEntry ise) {
        this.ircServerVector.addElement(ise);
        this.ircServerList.repaint();
    }

    public void removeSelectedIrcServerEntries() {
        int[] indices = this.ircServerList.getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.ircServerVector.removeElementAt(indices[i]);
        }
    }

    public IrcServerEntry removeAndGetSelectedIrcServerEntry() {
        int[] indices = this.ircServerList.getSelectedIndices();
        if (indices.length < 1) {
            return null;
        }
        IrcServerEntry ise = (IrcServerEntry)this.ircServerVector.get(indices[0]);
        this.ircServerVector.removeElementAt(indices[0]);
        return ise;
    }

    public void addPartidaEntry(PartidaEntry pe) {
        this.gameVector.addElement(pe);
        this.gameList.repaint();
    }

    public void removeSelectedPartidaEntries() {
        int[] indices = this.gameList.getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.gameVector.removeElementAt(indices[i]);
        }
    }

    public PartidaEntry removeAndGetSelectedPartidaEntry() {
        int[] indices = this.gameList.getSelectedIndices();
        if (indices.length < 1) {
            return null;
        }
        PartidaEntry pe = (PartidaEntry)this.gameVector.get(indices[0]);
        this.gameVector.removeElementAt(indices[0]);
        return pe;
    }
}

