/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import bsh.TargetError;
import eu.irreality.age.Descriptible;
import eu.irreality.age.Description;
import eu.irreality.age.EVASemanticException;
import eu.irreality.age.Entity;
import eu.irreality.age.Informador;
import eu.irreality.age.Inventory;
import eu.irreality.age.Item;
import eu.irreality.age.Mobile;
import eu.irreality.age.MobileList;
import eu.irreality.age.Nameable;
import eu.irreality.age.NaturalLanguage;
import eu.irreality.age.ObjectCode;
import eu.irreality.age.Path;
import eu.irreality.age.ReturnValue;
import eu.irreality.age.StringMethods;
import eu.irreality.age.SupportingCode;
import eu.irreality.age.Utility;
import eu.irreality.age.VolumeLimitExceededException;
import eu.irreality.age.WeightLimitExceededException;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import eu.irreality.age.debug.Debug;
import eu.irreality.age.debug.ExceptionPrinter;
import eu.irreality.age.messages.Messages;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Room
extends Entity
implements Descriptible,
SupportingCode {
    private World mundo;
    private int idnumber;
    private int inheritsFrom;
    protected String title;
    protected Description[] descriptionList;
    protected Path[] standardExits;
    protected Path[] otherExits;
    protected Inventory itemsInRoom;
    protected MobileList mobsInRoom;
    protected String extraDescriptions;
    protected List extraDescriptionArrays;
    protected List extraDescriptionNameArrays;
    protected Vector onlyRestrictions;
    protected ObjectCode itsCode;
    private NaturalLanguage lenguaje;
    private Random aleat;
    transient boolean getDescription_bsh_call = false;

    public Room(World mundo, String roomfile) throws IOException, FileNotFoundException {
        this.constructRoom(mundo, roomfile);
    }

    public Room(World mundo, Node n) throws XMLtoWorldException {
        this.constructRoom(mundo, n, true);
    }

    public void constructRoom(World mundo, String roomfile) throws IOException, FileNotFoundException {
        this.mundo = mundo;
        boolean inheritance_done = false;
        this.lenguaje = mundo.getLanguage();
        FileInputStream fp = new FileInputStream(roomfile);
        BufferedReader filein = new BufferedReader(Utility.getBestInputStreamReader(fp));
        block21: for (int line = 1; line < 100; ++line) {
            String linea = filein.readLine();
            String id_linea = StringMethods.getTok(linea, 1, ' ');
            linea = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
            if (id_linea == null) continue;
            switch (Integer.valueOf(id_linea)) {
                case 1: {
                    this.idnumber = Integer.valueOf(linea);
                    continue block21;
                }
                case 2: {
                    this.inheritsFrom = Integer.valueOf(linea);
                    if (this.inheritsFrom >= this.idnumber || inheritance_done) continue block21;
                    this.constructRoom(mundo, Utility.roomFile(mundo, this.inheritsFrom));
                    inheritance_done = true;
                    this.constructRoom(mundo, roomfile);
                    return;
                }
                case 3: {
                    this.setNewState(Integer.valueOf(linea));
                    continue block21;
                }
                case 4: {
                    this.title = linea;
                    continue block21;
                }
                case 10: {
                    this.descriptionList = Utility.loadDescriptionListFromString(linea);
                    continue block21;
                }
                case 11: {
                    this.standardExits = new Path[10];
                    if (StringMethods.numToks(linea, '@') < 10) {
                        System.out.println("[SINTAXIS] l\u00ednea 10 (" + roomfile + ") insuficientes tokens con @");
                    }
                    for (int i = 0; i < 10; ++i) {
                        String curToken = StringMethods.getTok(linea, i + 1, '@');
                        this.standardExits[i] = new Path(mundo, true, curToken);
                    }
                    continue block21;
                }
                case 12: {
                    this.otherExits = new Path[StringMethods.numToks(linea, '@')];
                    for (int i = 0; i < this.otherExits.length; ++i) {
                        String curToken = StringMethods.getTok(linea, i + 1, '@');
                        this.otherExits[i] = new Path(mundo, false, curToken);
                    }
                    continue block21;
                }
                case 20: {
                    int i;
                    int nObjects = StringMethods.numToks(linea, '$');
                    this.itemsInRoom = new Inventory(1000000, 1000000, nObjects);
                    for (i = 0; i < nObjects; ++i) {
                        try {
                            this.itemsInRoom.addItem(mundo.getItem(StringMethods.getTok(linea, i + 1, '$')));
                            continue;
                        }
                        catch (WeightLimitExceededException exc) {
                            mundo.write("Item too heavy for room");
                            continue;
                        }
                        catch (VolumeLimitExceededException exc2) {
                            mundo.write("Item too big for room");
                        }
                    }
                    continue block21;
                }
                case 21: {
                    int i;
                    int nObjects = StringMethods.numToks(linea, '$');
                    this.mobsInRoom = new MobileList();
                    for (i = 0; i < nObjects; ++i) {
                        Mobile ourMob = mundo.getMob(StringMethods.getTok(linea, i + 1, '$'));
                        this.mobsInRoom.addElement(ourMob);
                        ourMob.setRoom(this);
                        ourMob.setRoom(this);
                    }
                    continue block21;
                }
                case 30: {
                    this.extraDescriptions = linea;
                    continue block21;
                }
                case 80: {
                    String EVACodeString = linea;
                    boolean terminamos = false;
                    while (!terminamos) {
                        int intval;
                        linea = filein.readLine();
                        id_linea = StringMethods.getTok(linea, 1, ' ');
                        try {
                            intval = Integer.valueOf(id_linea);
                        }
                        catch (NumberFormatException e) {
                            intval = 0;
                        }
                        if (intval == 81) {
                            terminamos = true;
                            continue;
                        }
                        EVACodeString = EVACodeString + "\n";
                        EVACodeString = EVACodeString + linea;
                    }
                    this.itsCode = new ObjectCode(EVACodeString, "EVA", mundo);
                    continue block21;
                }
                case 84: {
                    String bshCodeString = linea;
                    boolean terminamos = false;
                    while (!terminamos) {
                        int intval;
                        linea = filein.readLine();
                        id_linea = StringMethods.getTok(linea, 1, ' ');
                        try {
                            intval = Integer.valueOf(id_linea);
                        }
                        catch (NumberFormatException e) {
                            intval = 0;
                        }
                        if (intval == 85) {
                            terminamos = true;
                            continue;
                        }
                        bshCodeString = bshCodeString + "\n";
                        bshCodeString = bshCodeString + linea;
                    }
                    this.itsCode = new ObjectCode(bshCodeString, "BeanShell", mundo);
                    continue block21;
                }
            }
        }
        if (this.getID() < 10000000) {
            this.idnumber += 10000000;
        }
    }

    public void constructRoom(World mundo, Node n, boolean allowInheritance) throws XMLtoWorldException {
        NodeList moblistNodes;
        int i;
        int i2;
        this.mundo = mundo;
        this.lenguaje = mundo.getLanguage();
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Room node not Element");
        }
        Element e = (Element)n;
        if (e.hasAttribute("extends") && !e.getAttribute("extends").equals("0") && allowInheritance) {
            this.constructRoom(mundo, mundo.getRoomNode(e.getAttribute("extends")), true);
            this.constructRoom(mundo, n, false);
        }
        if (!e.hasAttribute("name")) {
            throw new XMLtoWorldException("Room node lacks attribute name");
        }
        try {
            if (e.hasAttribute("id")) {
                this.idnumber = Integer.valueOf(e.getAttribute("id"));
            }
        }
        catch (NumberFormatException nfe) {
            throw new XMLtoWorldException("Bad number format at attribute id in mobile node");
        }
        this.title = e.getAttribute("name");
        this.readPropListFromXML(mundo, n);
        this.descriptionList = Utility.loadDescriptionListFromXML(mundo, e, "DescriptionList", true);
        NodeList pathListNodes = e.getElementsByTagName("PathList");
        if (pathListNodes.getLength() > 0) {
            Element pathListNode = (Element)pathListNodes.item(0);
            NodeList pathNodes = pathListNode.getElementsByTagName("Path");
            int nNonStandard = 0;
            for (int i3 = 0; i3 < pathNodes.getLength(); ++i3) {
                Element commandListNode;
                Element curNode = (Element)pathNodes.item(i3);
                boolean hasCommands = false;
                if (curNode.getElementsByTagName("CommandList").getLength() > 0 && (commandListNode = (Element)curNode.getElementsByTagName("CommandList").item(0)).getElementsByTagName("Command").getLength() > 0) {
                    hasCommands = true;
                }
                if (Boolean.valueOf(curNode.getAttribute("standard")).booleanValue() && !hasCommands) continue;
                ++nNonStandard;
            }
            this.standardExits = new Path[10];
            this.otherExits = new Path[nNonStandard];
            int nonStandardExitCounter = 0;
            for (i2 = 0; i2 < pathNodes.getLength(); ++i2) {
                Element curNode = (Element)pathNodes.item(i2);
                Path p = new Path(mundo, curNode);
                Debug.println("Path " + i2 + " for room " + this.getID());
                if (p.isStandard()) {
                    int direccion = Path.nameToDirection(curNode.getAttribute("direction"));
                    this.standardExits[direccion] = p;
                    if (!p.isExtended()) continue;
                    this.otherExits[nonStandardExitCounter] = p;
                    ++nonStandardExitCounter;
                    continue;
                }
                this.otherExits[nonStandardExitCounter] = p;
                ++nonStandardExitCounter;
            }
        } else {
            this.standardExits = new Path[10];
            this.otherExits = new Path[0];
        }
        for (int i4 = 0; i4 < this.standardExits.length; ++i4) {
            if (this.standardExits[i4] != null) continue;
            this.standardExits[i4] = new Path(mundo, true, "0");
        }
        NodeList inventoryNodes = e.getElementsByTagName("Inventory");
        ArrayList<Node> realInventoryNodes = new ArrayList<Node>();
        for (i = 0; i < inventoryNodes.getLength(); ++i) {
            if (inventoryNodes.item(i).getParentNode() != e) continue;
            realInventoryNodes.add(inventoryNodes.item(i));
        }
        this.itemsInRoom = realInventoryNodes.size() < 1 ? null : new Inventory(mundo, (Node)realInventoryNodes.get(0));
        if (this.itemsInRoom != null) {
            for (i = 0; i < this.itemsInRoom.size(); ++i) {
                Item cur = this.itemsInRoom.elementAt(i);
                cur.addRoomReference(this);
            }
        }
        if ((moblistNodes = e.getElementsByTagName("MobileList")).getLength() < 1) {
            this.mobsInRoom = new MobileList();
        } else {
            this.mobsInRoom = new MobileList(mundo, moblistNodes.item(0));
            if (this.mobsInRoom == null) {
                this.mobsInRoom = new MobileList();
            }
            MobileList copiaMobsInRoom = new MobileList(mundo, moblistNodes.item(0));
            for (i2 = 0; i2 < copiaMobsInRoom.size(); ++i2) {
                Mobile ourMob = copiaMobsInRoom.elementAt(i2);
                Debug.println("i= " + i2 + ": Setting room on mob " + ourMob + " to " + this);
                ourMob.setRoom(this);
                ourMob.setRoom(this);
            }
        }
        List temp = Utility.loadExtraDescriptionsFromXML(mundo, e, "ExtraDescriptionList", true);
        if (temp == null || temp.size() < 2) {
            this.extraDescriptionArrays = new ArrayList();
            this.extraDescriptionNameArrays = new ArrayList();
        } else {
            this.extraDescriptionArrays = (List)temp.get(1);
            this.extraDescriptionNameArrays = (List)temp.get(0);
        }
        NodeList codeNodes = e.getElementsByTagName("Code");
        if (codeNodes.getLength() > 0) {
            try {
                this.itsCode = new ObjectCode(mundo, codeNodes.item(0));
            }
            catch (XMLtoWorldException ex) {
                throw new XMLtoWorldException("Exception at Code node: " + ex.getMessage());
            }
        }
        if (this.getID() != 0 && this.getID() < 10000000) {
            this.idnumber += 10000000;
        }
        try {
            boolean ejecutado = this.execCode("onInit", new Object[0]);
        }
        catch (TargetError te) {
            mundo.writeError(ExceptionPrinter.getExceptionReport(te));
            te.printStackTrace();
        }
    }

    public void setID(int newid) {
        this.idnumber = newid < 10000000 ? newid + 10000000 : newid;
    }

    public boolean isValidExit(boolean isStandard, int exitn) {
        if (isStandard) {
            return this.standardExits[exitn].isValid();
        }
        Debug.println("Other Exits: " + this.otherExits);
        Debug.println("" + exitn);
        Debug.println("Len " + this.otherExits.length);
        for (int i = 0; i < this.otherExits.length; ++i) {
            Debug.println(this.otherExits[i]);
        }
        return this.otherExits[exitn].isValid();
    }

    public Path[] getValidExits() {
        int i;
        ArrayList<Path> caminos = new ArrayList<Path>();
        for (i = 0; i < this.standardExits.length; ++i) {
            if (!this.standardExits[i].isValid()) continue;
            caminos.add(this.standardExits[i]);
        }
        for (i = 0; i < this.otherExits.length; ++i) {
            if (!this.otherExits[i].isValid()) continue;
            caminos.add(this.otherExits[i]);
        }
        Path[] caminos_ar = new Path[caminos.size()];
        for (int i2 = 0; i2 < caminos_ar.length; ++i2) {
            caminos_ar[i2] = (Path)caminos.get(i2);
        }
        return caminos_ar;
    }

    public Path getExit(boolean isStandard, int exitn) {
        if (isStandard) {
            return this.standardExits[exitn];
        }
        return this.otherExits[exitn];
    }

    public Path getPath(boolean isStandard, int exitn) {
        return this.getExit(isStandard, exitn);
    }

    public Path[] getStandardExits() {
        return this.standardExits;
    }

    public Path[] getNonStandardExits() {
        return this.otherExits;
    }

    public int getRandomValidExitAsNumber() {
        int i;
        int nvalid_standard = 0;
        int nvalid_nonstandard = 0;
        for (i = 0; i < this.standardExits.length; ++i) {
            if (!this.isValidExit(true, i)) continue;
            ++nvalid_standard;
        }
        for (i = 0; i < this.otherExits.length; ++i) {
            if (!this.isValidExit(false, i)) continue;
            ++nvalid_nonstandard;
        }
        if (nvalid_standard + nvalid_nonstandard < 1) {
            return -1;
        }
        int numsalida = this.aleat.nextInt(nvalid_standard + nvalid_nonstandard);
        int i2 = 0;
        System.err.println("Room " + this + " numsal " + numsalida);
        for (int k = 0; k < this.standardExits.length && k < numsalida; ++k) {
            if (this.isValidExit(true, i2)) {
                ++i2;
            }
            if (i2 != numsalida) continue;
            return i2 - 1;
        }
        int j = i2;
        while (j - i2 < this.otherExits.length && j < numsalida) {
            if (!this.isValidExit(false, j - i2)) continue;
            ++j;
        }
        return 10 + j - i2 - 1;
    }

    public Path getRandomValidExit() {
        int nsal = this.getRandomValidExitAsNumber();
        if (nsal < 0) {
            return null;
        }
        if (nsal < 10) {
            return this.standardExits[nsal];
        }
        return this.otherExits[10 - nsal];
    }

    public String getExitName(boolean isStandard, int exitn) {
        if (isStandard) {
            switch (exitn) {
                case 0: {
                    return "el norte";
                }
                case 1: {
                    return "el sur";
                }
                case 3: {
                    return "el este";
                }
                case 2: {
                    return "el oeste";
                }
            }
            return "alg\u00fan lado";
        }
        return this.otherExits[exitn].getNonStandardName();
    }

    public String getExitName(Path p) {
        if (p.isStandard()) {
            int exitn;
            for (exitn = 0; exitn < this.standardExits.length && this.standardExits[exitn] != p; ++exitn) {
            }
            return this.getExitName(true, exitn);
        }
        return p.getNonStandardName();
    }

    public List getExitNames(Path p) {
        String[] moreNames;
        ArrayList<String> result = new ArrayList<String>();
        if (p.isStandard()) {
            int exitn;
            for (exitn = 0; exitn < this.standardExits.length && this.standardExits[exitn] != p; ++exitn) {
            }
            result.add(this.getExitName(true, exitn));
        }
        if ((moreNames = p.getNonStandardNames()) != null) {
            for (int i = 0; i < moreNames.length; ++i) {
                result.add(moreNames[i]);
            }
        }
        return result;
    }

    public Room getPathDestination(Path p, World w) {
        return w.getRoom(p.getDestinationID());
    }

    public int getID() {
        return this.idnumber;
    }

    public int getItsID() {
        return this.idnumber;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription(long comparand) {
        String desString = "";
        for (int i = 0; i < this.descriptionList.length; ++i) {
            if (!this.descriptionList[i].matches(comparand)) continue;
            desString = desString + this.descriptionList[i].getText();
        }
        if (this.itemsInRoom != null && !this.itemsInRoom.isEmpty() && !this.itemsInRoom.toString().equals("nada.")) {
            desString = desString + "\nAqu\u00ed hay ";
            desString = desString + this.itemsInRoom.toString();
        }
        if (this.mobsInRoom != null && !this.mobsInRoom.isEmpty() && !this.mobsInRoom.toString().equals("nada.")) {
            desString = this.mobsInRoom.size() > 1 ? desString + "\nAqu\u00ed est\u00e1n " : desString + "\nAqu\u00ed est\u00e1 ";
            desString = desString + this.mobsInRoom.toString();
        }
        return desString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription(Entity viewer) {
        if (!this.getDescription_bsh_call) {
            boolean ejecutado = false;
            ReturnValue retval = new ReturnValue(null);
            try {
                this.getDescription_bsh_call = true;
                ejecutado = this.execCode("getDescription", new Object[]{viewer}, retval);
            }
            catch (TargetError te) {
                this.mundo.writeError(ExceptionPrinter.getExceptionReport(te));
                te.printStackTrace();
            }
            finally {
                this.getDescription_bsh_call = false;
            }
            if (retval.getRetVal() != null) {
                return (String)retval.getRetVal();
            }
            if (ejecutado) {
                return null;
            }
        }
        String desString = "";
        boolean quitado = false;
        for (int i = 0; i < this.descriptionList.length; ++i) {
            if (!this.descriptionList[i].matchesConditions(this, viewer)) continue;
            desString = desString + this.descriptionList[i].getText();
        }
        if (this.itemsInRoom != null && !this.itemsInRoom.isEmpty() && !this.itemsInRoom.toString(viewer).equals("nada.")) {
            desString = desString + "\n" + this.getLayingObjectString(viewer);
        }
        if (this.mobsInRoom != null && viewer instanceof Mobile) {
            quitado = this.mobsInRoom.removeElement((Mobile)viewer);
        }
        if (this.mobsInRoom != null && !this.mobsInRoom.isEmpty() && !this.mobsInRoom.toString(viewer).equals("nada.")) {
            desString = this.mobsInRoom.size() > 1 ? desString + "\n" + this.getPresentMobilesPluralString(viewer) : desString + "\n" + this.getPresentMobilesSingularString(viewer);
        }
        if (quitado) {
            this.mobsInRoom.addElement((Mobile)viewer);
        }
        return desString;
    }

    private String getLayingObjectString(Entity viewer) {
        String customMessage = this.getPropertyValueAsString("itemsHereMessage");
        String itemsString = this.itemsInRoom.toString(viewer);
        String rawString = itemsString.substring(0, itemsString.length() - 1);
        if (customMessage != null) {
            return Messages.buildMessage(customMessage, "$dotinventory", itemsString, "$inventory", rawString);
        }
        return this.mundo.getMessages().getMessage("items.here", "$dotinventory", itemsString, "$inventory", rawString, new Object[]{this});
    }

    private String getPresentMobilesSingularString(Entity viewer) {
        String customMessage = this.getPropertyValueAsString("mobileHereMessage");
        String mobsString = this.mobsInRoom.toString(viewer);
        String rawString = mobsString.substring(0, mobsString.length() - 1);
        if (customMessage != null) {
            return Messages.buildMessage(customMessage, "$dotlist", mobsString, "$list", rawString);
        }
        return this.mundo.getMessages().getMessage("mobile.here", "$dotlist", mobsString, "$list", rawString, new Object[]{this});
    }

    private String getPresentMobilesPluralString(Entity viewer) {
        String customMessage = this.getPropertyValueAsString("mobilesHereMessage");
        String mobsString = this.mobsInRoom.toString(viewer);
        String rawString = mobsString.substring(0, mobsString.length() - 1);
        if (customMessage != null) {
            return Messages.buildMessage(customMessage, "$dotlist", mobsString, "$list", rawString);
        }
        return this.mundo.getMessages().getMessage("mobiles.here", "$dotlist", mobsString, "$list", rawString, new Object[]{this});
    }

    public String getDescription(long comparand, Mobile toExclude) {
        String desString = "";
        for (int i = 0; i < this.descriptionList.length; ++i) {
            if (!this.descriptionList[i].matches(comparand)) continue;
            desString = desString + this.descriptionList[i].getText();
        }
        if (this.itemsInRoom != null && !this.itemsInRoom.isEmpty() && !this.itemsInRoom.toString().equals("nada.")) {
            desString = desString + "\nAqu\u00ed hay ";
            desString = desString + this.itemsInRoom.toString();
        }
        boolean quitado = false;
        if (this.mobsInRoom != null) {
            quitado = this.mobsInRoom.removeElement(toExclude);
        }
        if (this.mobsInRoom != null && !this.mobsInRoom.isEmpty() && !this.mobsInRoom.toString().equals("nada.")) {
            desString = this.mobsInRoom.size() > 1 ? desString + "\nAqu\u00ed est\u00e1n " : desString + "\nAqu\u00ed est\u00e1 ";
            desString = desString + this.mobsInRoom.toString();
        }
        if (quitado) {
            this.mobsInRoom.addElement(toExclude);
        }
        return desString;
    }

    public String getExtraDescription(String thingieName, Entity viewer) {
        if (thingieName == null || thingieName.length() == 0) {
            return null;
        }
        for (int i = 0; i < this.extraDescriptionNameArrays.size(); ++i) {
            int j;
            String[] curNameArray = (String[])this.extraDescriptionNameArrays.get(i);
            Description[] curDesArray = (Description[])this.extraDescriptionArrays.get(i);
            for (j = 0; j < curNameArray.length; ++j) {
                if (!thingieName.toLowerCase().endsWith(curNameArray[j].toLowerCase())) continue;
                String desString = "";
                for (int k = 0; k < curDesArray.length; ++k) {
                    if (!curDesArray[k].matchesConditions(this, viewer)) continue;
                    desString = desString + "\n";
                    desString = desString + curDesArray[k].getText();
                }
                if (desString.length() > 0) {
                    return desString.substring(1);
                }
                return null;
            }
            for (j = 0; j < curNameArray.length; ++j) {
                if (!StringMethods.getTok(thingieName, StringMethods.numToks(thingieName, ' '), ' ').equalsIgnoreCase(curNameArray[j])) continue;
                String desString = "";
                for (int k = 0; k < curDesArray.length; ++k) {
                    if (!curDesArray[k].matchesConditions(this, viewer)) continue;
                    desString = desString + "\n";
                    desString = desString + curDesArray[k].getText();
                }
                if (desString.length() > 0) {
                    return desString.substring(1);
                }
                return null;
            }
        }
        return null;
    }

    public void changeState(World mundo) {
    }

    public void addItem(Item nuevo) throws WeightLimitExceededException, VolumeLimitExceededException {
        if (this.itemsInRoom == null) {
            this.itemsInRoom = new Inventory(100000, 100000, 1);
        }
        this.itemsInRoom.addItem(nuevo);
        nuevo.addRoomReference(this);
    }

    public boolean removeItem(Item viejo) {
        if (this.itemsInRoom == null) {
            return false;
        }
        viejo.removeRoomReference(this);
        return this.itemsInRoom.removeItem(viejo);
    }

    public void addMob(Mobile nuevo) {
        if (this.mobsInRoom == null) {
            this.mobsInRoom = new MobileList();
        }
        this.mobsInRoom.addElement(nuevo);
        Debug.println("Mobs In Roome After Addendum " + this.mobsInRoom);
    }

    public boolean removeMob(Mobile viejo) {
        if (this.mobsInRoom == null) {
            return false;
        }
        return this.mobsInRoom.removeElement(viejo);
    }

    public boolean execCode(String routine, String dataSegment) throws EVASemanticException {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, dataSegment);
        }
        return false;
    }

    public boolean execCode(String routine, Object[] args) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args);
        }
        return false;
    }

    public boolean execCode(String routine, Object[] args, ReturnValue retval) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args, retval);
        }
        return false;
    }

    public String personalizeDescription(String des, Mobile source, Mobile target) {
        String nombre;
        String s = des;
        if (source != null) {
            nombre = source.constructName2(1, null);
            if (nombre == null) {
                nombre = "alguien";
            }
            s = StringMethods.textualSubstitution(s, "$1", nombre);
        }
        if (target != null) {
            nombre = target.constructName2(1, null);
            if (nombre == null) {
                nombre = "alguien";
            }
            s = StringMethods.textualSubstitution(s, "$2", nombre);
        }
        return s;
    }

    public String personalizeDescription(String des, Entity viewer, Nameable[] dollarEntities) {
        String s = des;
        for (int i = 0; i < dollarEntities.length; ++i) {
            if (dollarEntities[i] == null) continue;
            String nombre = dollarEntities[i].constructName2(1, viewer);
            if (nombre == null || dollarEntities[i].isInvisible(viewer)) {
                nombre = dollarEntities[i] instanceof Mobile ? "alguien" : "algo";
            }
            s = StringMethods.textualSubstitution(s, "$" + (i + 1), nombre);
        }
        return this.lenguaje.gramaticalizarSinTrimear(s);
    }

    public void informAction(Entity source, Entity target, Entity[] objects, String thirdPersonDes, String sufferDes, String execDes, boolean self_included) {
        this.reportAction(source, target, objects, thirdPersonDes, sufferDes, execDes, self_included);
    }

    public void reportAction(Entity source, Entity target, Entity[] objects, String thirdPersonDes, String sufferDes, String execDes, boolean self_included) {
        this.reportAction(source, target, objects, thirdPersonDes, sufferDes, execDes, null, self_included);
    }

    public void reportAction(Entity source, Entity target, Entity[] objects, String thirdPersonDes, String sufferDes, String execDes, String style, boolean self_included) {
        Mobile actual;
        int i;
        Nameable[] dollarEntities = objects == null ? new Nameable[2] : new Nameable[2 + objects.length];
        dollarEntities[0] = (Nameable)((Object)source);
        dollarEntities[1] = (Nameable)((Object)target);
        if (objects != null) {
            for (i = 0; i < objects.length; ++i) {
                dollarEntities[2 + i] = (Nameable)((Object)objects[i]);
            }
        }
        for (i = 0; i < this.mobsInRoom.size(); ++i) {
            actual = this.mobsInRoom.elementAt(i);
            if (actual == source && execDes != null && self_included) {
                if (!(actual instanceof Informador)) continue;
                actual.writeWithTemplate(style, this.personalizeDescription(execDes, (Entity)actual, dollarEntities));
                continue;
            }
            if (actual == target && sufferDes != null) {
                if (!(actual instanceof Informador)) continue;
                actual.writeWithTemplate(style, this.personalizeDescription(sufferDes, (Entity)actual, dollarEntities));
                continue;
            }
            if (thirdPersonDes == null || actual == source || actual == target || !(actual instanceof Informador)) continue;
            actual.writeWithTemplate(style, this.personalizeDescription(thirdPersonDes, (Entity)actual, dollarEntities));
        }
        for (i = 0; i < this.mobsInRoom.size(); ++i) {
            actual = this.mobsInRoom.elementAt(i);
            if (actual == source && execDes != null && self_included) {
                actual.reactToRoomText(this.personalizeDescription(execDes, (Entity)actual, dollarEntities));
                continue;
            }
            if (actual == target && sufferDes != null) {
                actual.reactToRoomText(this.personalizeDescription(sufferDes, (Entity)actual, dollarEntities));
                continue;
            }
            if (thirdPersonDes == null) continue;
            actual.reactToRoomText(this.personalizeDescription(thirdPersonDes, (Entity)actual, dollarEntities));
        }
        try {
            this.execCode("onRoomText", new Object[]{this.personalizeDescription(thirdPersonDes, null, dollarEntities)});
        }
        catch (TargetError te) {
            System.err.println((Object)te);
            this.mundo.writeError(ExceptionPrinter.getExceptionReport(te));
            te.printStackTrace();
        }
    }

    public void informActionAuto(Entity source, Entity target, Entity[] objects, String thirdPersonDes, boolean self_included) {
        this.reportActionAuto(source, target, objects, thirdPersonDes, self_included);
    }

    public void reportActionAuto(Entity source, Entity target, Entity[] objects, String thirdPersonDes, boolean self_included) {
        this.reportActionAuto(source, target, objects, thirdPersonDes, null, self_included);
    }

    public void reportActionAuto(Entity source, Entity target, Entity[] objects, String thirdPersonDes, String style, boolean self_included) {
        Debug.println("Autoinforming " + thirdPersonDes + " at roome " + this.getID() + ":" + this.getTitle());
        StringTokenizer st = new StringTokenizer(thirdPersonDes, " ", true);
        String execDes = "";
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("$1")) {
                if (!st.hasMoreTokens()) continue;
                execDes = execDes + st.nextToken();
                if (!st.hasMoreTokens()) continue;
                String posibleVerbo = st.nextToken();
                String segundaPers = this.lenguaje.terceraASegunda(posibleVerbo);
                if (segundaPers != null) {
                    execDes = execDes + segundaPers;
                    continue;
                }
                execDes = execDes + posibleVerbo;
                continue;
            }
            execDes = execDes + tok;
        }
        execDes = execDes + "a";
        execDes = execDes.trim();
        execDes = execDes.substring(0, execDes.length() - 1);
        String sufferDes = null;
        Debug.println("Gonna deft'ly call informAction");
        this.reportAction(source, target, objects, thirdPersonDes, sufferDes, execDes, style, self_included);
    }

    public void informAction(Mobile source, Mobile target, String thirdPersonDes, String sufferDes, String execDes, boolean self_included) {
        this.reportAction(source, target, thirdPersonDes, sufferDes, execDes, self_included);
    }

    public void reportAction(Mobile source, Mobile target, String thirdPersonDes, String sufferDes, String execDes, boolean self_included) {
        this.reportAction(source, target, null, thirdPersonDes, sufferDes, execDes, self_included);
    }

    public void informActionAuto(Mobile source, Mobile target, String thirdPersonDes, boolean self_included) {
        this.reportActionAuto(source, target, thirdPersonDes, self_included);
    }

    public void reportActionAuto(Mobile source, Mobile target, String thirdPersonDes, boolean self_included) {
        this.reportActionAuto(source, target, null, thirdPersonDes, self_included);
    }

    public void loadNumberGenerator(World mundo) {
        this.aleat = mundo.getRandom();
    }

    public boolean hasItem(Item it) {
        return this.itemsInRoom.contains(it);
    }

    public boolean hasMobile(Mobile m) {
        return this.mobsInRoom.contains(m);
    }

    public Inventory getInventory() {
        if (this.itemsInRoom == null) {
            this.itemsInRoom = new Inventory(10000, 10000);
        }
        return this.itemsInRoom;
    }

    public Inventory getContents() {
        return this.getInventory();
    }

    public MobileList getMobiles() {
        if (this.mobsInRoom == null) {
            this.mobsInRoom = new MobileList();
        }
        return this.mobsInRoom;
    }

    public Node getXMLRepresentation(Document doc) {
        Element suElemento = doc.createElement("Room");
        suElemento.setAttribute("id", String.valueOf(this.idnumber));
        suElemento.setAttribute("name", String.valueOf(this.title));
        suElemento.setAttribute("extends", String.valueOf(this.inheritsFrom));
        suElemento.appendChild(this.getPropListXMLRepresentation(doc));
        suElemento.appendChild(this.getRelationshipListXMLRepresentation(doc));
        Element listaDesc = doc.createElement("DescriptionList");
        for (int i = 0; i < this.descriptionList.length; ++i) {
            Description nuestraDescripcion = this.descriptionList[i];
            listaDesc.appendChild(nuestraDescripcion.getXMLRepresentation(doc));
        }
        suElemento.appendChild(listaDesc);
        Element listaSal = doc.createElement("PathList");
        if (this.standardExits != null) {
            for (int i = 0; i < this.standardExits.length; ++i) {
                if (this.standardExits[i] == null) continue;
                listaSal.appendChild(this.standardExits[i].getXMLRepresentation(doc, Path.directionName(i)));
            }
        }
        if (this.otherExits != null) {
            for (int i = 0; i < this.otherExits.length; ++i) {
                if (this.otherExits[i] == null || this.otherExits[i].isExtended()) continue;
                listaSal.appendChild(this.otherExits[i].getXMLRepresentation(doc));
            }
        }
        suElemento.appendChild(listaSal);
        if (this.itemsInRoom != null) {
            suElemento.appendChild(this.itemsInRoom.getXMLRepresentation(doc));
        }
        if (this.mobsInRoom != null) {
            suElemento.appendChild(this.mobsInRoom.getXMLRepresentation(doc));
        }
        if (this.extraDescriptions != null) {
            Element extraDes = doc.createElement("ExtraDescriptionList");
            StringTokenizer st1 = new StringTokenizer(this.extraDescriptions, "@");
            while (st1.hasMoreTokens()) {
                String desActual = st1.nextToken();
                Element unaDescripcion = doc.createElement("ExtraDescription");
                StringTokenizer st2 = new StringTokenizer(desActual, "$");
                while (st2.hasMoreTokens()) {
                    String wordActual = st2.nextToken();
                    if (st2.hasMoreTokens()) {
                        Element comando = doc.createElement("Name");
                        Text contenido = doc.createTextNode(wordActual);
                        comando.appendChild(contenido);
                        unaDescripcion.appendChild(comando);
                        continue;
                    }
                    Text texto = doc.createTextNode(wordActual);
                    unaDescripcion.appendChild(texto);
                }
                extraDes.appendChild(unaDescripcion);
            }
            suElemento.appendChild(extraDes);
        }
        if (this.itsCode != null) {
            suElemento.appendChild(this.itsCode.getXMLRepresentation(doc));
        }
        return suElemento;
    }

    public Inventory getFlattenedInventory() {
        if (this.itemsInRoom == null) {
            return new Inventory(1, 1);
        }
        Inventory result = new Inventory(this.itemsInRoom.getWeightLimit(), this.itemsInRoom.getVolumeLimit());
        for (int i = 0; i < this.itemsInRoom.size(); ++i) {
            Item thisPart = this.itemsInRoom.elementAt(i);
            Inventory subInv = thisPart.getFlattenedInventory();
            try {
                result.setVolumeLimit(result.getVolumeLimit() + subInv.getVolumeLimit());
                result.setWeightLimit(result.getWeightLimit() + subInv.getWeightLimit());
            }
            catch (Exception e) {
                Debug.println("Impossible exception thrown: " + e);
                e.printStackTrace();
            }
            for (int j = 0; j < subInv.size(); ++j) {
                try {
                    result.addItem(subInv.elementAt(j));
                    continue;
                }
                catch (Exception e) {
                    Debug.println("Impossible exception thrown: " + e);
                    e.printStackTrace();
                }
            }
            try {
                result.addItem(thisPart);
                continue;
            }
            catch (Exception e) {
                Debug.println("Impossible exception thrown: " + e);
                e.printStackTrace();
            }
        }
        return result;
    }

    public void copyRoomFieldsTo(Room r) {
        int i;
        r.copyEntityFields(this);
        r.mundo = this.mundo;
        r.aleat = this.getRandom();
        r.extraDescriptions = this.extraDescriptions;
        r.idnumber = this.idnumber;
        r.inheritsFrom = this.inheritsFrom;
        r.itemsInRoom = this.itemsInRoom != null ? (Inventory)this.itemsInRoom.clone() : null;
        r.itsCode = this.itsCode.cloneIfNecessary();
        r.title = this.title;
        r.descriptionList = new Description[this.descriptionList.length];
        for (i = 0; i < r.descriptionList.length; ++i) {
            r.descriptionList[i] = (Description)this.descriptionList[i].clone();
        }
        r.lenguaje = this.lenguaje;
        r.mobsInRoom = this.mobsInRoom != null ? (MobileList)this.mobsInRoom.clone() : null;
        r.standardExits = new Path[this.standardExits.length];
        for (i = 0; i < this.standardExits.length; ++i) {
            r.standardExits[i] = this.standardExits[i] != null ? (Path)this.standardExits[i].clone() : null;
        }
        r.otherExits = new Path[this.otherExits.length];
        for (i = 0; i < this.otherExits.length; ++i) {
            r.otherExits[i] = this.otherExits[i] != null ? (Path)this.otherExits[i].clone() : null;
        }
        r.extraDescriptionArrays = this.extraDescriptionArrays;
        r.extraDescriptionNameArrays = this.extraDescriptionNameArrays;
    }

    public Random getRandom() {
        return this.aleat;
    }

    public Room createNewInstance(World mundo, boolean cloneContents) {
        Room r = (Room)this.clone();
        r.inheritsFrom = this.idnumber;
        mundo.addRoomAssigningID(r);
        return r;
    }

    public Object clone() {
        Room r = new Room();
        this.copyRoomFieldsTo(r);
        return r;
    }

    public Room() {
    }

    public ObjectCode getAssociatedCode() {
        return this.itsCode;
    }
}

