/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.ServerConfigurationWindow;
import eu.irreality.age.server.IrcServerEntry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;

class AddIrcNetworkWindow
extends JDialog {
    public JTextField serverTextField = new JTextField("libres.irc-hispano.org");
    public JTextField portTextField = new JTextField("6667");
    public JTextField nickTextField = new JTextField("AGEserver");
    public JCheckBox cbQuery = new JCheckBox("Privado");
    public JCheckBox cbChannel = new JCheckBox("Canal");
    public JCheckBox cbDCC = new JCheckBox("DCC");
    public Vector channelVector = new Vector();
    public JList channelList = new JList(this.channelVector);
    private JButton botonAceptar = new JButton("Aceptar");
    private JButton botonCancelar = new JButton("Cancelar");
    private final ServerConfigurationWindow madre;
    private boolean editMode = false;

    public AddIrcNetworkWindow(final ServerConfigurationWindow madre) {
        super((Dialog)madre, true);
        this.madre = madre;
        this.setTitle("Servidor IRC");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelPrincipal = new JPanel(new GridLayout(2, 1));
        JPanel subPan1 = new JPanel();
        JPanel subPan11 = new JPanel();
        subPan11.add(new JLabel("Servidor IRC:"));
        subPan11.add(this.serverTextField);
        JPanel subPan12 = new JPanel();
        subPan12.add(new JLabel("Puerto:"));
        subPan12.add(this.portTextField);
        JPanel subPan13 = new JPanel();
        subPan13.add(new JLabel("Nick:"));
        subPan13.add(this.nickTextField);
        subPan1.add(subPan11);
        subPan1.add(subPan12);
        subPan1.add(subPan13);
        JPanel subPan2 = new JPanel();
        subPan2.setLayout(new GridLayout(1, 2));
        JPanel subPan21 = new JPanel();
        subPan21.add(this.cbQuery);
        subPan21.add(this.cbChannel);
        subPan21.add(this.cbDCC);
        JPanel subPan22 = new JPanel();
        subPan22.add(this.channelList);
        this.channelVector.add("#aetheria");
        subPan2.add(subPan21);
        subPan2.add(subPan22);
        panelPrincipal.add(subPan1);
        panelPrincipal.add(subPan2);
        JPanel panelBotones = new JPanel(new GridLayout(1, 4));
        panelBotones.add(new JPanel());
        panelBotones.add(new JPanel());
        panelBotones.add(this.botonAceptar);
        panelBotones.add(this.botonCancelar);
        panelPrincipal.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)panelPrincipal, "Center");
        this.getContentPane().add((Component)panelBotones, "South");
        this.pack();
        this.botonCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddIrcNetworkWindow.this.dispose();
            }
        });
        this.botonAceptar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IrcServerEntry ise = AddIrcNetworkWindow.this.getEntrada();
                madre.addIrcServerEntry(ise);
                AddIrcNetworkWindow.this.dispose();
            }
        });
    }

    public AddIrcNetworkWindow(final ServerConfigurationWindow madre, final IrcServerEntry aEditar) {
        super((Dialog)madre, true);
        this.madre = madre;
        this.setTitle("Servidor IRC");
        this.editMode = true;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelPrincipal = new JPanel(new GridLayout(2, 1));
        JPanel subPan1 = new JPanel();
        JPanel subPan11 = new JPanel();
        subPan11.add(new JLabel("Servidor IRC:"));
        this.serverTextField.setText(aEditar.getServer());
        subPan11.add(this.serverTextField);
        JPanel subPan12 = new JPanel();
        subPan12.add(new JLabel("Puerto:"));
        this.portTextField.setText(String.valueOf(aEditar.getPort()));
        subPan12.add(this.portTextField);
        JPanel subPan13 = new JPanel();
        subPan13.add(new JLabel("Nick:"));
        this.nickTextField.setText(aEditar.getNick());
        subPan13.add(this.nickTextField);
        subPan1.add(subPan11);
        subPan1.add(subPan12);
        subPan1.add(subPan13);
        JPanel subPan2 = new JPanel();
        subPan2.setLayout(new GridLayout(1, 2));
        JPanel subPan21 = new JPanel();
        this.cbQuery.setSelected(aEditar.respondeAPrivados());
        this.cbChannel.setSelected(aEditar.respondeACanales());
        this.cbDCC.setSelected(aEditar.respondeADCC());
        subPan21.add(this.cbQuery);
        subPan21.add(this.cbChannel);
        subPan21.add(this.cbDCC);
        JPanel subPan22 = new JPanel();
        subPan22.add(this.channelList);
        this.channelVector = aEditar.getChannels();
        subPan2.add(subPan21);
        subPan2.add(subPan22);
        panelPrincipal.add(subPan1);
        panelPrincipal.add(subPan2);
        JPanel panelBotones = new JPanel(new GridLayout(1, 4));
        panelBotones.add(new JPanel());
        panelBotones.add(new JPanel());
        panelBotones.add(this.botonAceptar);
        panelBotones.add(this.botonCancelar);
        panelPrincipal.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)panelPrincipal, "Center");
        this.getContentPane().add((Component)panelBotones, "South");
        this.pack();
        this.botonCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (AddIrcNetworkWindow.this.editMode = true) {
                    madre.addIrcServerEntry(aEditar);
                }
                AddIrcNetworkWindow.this.dispose();
            }
        });
        this.botonAceptar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IrcServerEntry ise = AddIrcNetworkWindow.this.getEntrada();
                madre.addIrcServerEntry(ise);
                AddIrcNetworkWindow.this.dispose();
            }
        });
    }

    public IrcServerEntry getEntrada() {
        try {
            return new IrcServerEntry(this.serverTextField.getText(), this.portTextField.getText(), this.nickTextField.getText(), this.cbQuery.isSelected(), this.cbChannel.isSelected(), this.cbDCC.isSelected(), this.channelVector);
        }
        catch (NumberFormatException nfe) {
            return new IrcServerEntry(this.serverTextField.getText(), 6667, this.nickTextField.getText(), this.cbQuery.isSelected(), this.cbChannel.isSelected(), this.cbDCC.isSelected(), this.channelVector);
        }
    }
}

