/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.FillElement;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.Stop;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class Gradient
extends FillElement {
    public static final int SM_PAD = 0;
    public static final int SM_REPEAT = 1;
    public static final int SM_REFLECT = 2;
    int spreadMethod = 0;
    public static final int GU_OBJECT_BOUNDING_BOX = 0;
    public static final int GU_USER_SPACE_ON_USE = 1;
    protected int gradientUnits = 0;
    ArrayList stops = new ArrayList();
    URI stopRef = null;
    protected AffineTransform gradientTransform = null;
    float[] stopFractions;
    Color[] stopColors;

    public void loaderAddChild(SVGLoaderHelper helper, SVGElement child) throws SVGElementException {
        super.loaderAddChild(helper, child);
        if (!(child instanceof Stop)) {
            return;
        }
        this.appendStop((Stop)child);
    }

    protected void build() throws SVGException {
        String strn;
        super.build();
        StyleAttribute sty = new StyleAttribute();
        if (this.getPres(sty.setName("spreadMethod"))) {
            strn = sty.getStringValue().toLowerCase();
            this.spreadMethod = strn.equals("repeat") ? 1 : (strn.equals("reflect") ? 2 : 0);
        }
        if (this.getPres(sty.setName("gradientUnits"))) {
            strn = sty.getStringValue().toLowerCase();
            this.gradientUnits = strn.equals("userspaceonuse") ? 1 : 0;
        }
        if (this.getPres(sty.setName("gradientTransform"))) {
            this.gradientTransform = Gradient.parseTransform(sty.getStringValue());
        }
        if (this.gradientTransform == null) {
            this.gradientTransform = new AffineTransform();
        }
        if (this.getPres(sty.setName("xlink:href"))) {
            try {
                this.stopRef = sty.getURIValue(this.getXMLBase());
            }
            catch (Exception e) {
                throw new SVGException("Could not resolve relative URL in Gradient: " + sty.getStringValue() + ", " + this.getXMLBase(), e);
            }
        }
    }

    public float[] getStopFractions() {
        if (this.stopRef != null) {
            Gradient grad = (Gradient)this.diagram.getUniverse().getElement(this.stopRef);
            return grad.getStopFractions();
        }
        if (this.stopFractions != null) {
            return this.stopFractions;
        }
        this.stopFractions = new float[this.stops.size()];
        int idx = 0;
        Iterator it = this.stops.iterator();
        while (it.hasNext()) {
            Stop stop = (Stop)it.next();
            float val = stop.offset;
            if (idx != 0 && val < this.stopFractions[idx - 1]) {
                val = this.stopFractions[idx - 1];
            }
            this.stopFractions[idx++] = val;
        }
        return this.stopFractions;
    }

    public Color[] getStopColors() {
        if (this.stopRef != null) {
            Gradient grad = (Gradient)this.diagram.getUniverse().getElement(this.stopRef);
            return grad.getStopColors();
        }
        if (this.stopColors != null) {
            return this.stopColors;
        }
        this.stopColors = new Color[this.stops.size()];
        int idx = 0;
        Iterator it = this.stops.iterator();
        while (it.hasNext()) {
            Stop stop = (Stop)it.next();
            int stopColorVal = stop.color.getRGB();
            Color stopColor = new Color(stopColorVal >> 16 & 0xFF, stopColorVal >> 8 & 0xFF, stopColorVal & 0xFF, this.clamp((int)(stop.opacity * 255.0f), 0, 255));
            this.stopColors[idx++] = stopColor;
        }
        return this.stopColors;
    }

    public void setStops(Color[] colors, float[] fractions) {
        if (colors.length != fractions.length) {
            throw new IllegalArgumentException();
        }
        this.stopColors = colors;
        this.stopFractions = fractions;
        this.stopRef = null;
    }

    private int clamp(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public void setStopRef(URI grad) {
        this.stopRef = grad;
    }

    public void appendStop(Stop stop) {
        this.stops.add(stop);
    }

    public boolean updateTime(double curTime) throws SVGException {
        String strn;
        int newVal;
        boolean stateChange = false;
        StyleAttribute sty = new StyleAttribute();
        boolean shapeChange = false;
        if (this.getPres(sty.setName("spreadMethod")) && this.spreadMethod != (newVal = (strn = sty.getStringValue().toLowerCase()).equals("repeat") ? 1 : (strn.equals("reflect") ? 2 : 0))) {
            this.spreadMethod = newVal;
            stateChange = true;
        }
        if (this.getPres(sty.setName("gradientUnits")) && (newVal = (strn = sty.getStringValue().toLowerCase()).equals("userspaceonuse") ? 1 : 0) != this.gradientUnits) {
            this.gradientUnits = newVal;
            stateChange = true;
        }
        if (this.getPres(sty.setName("gradientTransform")) && (newVal = Gradient.parseTransform(sty.getStringValue())) != null && newVal.equals(this.gradientTransform)) {
            this.gradientTransform = newVal;
            stateChange = true;
        }
        if (this.getPres(sty.setName("xlink:href"))) {
            try {
                URI newVal2 = sty.getURIValue(this.getXMLBase());
                if (newVal2 == null && this.stopRef != null || !newVal2.equals(this.stopRef)) {
                    this.stopRef = newVal2;
                    stateChange = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Iterator it = this.stops.iterator();
        while (it.hasNext()) {
            Stop stop = (Stop)it.next();
            if (!stop.updateTime(curTime)) continue;
            stateChange = true;
            this.stopFractions = null;
            this.stopColors = null;
        }
        return stateChange;
    }
}

