
rooms.vault = () => {

    stdlib()
    immobile('the vault', `you couldn't move the vault, even with an army to help you`)

    const gems = ['d', 'h', 'c', 's'].map(m => {
        if (game?.dos_mode) {
            if (m === 'd') {
                return ' ';
            }
            if (m === 'h') {
                return ' ';
            }
            if (m === 'c') {
                return ' ';
            }
            if (m === 's') {
                return ' ';
            }    
        } else {
            if (m === 'd') {
                return '♦️';
            }
            if (m === 'h') {
                return '♥︎';
            }
            if (m === 'c') {
                return '♣';
            }
            if (m === 's') {
                return '♠️';
            }
        }
    }).join('');

    header('Before the Great Vault of Yurf')

    set_exits('south')

    preview('s', 'return to the throne room')
    check('s', () => nav('throne'))

    preview('open', 'open the vault')
    check('open', () => `The enormous door won't budge. Perhaps the inscription would be helpful here?`)

    preview(['read', 'examine'], 'read the inscription')
    check(['read', 'examine'], () => `
    The inscription reads:
    <div class='scrawl'>
    Only the adventurer with the four gems can open the Vault of Yurf.
    </div>
    `)

    return `
    Rising in a majestic slab before you is a mountainous mound of marble, set in
    which is a massive metal door. Below the door is a panel with indentations
    in four shapes:
    <p>${gems}</p>
    <p>An inscription is set below the panel.</p>
    `

}
