

function with_the_king() {

    person('the king', `Doing that to the king may be unwise.`)

    blues('give the blues to the king', () => `
        The king sees the blues you're carrying and sobs an
        unintelligible reply.
    `)

    preview('talk', `converse with the wet weeping mound that is apparently the king`)
    check('talk', () => looping([
        `
        "You're ${game.player_name}, aren't you?" says the king. "I suppose I should be thanking you
        for the attempt to save my kingdom." Then, a fresh assault of tears. "But it's so hopeless!"
        `,
        `
        "Oh, ${game.player_name}, it's just so impossible!" he says. "The last I heard, the color
        bug had one gem, and the Air to the Throne made off with another. And only the
        wisest can make their way into the Mathegarden..."
        `,
        `
        "Go see the vault to the north of if you wish," says the king, "But don't you dare
        enter the forbidden chamber!" His expression grows dark. "No-one is permitted in there,
        without my express permission."
        `
    ]))

}


rooms.throne = () => {

    header('The Throne of Endless Happy Sunshine')

    set_exits('west, south, north')

    stdlib()
    cant_go(`a palace wall prevents movement that way`)

    if (!game.boss) {
        preview('hint', `no hints available here`)
    }
    
    with_the_king()

    preview('w', `enter the forbidden room`)
    check('w', `
    "Stop!" cries the King. "You must not enter the
    forbidden room. No-one goes in there without my
    express permission!"
    `)

    preview('examine', `admire beautiful painting`)
    check('examine', () => {
        return `
        <div class="painting">
            <img src="./pond.jpg" alt="The Palace Painting" class="painting-img" />
        </div>
        <p>
        "Nice, isn't it?" bleats the king. "I have a bridge just like it in
        my courtyard. "The queen and I used to go there all the time." And on
        mentioning the queen, he wails even harder than before.
        `
    })

    preview('smell', 'smell the air');
    check('smell', `The palace smells like waffle cone and sadness.`);

    preview('s', `leave the King`)
    check('s', () => nav('palace'))

    preview('n', `enter the vault room`)
    check('n', () => nav('vault'))


    return `The King sits on his throne, sobbing furiously. Everything
    he's wearing is stained with tears, which pour in great drops like
    rain in a thunderstorm. No amount of ice cream sundae will make him feel better.
    <p>
    On the wall is a familiar looking painting.
    </p> `

}
