

function queen_explains_everything() {
    const b = set_verses(broken());
    game.burn = true;
    award('burn')
    return `She sets down her paintbrush with a heavy sigh. "Ok... There is
    one thing we could try.
    <p>
    "I have an old love poem the king gave me years ago. It was brilliant, and romantic, and perfect...
    but somehow, it got damaged. There's a possibility that if you can
    fix the poem, we just might, perhaps, get the heart-stone fused back together
    and save the kingdom." Her tone sharpened. "But with that pig-headed jerk on
    the throne, I wouldn't count in it."
    </p>
    <p>
    She procures a small box with a royal insignia on it. "Here, this may be
    helpful. I swiped it before that lousy Humphrey kicked me out. Because he's
    the king of sunshine, well, let's say he had a weird obsession with burning
    things.
    </p>
    <p>
    "This is his old tinder box. He used to use to a lot--maybe too much. So, I
    grabbed it on my way out and put a safety on it. Now, it can only burn
    <i>useless things</i>. It still works fine, but with the safety, I don't
    think he'll want to play with it anymore. You can have it."
    </p>
    <p>
    She hands you the tinder box.
    ${aside(`You now have the tinder box. You can burn (only truly useless things)
    by typing the <span class="key-command">burn</span> command.`)}
    </p>
    <p>
    She goes back to her painting, then realizes she forgot something. "Oh, and
    I suppose you'll be needing the poem."
    ${b}
    The queen shakes her head and tsk's. "What a mess. Somebody got food all over it.
    You'll probably have to take this into a poetry professional to get it right again."
    `
}


rooms.studio = () => {


    stdlib()
    header('Studio of the Moon Tower')
    cant_go(`that would send you into a gallery wall`)

    set_exits('north (or exit)')

    if (!game.boss) {
        preview('hint', `get a hint`)
        check('hint', () => `
            The queen will tell you what you need to do.
        `)
    }

    preview('smell', 'smell the studio');
    check('smell', `It smells of old leather and paint oil.`);

    preview('examine', `admire the painting on the wall`)
    check('examine', () => `
    <div class="painting">
        <img src="./starry.jpg" alt="Starry Night" class="painting-img" />
    </div>
    "Do you like it?" asks the queen. "It's not mine; I've been
    studying it for years."
    `)

    preview(['n', 'exit'], `leave the gallery`)
    check(['n', 'exit'], () => {
        if (!game?.poem_fixed) {
            on_exit(() => `
            "See you later," calls the queen from her easel.
            `)
        } else {
            on_exit(() => `
            "You're amazing!" cries the queen as you leave.
            `)
        }
        nav('antechamber')
    })


    preview('talk', `converse with the queen`)

    blues('give the blues to the queen', () => `
    "I don't need to be in a worse mood," says the queen.
    `)

    if (!game?.poem_fixed) {
        check('talk', () => stop_list([
            `"Don't even think of trying such a silly idea," says the queen, you
            not being clear about what idea she's referring to.`,
            queen_explains_everything,
            `"Don't you have a kingdom to save?" she says coldly. "Go fix that poem.
            That'll be tough--you may have to get someone (or maybe several someones) who
            know about poetry to help you."`
        ], 'first_queen_talk'))    
    } else {
        const c = set_verses(correct());
        check('talk', () => stop_list([
            `
            "You got it!" exclaims the queen, grabbing the poem. "Incredible! I didn't think this
            could ever be fixed."
            ${c}
            <p>
            She shrugs. "Maybe there's hope after all. Maybe this old broken heart... I don't know.
            It all seems so impossible."
            </p>
            <p>
            The queen turns to look at you. "But I made an agreement. If you can get the king to the vault in his palace, with
            the other gems, it may be worth a try. I promise I won't let you down, ${game.player_name}."
            </p>
            `,
            `
            "If you can get the spade, clubs, and diamonds gems to the vault, with the king, I'll
            meet you there," says the queen. "And I'll bring my broken heart."
            `
        ], 'talk_to_queen'))   
    }


    const desc = `
    The antechamber gives way to a tall round chamber lit by the soft
    glow of moon blooms, freshly cut and arranged in narrow vases.
    Most of the walls are consumed long round-top windows, but what
    little space remains is covered by paintings. The open windows
    permit a good deal of fresh lunar air, which mingles with the
    comforting scent of smoke off a merry little hearth.
    `

    return first_time(`
    ${desc}
    <p>
    The Queen of Night stands at the center, clad in an extraordinary
    black dress that sparkles in the dim light. Her skin is pale, her
    eyes sharp and wide, so dark they nearly appear as dots on her face.
    Her hair is tied in a tight golden crescent. In her hand is a paintbrush,
    and before her a splattered oil canvas. Dabbing with short, intense
    stokes of black paint, her already black landscape becomes even blacker.
    </p>
    <p>"Nice to meet you, at last", says the queen. "I suppose you're here to save
    the kingdom by getting me back together with my rotten husband, the king?
    Well, it won't work."
    </p>
    <p>Hanging on the edge of her easel is a chain attached to a gem in the
    shape of a half a heart. "As you
    can see, the king broke my heart. Then he banished me. There's no getting us
    back together, even if it does save the kingdom."
    `) ?? `
    ${desc}
    <p>
    The queen is presently absorbed in her painting.
    </p>
    `

}


