

rooms.quarters = () => {


    stdlib()
    header('Abord the Ship')
    cant_go(`a bulkhead stands in your way`)

    if (!game.boss) {
        preview('hint', `get a hint`)
        check('hint', () => `
        Try leaving the quarters.
        `)
    }

    const content = `There's the bunk you woke up
    in, and a porthole providing a thin strip of pale light.`

    set_exits('south (or exit)')

    preview('examine', `peer through the porthole`)
    check('examine', () => `
        You peer through the glass...
        <p>Night sky surrounds the vessel on all sides! The ship sails an ocean
        of clouds and stars, headed for a great looming moon, bigger than
        you've ever seen before. Porpoises leap and play next to the glass, as
        the earth continues to shrink into a distant shadow below.</p>
    `)

    preview(['s', 'exit'], `exit quarters`)
    check(['s', 'exit'], () => {

        on_exit(() => `
        You hear footsteps approaching as you prepare to leave. The
        door swings open to reveal a short young woman with dark features. She is clad
        in spotless uniform of deep crimson and glittering gold, and a felt three-corner hat.
        <p>"Ah, you're looking much more awake!" she says. "It's not every
        day we find stowaways stuck to the hull!</p>
        <p>"I'm Captain Bedeilia, and you're found yourself on the good airship
        <i>Soaring Narwhal</i>!" she says, shaking your hand. "I don't believe I caught your name."</p>
        ${aside(`Type your first name or favorite nickname below.`)}

        `)
        nav('name_entry', { silent: true, show_header: false })
    })

    return first_time(`
    You awaken in a bunk, on what appears to be a wooden ship.
    A porthole on the wall provides a narrow strip of light.
    `) ?? content;
}


