
const poem_puzzle_finished = () => {

    const scr = [...game.scratch];
    let text = set_verses(broken())
    for (const word of game.scratch) {
        text = text.replace(word, `<s>${word}</s>`)
    }
    const correct_check = () => {
        return (scr.indexOf('taco') > -1) &&
        (scr.indexOf('hamburgers') > -1) &&
        (scr.indexOf('doughnut') > -1) &&
        (scr.indexOf('waffles') > -1);   
    }
    game.scratch = [];
    if (correct_check()) {
        game.poem_fixed = true
        award('poem fixed')
        return `
        ${set_verses(correct())}
        <p>"That looks good!" cries the Editor.</p>
        <p>"Much better!" agrees the Thesaurus.</p>
        <p>"Glad to be of service!" says the Auntonym. "The poem is now in good repair."</p>
        `
        
    } else {
        return `
        ${text}
        <p>"No, that's not right," says the Thesaurus.</p>
        <p>"Must be a matter of the wrong words," says the Auntonym.</p>
        `
    }

}


rooms.poem_puzzle_check = () => {

    if (game?.poem_word) {
        if (game?.poem_word === 'the') {
            on_exit(() => `
            "Hey, don't touch that word, it's fine," says the Thesaurus.
            `)
        } else {
            game.scratch.push(game.poem_word)
        }
    }
    game.poem_word = undefined;

    if (game.scratch.length === 4) {
        const d = poem_puzzle_finished();
        nav('picnic', { show_header: false, silent: true })
        return d;
    }
    nav('poem_puzzle')

}


rooms.poem_puzzle = () => {

    let text = set_verses(broken())

    for (const word of game.scratch) {
        text = text.replace(word, `<s>${word}</s>`)
    }

    if (game.scratch.length < 4) {
        record_val('poem_word', 'poem_puzzle_check', { show_header: false })
    }
    
    return `
    ${text}
    ${aside(`Type the next word that should be removed.`)}
    `
}
