

function edx1() {
return `
You arrive in a shady part of the forest, where a small patch of grass rolls with
soft muted moss roses. A wooly mammoth, a dinosaur, and a woman are seated on a 
blanket on the ground, apparently having a picnic. The mammoth is wearing a slovenly satin puff tie with a
shapeless cotton black vest and a filthy derby hat.
The dinosaur somewhat resembles a stegosaurus, and has the words
<i>et cetera</i> printed in big black lettering on his side. The woman is wearing an array of floral scarves,
with a wide wonderful straw hat festooned with flowers.`;
}


function edx2() {
const ed = (game?.editor) ?? 'the mammoth';
const th = (game?.thesaurus) ?? 'the dinosaur';
const au = (game?.auntonym) ?? 'the woman';
return `
The picnic continues in the shady woods. Sprawled on a blanket, ${ed},
${th}, ${au} don't appear to be accomplishing much beyond consuming
great quantities of lunch-meat and shouting about iambic pentameter.
`;
}

function ed_talk_1() {
game.editor = 'the Editor';
game.thesaurus = 'the Thesaurus';
game.auntonym = 'the Auntonym';
return `
"We a visitor!" cries the mammoth.
<p>The dinosaur raises his head to speak:</p>
${get_poem_lines('traveler')}
<p>He then lowers his head. "What he means to say is 'we <i>have</i> a visitor,'" says the dinosaur.
"My friend never knows when to stop chopping words."</p>
<p>"Too many words!" says the mammoth.</p>
<p>The woman clears her throat. "A proper introduction is warranted," she says.
"Our pachyderm is none other than the Editor. Our dear dinosaur is, of course,
the famous Thesaurus. My role here is to keep the peace between these two.
I am called the Auntonym. Perhaps you've heard of me."</p>
<p>The Editor rolled his trunk incredulously. "You're such a homophone." Then he looks at you.
"Thine unto shambled cabbages."</p>
<p>"He means to say we're pleased to meet you," says the Auntonym. "Forgive him dear,
he is graduated from an antiquated institute of education."</p>
<p>"Too many words!" cries the Editor. "Old school!"</p>
<p>"We're on break right now," says the Thesaurus, in between swallows of black coffee,
which they consume from a great steaming pot.</p>`
}


function ed_talk_2() {
return `
"What do we do?" asks the Editor in surprise. "What do you mean, what do we do?
Why, we do the most important work there is: removing needless words!"
<p>The Thesaurus raises his head, in a most solemn fashion:</p>
${get_poem_lines('jubjub')}
<p>"The Editor takes his job very seriously," says the Auntonym. "We all do."</p>
<p>"It's an important job," says the Thesaurus, "or should I say a distinguished role."</p>
<p>"I'll say!" says the Editor, spewing coffee from his mouth mid-gulp all over the
Thesaurus. The Auntonym wipes off the ever-reddening dinosaur with a handkerchief.</p>
<p>"Why, imagine a world where Moby Dick was twice as long," says the Editor. "Or War and Peace.
What if you had to listen to all 12 of Jane Eyre's favorite pudding recipes? She can recite them
from memory, you know!</p>
<p>"Good words are <i>terse</i> words," he says. "Clean, elegant, efficient! That's what we do!"</p>
<p>"Or," adds the Thesaurus, "Tidy, graceful, capable."</p>
<p>"Not everyone has the horse cents we do," says the Auntonym, perusing her bag full of
horse-head pennies. "It's our calling."</p>
`
}


function ed_talk_3() {
return `
"Dickens, I can tolerate," says the Editor with a slurp of coffee. "Or Jane Austen."
<p>"But don't get him started on James Michener or Robert Jordan," says the Thesaurus.
"You'll be here till next Thursday at the earliest."</p>
<p>The Auntonym nods. "Yes, please don't. We've supposed to get back to work sometime today."</p>`
}


function ed_talk_4() {
   return `
   "Have you been to the field east of the border?" asks the Auntonym. "That's where people used
   to hop to the moon."
   <p>"Not all the way," says the Thesaurus. "They had help from the --"</p>
   <p>"Too many words!" clipped the Editor.</p>
   <p>"It's still a good place to get a good flying leap," says the Auntonym. "Lots of fun, and
   vigorous exercise is a fine curative for rheumatism."</p>
   <p>The Thesaurus raises his head, in a most solemn fashion:</p>
   ${get_poem_lines('stars')}
   `
}


function ed_poem_1() {
   return `
   "Of course, everyone knows why our kingdom is falling apart," says the Auntonym.
   <p>The Thesaurus raises his head, in a most solemn fashion:</p>
   ${get_poem_lines('shay')}
   `
}


function ed_poem_2() {
   return `
   "There are a lot of words at this picnic," growls the Editor.
   <p>The Thesaurus raises his head, in a most solemn fashion:</p>
   ${get_poem_lines('bells')}
   `
}


function lower(s) {
   const f = s[0].toLocaleLowerCase();
   const m = s.substring(1);
   return `${f}${m}`;
}


rooms.picnic = () => {

   stdlib()
   immobile('the picnickers', `the picnickers would not appreciate that`)
   header("At the Picnic")
   cant_go(`the trees are too thick for travel much beyond the picnic spot`)
   set_exits('south')

   const ed = (game?.editor) ?? 'the mammoth';
   const th = (game?.thesaurus) ?? 'the dinosaur';
   const au = (game?.auntonym) ?? 'the woman';

   if (!game.boss) {
      preview('hint', `no hints available here`)
   }
   
   preview('s', `south into the woods`)
   check('s', () => nav('qwerti'))

   blues('give the blues to the picnickers', () => `
   Raising his head, ${lower(th)} gains to speak:
   ${get_poem_lines('bells')}
   <p>
   "He means to say that we don't need any blues," says the Auntonym.
   </p>
   `)

   preview('examine', `examine the picnickers`)
   check('examine', () => `
   "What are you looking at?" asks ${lower(ed)}.
   <p>
   "Humans have no manner of manners," says ${lower(th)}.
   </p>
   <p>
   "We're not all like that" says ${lower(au)} with a harrumph.
   </p>
   `)

   preview(['drink', 'consume'], `drink some coffee`)
   check(['drink', 'consume'], () => `
   "Where are my manners? Care for some coffee?" asks ${lower(th)}.
   <p>The black coffee is ludicrously strong, but delicious.</p>
   `)

   preview('eat', `eat some of the picnic food`)
   check('eat', () => `
   Every time you look to take a small nibble, the food is gobbled up
   before you, but more provisions seem to continuously appear from
   no-where.
   `)

   preview('smell', 'smell the picnic');
   check('smell', `It smells of coffee and old dictionaries.`);


   preview('talk', `converse with the picnic-enjoyers`)
   if (!game?.editor) {
      
      check('talk', () => stop_list([
         ed_talk_1(),
         ed_poem_1(),
         ed_talk_2(),
         ed_talk_3(),
         ed_poem_2(),
         ed_talk_4()
      ]));
   } else {
      check('talk', () => stop_list([
         ed_poem_1(),
         ed_talk_2(),
         ed_talk_3(),
         ed_poem_2(),
         ed_talk_4()
      ]));
   }

   if (game?.burn && !game?.poem_fixed) {

      if (!game?.editor) {

         check('talk', ed_talk_1)

      } else {

         if (!game.boss) {
            preview('hint', `get a hint`)
            check('hint', () => `
            Talk with them about that broken poem the queen gave you.
            `)
         }

         preview('talk', `show the poem to the picnic-enjoyers`)
         check('talk', () => {
            on_exit(() => `
            "What a mess of a poem," comments the Auntonym.
            <p>
            "Pretty rough," says the Thesaurus.
            </p>
            <p>
            "Too many words!," cries the Editor.
            </p>
            `)
            nav('poem_puzzle', {show_header: false})
         })
         
      }

   }
   const desc = first_time(edx1()) ?? edx2();
   return desc

}


