

function owl_speak(content) {
    return `<span class='owl-speak'>${content}</span>`
}


rooms.mathegarden = () => {

    stdlib();
    header('Mathegarden');
    set_exits('north');
    cant_go(`the garden fades into a haze of fuzzy logic that way`)

    preview('n', `north to the forest`);
    check('n', () => nav('math_entrance'));
    preview('mlotz', `smother numbers in custard`);
    check('mlotz', `
    "Don't you dare," says the Mathegardener. "Bothersome number custard-smotherer."
    `)

    if (!game.boss) {
        preview('hint', `no hints available here`)
    }

    mathegardener();

    preview('smell', `sniff the air`);
    check('smell', `
    Ah, the gentle scent of freshly cut fractions.
    `);

    preview('lick', `taste the Mathegarden`);
    check('lick', `
    It tastes exactly as one would expect math to taste.
    <p>
    The Mathegardener gives you a quizzical sidelong glance and keeps tilling.
    </p>
    `);

    const gem = spades_gem();

    const desc = `
    The bramble gives way to a sweeping garden paradise. Everywhere there are
    exquisite blooms--2's, 5's, 8's, and every other number imaginable.
    Beds of integers blossom next to arranged bouquets of freshly cut fractions
    in ornate vases,
    filling the air with rich perfume. Tall trees with thin bark grow long
    wispy digits that drooped almost to the emerald green grass.
    ${gem}
    `

    return first_time(`${desc}
    <p>
    A tall slender woman approaches. Ivory hair pours on her shoulders from
    beneath her wide straw hat. Her lined, smiling face and rosy cheeks
    speak to years tending blooms in the sun.
    </p>
    <p>
    "Ah, a visitor," she says as an owl comes to perch on her shoulder. "Even though
    I posted three guards to prevent anyone from entering not just this morning. Looks
    as though our friend subtracted 3 to none, eh 0wlgebra?" 
    </p>
    <p>
    ${owl_speak(`000`)} ${owl_speak(`000`)} ${owl_speak(`000`)} the owl nodded, clearly understanding every word.
    </p>
    <p>
    "Allow me to introduce myself," says the woman. "I am the Mathegardener.
    I grow 6's to 7's and 10's into 11's. My gift is for numbers, budding, blooming, or otherwise,
    but I'm also not bad at sizing up people." Her eyes narrow on you intently. "What do you think of
    our intruder, 0wlgebra?"
    </p>
    <p>
    ${owl_speak(`000`)} says 0wlgebra.
    </p> 
    <p>
    The Mathegardener nods. "Quite right."
    </p>
    `) ?? `
    ${desc}
    <p>
    The Mathegardener quietly tills the soil, while 0wlgebra watches perched on a branch.
    </p>
    `

}
