
const guards_desc = `

Three fierce guards come running from the south, their swords
drawn! Each looks bigger and more terrible than the last.
<p>
"You can't just enter the Mathegarden unannounced!" says the first guard.
</p>
<p>
"Certainly not!" cries the second.
</p>
<p>
"Not without solving the Three Guards Riddle" mumbles the third with great
seriousness.
</p>
<p>
"Ours is a riddle to test your wits, and perplex the wisest," all three say
in unison.
</p>
<p>
"One of us always tells the truth," says the first guard.
</p>
<p>
"One of us always lies," says the second guard.
</p>
<p>
"And one always multiplies," says the third guard.
</p>
<p>And, chiming in unison again, all three say:</p>
<p>"Give us a number!"</p>
`


const boss_guards_desc = `

Three fierce guards come running from the south, their swords
drawn! Each looks bigger and more terrible than the last.
<p>
"You can't just enter the Mathegarden unannounced!" says the first guard.
</p>
<p>
"Certainly not!" cries the second.
</p>
<p>
"Not without solving the Three Guards Riddle" mumbles the third with great
seriousness.
</p>
<p>
"Ours is a riddle to test your wits, and perplex the wisest," all three say
in unison.
</p>
<p>
"You must add using only 3's," says the first guard. 
</p>
<p>
"Only with addition!" says the second guard. 
</p>
<p>
"And the answer must be 300," says the third guard. 
</p>
<p>
"Not another, more or less," they all say in unison. 
</p>
<p>
"Oh! and forget to mention," says the first guard. 
</p>
<p>
"You can only use + up to 9 times," says the second guard. 
</p>
<p>
"You can't just do 3+3+3+3+3+3+3 up to 300," says the third guard. 
</p>

`


rooms.math_entrance = () => {

    stdlib()
    header('Shadowy Thicket')
    set_exits('north, south')
    cant_go(`thick bramble and tall trees block your path`)

    immobile('the bramble', 'that has no effect on the bramble');

    preview('smell', 'smell the bramble');
    check('smell', `The bramble smells of old growth.`);

    burn('burn bramble', `
    The bramble refuses to catch fire.
    `)

    preview('n', `to the oak tree`)
    check('n', () => nav('oaktree'))

    if (!game?.guards_puzzle_solved) {

        if (!game.boss) {
            preview('hint', `get a hint`)
            check('hint', () => `
            You need a number that the guards can multiply that always gives the same result,
            no-matter what else they multiply it by.
            `)
        }

    }


    preview('s', `enter the mathegarden`)
    check('s', () => {
        if (!game?.guards_puzzle_solved) {
            if (!game?.boss) {
                on_exit(() => guards_desc)
                nav('three_guards_puzzle', { show_header: false})    
            } else {
                on_exit(() => boss_guards_desc)
                nav('boss_three_guards_puzzle', { show_header: false})
            }
        } else {
            nav('mathegarden')
        }
    })

    return `
    The colors of the forest are darker here--the leaves grow in
    muted tones, and the shrubs produce deep reds and emeralds greens.
    A high thorny bramble rises to the south, looking big and foreboding,
    though a tight passage might permit you to squeeze through.
    `
}
