

function note_box() {
    const notes = [
        '𝆕',
        '𝅘𝅥',
        '𝅗𝅥',
        '𝅘𝅥𝅯',
        '𝄫',
        '𝆕'
    ];
    const times = [
        [250, 500, 750],
        [100, 300, 600, 800],
        [300, 400, 500],
    ];
    const s = shuffle(times)[0].map(time => {
        const note = shuffle(notes)[0];
        const div = `
        <div class='note-div' style="animation-delay: ${time}ms;">
            ${note}
        </div>
        `;
        return div;
    });
    return `<div class="notes-container">
    ${s.join(' ')}
    </div>`
}


function melody_puzzle_unsolved() {
    person('Melody', `she looks like she's already having kind of a rough day`);

    check('examine', `
    Melody keeps looking glumly at a
    blank music sheet, occasionally producing a soft sigh.${note_box()}
    `)


    check('talk', () => {
        const soundy = (game.boss) ? `sharp` : `<i>CRASH</i>`;
        award("melody")
        return stop_list([
        `"You're probably wondering how I fit all this space into that tiny
        clef outside," says Melody. "I always say that music is transformative."${note_box()}`,
        `She dots a few notes on the page, which pop off the paper and fly into the
        air as little piano sounds. <p>"Not right, not right at all," she says in a melancholy tone.</p>${note_box()}`,
        `
        "Maybe you can help me," says Melody. "I find music can come from anywhere.
        Harmony, rhythm, order--these are the very tools of composition found in
        nature itself.
        <p>"I'm trying to create a piece of music based on some pictures I saw at
        an exhibition. Take a look at this picture."</p>
        <div class="painting">
            <img src="./cart.jpg" alt="The Ox Cart Painting" class="painting-img" />
        </div>
        <p>She continues. "I need something big to capture the Ox-Cart... Like a great,
        powerful ${soundy} sound. Do you have a ${soundy} sound I could borrow?"${note_box()}
        `
        ,
        `
        "I'm trying to create a piece of music based on this picture," says Melody.
        <div class="painting">
            <img src="./cart.jpg" alt="The Ox Cart Painting" class="painting-img" />
        </div>
        <p>"Do you have some big ${soundy} sound I could borrow?"</p>${note_box()}
        `
    ])})


    function solve_the_puzzle(st, st2) {
        game.blues = true;
        game.grave_puzzle_solved = true;
        award('received the blues')

        return `A ${st}
        <p>"Wait," says Melody, "Do that again."</p>
        <p>${st2}</p>
        <p>"That's the sound!" she begins dancing on the smudged papers. "That's what I've been
        looking for! What a glorious sound!" cried Melody. "Thank you, thank you, thank you!"</p>
        <p>She hands you the blues. "I won't be needing these anymore!"</p>
        ${aside(`You now have the blues. You can give the
        blues to someone else by typing <span class="key-command">blues</span> at the prompt.`)}
        "If you'll excuse me," says Melody, "I've got some work to do!"
        `
    }


    check('`', () => {
        if (!game.boss) {
            const st = `
            thunderous crash, like a thousand bricks falling through a thousand baubles of
            thin glass, crescendos through the air!
            `
            const st2 = `
            Another thunderous crash, like a thousand bricks falling through a thousand baubles of
            thin glass!
            `
            return solve_the_puzzle(st, st2)
        } else {
            return `
            "Not bad," she says, "But not quite. I need something like that but...
            sharper."
            `
        }
    })


    check('#', () => {
        if (!game.boss) {
            return `
            "Gah!" she cries, "Too sharp!"
            `
        } else {
            return solve_the_puzzle(`sharp slash sound zings through the air!`, `Again, a sharp slash noise zings through the air!`)
        }
    })

}

rooms.inside_conservatory = () => {

    stdlib()
    header('Inside the Treble Clef')
    set_exits('west (or exit)')
    cant_go(`a well-polished wall with perfect acoustics stands in your way`)

    preview(['w', 'exit'], `exit conservatory`)
    check(['w', 'exit'], () => nav('outside_conservatory'))

    preview('smell', 'smell the air');
    check('smell', `It smells of wet ink and piano oil.`);

    let desc = `
    Melody sits at her desk, covered in ink and
    discarded papers, staring at a blank music sheet.
    `
    if (!game?.grave_puzzle_solved) {
        if (!game.boss) {
            preview('hint', `get a hint`)
            check('hint', () => `
            Melody needs a loud sound. What was that sound Bedeilia showed you on the airship?
            `)
        }
        melody_puzzle_unsolved();    
    } else {
        person('Melody', `She's pretty busy.`);
        desc = `Melody is excitedly penning music, scribbling notes as fast as she can
        put them down.`
        check('examine', () => desc)
        check('talk', `
        "Hey, I'm really busy," says Melody. "Can you come back some other time?"
        ${note_box()}
        `)
    }

    preview('examine', `examine Melody`)
    preview('talk', `converse with Melody`)

    blues('give the blues to Melody', () => `
        "No!" she says, "I just got rid of those!"
    `)

    return first_time(`
        ${note_box()}
        You enter the door and find yourself in a sweeping ballroom, huge in size
        compared to the hovering structure outside.
        At the center is a frazzled-looking woman at substantial dark-stained
        teak desk. She is surrounded by papers scribbled all over with black
        ink. In fact, she is rather ink-stained herself; her fingers,
        face and hair are all smudgy.
        <p>"Oh, hello," she says, barely looking up. "You must be that
        new adventurer." She sighs. "I'm Melody. Nice to meet you."</p>
    `) ?? `
    You stand in a vast ballroom that somehow fits inside the tiny cottage floating
    over the pond.
    ${note_box()}
    <p>${desc}</p>`
}
