
rooms.gate = () => {

    header('The Very Large Scary Gate')

    set_exits('west, east')

    stdlib()
    cant_go(`a thicket of trees stands in your way`)

    preview('smell', 'smell the gate');
    check('smell', `Smells like an obstacle.`);

    preview('w', `to the moat`)
    const burned = (game?.gate_burned);
    if (!burned) {
        if (!game.boss) {
            preview('hint', `get a hint`)
            check('hint', () => `
            You need something to get rid of that door. If only you had the capacity to set useless things on fire...
            `)
        }

        check('w', () => `Did I mention the huge shut gate in the way?`)
        preview('open', `the gate is very, very covered with huge wooden boards`)

        preview('examine', `examine the very massive gate`)
        check('examine', () => `
            The gate is heavily boarded with big oily timber planks. You'd need to burn it down
            to pass.
        `)
        
        preview('read', `hmmm what does this gate say`)
        check('read', () => `
            You read the warnings on the gate for a while, and decide someone doesn't
            want visitors.
        `)
    } else {
        check('w', () => nav('moat'))
    }

    if (game?.burn) {
        preview('burn', `light heavily boarded gate on fire with the tinder box`)
        check('burn', () => {
            game.gate_burned = true;
            award("gate")
            return `
            FOOM! The gate explodes into flames and the fire devours the oily timbers, revealing
            passage to the west!
        `})    
    }

    preview('e', `head up the hill`)
    check('e', () => nav('hilltop'))
    

    return (!burned) ? `
    A tall stone wall divides the forest, with a massive oak door
    blocking passage to the west. It is heavily boarded with thick oily timbers, and covered with warnings
    like "No trespassers!" and "Visitors not permitted,
    especially the Queen!" in hasty scrawl.
    `:
    `
    A tall stone wall divides the forest, broken only by the remaining
    ashes of the door you burnt down.
    `

}
