

rooms.boss_finalize_bridge_name = () => {

    const n = game.boss_bridge_name ?? '';
    const m = n.split('');
    let v = 'jb ch r kp i qu d vw g xy ez';
    for (const c of m) {
        v = v.replace(c, ' ');
    }
    while (v.indexOf(' ') > -1) {
        v = v.replace(' ', '');
    }

    if (strcmp(v, 'bridge')) {
        game.bridge_built = true;
        award("bridge")
        nav('moat', { silent: true, show_header: true })
        return `
        Emilio grins. "That's it! Of course! The bridge is already there, I just
        have to remove the extra letters!"
        <p>
        He sets to work quickly, and when the eraser shavings are cleared,
        a fine serviceable <kbd>bridge</kbd> remains.
        </p>
        <p>
        "Finished!" Emilio cries, exhausted. "A masterpiece, if I do
        say so myself." He strides off, head held high.
        </p>
        <p>
        Congratulations, you have abridged the moat!
        </p>
        `
    } else {

        nav('moat', { silent: true, show_header: true })
        return `
        Emilio sets to work with his eraser:
        <p>
        ${v}
        </p>
        <p>
        "No," he says, "That's no manner of bridge at all!"
        </p>
        `;

    }

}



rooms.finalize_bridge_name = () => {

    const v = game.bridge_name ?? '';

    if (strcmp(v, 'drawbridge') || strcmp(v, 'draw')) {
        game.bridge_built = true;
        award("bridge")
        nav('moat', { silent: true, show_header: true })
        return `
        Emilio grins. "That's it! Of course! I need to just <i>draw</i> a bridge!
        That's what I'm good at!"
        <p>The artist goes to work. He draws at a furious pace, scribbling
        pencil lines, inch by inch over the water, until...</p>
        <p>"Finished!" Emilio cries, exhausted. "A masterpiece, if I do
        say so myself." He strides off, head held high.</p>
        You're not so sure yourself. Sure, it seems plenty sturdy, and will
        likely be a serviceable bridge. Still, it seems a bit sketchy.
        `
    } else {

        const arr = [
            `
            "I don't know how to build that," says the artist.
            "I don't know how to build anything."
            `,
            `
            "I draw! I sketch! I even doodle on occasion!" cries the artist.
            "But how to I build <i>that</i> with this.
            `,
            `
            Emilio is too upset to even consider that.
            `
        ]
        nav('moat', { silent: true, show_header: true })
        return looping(arr);

    }

}
