
rooms.edge = () => {

    header('The Edge of the Earth')

    set_exits('west')

    stdlib()

    preview('n', `there is no path into the shadows to the north`)
    preview('s', `there is no path into the shadows to the south`)
    preview('e', `the land ends eastwards`)
    preview('w', `return to the forest`)
    check('w', () => nav('border'))

    if (!game.boss) {
        preview('hint', `get a hint`)
        check('hint', () => `
        You need <i>another</i> hint? Okay, take a flying leap.
        `)
    }

    preview('smell', 'smell the air');
    check('smell', `The air carries the fragrance of soft rain and moonlight.`);

    preview('jump', `leap into the expanse`)
    check('jump', () => {
    
        if (!game?.leaped) {
            game.leaped = true;
            nav('first_leap')
        } else {
            on_exit(() => `You leap into the air, rising high into the clouds, where
            you grip onto the rigging of the <i>Soaring Narwhal</i>.
            <p>
            ${looping([
                `
                "Welcome back aboard the <i>Soaring Narwhal</i>!" cries Bedeilia.
                "We're happy to help you anytime, ${game.player_name}!"
                `,
                `
                Bedeilia gives a little salute. "Glad to see you again, ${game.player_name}.
                The <i>Soaring Narwhal</i> is at your service!"
                `,
                `
                "Good tidings I hope, ${game.player_name}," says Bedeilia.
                "Any further along on saving the kingdom?"
                `,
            ])}
            </p>`)
            nav('sea_of_shadows')
        }

    })

    return `The land fades to darkness, where to the west is trees and sunlight,
        the ground turns into night and stars to the east. Even gravity
    is different--walking about feels almost like bouncing, as though
    your body is nearly lighter than air.`

}
