

rooms.boat_ride_next_scene = () => {

    header('')
    preview('drift', `drift down the rolling waters`)
    check('drift', () => {
        on_exit(() => `
        "Tour's over!" says the Mathegardener, snapping out of her
        daze. "Back to work, I suppose. 0wlgebra, give us a quick logarithm back
        to the rhombus, huh?"
        <p>
        ${owl_speak(`000`)} affirms 0wlgebra. Strangely, the river is gone, along wih the 12.345.
        You're right back where you started.
        </p>
        <p>
        "Can't lollygag around all day," says the Mathegardener. "We're very coefficient around here."
        </p>
        `)
        nav('mathegarden');
    })
    set_exits('')
    
    const song = `${set_verses(song_of_the_number_mites())}`;

    return `
    <div class='dropcaps'>
    The 12.345 drifts merrily along the rushing gray waters, and the great trees
    grow bigger and sparser along the banks. Soon, the rolling green hills of
    integers, glistening in the sun, give way to long low plains of dewey decimals.
    </div>
    <p>
    "Exquisite, isn't it?" says the Mathegardener. "I've worked for years to craft the
    perfect garden. It goes on for miles, perhaps forever, like numbers themselves."
    </p>
    <p>
    ${owl_speak(`000`)} contributes 0wlgebra.
    </p>
    <p>
    "Indeed," says the Mathegardener. "It is worth protecting."
    </p>
    <p>
    The garden becomes less manicured, and more wild, growing dense with primes and
    strange blooms like imaginary numbers and irrationals. Odd numbers particularly flourish here.
    </p>
    <p>
    The Mathegardener's eyes glaze off with the swirling currents, and she begins to hum
    a bit of verse:
    </p>
    ${song}
    ${aside(`Type <span class="key-command">drift</span> to continue.`)}
    `

}



rooms.boat_ride = () => {

    header('')
    preview(['leap', 'hop', 'jump', 'bounce', 'boing'], `hop on board`)
    check(['leap', 'hop', 'jump', 'bounce', 'boing'], () => {
        nav('boat_ride_next_scene', { show_header: false })
    })
    set_exits('')

    game.boat_ride = true;
    
    return `
    "Never been to the Mathegarden before?" asks the gardener.
    <p>
    ${owl_speak(`000`)} cries 0wlgebra curiously.
    </p>
    <p>
    "Then it's time for a tour. Come with me."
    </p>
    <p>
    She leads through the vast garden, where numbers bloom exuberantly on every tree, shrub and bush.
    The colors are vivid, and the rolling hills are lush and green with short, dew-coated integers.
    </p>
    <p>
    "We have reason to be careful," she says. "We're always on the lookout for number mites.
    0wlgebra helps keep 'em at bay. Don't you, my little friend?"
    </p>
    <p>
    ${owl_speak(`000`)} 0wlgebra cheerfully chirps.
    </p>
    <p>
    Presently you arrive at a long, flowing channel with a weathered dock. Tied to the dock
    is a number, bobbing up and down the water: 12.345.
    </p>
    <p>
    The Mathegardener hops on the number and beckons you to join. "Come aboard," she
    says. "Don't worry, this number won't sink. It's a very good floating point number."
    </p>
    ${aside(`Type <span class="key-command">hop</span> to continue.`)}
    `

}
