
rooms.antechamber = () => {

    header("The Queen&rsquo;s Antechamber")

    set_exits('south (or enter)')

    stdlib()
    person('Boz', `Boz does not appear amused by your shenanigans.`)
    cant_go(`a cold, riveted metal wall stands in your way`)

    if (!game.boss) {
        preview('hint', `get a hint`)
        check('hint', () => `
        You've come this far, go in and talk to the queen!
        `)
    }

    preview('talk', `converse with Boz`)
    check(`talk`, () => {
        on_exit(() => `"Ready to go?" he asks. "I can take you back out to the courtyard again."`)
        nav('at_the_tower')
    })

    preview(['s', 'enter'], `enter the Queen's studio`)
    check(['s', 'enter'], () => nav('studio'))

    preview(['read', 'examine'], `Read the plaque`)
    check(['read', 'examine'], `
    <i>The night is not evil</i>
    <div><i>Not all darkness is bad</i></div>
    <div><i>The moon rises only in twilight</i></div>
    <div><i>And the stars are totally rad!</i></div>
    `)

    preview('smell', 'smell the air');
    check('smell', `It smells of old leather and paint oil.`);

    const first = first_time(`<p>"Come in," chimes a sweet, dignified voice
    in the next room.</p>`) ?? '';

    return `
    Pillars of black marble lavished with gold reach to a curved paneled
    ceiling glittering with small cold blue gems, evoking the stars
    on a clear winter's night. On the wall is a bright, floral painting of
    a bridge in a garden. Over the entrance of to the studio is a plaque
    inscribed with a bit of verse.

    <p>Boz watches you with some mild interest.</p>
    ${first}
    `

}
