
function rnd_int(max) {
  return Math.floor(Math.random() * max) + 1;
}



rooms.boss_finalize_guards_answer = () => {

    if (game.boss_guards_number === '33+33+33+33+33+33+33+33+33+3') {

        on_exit(() => `
        "Heavens!" thunder all three at once. "The intruder is
        correct! The answer is 300!"
        <p>The guards scramble away, each running faster than the other
        two.</p>
        `)
        award("guards")
        game.guards_puzzle_solved = true;
        nav('mathegarden');

    } else {

        const checkValid = () => {
            if (game.boss_guards_number === '') {
                return false;
            }
            if (game.boss_guards_number.indexOf('+') > -1 && game.boss_guards_number.indexOf('3') > -1) {
                return true;
            }
            return false;
        }

        if (!checkValid()) {

            on_exit(() => `
            "NO!" thunders all three guards at once. "Only 3's and +'s! Begone, intruder!"
            `)    

        } else {

            on_exit(() => `
            "That's not right!" says the first guard.
            <p>"Not at all!" says the second.</p>
            <p>"Begone, intruder!" says the third.</p>
            `)
    
        }

        nav('math_entrance');

    }
    
}



rooms.almost_guards_answer = () => {

    record_val('guards_answer', 'finalize_guards_answer',
        { silent: true, show_header: false })
    const first = rnd_int(9)
    const second = rnd_int(9)
    const n = game.guards_number;

    let sq = `
    "Oh ho!" cries the first guard. "Our intruder
    says ${n}! I say we start with the
    number ${first}."
    `

    if (!is_numeric(n.toString())) {
        sq = `"Oh ho!" cries the first guard. "Our intruder says ${n}!"
            <p>"Thats's not even a number," says the third guard.</p>
            <p>"I say we start with the number ${first},"
            continues the first guard.</p>`
    }

    return `
    ${sq}
    <p>"Lo there!" says the second guard. "Let us add 
    ${second}."</p>
    <p>"And let us multiply by the intruder's number,
    ${game.guards_number}!" says the third guard.
    "Now, what is the answer?"</p>

    ${aside(`Type your answer to the guard's problem below.`)}

    `
    
}


rooms.finalize_guards_answer = () => {

    if (game.guards_number === '0' && game.guards_answer === '0') {

        on_exit(() => `
        "Heavens!" thunder all three at once. "The intruder is
        correct! The answer is zero!"
        <p>The guards scramble away, each running faster than the other
        two.</p>
        `)
        award("guards")
        game.guards_puzzle_solved = true;
        nav('mathegarden');

    } else {

        on_exit(() => `
        "That's not right!" says the first guard.
        <p>"Not at all!" says the second.</p>
        <p>"Begone, intruder!" says the third.</p>
        `)
        nav('math_entrance');

    }
    
}

