
function mathegardener() {

    person('the Mathgardener', `no--something about her intimidates you`)

    preview('examine', `examine the Mathegardener`)
    check('examine', `She crouches in the soil, tilling the earth protected from the bright warm sun
    by her wide straw hat. The quick movements of her hands reflect great skill with her tools:
    dividing numbers with her shears, multiplying seed in the beds. 
    0wlgebra watches carefully from his perch in the trees.`)

    blues('give the blues to the Mathegardener', () => `
        "No thanks," says the Mathegardener. "I prefer my
        fresh air and sunshine to the blues."
    `)

    preview(['eat', 'consume'], `consume the Mathegardener`)
    check(['eat', 'consume'], `
    "You're hungrier than a 7 who saw a 9," says the Mathegardener.
    `)

    preview('smell', 'smell the Mathegardener');
    check('smell', `"Cut that out," she says. "I smell just fine."`);

    preview('talk', `converse with the Mathegardener`)

    if (game?.round_number && game?.blorple_puzzle_solved) {

        check('talk', looping([
            `
            "0wlgebra is a wonderful creature, isn't he?" says the Mathegardener. "Among other things,
            he keeps down the number mites."
            `,
            `
            "Would you look at that, 0wlgebra?" muses the Mathegardener. "One square root of
            2 blossoms."
            <p>
            0wlgebra replies: ${owl_speak(`000`)} ${owl_speak(`000`)}
            </p>
            <p>
            "Yes, agreed," says the Mathegardener, "It's not terribly rational."
            </p>
            `,
            `
            "Goodness, y = 3<i>x</i> + 6!" exclaims the Mathegardener.
            <p>
            ${owl_speak(`000`)} chimes 0wlgebra.
            </p>
            <p>
            "Of course! My precious seedlings will never grow on a slope that steep!"
            </p>
            `
        ]))

    } else if (!game?.blorple_puzzle_solved) {

        if (!game.boss) {
            preview('hint', `get a hint`)
            check('hint', () => `
            Did you talk to Gnomon about the paper he received from the Mathegardener a while back?
            `)
        }

        check('talk', () => {
            on_exit(() => `
            ${owl_speak(`000`)} cries 0wlgebra.
            <p>
            "I don't know if we can trust the intruder," says the Mathegardener.
            "But perhaps a simple puzzle will serve as a test."
            </p>
            <p>
            "Consider this trivial little challenge, my dear trespasser."
            </p>
            <div class="verse-div">
            2 plus 3 is 5
            </div>
            <div class="verse-div">
            7 minus 1 is 6
            </div>
            <div class="verse-div">
            4 ? 4 is 4
            </div>
            <p>
            "Almost too easy. "What's missing, my new friend?"
            </p>
            <p>
            ${owl_speak(`000`)} 0wlgebra chimes as he nods his head.
            </p>
            `)
            nav('blorple', { show_header: false })
        })

    } else {

        if (!game.boss) {
            preview('hint', `get a hint`)
            check('hint', () => `
            You need a round number, the kind that Gnomon said was so round you could make pies with it.
            `)

            check('talk', () => {
                on_exit(() => `
                "All right. I'll give you a real test. If you're worthy of 
                my spade gem, this should be easy."
                <p>
                ${owl_speak(`000`)} cries 0wlgebra with utmost sincerity.
                </p>
                <p>
                The Mathegardener flashes a wicked grin.
                "I need a very round number. The roundest number I can get."
                </p>
                `)
                nav('enter_number', { show_header: false })
            })

        } else {

            check('talk', () => {
                on_exit(() => `
                "All right. I'll give you a real test. If you're worthy of 
                my spade gem, this should be easy."
                <p>
                ${owl_speak(`000`)} cries 0wlgebra with utmost sincerity.
                </p>
                <p>
                "I'm looking for a good spiral," she says. "Better than
                good, in fact. You could almost say golden, I suppose. I've worked
                out most of the numbers:
                </p>
                <p>
                "18, 29, 47, 76. What's the next number in the sequence?"
                </p>
                `)
                nav('boss_enter_number', { show_header: false })
            })

        }

    }


    if (!game.boat_ride) {

        check('talk', () => nav('boat_ride', { show_header: false }));

    }


}
